/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import model.Globals;
import model.MethodScores;
import model.SuggestedReplacement;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.ReplacedInstance;

public class ConfidenceWeights
implements HolderChangeListener {
    public static final String KV_METHOD = "KV";
    public static final String LR_METHOD = "LR";
    public static final String SE_METHOD = "PM";
    public static final String ED_METHOD = "ED";
    private HashMap<String, MethodScores> methodScores = new LinkedHashMap<String, MethodScores>();
    private static final long serialVersionUID = 1574820836410213387L;
    public static final int SUGGESTED_TOTAL = 50;
    public static final int MIN_TOTAL = 0;
    public static final int MAX_TOTAL = 100;
    public double F_WEIGHT = 1.0;
    private static final boolean DEFAULT_UPDATE = true;
    private static transient boolean hasChanged = false;
    private transient boolean update = true;
    private static transient Vector<ChangeListener> changeListeners = new Vector();
    private static ConfidenceWeights _instance = null;
    private static transient Globals global;

    public ConfidenceWeights() {
        this.methodScores.put(KV_METHOD, new MethodScores(0.5, 0.5));
        this.methodScores.put(LR_METHOD, new MethodScores(0.5, 0.5));
        this.methodScores.put(SE_METHOD, new MethodScores(0.5, 0.5));
        this.methodScores.put(ED_METHOD, new MethodScores(0.5, 0.5));
        global = Globals.getInstance();
        File conf = new File(Globals.getSetupFolder(), "weights.txt");
        try {
            if (conf.exists()) {
                this.loadWeights(conf);
            } else {
                this.save();
            }
        }
        catch (FileNotFoundException e) {
            global.showException("weights.txt not found when should exist, please reinstall if error persists", e);
        }
        catch (IOException e) {
            global.showException("Error reading weights.txt, please reinstall if error persists", e);
        }
        catch (NumberFormatException ex) {
            global.showException("Weights in weights.txt must be decimal values.", ex);
        }
    }

    public static ConfidenceWeights getInstance() {
        if (_instance == null) {
            _instance = new ConfidenceWeights();
        }
        return _instance;
    }

    public void loadWeights(File conf) throws IOException, NumberFormatException {
        LineNumberReader textIn = new LineNumberReader(new FileReader(conf));
        String currentLine = "file not ready";
        try {
            while ((currentLine = textIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                for (String method : this.methodScores.keySet()) {
                    if (!currentLineArray[0].contains(method)) continue;
                    this.methodScores.put(method, new MethodScores(Double.parseDouble(currentLineArray[1].trim()), Double.parseDouble(currentLineArray[2].trim()), Double.parseDouble(currentLineArray[3].trim())));
                }
            }
        }
        finally {
            textIn.close();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        changeListeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        changeListeners.remove(cl);
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean newUpdate) {
        this.update = newUpdate;
    }

    public void setUpdateToDefault() {
        this.update = true;
    }

    private void adjustValuesForReplacementSelected(SuggestedReplacement sr) {
        sr.picked();
        this.setHasChanged(true);
    }

    private void adjustValuesForScoreAdjustmentCancelled(SuggestedReplacement sr) {
        sr.unpicked();
        this.setHasChanged(true);
    }

    public double calculateScoreOfReplacement(SuggestedReplacement sr) {
        double recall = 0.0;
        double maxRecall = 0.0;
        double precision = 0.0;
        for (Map.Entry<String, MethodScores> ms : this.methodScores.entrySet()) {
            double methodRecall = ms.getValue().recall();
            recall += methodRecall * sr.getScoreUpdate(ms.getKey()).getUpdate().recall();
            maxRecall += methodRecall;
            precision = Math.max(precision, ms.getValue().precision() * sr.getScoreUpdate(ms.getKey()).getUpdate().precision());
        }
        double score = MethodScores.fScore(precision, recall /= maxRecall, this.F_WEIGHT);
        return MethodScores.round(score *= 100.0, 2);
    }

    public static boolean hasChanged() {
        return hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        ConfidenceWeights.hasChanged = hasChanged;
        for (ChangeListener cl : changeListeners) {
            cl.changeUpdate(hasChanged);
        }
    }

    public void save() throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(Globals.getSetupFolder(), "weights.txt"))));
        try {
            for (Map.Entry<String, MethodScores> ms : this.methodScores.entrySet()) {
                writer.println(String.valueOf(ms.getKey()) + ":\t" + ms.getValue());
            }
            this.setHasChanged(false);
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance ri, int type) {
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance ri, int type) {
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
        if (this.update && instance.getType() == 102) {
            this.adjustValuesForScoreAdjustmentCancelled(((ReplacedInstance)instance).getReplacement());
        }
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
        if (this.update && instance.getType() == 102) {
            this.adjustValuesForReplacementSelected(((ReplacedInstance)instance).getReplacement());
        }
    }

    public MethodScores getKV() {
        return this.getScore(KV_METHOD);
    }

    public MethodScores getLR() {
        return this.getScore(LR_METHOD);
    }

    public MethodScores getSE() {
        return this.getScore(SE_METHOD);
    }

    public MethodScores getED() {
        return this.getScore(ED_METHOD);
    }

    public MethodScores getScore(String method) {
        return this.methodScores.get(method);
    }

    public String getMethodScoresString(MethodScores ms) {
        double precision = ms.precision();
        double recall = ms.recall();
        double fScore = MethodScores.fScore(precision, recall, this.F_WEIGHT);
        return String.valueOf(MethodScores.round(precision, 2)) + " | " + MethodScores.round(recall, 2) + " | " + MethodScores.round(fScore, 2);
    }

    public void setScores(HashMap<String, MethodScores> scores) {
        this.methodScores = scores;
    }

    public HashMap<String, MethodScores> getScores() {
        return this.methodScores;
    }

    public static double calculateFWeight(int value) {
        if (value == 0) {
            return 1.0;
        }
        if (value > 0) {
            return (double)value + 1.0;
        }
        return 1.0 / (double)Math.abs(value - 1);
    }

    public static interface ChangeListener {
        public void changeUpdate(boolean var1);
    }
}

