/*
 * Decompiled with CFR 0.152.
 */
package clui;

import clui.CommandLineProgressAndExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.ConfidenceWeights;
import model.Globals;
import model.doc.DocumentModel;

public class OneFileDriver {
    public static void main(String[] args) {
        boolean xml;
        if (args.length != 6) {
            System.err.println();
            System.err.println("There should be SIX arguments: the setup folder, the threshold (a whole number between 0 and 100), the f-score weight(a fraction or whole number), the input file (a single text to process), the string \"XML\" or \"Plain\" to indicate the output type, and the output file.");
            System.exit(1);
            return;
        }
        File setupFolder = new File(args[0]);
        setupFolder.mkdirs();
        if (!setupFolder.isDirectory()) {
            System.err.println();
            System.err.println("First argument, the setup folder, must be a path to a folder.");
            System.exit(1);
            return;
        }
        Globals.setSetupFolder(setupFolder);
        int threshold = 50;
        try {
            threshold = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException ex) {
            System.err.println();
            System.err.println("Second argument, the threshold, should be an integer value");
            System.exit(1);
            return;
        }
        if (threshold < 0 || threshold > 100) {
            System.err.println();
            System.err.println("Second argument, the threshold, should be between 0 and 100");
            System.exit(1);
            return;
        }
        String fweight = args[2];
        Pattern fwPattern = Pattern.compile("([1-9]{1})[/]?([1-9]?)");
        Matcher fwMatcher = fwPattern.matcher(fweight);
        double fWeight = 1.0;
        if (fwMatcher.find()) {
            int top = Integer.parseInt(fwMatcher.group(1));
            fWeight = top;
            String denString = fwMatcher.group(2);
            if (denString != null && !denString.isEmpty()) {
                fWeight /= (double)Integer.parseInt(denString);
            }
        } else {
            System.err.println();
            System.err.println("Third argument, the f-score weight, should either be a fraction with a numerator and denominator between 1 and 9 (inclusive) or a whole number between 1 and 9 (inclusive). 1 represents equal weighting between precision and recall, 1/2 represents precision weighted twice as much as recall, 2 represents recall weighted twice as much as precision.");
            System.exit(1);
            return;
        }
        File inputFile = new File(args[3]);
        if (!inputFile.exists()) {
            System.err.println();
            System.err.println("Fouth argument, the input file, must exist.");
            System.exit(1);
            return;
        }
        if (args[4].equalsIgnoreCase("xml")) {
            xml = true;
        } else if (args[4].equalsIgnoreCase("plain")) {
            xml = false;
        } else {
            System.err.println();
            System.err.println("Fifth argument, the output type, must be XML or Plain.");
            System.exit(1);
            return;
        }
        File outFile = new File(args[5]);
        try {
            outFile.createNewFile();
        }
        catch (IOException e1) {
            System.err.println();
            System.err.println("Out file could not be created (Argument 6).");
            e1.printStackTrace();
            System.exit(1);
            return;
        }
        long initStart = System.currentTimeMillis();
        Globals.PROGRESS_DELAY = 1000;
        Globals global = Globals.getInstance();
        CommandLineProgressAndExceptionHandler handler = new CommandLineProgressAndExceptionHandler();
        global.setExceptionHandler(handler);
        global.setProgressHandler(handler);
        ConfidenceWeights.getInstance().F_WEIGHT = fWeight;
        DocumentModel docModel = DocumentModel.getInstance();
        System.out.println("Initialisiation: " + OneFileDriver.getTimeString(System.currentTimeMillis() - initStart));
        try {
            long processStart = System.currentTimeMillis();
            docModel.processNewFile(inputFile);
            docModel.getProcessAllVariantsEdit(threshold, false).execute();
            if (xml) {
                docModel.exportToXML(outFile);
            } else {
                docModel.saveToFile(outFile);
            }
            System.out.println();
            System.out.println("File process: " + OneFileDriver.getTimeString(System.currentTimeMillis() - processStart));
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("Error occurred processing file.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        System.exit(0);
    }

    private static String getTimeString(long timeMillis) {
        long time = timeMillis / 1000L;
        String seconds = Integer.toString((int)(time % 60L));
        String minutes = Integer.toString((int)(time % 3600L / 60L));
        String hours = Integer.toString((int)(time / 3600L));
        int i = 0;
        while (i < 2) {
            if (seconds.length() < 2) {
                seconds = "0" + seconds;
            }
            if (minutes.length() < 2) {
                minutes = "0" + minutes;
            }
            if (hours.length() < 2) {
                hours = "0" + hours;
            }
            ++i;
        }
        return String.valueOf(hours) + ":" + minutes + ":" + seconds;
    }
}

