/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import model.Globals;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.RevertReplacedInstanceEdit;

class RevertInstanceAction
extends AbstractAction {
    private static final long serialVersionUID = -7964139713034760680L;
    RevertReplacedInstanceEdit edit;

    RevertInstanceAction(ReplacedInstance ri, StyledDocument doc) {
        try {
            this.edit = new RevertReplacedInstanceEdit(ri, doc);
            this.putValue("Name", this.edit.getActionName());
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred in reverting instance prep.", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            this.edit.execute();
            MainScreen.undoSupport.postEdit(this.edit);
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred reverting instance.", ex);
        }
        catch (BadLocationException ex) {
            Globals.getInstance().showException("Error occurred reverting instance in text", ex);
        }
    }
}

