/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import gui.ThreadedProcessEditHolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import model.Globals;
import model.doc.DocumentModel;
import model.doc.Instance;
import model.doc.InvalidInstanceChangeException;
import model.doc.MarkAllFInstancesAsTEdit;
import model.doc.WordHolder;

class MarkAllFInstancesAsTAction<F extends Instance, T extends Instance>
extends AbstractAction {
    private static final long serialVersionUID = -7964139713034760680L;
    MarkAllFInstancesAsTEdit<F, T> edit;
    WordHolder wh;

    MarkAllFInstancesAsTAction(WordHolder wh, F tempFrom, T tempTo) {
        this.wh = wh;
        try {
            this.edit = new MarkAllFInstancesAsTEdit<F, T>(wh, tempFrom, tempTo);
            this.putValue("Name", this.edit.getActionName());
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred in marking all instances prep.", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int o;
        ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(this.edit);
        tEdit.execute();
        MainScreen.undoSupport.postEdit(tEdit);
        if (this.edit.getToType() == 103 && !this.wh.isInDictionary()) {
            int o2 = JOptionPane.showOptionDialog(MainScreen.frame, "Would you like to add this word to the dictionary?", "Add to dictionary?", 0, 3, null, null, null);
            if (o2 == 0) {
                DocumentModel.AddWordToDictionaryEdit addEdit = new DocumentModel.AddWordToDictionaryEdit(this.wh, this.wh.getWord());
                addEdit.execute();
                MainScreen.undoSupport.postEdit(addEdit);
            }
        } else if (this.edit.getToType() == 101 && (o = JOptionPane.showOptionDialog(MainScreen.frame, "Would you like to remove this word from the dictionary?\nThis will result in the word being marked as a variant in future.", "Remove from dictionary?", 0, 3, null, null, null)) == 0) {
            DocumentModel.RemoveWordFromDictionaryEdit removeEdit = new DocumentModel.RemoveWordFromDictionaryEdit(this.wh, this.wh.getWord());
            removeEdit.execute();
            MainScreen.undoSupport.postEdit(removeEdit);
        }
    }
}

