/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.BatchScreen;
import gui.ExceptionDisplay;
import gui.MainScreen;
import gui.ProcessingScreen;
import gui.TrainingScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import model.Globals;

public class GUISelector
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    JButton[] buttons = new JButton[3];
    private static Globals global;
    private JTextField setupTF;
    private JFileChooser fc = new JFileChooser();

    private void browse() {
        int returnVal2 = this.fc.showSaveDialog(this);
        if (returnVal2 == 0) {
            String ofs = this.fc.getSelectedFile().getPath();
            this.setupTF.setText(ofs);
        }
    }

    public GUISelector() {
        this.setTitle("Select User Interface");
        JPanel setupPanel = new JPanel(new BorderLayout());
        setupPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        setupPanel.add((Component)new JLabel("Setup folder: "), "West");
        this.setupTF = new JTextField(15);
        this.setupTF.setText(Globals.getSetupFolder().getAbsolutePath());
        this.setupTF.setTransferHandler(new FolderTransferHandler());
        setupPanel.add((Component)this.setupTF, "Center");
        JButton browseButton = new JButton("Browse");
        this.fc.setFileSelectionMode(1);
        this.fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUISelector.this.browse();
            }
        });
        setupPanel.add((Component)browseButton, "East");
        this.buttons[0] = new JButton("Single text (interactive)");
        this.buttons[1] = new JButton("Batch process (automatic)");
        this.buttons[2] = new JButton("Train from VARDed texts");
        JPanel buttonsPanel = new JPanel(new GridLayout(this.buttons.length, 1));
        int i = 0;
        while (i < this.buttons.length) {
            buttonsPanel.add(this.buttons[i]);
            this.buttons[i].addActionListener(this);
            this.buttons[i].setFont(new Font("Verdana", 1, 20));
            ++i;
        }
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)setupPanel, "North");
        main.add((Component)buttonsPanel, "Center");
        this.setSize(500, 300);
        this.setDefaultCloseOperation(3);
        this.setContentPane(main);
        this.setLocation(GUISelector.SCREEN_SIZE.width / 2 - this.getWidth() / 2, GUISelector.SCREEN_SIZE.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new GUISelector();
    }

    private static void start() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error occurred setting look and feel.\n\n" + ex.getMessage(), "Error", 0);
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        global = Globals.getInstance();
        global.setExceptionHandler(ExceptionDisplay.getInstance());
        global.setProgressHandler(ProcessingScreen.getInstance());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File setupFolder = new File(this.setupTF.getText());
        setupFolder.mkdirs();
        if (!setupFolder.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Please ensure that setup folder is a folder and not a file.", "Error", 0);
            return;
        }
        this.dispose();
        Globals.setSetupFolder(setupFolder);
        GUISelector.start();
        if (ae.getSource() == this.buttons[0]) {
            MainScreen.run();
        } else if (ae.getSource() == this.buttons[1]) {
            BatchScreen.run();
        } else if (ae.getSource() == this.buttons[2]) {
            TrainingScreen.run();
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting setup folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting setup folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            GUISelector.this.setupTF.setText(folder.getAbsolutePath());
            return true;
        }
    }
}

