/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.util.Collection;
import java.util.TreeMap;
import model.lookup.LookUpDictionary;
import model.lookup.Node;
import model.lookup.VariantReplacement;

public class VariantHolder
extends Node
implements Comparable<VariantHolder> {
    private String variant;
    private static final long serialVersionUID = 7030014296928387061L;
    private TreeMap<String, VariantReplacement> variantReplacements;
    private int seen;

    public VariantHolder(String vs, Node node) {
        super(Character.valueOf(vs.charAt(vs.length() - 1)));
        if (node != null) {
            this.next = node.next;
        }
        this.variantReplacements = new TreeMap();
        this.variant = vs.toLowerCase().trim();
        this.seen = 0;
    }

    @Override
    public boolean isWord() {
        return true;
    }

    Collection<VariantReplacement> getVariantReplacements() {
        return this.variantReplacements.values();
    }

    boolean addVariant(VariantReplacement variant) {
        if (this.variantReplacements.containsKey(variant.getWordString())) {
            return false;
        }
        this.variantReplacements.put(variant.getWordString(), variant);
        this.seen += variant.getPicked();
        return true;
    }

    boolean removeVariant(VariantReplacement v) {
        VariantReplacement removed = this.variantReplacements.remove(v.getWordString());
        if (removed == null) {
            return false;
        }
        this.seen -= removed.getPicked();
        return true;
    }

    boolean isEmpty() {
        return this.variantReplacements.isEmpty();
    }

    public String getVariantString() {
        return this.variant;
    }

    public String toString() {
        return this.variant;
    }

    int getSeen() {
        if (this.seen < 0) {
            return 0;
        }
        return this.seen;
    }

    public boolean equals(String s) {
        return this.variant.equals(s);
    }

    void incrementSeen() {
        ++this.seen;
        LookUpDictionary.setVariantsChanged(true);
    }

    void decrementSeen() {
        --this.seen;
        LookUpDictionary.setVariantsChanged(true);
    }

    @Override
    public int compareTo(VariantHolder vh) {
        return this.variant.compareToIgnoreCase(vh.variant);
    }

    public boolean equals(VariantHolder vh) {
        return this.variant.equalsIgnoreCase(vh.variant);
    }
}

