/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import model.doc.DocumentElement;
import model.doc.DocumentModel;
import model.doc.InstanceHolder;
import model.doc.WordHolder;
import model.lookup.WordUtilities;

public abstract class Instance
extends DocumentElement {
    protected String joinString;
    protected boolean isJoin;
    protected int capitalization;
    protected WordHolder holder;
    protected Instance previousInstance;
    protected InstanceHolder<? extends Instance> instanceHolder;
    protected boolean userChanged = false;
    private int openTagLength = 0;
    private int closeTagLength = 0;

    protected Instance() {
    }

    protected Instance(Position start, Position end, WordHolder holder, InstanceHolder<? extends Instance> instanceHolder, String original) {
        super(start, end, original);
        if (start == null) {
            throw new NullPointerException("Start null");
        }
        if (holder == null) {
            throw new NullPointerException("WordHolder null");
        }
        if (instanceHolder == null) {
            throw new NullPointerException("InstanceHolder null");
        }
        if (original == null) {
            throw new NullPointerException("Original null");
        }
        this.holder = holder;
        this.instanceHolder = instanceHolder;
        this.isJoin = false;
        this.joinString = null;
        this.capitalization = WordUtilities.getCapitalization(original);
        this.previousInstance = null;
    }

    protected Instance(Instance oldInstance) {
        this(oldInstance.getStart(), oldInstance.getEnd(), oldInstance.holder, oldInstance.instanceHolder, oldInstance.getOriginal());
        this.previousInstance = oldInstance;
        this.isJoin = oldInstance.isJoin;
        this.joinString = oldInstance.joinString;
        this.userChanged = true;
    }

    public String analysisString() {
        return String.valueOf(this.getType()) + ": " + this.getDisplayString() + " (" + this.getStartOffset() + " - " + this.getEndOffset() + ")";
    }

    @Override
    public String toString() {
        return this.analysisString();
    }

    public boolean isXMLRequired() {
        return this.isJoin;
    }

    public void insertXMLTags(Document doc) throws BadLocationException {
        if (this.isJoin) {
            String openTag = "<join original=\"" + this.joinString + "\">";
            this.openTagLength = openTag.length();
            String closeTag = "</join>";
            this.closeTagLength = closeTag.length();
            doc.insertString(this.getStartOffset(), openTag, null);
            doc.insertString(this.getEndOffset(), closeTag, null);
        } else {
            this.openTagLength = 0;
            this.closeTagLength = 0;
        }
    }

    protected void insertXMLTags(Document doc, String startTag, String endTag) throws BadLocationException {
        if (this.isJoin) {
            String openTag = "<join original=\"" + this.joinString + "\">" + startTag;
            this.openTagLength = openTag.length();
            String closeTag = String.valueOf(endTag) + "</join>";
            this.closeTagLength = closeTag.length();
            doc.insertString(this.getStartOffset(), openTag, null);
            doc.insertString(this.getEndOffset(), closeTag, null);
        } else {
            this.openTagLength = startTag.length();
            this.closeTagLength = endTag.length();
            doc.insertString(this.getStartOffset(), startTag, null);
            doc.insertString(this.getEndOffset(), endTag, null);
        }
    }

    public void removeLastXMLTags(Document doc) throws BadLocationException {
        doc.remove(this.getStartOffset() - this.openTagLength, this.openTagLength);
        doc.remove(this.getEndOffset() - this.closeTagLength, this.closeTagLength);
    }

    public abstract int getType();

    public boolean isJoin() {
        return this.isJoin;
    }

    public void setJoin(boolean isJoin) {
        this.isJoin = isJoin;
    }

    public String getJoinString() {
        return this.joinString;
    }

    public void setJoinString(String joinString) {
        this.joinString = joinString;
        if (joinString != null) {
            this.joinString = this.joinString.replaceAll("\r\n", "[n]");
            this.joinString = this.joinString.replaceAll("\n", "[n]");
            this.joinString = this.joinString.replaceAll("\r", "[n]");
        }
    }

    Instance getPreviousInstance() {
        return this.previousInstance;
    }

    void clearPreviousInstance() {
        this.previousInstance = null;
    }

    public int getCapitalization() {
        return this.capitalization;
    }

    public WordHolder getHolder() {
        return this.holder;
    }

    public abstract boolean removeSelfFromHolder();

    public abstract void addSelfToHolder();

    public InstanceHolder<? extends Instance> getInstanceHolder() {
        return this.instanceHolder;
    }

    public void setInstanceHolder(InstanceHolder<? extends Instance> instanceHolder) {
        this.instanceHolder = instanceHolder;
    }

    public boolean isUserChanged() {
        return this.userChanged;
    }

    public void setUserChanged(boolean userChanged) {
        this.userChanged = userChanged;
    }

    @Override
    public void restoreStart(StyledDocument doc, int offset) throws BadLocationException {
        Position newStart = doc.createPosition(this.startInt1 + offset);
        DocumentModel.getInstance().instanceStartMoved(this.getStart(), newStart, this);
        super.restoreStart(doc, offset);
    }
}

