/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

public abstract class DocumentElement
implements Comparable<DocumentElement> {
    private Position start;
    private Position end;
    private String original;
    protected int startInt1;

    protected DocumentElement() {
    }

    protected DocumentElement(Position start, Position end, String original) {
        this.start = start;
        this.end = end;
        this.original = original;
    }

    Position getStart() {
        return this.start;
    }

    void setStart(Position start) {
        this.start = start;
    }

    Position getEnd() {
        return this.end;
    }

    public void saveStart() {
        this.startInt1 = this.start.getOffset();
    }

    public void restoreStart(StyledDocument doc, int offset) throws BadLocationException {
        this.start = doc.createPosition(this.startInt1 + offset);
    }

    public int getSavedStartInt() {
        return this.startInt1;
    }

    public String toString() {
        return String.valueOf(this.start.getOffset()) + ": " + this.original;
    }

    public String getDisplayString() {
        return this.original;
    }

    @Override
    public int compareTo(DocumentElement another) {
        return new Integer(this.getStartOffset()).compareTo(new Integer(another.getStartOffset()));
    }

    public boolean equals(DocumentElement another) {
        return this.compareTo(another) == 0;
    }

    public int compareAlphabeticallyTo(DocumentElement other) {
        return this.original.compareToIgnoreCase(other.original);
    }

    public int getStartOffset() {
        return this.start.getOffset();
    }

    public int getEndOffset() {
        return this.end.getOffset();
    }

    public void restoreEnd(StyledDocument doc) throws BadLocationException {
        this.end = doc.createPosition(this.start.getOffset() + this.getDisplayString().length());
    }

    public boolean containsPosition(int caretPosition) {
        return caretPosition >= this.getStartOffset() && caretPosition < this.getEndOffset();
    }

    public void changeHighlight(StyledDocument doc, AttributeSet atts) {
        doc.setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), atts, false);
    }

    public String getOriginal() {
        return this.original;
    }
}

