/*
 * Decompiled with CFR 0.152.
 */
package model;

public class MethodScores {
    private double tp;
    private double fp;
    private double fn;

    public MethodScores(double tp, double fp) {
        if (tp < 0.0 || tp > 1.0) {
            throw new IllegalArgumentException("tp must be between 0.0 and 1.0");
        }
        this.tp = tp;
        this.fp = fp;
        this.fn = 1.0 - tp;
    }

    public MethodScores(double tp, double fp, double fn) {
        this.tp = tp;
        this.fp = fp;
        this.fn = fn;
    }

    public MethodScores(MethodScores ms) {
        this.tp = ms.tp;
        this.fp = ms.fp;
        this.fn = ms.fn;
    }

    public double recall() {
        if (this.tp + this.fn == 0.0) {
            return 0.0;
        }
        return this.tp / (this.tp + this.fn);
    }

    public double precision() {
        if (this.tp + this.fp == 0.0) {
            return 0.0;
        }
        return this.tp / (this.tp + this.fp);
    }

    public static double fScore(double precision, double recall, double weight) {
        if (precision + recall == 0.0) {
            return 0.0;
        }
        double weight_sq = weight * weight;
        return (1.0 + weight_sq) * (precision * recall / (weight_sq * precision + recall));
    }

    public static double round(double value, int places) {
        String r = "1";
        int i = 0;
        while (i < places) {
            r = String.valueOf(r) + "0";
            ++i;
        }
        r = String.valueOf(r) + ".0";
        Double p = Double.parseDouble(r);
        return Math.rint(value * p) / p;
    }

    public double fScore(double weight) {
        return MethodScores.fScore(this.precision(), this.recall(), weight);
    }

    public String getPrecisionPercent() {
        String scoreString = Double.toString(MethodScores.round(this.precision() * 100.0, 2));
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return String.valueOf(scoreString) + "%";
    }

    public String getRecallPercent() {
        String scoreString = Double.toString(MethodScores.round(this.recall() * 100.0, 2));
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return String.valueOf(scoreString) + "%";
    }

    public String getFScorePercent(double weight) {
        String scoreString = Double.toString(MethodScores.round(this.fScore(weight) * 100.0, 2));
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return String.valueOf(scoreString) + "%";
    }

    public void addEvidence(MethodScores e) {
        this.tp += e.tp;
        this.fp += e.fp;
        this.fn += e.fn;
    }

    public void removeEvidence(MethodScores e) {
        this.tp -= e.tp;
        this.fp -= e.fp;
        this.fn -= e.fn;
    }

    public double fp() {
        return this.fp;
    }

    public double tp() {
        return this.tp;
    }

    public String toFileString() {
        return String.valueOf(this.tp) + "\t" + this.fp + "\t" + this.fn;
    }

    public String toString() {
        return this.toFileString();
    }

    public String toMenuString(double weight) {
        return String.valueOf(this.getFScorePercent(weight)) + " (" + this.getPrecisionPercent() + "|" + this.getRecallPercent() + ")";
    }
}

