/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.InstanceStepPanel;
import gui.MarkAllFInstancesAsTAction;
import gui.MarkFInstanceAsTAction;
import gui.ReplaceAllFInstancesAction;
import gui.ReplaceFInstanceAction;
import gui.ReplaceWithAction;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import model.SuggestedReplacement;
import model.doc.CorrectInstance;
import model.doc.Instance;
import model.doc.VariantInstance;

class VariantStepPanel
extends InstanceStepPanel {
    private static final long serialVersionUID = 3538050211560168605L;
    private JComboBox replacementsCB;
    private JButton normaliseInstanceButton;
    private JButton normaliseAllButton;
    private JButton normaliseToButton;
    private JButton markInstanceButton;
    private JButton markAllButton;
    private boolean repPresent;
    private boolean currentEnabled = true;

    VariantStepPanel() {
        this.setLayout(new GridLayout(6, 1));
        this.replacementsCB = new JComboBox();
        this.add(this.replacementsCB);
        this.normaliseInstanceButton = new JButton("Normalise instance");
        this.normaliseInstanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceFInstanceAction<VariantInstance> action = new ReplaceFInstanceAction<VariantInstance>((VariantInstance)VariantStepPanel.this.currentInstance, (SuggestedReplacement)VariantStepPanel.this.replacementsCB.getSelectedItem(), docModel.getDoc());
                action.actionPerformed(e);
            }
        });
        this.add(this.normaliseInstanceButton);
        this.normaliseAllButton = new JButton("Normalise all");
        this.normaliseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceAllFInstancesAction<VariantInstance> action = new ReplaceAllFInstancesAction<VariantInstance>(VariantStepPanel.this.currentWH, new VariantInstance(), (SuggestedReplacement)VariantStepPanel.this.replacementsCB.getSelectedItem(), docModel.getDoc());
                action.actionPerformed(e);
            }
        });
        this.add(this.normaliseAllButton);
        this.normaliseToButton = new JButton("Normalise to...");
        this.normaliseToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceWithAction<VariantInstance> action = new ReplaceWithAction<VariantInstance>((VariantInstance)VariantStepPanel.this.currentInstance);
                action.actionPerformed(e);
            }
        });
        this.add(this.normaliseToButton);
        this.markInstanceButton = new JButton("Instance not variant");
        this.markInstanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkFInstanceAsTAction<VariantInstance, CorrectInstance> action = new MarkFInstanceAsTAction<VariantInstance, CorrectInstance>((VariantInstance)VariantStepPanel.this.currentInstance, new CorrectInstance());
                action.actionPerformed(e);
            }
        });
        this.add(this.markInstanceButton);
        this.markAllButton = new JButton("All not variant");
        this.markAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarkAllFInstancesAsTAction<VariantInstance, CorrectInstance> action = new MarkAllFInstancesAsTAction<VariantInstance, CorrectInstance>(VariantStepPanel.this.currentWH, new VariantInstance(), new CorrectInstance());
                action.actionPerformed(e);
            }
        });
        this.add(this.markAllButton);
    }

    @Override
    void changeInstance(Instance instance) {
        super.changeInstance(instance);
        this.replacementsCB.removeAllItems();
        docModel.findReplacementsForWord(this.currentWH, 25);
        List<SuggestedReplacement> reps = this.currentWH.getReplacements();
        int capitalization = this.currentInstance.getCapitalization();
        for (SuggestedReplacement rep : reps) {
            rep.setCapitalization(capitalization);
        }
        this.replacementsCB.setModel(new DefaultComboBoxModel<Object>(reps.toArray()));
        boolean bl = this.repPresent = !reps.isEmpty();
        if (this.currentEnabled) {
            this.normaliseInstanceButton.setEnabled(this.repPresent);
            this.normaliseAllButton.setEnabled(this.repPresent);
        }
    }

    @Override
    void emptyInstance() {
        super.emptyInstance();
        this.replacementsCB.setModel(new DefaultComboBoxModel());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.currentEnabled = enabled;
        this.normaliseToButton.setEnabled(enabled);
        this.markInstanceButton.setEnabled(enabled);
        this.markAllButton.setEnabled(enabled);
        if (enabled) {
            this.normaliseInstanceButton.setEnabled(this.repPresent);
            this.normaliseAllButton.setEnabled(this.repPresent);
        } else {
            this.normaliseInstanceButton.setEnabled(false);
            this.normaliseAllButton.setEnabled(false);
        }
    }
}

