/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AddOwnVariantDialog;
import gui.MainScreen;
import gui.ThreadedProcessEditHolder;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import model.ConfidenceWeights;
import model.Globals;
import model.MethodScores;
import model.MethodScoresUpdate;
import model.SuggestedReplacement;
import model.doc.DocumentElement;
import model.doc.DocumentModel;
import model.doc.Instance;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplaceAllFInstancesEdit;
import model.doc.ReplaceFInstanceEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.Word;
import model.lookup.WordUtilities;

class ReplaceWithAction<F extends VariantInstance>
extends AbstractAction {
    private static final long serialVersionUID = 6659037788557951900L;
    F fi;
    WordHolder wh;
    boolean isInstance;
    int fromType;

    ReplaceWithAction(F fi) {
        this.isInstance = true;
        this.fi = fi;
        this.wh = ((Instance)fi).getHolder();
        this.fromType = ((VariantInstance)fi).getType();
        this.putValue("Name", "Normalise to...");
    }

    ReplaceWithAction(WordHolder wh, F temp) {
        this.isInstance = false;
        this.wh = wh;
        this.fi = temp;
        this.fromType = ((VariantInstance)this.fi).getType();
        this.putValue("Name", "Normalise to...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int o;
        String variantString = this.isInstance ? ((DocumentElement)this.fi).getOriginal() : this.wh.getWord();
        AddOwnVariantDialog.UserInput userInput = new AddOwnVariantDialog().showDialog(MainScreen.frame, variantString, this.isInstance);
        if (userInput == null) {
            return;
        }
        Word word = MainScreen.lud.checkWords(userInput.getReplacement());
        boolean newWord = false;
        if (word == null) {
            word = new Word(userInput.getReplacement(), null, true, 1);
            newWord = true;
        }
        SuggestedReplacement rep = null;
        List<SuggestedReplacement> reps = MainScreen.lud.findReplacements(variantString, WordUtilities.getSoundexCode(variantString), 0);
        for (SuggestedReplacement r : reps) {
            if (!r.getReplacement().equals(word)) continue;
            rep = r;
            break;
        }
        if (rep == null) {
            rep = new SuggestedReplacement(word, variantString, false);
            if (reps.size() != 0) {
                SuggestedReplacement first = (SuggestedReplacement)reps.iterator().next();
                for (Map.Entry<String, MethodScoresUpdate> msu : first.getMethodScoresUpdates().entrySet()) {
                    MethodScores origUpdate = msu.getValue().getUpdate();
                    MethodScores newUpdate = new MethodScores(0.0, origUpdate.fp() + origUpdate.tp());
                    rep.setScoreUpdate(msu.getKey(), new MethodScoresUpdate(msu.getValue().getToUpdate(), newUpdate));
                }
            } else {
                Set<Map.Entry<String, MethodScores>> cwMSs = ConfidenceWeights.getInstance().getScores().entrySet();
                for (Map.Entry<String, MethodScores> ms : cwMSs) {
                    rep.setScoreUpdate(ms.getKey(), new MethodScoresUpdate(ms.getValue(), new MethodScores(0.0, 0.0)));
                }
            }
            rep.reCalculateScore();
        }
        if (newWord && (o = JOptionPane.showOptionDialog(MainScreen.frame, "Would you like to add this replacement word to the dictionary?", "Add replacement to dictionary?", 0, 3, null, null, null)) == 0) {
            DocumentModel.AddWordToDictionaryEdit addEdit = new DocumentModel.AddWordToDictionaryEdit(this.wh, word.toString());
            addEdit.execute();
            MainScreen.undoSupport.postEdit(addEdit);
        }
        try {
            if (userInput.isReplaceAllInstancesOfWord()) {
                ReplaceAllFInstancesEdit<F> edit = new ReplaceAllFInstancesEdit<F>(this.wh, this.fi, rep, MainScreen.docModel.getDoc(), true, false, true);
                ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
                tEdit.execute();
                MainScreen.undoSupport.postEdit(tEdit);
            } else {
                ReplaceFInstanceEdit<F> edit = new ReplaceFInstanceEdit<F>(this.fi, rep, MainScreen.docModel.getDoc(), true, false, true);
                edit.execute();
                MainScreen.undoSupport.postEdit(edit);
            }
        }
        catch (BadLocationException ex) {
            Globals.getInstance().showException("Error occurred replacing word", ex);
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred replacing word", ex);
        }
    }
}

