/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.CardPanel;
import gui.CorrectStepPanel;
import gui.InstanceStepPanel;
import gui.MarkAllFInstancesAsTAction;
import gui.MarkFInstanceAsTAction;
import gui.ReplaceAllFInstancesAction;
import gui.ReplaceFInstanceAction;
import gui.ReplaceWithAction;
import gui.ReplacedStepPanel;
import gui.RevertAllAction;
import gui.RevertInstanceAction;
import gui.RuleManager;
import gui.StackListModel;
import gui.TBJButton;
import gui.ThreadedProcessEditHolder;
import gui.VariantStepPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import model.ConfidenceWeights;
import model.ExceptionMessageHandler;
import model.Globals;
import model.MethodScores;
import model.ProgressListener;
import model.SuggestedReplacement;
import model.doc.CorrectInstance;
import model.doc.DocumentModel;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.IgnorableTextListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;

public class MainScreen
implements ProgressListener,
ExceptionMessageHandler,
LookUpDictionary.DataChangeListener,
ConfidenceWeights.ChangeListener {
    private boolean allowEditing = false;
    private static final String PROGRAM_TITLE = "VARD 2.4";
    private static final int XML = 66;
    private static final int TXT = 88;
    private static final int TYPE_INSTANCES = 55;
    private static final int TEXT_INSTANCES = 56;
    private int instancesControl = 56;
    private JToggleButton typeInstancesTB;
    private JToggleButton textInstancesTB;
    private int listSelected = WordHolder.types[0];
    private HashMap<String, JLabel> methodLabels;
    public static ImageIcon LOADING_ICON;
    private final Integer[] fontSizes = new Integer[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48};
    static DocumentModel docModel;
    private Globals global;
    private JTextPane textPane;
    private JScrollPane textPaneSP;
    private JToolBar mainToolBar;
    private JToolBar standardToolBar;
    private JToolBar formattingToolBar;
    private Vector<JToggleButton> formattingTBButtons;
    private Vector<JComponent> fontTBComponents;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu styleMenu;
    private JComboBox fontComboBox;
    private JComboBox sizeComboBox;
    private String[] systemFonts;
    private JFileChooser fileChooser;
    static JFrame frame;
    private JPanel main;
    private HashMap<String, Action> actions;
    private HashMap<String, Action> ekActions;
    private JProgressBar progressBar;
    private JLabel progressBarLabel;
    private JPanel progressBarPanel;
    private JRadioButton[] radioButtonArray;
    private ButtonGroup radioButtonGroup;
    private JLabel listHeader;
    private JLabel nextPreviousLabel;
    private CardPanel<InstanceStepPanel> stepPanel;
    private JList wordList;
    private JScrollPane wordListSP;
    private JRadioButton wordListAZ;
    private JRadioButton wordListFreq;
    private ButtonGroup wordListOrderRBs;
    private InstanceHolder<? extends Instance> selectedHolder;
    private Instance selectedInstance;
    private JSpinner thresholdSpinner;
    private JSlider fScoreSlider;
    private File currentFile;
    private int currentFileType;
    private JToggleButton boldToggle;
    private JToggleButton italicToggle;
    private JToggleButton underlineToggle;
    private Style currentViewAttributes;
    private Style removeHighlight;
    private Style mainHighlight;
    private Style selectedHighlight;
    private Style ignored;
    private Style instanceHighlight;
    private static final Color SELECTION_COLOUR;
    private UIUpdatingUndoManager undoManager = new UIUpdatingUndoManager();
    static UndoableEditSupport undoSupport;
    private ConfidenceWeights confidenceWeights;
    static LookUpDictionary lud;

    static {
        SELECTION_COLOUR = new Color(120, 220, 120);
        undoSupport = new UndoableEditSupport();
    }

    public static void run() {
        URL loadingURL = MainScreen.class.getResource("icons/loading.gif");
        if (loadingURL != null) {
            LOADING_ICON = new ImageIcon(loadingURL);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                new MainScreen(null);
            }
        };
        thread.setPriority(10);
        thread.start();
    }

    private MainScreen() {
        this.global = Globals.getInstance();
        docModel = DocumentModel.getInstance();
        lud = LookUpDictionary.getInstance();
        this.confidenceWeights = ConfidenceWeights.getInstance();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Loading user interface...");
        this.global.lockFinishProgress();
        undoSupport.addUndoableEditListener(this.undoManager);
        this.textPane = new JTextPane();
        this.textPane.setSelectedTextColor(Color.RED);
        this.currentViewAttributes = this.textPane.addStyle("Current View", null);
        this.removeHighlight = this.textPane.addStyle("Remove Highlight", null);
        StyleConstants.setBackground(this.removeHighlight, Color.WHITE);
        StyleConstants.setForeground(this.removeHighlight, Color.BLACK);
        this.mainHighlight = this.textPane.addStyle("Highlight Yellow", null);
        StyleConstants.setBackground(this.mainHighlight, Color.YELLOW);
        StyleConstants.setForeground(this.mainHighlight, Color.BLACK);
        this.selectedHighlight = this.textPane.addStyle("Highlight Selected", null);
        StyleConstants.setBackground(this.selectedHighlight, SELECTION_COLOUR);
        StyleConstants.setForeground(this.selectedHighlight, Color.BLACK);
        this.instanceHighlight = this.textPane.addStyle("Selected Instance", null);
        StyleConstants.setBackground(this.instanceHighlight, new Color(240, 160, 160));
        StyleConstants.setForeground(this.instanceHighlight, Color.BLACK);
        this.ignored = this.textPane.addStyle("Ignored", null);
        StyleConstants.setBackground(this.ignored, Color.WHITE);
        StyleConstants.setForeground(this.ignored, Color.LIGHT_GRAY);
        this.ekActions = new HashMap();
        Action[] aa = this.textPane.getEditorKit().getActions();
        int i = 0;
        while (i < aa.length) {
            Action a = aa[i];
            this.ekActions.put((String)a.getValue("Name"), a);
            ++i;
        }
        this.actions = new HashMap();
        this.actions.put("New", this.fixAction(new NewAction(), "New", "page_white_text", "Create a new file", 78, KeyStroke.getKeyStroke(78, 2)));
        this.actions.put("Open", this.fixAction(new OpenAction(), "Open", "folder_page", "Open a file to analyse", 79, KeyStroke.getKeyStroke(79, 2)));
        this.actions.put("Save", this.fixAction(new SaveAction(), "Save", "disk", "Save current file", 83, KeyStroke.getKeyStroke(83, 2)));
        this.actions.put("Save As Plain", this.fixAction(new SaveAsPlainAction(), "Save Without XML Tags", "script_save", "Save the file in it's original format, but with variants replaced (unmarked).", 84, null));
        this.actions.put("Save As XML", this.fixAction(new ExportToXMLAction(), "Save With XML Tags", "script_code_red", "Saves the file with variants replaced and marked. No formatting will be saved.", 88, null));
        this.actions.put("Save Dictionary", this.fixAction(new SaveDictionaryAction(), "Save Dictionary", "book_add", "Save changes to dictionary", 68, null));
        this.actions.put("Save Variant List", this.fixAction(new SaveVariantsAction(), "Save Variant List", "table_add", "Save changes to known variants list", 86, null));
        this.actions.put("Save Rule List", this.fixAction(new SaveRulesAction(), "Save Rule List", "brick_add", "Save changes to rule list", 82, null));
        this.actions.put("Save Confidence Weights", this.fixAction(new SaveConfidenceWeightsAction(), "Save Confidence Weights", "chart_pie_add", "Save changes to replacement method confidence weights", 67, null));
        this.actions.put("Save All", this.fixAction(new SaveAllAction(), "Save All", "disk_multiple", "Save document, dictionary, variant list, rule list and confidence weights", 65, null));
        this.actions.put("Exit", this.fixAction(new ExitAction(), "Exit", "door", null, 88, null));
        this.actions.put("Copy", this.fixAction(new DefaultEditorKit.CopyAction(), "Copy", "page_copy", "Copy selected text to clipboard", 67, KeyStroke.getKeyStroke(67, 2)));
        this.actions.put("Paste", this.fixAction(new PasteAction(), "Paste", "paste_plain", "Paste text from clipboard into document", 80, KeyStroke.getKeyStroke(86, 2)));
        this.actions.put("Bold", this.fixAction(new StyledEditorKit.BoldAction(), "Bold", "text_bold", "Toggle Bold on selected text", 66, KeyStroke.getKeyStroke(66, 2)));
        this.actions.put("Italic", this.fixAction(new StyledEditorKit.ItalicAction(), "Italic", "text_italic", "Toggle Italic on selected text", 73, KeyStroke.getKeyStroke(73, 2)));
        this.actions.put("Underline", this.fixAction(new StyledEditorKit.UnderlineAction(), "Underline", "text_underline", "Toggle Underline on selected text", 85, KeyStroke.getKeyStroke(85, 2)));
        this.actions.put("Select All", this.fixAction(this.getDefaultActionByName("select-all"), "Select All", "arrow_out", "Select All Text In Document", 65, KeyStroke.getKeyStroke(65, 2)));
        this.actions.put("Correct All", this.fixAction(new ProcessAllVariantsAction(), "Normalise all", null, "Normalise all variants with top replacement when above threshold", -1, null));
        this.actions.put("Copy List", this.fixAction(new CopyListAction(), "Copy Current List", null, "Copy current list to system's clipboard", -1, null));
        this.actions.put("Join", this.fixAction(new JoinAction(), "Join", "arrow_join", "Join two or more words.", -1, null));
        this.actions.put("Undo", this.fixAction(new UndoAction(), "Undo", "arrow_undo", "Undo", 85, KeyStroke.getKeyStroke(90, 2)));
        this.actions.put("Redo", this.fixAction(new RedoAction(), "Redo", "arrow_redo", "Redo", 82, KeyStroke.getKeyStroke(89, 2)));
        this.actions.put("Rule List Manager", this.fixAction(new RuleListManagerAction(), "Rule List Manager", "brick_edit", "Open rule list manager", 82, KeyStroke.getKeyStroke(82, 2)));
        this.actions.put("Next Instance", this.fixAction(new NextInstanceAction(), "Next Instance", "resultset_next", "Find the next instance of the selected word.", 39, KeyStroke.getKeyStroke(39, 0)));
        this.actions.put("Previous Instance", this.fixAction(new PreviousInstanceAction(), "Previous Instance", "resultset_previous", "Find the previous instance of the selected word.", 37, KeyStroke.getKeyStroke(37, 0)));
        this.actions.put("First Instance", this.fixAction(new FirstInstanceAction(), "First Instance", "resultset_first", "Find the first instance of the selected word.", -1, KeyStroke.getKeyStroke(37, 2)));
        this.actions.put("Last Instance", this.fixAction(new LastInstanceAction(), "Last Instance", "resultset_last", "Find the last instance of the selected word.", -1, KeyStroke.getKeyStroke(39, 2)));
        this.actions.put("Text Control", this.fixAction(new TextInstancesControlAction(), "Text Instances", "arrow_left", "Cycle through instances in the text during step complete.", -1, null));
        this.actions.put("Type Control", this.fixAction(new TypeInstancesControlAction(), "Type Instances", "arrow_up", "Cycle through instances of the currently selected type during step complete.", -1, null));
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.main = new JPanel(new BorderLayout());
        this.textPane.setEditable(false);
        this.textPaneSP = new JScrollPane(this.textPane, 22, 31);
        this.currentFile = null;
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                if (MainScreen.this.allowEditing) {
                    int end;
                    int start = evt.getMark();
                    if (start == (end = evt.getDot())) {
                        start = docModel.getStartOfDoc();
                        end = docModel.getEndOfDoc();
                        MainScreen.this.getActionByName("Copy").setEnabled(false);
                        MainScreen.this.getActionByName("Join").setEnabled(false);
                    } else {
                        MainScreen.this.getActionByName("Copy").setEnabled(true);
                        MainScreen.this.getActionByName("Join").setEnabled(true);
                    }
                    if (start > end) {
                        start = evt.getDot();
                        end = evt.getMark();
                    }
                    try {
                        MainScreen.this.updateAttributesViewWithAttributesOfRange(start, end);
                    }
                    catch (BadLocationException ex) {
                        MainScreen.this.global.showException("Error occurred whilst finding the attributes for the selected word.\n\n", ex);
                    }
                }
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MainScreen.this.allowEditing && e.getButton() == 3) {
                    Rectangle wordRect;
                    Instance instance;
                    block20: {
                        int caretPos = MainScreen.this.textPane.viewToModel(e.getPoint());
                        MainScreen.this.textPane.setCaretPosition(caretPos);
                        instance = null;
                        try {
                            try {
                                instance = docModel.getWordAt(caretPos);
                            }
                            catch (BadLocationException ex) {
                                MainScreen.this.global.showException("Error occurred finding word.", ex);
                                if (instance == null) {
                                    return;
                                }
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            if (instance == null) {
                                return;
                            }
                            throw throwable;
                        }
                        if (instance == null) {
                            return;
                        }
                    }
                    WordHolder wh = instance.getHolder();
                    try {
                        wordRect = MainScreen.this.textPane.modelToView(instance.getEndOffset());
                    }
                    catch (BadLocationException ex) {
                        MainScreen.this.global.showException("Error occurred trying to find word.", ex);
                        return;
                    }
                    switch (instance.getType()) {
                        case 101: {
                            JPopupMenu popup = new JPopupMenu();
                            JMenuItem wait = new JMenuItem("Please Wait...");
                            wait.setEnabled(false);
                            popup.add(wait);
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            JMenu more = new JMenu("More Suggestions...");
                            int added = 0;
                            docModel.findReplacementsForWord(wh, 25);
                            List<SuggestedReplacement> reps = wh.getReplacements();
                            for (SuggestedReplacement replacement : reps) {
                                JMenu repPopup = MainScreen.this.getReplacementPopupMenu(replacement, wh, (VariantInstance)instance, 101, instance.getCapitalization());
                                if (added < 5) {
                                    popup.add(repPopup);
                                    ++added;
                                    continue;
                                }
                                more.add(repPopup);
                                ++added;
                            }
                            if (added == 0) {
                                JMenuItem noneFound = new JMenuItem("No Replacements found");
                                noneFound.setEnabled(false);
                                popup.add(noneFound);
                            }
                            if (added > 5) {
                                popup.add(more);
                            }
                            popup.addSeparator();
                            popup.add(new ReplaceWithAction<VariantInstance>((VariantInstance)instance));
                            popup.add(new MarkFInstanceAsTAction<VariantInstance, CorrectInstance>((VariantInstance)instance, new CorrectInstance()));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new MarkAllFInstancesAsTAction<VariantInstance, CorrectInstance>(wh, new VariantInstance(), new CorrectInstance()));
                            popup.setVisible(false);
                            popup.remove(wait);
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            break;
                        }
                        case 103: {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new MarkFInstanceAsTAction<CorrectInstance, VariantInstance>((CorrectInstance)instance, new VariantInstance()));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new MarkAllFInstancesAsTAction<CorrectInstance, VariantInstance>(wh, new CorrectInstance(), new VariantInstance()));
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            break;
                        }
                        case 102: {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new RevertInstanceAction((ReplacedInstance)instance, docModel.getDoc()));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new RevertAllAction(wh, ((ReplacedInstance)instance).getReplacement(), docModel.getDoc()));
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                        }
                    }
                }
            }
        });
        this.textPane.setTransferHandler(new InteractiveTransferHandler());
        this.systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontComboBox = new JComboBox<String>(this.systemFonts);
        this.fontComboBox.setEditable(true);
        this.fontComboBox.addActionListener(new ActionListener(){
            boolean shownOnce = false;

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("skip")) {
                    return;
                }
                String f = (String)MainScreen.this.fontComboBox.getSelectedItem();
                if (Arrays.binarySearch(MainScreen.this.systemFonts, f) < 0) {
                    if (!this.shownOnce) {
                        this.shownOnce = true;
                        int yn = JOptionPane.showConfirmDialog(frame, "The font '" + f + "' is not available on this system, do you still wish to use it?", "' " + f + "' not found", 0);
                        if (yn == 1) {
                            return;
                        }
                    } else {
                        this.shownOnce = false;
                        return;
                    }
                }
                Style style = MainScreen.this.textPane.addStyle("Font " + f, null);
                StyleConstants.setFontFamily(style, f);
                StyleConstants.setFontFamily(MainScreen.this.currentViewAttributes, f);
                MainScreen.this.textPane.setCharacterAttributes(style, false);
                MainScreen.this.textPane.requestFocus();
            }
        });
        this.fontComboBox.setMaximumSize(this.fontComboBox.getPreferredSize());
        this.sizeComboBox = new JComboBox<Integer>(this.fontSizes);
        this.sizeComboBox.setEditable(true);
        this.sizeComboBox.addActionListener(new ActionListener(){
            boolean shownOnce = false;

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("skip")) {
                    return;
                }
                if (!(MainScreen.this.sizeComboBox.getSelectedItem() instanceof Integer)) {
                    if (!this.shownOnce) {
                        MainScreen.this.displayError("Not a valid font size");
                        this.shownOnce = true;
                    } else {
                        this.shownOnce = false;
                    }
                    return;
                }
                Integer s = (Integer)MainScreen.this.sizeComboBox.getSelectedItem();
                Style style = MainScreen.this.textPane.addStyle("Size " + s, null);
                StyleConstants.setFontSize(style, s);
                StyleConstants.setFontSize(MainScreen.this.currentViewAttributes, s);
                MainScreen.this.textPane.setCharacterAttributes(style, false);
                MainScreen.this.textPane.requestFocus();
            }
        });
        this.sizeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                MainScreen.this.textPane.requestFocus();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                MainScreen.this.textPane.requestFocus();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.sizeComboBox.setMaximumSize(this.sizeComboBox.getPreferredSize());
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setValue(0);
        this.progressBarLabel = new JLabel();
        this.resetProgressBarLabel();
        this.progressBarPanel = new JPanel(new BorderLayout());
        this.progressBarPanel.add((Component)this.progressBar, "Center");
        this.progressBarPanel.add((Component)this.progressBarLabel, "West");
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        this.mainToolBar = new JToolBar("Functions");
        this.mainToolBar.setFloatable(false);
        JToolBar textTB = new JToolBar("Text");
        textTB.setFloatable(false);
        this.standardToolBar = new JToolBar("Standard");
        this.standardToolBar.setFloatable(false);
        this.standardToolBar.add(new TBJButton(this.getActionByName("New")));
        this.standardToolBar.add(new TBJButton(this.getActionByName("Open")));
        this.standardToolBar.add(new TBJButton(this.getActionByName("Save")));
        this.standardToolBar.add(new TBJButton(this.getActionByName("Save All")));
        this.standardToolBar.addSeparator();
        textTB.add(new TBJButton(this.getActionByName("Undo")));
        textTB.add(new TBJButton(this.getActionByName("Redo")));
        this.standardToolBar.add(new TBJButton(this.getActionByName("Copy")));
        this.standardToolBar.add(new TBJButton(this.getActionByName("Paste")));
        this.standardToolBar.add(new TBJButton(this.getActionByName("Select All")));
        this.mainToolBar.add(this.standardToolBar);
        JToolBar fScoreTB = new JToolBar("F-Score");
        fScoreTB.setToolTipText("Change F-Score Precision/Recall weight");
        fScoreTB.setFloatable(false);
        fScoreTB.add(new JLabel("P"));
        this.fScoreSlider = new JSlider(-4, 4, 0);
        this.fScoreSlider.setToolTipText("Change F-Score Precision/Recall weight");
        this.fScoreSlider.setMaximumSize(new Dimension(180, 50));
        this.fScoreSlider.setMajorTickSpacing(1);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("1"));
        labelTable.put(1, new JLabel("2"));
        labelTable.put(2, new JLabel("3"));
        labelTable.put(3, new JLabel("4"));
        labelTable.put(4, new JLabel("5"));
        labelTable.put(-1, new JLabel("\u00bd"));
        labelTable.put(-2, new JLabel("\u2153"));
        labelTable.put(-3, new JLabel("\u00bc"));
        labelTable.put(-4, new JLabel("\u2155"));
        this.fScoreSlider.setLabelTable(labelTable);
        this.fScoreSlider.setPaintLabels(true);
        this.fScoreSlider.setSnapToTicks(true);
        fScoreTB.add(this.fScoreSlider);
        fScoreTB.add(new JLabel("R"));
        this.fScoreSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((MainScreen)MainScreen.this).confidenceWeights.F_WEIGHT = ConfidenceWeights.calculateFWeight(MainScreen.this.fScoreSlider.getValue());
                MainScreen.this.confidenceWeights.setHasChanged(true);
            }
        });
        textTB.addSeparator();
        textTB.add(new TBJButton(this.getActionByName("Join")));
        textTB.addSeparator();
        textTB.add(fScoreTB);
        this.formattingToolBar = new JToolBar("Formatting");
        this.formattingToolBar.setFloatable(false);
        this.fontTBComponents = new Vector();
        this.fontTBComponents.add(this.fontComboBox);
        this.fontTBComponents.add(this.sizeComboBox);
        for (JComponent component : this.fontTBComponents) {
            this.formattingToolBar.add(component);
        }
        this.formattingTBButtons = new Vector();
        this.boldToggle = new JToggleButton(this.getActionByName("Bold"));
        this.italicToggle = new JToggleButton(this.getActionByName("Italic"));
        this.underlineToggle = new JToggleButton(this.getActionByName("Underline"));
        this.formattingTBButtons.add(this.boldToggle);
        this.formattingTBButtons.add(this.italicToggle);
        this.formattingTBButtons.add(this.underlineToggle);
        for (JToggleButton button : this.formattingTBButtons) {
            button.setText("");
            button.setFocusable(false);
            this.formattingToolBar.add(button);
        }
        this.mainToolBar.addSeparator();
        this.mainToolBar.add(this.formattingToolBar);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.add(this.getActionByName("New"));
        this.fileMenu.add(this.getActionByName("Open"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getActionByName("Save"));
        this.fileMenu.add(this.getActionByName("Save As XML"));
        this.fileMenu.add(this.getActionByName("Save As Plain"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getActionByName("Save Dictionary"));
        this.fileMenu.add(this.getActionByName("Save Variant List"));
        this.fileMenu.add(this.getActionByName("Save Rule List"));
        this.fileMenu.add(this.getActionByName("Save Confidence Weights"));
        this.fileMenu.add(this.getActionByName("Save All"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getActionByName("Exit"));
        this.menuBar.add(this.fileMenu);
        this.getActionByName("Save Rule List").setEnabled(false);
        this.getActionByName("Save Variant List").setEnabled(false);
        this.getActionByName("Save Dictionary").setEnabled(false);
        this.getActionByName("Save Confidence Weights").setEnabled(false);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.editMenu.add(this.getActionByName("Undo"));
        this.editMenu.add(this.getActionByName("Redo"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("Join"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("Copy"));
        this.editMenu.add(this.getActionByName("Paste"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("Select All"));
        this.menuBar.add(this.editMenu);
        this.styleMenu = new JMenu("Style");
        this.styleMenu.setMnemonic(83);
        this.styleMenu.add(this.getActionByName("Bold"));
        this.styleMenu.add(this.getActionByName("Italic"));
        this.styleMenu.add(this.getActionByName("Underline"));
        this.menuBar.add(this.styleMenu);
        JMenu advancedMenu = new JMenu("Advanced");
        advancedMenu.setMnemonic(65);
        advancedMenu.add(this.getActionByName("Rule List Manager"));
        this.menuBar.add(advancedMenu);
        this.radioButtonArray = new JRadioButton[WordHolder.types.length];
        this.radioButtonGroup = new ButtonGroup();
        JPanel displaySelectPanel = new JPanel();
        displaySelectPanel.setLayout(new BoxLayout(displaySelectPanel, 3));
        displaySelectPanel.add(new JLabel(" "));
        int i2 = 0;
        while (i2 < this.radioButtonArray.length) {
            this.radioButtonArray[i2] = new JRadioButton(new RadioButtonAction(WordHolder.types[i2]));
            this.radioButtonGroup.add(this.radioButtonArray[i2]);
            displaySelectPanel.add(this.radioButtonArray[i2]);
            this.radioButtonArray[i2].setAlignmentX(0.0f);
            this.radioButtonArray[i2].setFocusable(false);
            ++i2;
        }
        this.radioButtonArray[0].setSelected(true);
        JLabel sortHeader = new JLabel("Sort by:");
        sortHeader.setAlignmentX(0.0f);
        this.wordListAZ = new JRadioButton("A-Z");
        this.wordListAZ.setSelected(true);
        this.wordListFreq = new JRadioButton("Frequency (Desc.)");
        this.wordListOrderRBs = new ButtonGroup();
        this.wordListOrderRBs.add(this.wordListAZ);
        this.wordListOrderRBs.add(this.wordListFreq);
        this.wordListAZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainScreen.this.updateList(MainScreen.this.listSelected);
            }
        });
        this.wordListFreq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MainScreen.this.updateList(MainScreen.this.listSelected);
            }
        });
        JPanel sortPanel = new JPanel(new BorderLayout());
        sortPanel.add((Component)sortHeader, "North");
        sortPanel.add((Component)this.wordListAZ, "West");
        sortPanel.add((Component)this.wordListFreq, "East");
        this.listHeader = new JLabel("");
        this.listHeader.setAlignmentX(0.0f);
        this.wordList = new JList();
        this.wordList.setFocusable(false);
        this.wordList.setPrototypeCellValue("1234567890123456789012345");
        this.wordList.setVisibleRowCount(7);
        this.wordList.setSelectionBackground(SELECTION_COLOUR);
        this.wordList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!MainScreen.this.wordList.isSelectionEmpty()) {
                    InstanceHolder selectedValue = (InstanceHolder)MainScreen.this.wordList.getSelectedValue();
                    MainScreen.this.changeSelectedWord(selectedValue);
                    MainScreen.this.wordList.ensureIndexIsVisible(MainScreen.this.wordList.getSelectedIndex() - 3);
                    MainScreen.this.wordList.ensureIndexIsVisible(MainScreen.this.wordList.getSelectedIndex() + 3);
                }
            }
        });
        this.wordList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainScreen.this.allowEditing && e.getButton() == 3) {
                    int toSelect = MainScreen.this.wordList.locationToIndex(e.getPoint());
                    MainScreen.this.wordList.setSelectedIndex(toSelect);
                    InstanceHolder instanceHolder = (InstanceHolder)MainScreen.this.wordList.getSelectedValue();
                    if (instanceHolder == null) {
                        return;
                    }
                    WordHolder wordHolder = instanceHolder.getWordHolder();
                    Rectangle cellRect = MainScreen.this.wordList.getCellBounds(toSelect, toSelect);
                    switch (instanceHolder.getType()) {
                        case 101: {
                            JPopupMenu popup = new JPopupMenu();
                            JMenuItem wait = new JMenuItem("Please Wait...");
                            wait.setEnabled(false);
                            popup.add(wait);
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                            JMenu more = new JMenu("More Suggestions...");
                            int added = 0;
                            docModel.findReplacementsForWord(wordHolder, 25);
                            List<SuggestedReplacement> reps = wordHolder.getReplacements();
                            for (SuggestedReplacement replacement : reps) {
                                JMenu repPopup = MainScreen.this.getReplacementPopupMenu(replacement, wordHolder, null, 101, instanceHolder.getCapitalization());
                                if (added < 5) {
                                    popup.add(repPopup);
                                    ++added;
                                    continue;
                                }
                                more.add(repPopup);
                                ++added;
                            }
                            if (added == 0) {
                                JMenuItem noneFound = new JMenuItem("No Replacements found");
                                noneFound.setEnabled(false);
                                popup.add(noneFound);
                            }
                            if (added > 5) {
                                popup.add(more);
                            }
                            popup.addSeparator();
                            popup.add(new ReplaceWithAction<VariantInstance>(wordHolder, new VariantInstance()));
                            popup.add(new MarkAllFInstancesAsTAction<VariantInstance, CorrectInstance>(wordHolder, new VariantInstance(), new CorrectInstance()));
                            popup.setVisible(false);
                            popup.remove(wait);
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                            break;
                        }
                        case 103: {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new MarkAllFInstancesAsTAction<CorrectInstance, VariantInstance>(wordHolder, new CorrectInstance(), new VariantInstance()));
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                            break;
                        }
                        case 102: {
                            JPopupMenu popup = new JPopupMenu();
                            ReplacedInstance first = (ReplacedInstance)instanceHolder.firstInstance();
                            if (first == null) break;
                            popup.add(new RevertAllAction(wordHolder, first.getReplacement(), docModel.getDoc()));
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MainScreen.this.typeInstancesTB.setSelected(true);
                MainScreen.this.instancesControl = 55;
                if (MainScreen.this.selectedHolder != null) {
                    MainScreen.this.setSelectedInstance(MainScreen.this.selectedHolder.firstInstance());
                }
            }
        });
        this.wordListSP = new JScrollPane(this.wordList, 22, 31);
        this.wordListSP.setAlignmentX(0.0f);
        JButton copyListButton = new JButton(this.getActionByName("Copy List"));
        copyListButton.setFocusable(false);
        sortPanel.add((Component)this.listHeader, "South");
        JPanel typesListPanel = new JPanel(new BorderLayout());
        typesListPanel.setBorder(new TitledBorder("Types List"));
        typesListPanel.add((Component)sortPanel, "North");
        typesListPanel.add((Component)this.wordListSP, "Center");
        typesListPanel.add((Component)copyListButton, "South");
        this.nextPreviousLabel = new JLabel(" ", 0);
        this.nextPreviousLabel.setAlignmentX(0.5f);
        this.nextPreviousLabel.setMinimumSize(new Dimension(80, 20));
        this.nextPreviousLabel.setMaximumSize(new Dimension(80, 20));
        this.nextPreviousLabel.setPreferredSize(new Dimension(80, 20));
        JButton previousInstanceButton = new JButton(this.getActionByName("Previous Instance"));
        JButton nextInstanceButton = new JButton(this.getActionByName("Next Instance"));
        JButton firstInstanceButton = new JButton(this.getActionByName("First Instance"));
        JButton lastInstanceButton = new JButton(this.getActionByName("Last Instance"));
        Insets ei = new Insets(1, 1, 1, 1);
        previousInstanceButton.setFocusable(false);
        nextInstanceButton.setFocusable(false);
        previousInstanceButton.setText("");
        nextInstanceButton.setText("");
        previousInstanceButton.setMargin(ei);
        nextInstanceButton.setMargin(ei);
        firstInstanceButton.setFocusable(false);
        lastInstanceButton.setFocusable(false);
        firstInstanceButton.setText("");
        lastInstanceButton.setText("");
        firstInstanceButton.setMargin(ei);
        lastInstanceButton.setMargin(ei);
        JPanel nextPreviousPanel = new JPanel(new GridBagLayout());
        GridBagConstraints b = new GridBagConstraints();
        b.fill = 0;
        GridBagConstraints l = new GridBagConstraints();
        l.fill = 1;
        l.weightx = 1.0;
        nextPreviousPanel.add((Component)firstInstanceButton, b);
        nextPreviousPanel.add((Component)previousInstanceButton, b);
        nextPreviousPanel.add((Component)this.nextPreviousLabel, l);
        nextPreviousPanel.add((Component)nextInstanceButton, b);
        nextPreviousPanel.add((Component)lastInstanceButton, b);
        nextPreviousPanel.setAlignmentX(0.0f);
        this.textInstancesTB = new JToggleButton(this.getActionByName("Text Control"));
        this.textInstancesTB.setMargin(ei);
        this.typeInstancesTB = new JToggleButton(this.getActionByName("Type Control"));
        this.typeInstancesTB.setMargin(ei);
        ButtonGroup controlBG = new ButtonGroup();
        controlBG.add(this.textInstancesTB);
        controlBG.add(this.typeInstancesTB);
        this.textInstancesTB.setSelected(true);
        JPanel stepControlPanel = new JPanel(new BorderLayout());
        stepControlPanel.add((Component)this.textInstancesTB, "West");
        stepControlPanel.add((Component)this.typeInstancesTB, "East");
        stepControlPanel.add((Component)nextPreviousPanel, "South");
        this.stepPanel = new CardPanel();
        VariantStepPanel vsp = new VariantStepPanel();
        ReplacedStepPanel rsp = new ReplacedStepPanel();
        CorrectStepPanel csp = new CorrectStepPanel();
        this.stepPanel.add(new InstanceStepPanel(), 0);
        this.stepPanel.add(vsp, 101);
        this.stepPanel.add(rsp, 102);
        this.stepPanel.add(csp, 103);
        this.stepPanel.show(0);
        JPanel thresholdPanel = new JPanel(new BorderLayout());
        thresholdPanel.setBorder(new TitledBorder("Auto Normalise"));
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 100, 5));
        this.thresholdSpinner.setAlignmentX(0.0f);
        this.thresholdSpinner.setFocusable(false);
        JLabel thresholdLabel = new JLabel("Threshold (/100%):", 2);
        thresholdLabel.setLabelFor(this.thresholdSpinner);
        JButton correctAllButton = new JButton(this.getActionByName("Correct All"));
        correctAllButton.setFocusable(false);
        thresholdPanel.add((Component)thresholdLabel, "Center");
        thresholdPanel.add((Component)this.thresholdSpinner, "East");
        thresholdPanel.add((Component)correctAllButton, "South");
        JPanel allTypesPanel = new JPanel(new BorderLayout());
        allTypesPanel.add((Component)displaySelectPanel, "North");
        allTypesPanel.add((Component)typesListPanel, "Center");
        JPanel allStepPanel = new JPanel(new BorderLayout());
        allStepPanel.setBorder(new TitledBorder("Step Complete"));
        allStepPanel.add((Component)stepControlPanel, "North");
        allStepPanel.add((Component)this.stepPanel.getPanel(), "Center");
        JPanel sidebar = new JPanel(new BorderLayout());
        sidebar.add((Component)allTypesPanel, "North");
        sidebar.add((Component)allStepPanel, "Center");
        sidebar.add((Component)thresholdPanel, "South");
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.mainToolBar, "North");
        toolbars.add((Component)textTB, "South");
        JPanel methodsScoresPanel = new JPanel(new GridLayout(1, 4));
        methodsScoresPanel.setBorder(new EmptyBorder(5, 2, 5, 2));
        this.methodLabels = new LinkedHashMap<String, JLabel>();
        for (String method : this.confidenceWeights.getScores().keySet()) {
            JLabel ml = new JLabel(method);
            ml.setHorizontalAlignment(0);
            this.methodLabels.put(method, ml);
            methodsScoresPanel.add(ml);
        }
        this.updateMethodLabels();
        this.main.add((Component)methodsScoresPanel, "South");
        this.main.add((Component)toolbars, "North");
        this.main.add((Component)this.textPaneSP, "Center");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxWinSize = ge.getMaximumWindowBounds();
        frame = new JFrame(PROGRAM_TITLE);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainScreen.this.doExit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        JPanel sideBarHolder = new JPanel(new GridBagLayout());
        sideBarHolder.setAlignmentY(1.0f);
        GridBagConstraints sb = new GridBagConstraints();
        sb.fill = 0;
        sb.anchor = 19;
        sb.gridx = 0;
        sb.gridy = 0;
        sideBarHolder.add((Component)sidebar, sb);
        GridBagConstraints glue = new GridBagConstraints();
        glue.fill = 1;
        glue.gridx = 0;
        glue.gridy = 1;
        glue.weighty = 1.0;
        sideBarHolder.add(Box.createGlue(), glue);
        frame.setJMenuBar(this.menuBar);
        frame.getContentPane().add((Component)this.main, "Center");
        frame.getContentPane().add((Component)sideBarHolder, "East");
        frame.add((Component)this.progressBarPanel, "South");
        frame.setMaximizedBounds(maxWinSize);
        frame.setBounds(maxWinSize.x, maxWinSize.y, maxWinSize.width, maxWinSize.height);
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            docModel.addChangeListener(new HolderChangeListener(){

                @Override
                public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
                    MainScreen.this.updateList(type);
                    Instance toSelectInstance = MainScreen.this.selectedInstance;
                    if (toSelectInstance != null && MainScreen.this.listSelected == type && MainScreen.this.selectedHolder == holder && !MainScreen.this.selectedHolder.contains(MainScreen.this.selectedInstance)) {
                        switch (MainScreen.this.instancesControl) {
                            case 55: {
                                TreeSet<InstanceHolder<? extends Instance>> list;
                                toSelectInstance = MainScreen.this.selectedHolder.nextInstance(MainScreen.this.selectedInstance);
                                if (toSelectInstance != null || (list = docModel.getHolderList(MainScreen.this.listSelected)).isEmpty()) break;
                                InstanceHolder<? extends Instance> next = null;
                                if (MainScreen.this.wordListFreq.isSelected()) {
                                    TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
                                    resorted.addAll(list);
                                    list = resorted;
                                } else {
                                    next = list.higher(MainScreen.this.selectedHolder);
                                }
                                if (next == null) {
                                    next = list.first();
                                }
                                MainScreen.this.wordList.setSelectedValue(next, true);
                                toSelectInstance = next.firstInstance();
                                break;
                            }
                            case 56: {
                                toSelectInstance = docModel.getNextInstance(type, MainScreen.this.selectedInstance);
                            }
                        }
                    }
                    MainScreen.this.setSelectedInstance(toSelectInstance);
                }

                @Override
                public void instanceAboutToChange(Instance instance, int type) {
                    instance.changeHighlight(docModel.getDoc(), MainScreen.this.removeHighlight);
                }

                @Override
                public void instanceChanged(Instance instance, int type) {
                    if (MainScreen.this.selectedHolder != null && MainScreen.this.selectedHolder.contains(instance)) {
                        instance.changeHighlight(docModel.getDoc(), MainScreen.this.selectedHighlight);
                    } else if (MainScreen.this.listSelected == type) {
                        instance.changeHighlight(docModel.getDoc(), MainScreen.this.mainHighlight);
                    } else {
                        instance.changeHighlight(docModel.getDoc(), MainScreen.this.removeHighlight);
                    }
                }

                @Override
                public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                }

                @Override
                public void holderFilled(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                }
            }, t);
            ++n2;
        }
        this.global.finishProgress();
        this.global.setProgressHandler(this);
        this.global.setExceptionHandler(this);
        this.show();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Completing statup...");
        this.setupTextPane();
        lud.addDataChangeListener(this);
        this.confidenceWeights.addChangeListener(this);
        this.global.setGlobalIgnorableTextListener(new IgnorableTextListener(){

            @Override
            public void ignore(IgnorableText it) {
                it.changeHighlight(docModel.getDoc(), MainScreen.this.ignored);
            }

            @Override
            public void unIgnore(IgnorableText it) {
                it.changeHighlight(docModel.getDoc(), MainScreen.this.removeHighlight);
            }
        });
        this.clearText();
        this.global.unlockFinishProgress();
        this.global.finishProgress();
    }

    private void updateMethodLabels() {
        Set<Map.Entry<String, MethodScores>> methods = this.confidenceWeights.getScores().entrySet();
        for (Map.Entry<String, MethodScores> method : methods) {
            this.methodLabels.get(method.getKey()).setText(String.valueOf(method.getKey()) + ": " + method.getValue().toMenuString(this.confidenceWeights.F_WEIGHT));
        }
    }

    private Action fixAction(Action action, String name, String icon, String description, int mnemonic, KeyStroke keyStroke) {
        URL iconURL;
        if (name != null) {
            action.putValue("Name", name);
        }
        if (icon != null && (iconURL = MainScreen.class.getResource("icons/" + icon + ".png")) != null) {
            action.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        if (description != null) {
            action.putValue("ShortDescription", description);
        }
        if (mnemonic != -1) {
            action.putValue("MnemonicKey", new Integer(mnemonic));
        }
        if (keyStroke != null) {
            action.putValue("AcceleratorKey", keyStroke);
        }
        return action;
    }

    private Action getDefaultActionByName(String name) {
        return this.ekActions.get(name);
    }

    private Action getActionByName(String name) {
        return this.actions.get(name);
    }

    private void setAllActionsEnabled(boolean enabled) {
        for (Action a : this.actions.values()) {
            a.setEnabled(enabled);
        }
    }

    private void updateList(int type) {
        int radioButton = -1;
        int i = 0;
        while (i < WordHolder.types.length) {
            if (WordHolder.types[i] == type) {
                radioButton = i;
            }
            ++i;
        }
        this.radioButtonArray[radioButton].setText(String.valueOf(WordHolder.getTypeName(type)) + " (" + docModel.getTokenCount(type) + " tokens)");
        if (this.listSelected == type) {
            Object currentListSelection = this.wordList.getSelectedValue();
            TreeSet<InstanceHolder<? extends Instance>> hl = docModel.getHolderList(type);
            if (this.wordListFreq.isSelected()) {
                TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
                resorted.addAll(hl);
                hl = resorted;
            }
            Object[] holderList = hl.toArray();
            this.wordList.setListData(holderList);
            this.listHeader.setText(" " + WordHolder.getTypeName(type) + " (" + holderList.length + " types):");
            this.wordList.setSelectedValue(currentListSelection, true);
        }
    }

    private void show() {
        frame.setVisible(true);
        this.textPane.requestFocus();
    }

    private JMenu getReplacementPopupMenu(SuggestedReplacement replacement, WordHolder wh, VariantInstance instance, int type, int capitalization) {
        double weight = this.confidenceWeights.F_WEIGHT;
        JMenu toReturn = new JMenu(replacement.toMenuString(capitalization));
        Set<String> methods = this.confidenceWeights.getScores().keySet();
        Vector<JMenuItem> mis = new Vector<JMenuItem>(1 + methods.size());
        for (String method : methods) {
            mis.add(new JMenuItem(String.valueOf(method) + ": " + replacement.getScoreUpdate(method).getUpdate().toMenuString(weight)));
        }
        mis.add(new JMenuItem("Frequency is " + replacement.getReplacement().getFreq()));
        if (instance != null && instance.getType() == 101) {
            toReturn.add(new ReplaceFInstanceAction<VariantInstance>(instance, replacement, docModel.getDoc()));
        }
        if (type == 101) {
            toReturn.add(new ReplaceAllFInstancesAction<VariantInstance>(wh, new VariantInstance(), replacement, docModel.getDoc()));
        }
        toReturn.addSeparator();
        for (JMenuItem m : mis) {
            m.setEnabled(false);
            toReturn.add(m);
        }
        return toReturn;
    }

    private void resetProgressBarLabel() {
        this.progressBarLabel.setText("");
        this.progressBarLabel.setIcon(null);
    }

    private void setProgressBarLabelLoading(String text) {
        this.progressBarLabel.setText(text);
        this.progressBarLabel.setIcon(LOADING_ICON);
    }

    private boolean checkSave() {
        Object[] options;
        int pc;
        if (docModel.getDoc().getLength() == 0) {
            return true;
        }
        JPanel savePanel = new JPanel(new GridLayout(0, 1));
        JCheckBox docCB = new JCheckBox("Current Document", false);
        JCheckBox cwCB = new JCheckBox("Confidence Weights", false);
        JCheckBox dCB = new JCheckBox("Dictionary", false);
        JCheckBox vCB = new JCheckBox("Variant list", false);
        JCheckBox rCB = new JCheckBox("Letter replacement rules", false);
        savePanel.add(new JLabel("Tick changes to save:"));
        docCB.setSelected(true);
        savePanel.add(docCB);
        if (ConfidenceWeights.hasChanged()) {
            cwCB.setSelected(true);
            savePanel.add(cwCB);
        }
        if (LookUpDictionary.isWordsChanged()) {
            dCB.setSelected(true);
            savePanel.add(dCB);
        }
        if (LookUpDictionary.isVariantsChanged()) {
            vCB.setSelected(true);
            savePanel.add(vCB);
        }
        if (LookUpDictionary.isRulesChanged()) {
            rCB.setSelected(true);
            savePanel.add(rCB);
        }
        if ((pc = JOptionPane.showOptionDialog(frame, savePanel, "Save changes?", 1, 3, null, options = new Object[]{"Save changes", "Discard changes", "Cancel"}, options[0])) == 0) {
            if (docCB.isSelected() && !this.save()) {
                return false;
            }
            try {
                if (dCB.isSelected()) {
                    lud.writeWordsToFile();
                }
                if (vCB.isSelected()) {
                    lud.writeVariantsToFile();
                }
                if (rCB.isSelected()) {
                    lud.writeRulesToFile();
                }
                if (cwCB.isSelected()) {
                    this.confidenceWeights.save();
                }
                return true;
            }
            catch (IOException ex) {
                this.global.showException("Error writing file.", ex);
                return false;
            }
        }
        return pc == 1;
    }

    private void doExit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (MainScreen.this.checkSave()) {
                    System.exit(0);
                }
            }
        }).start();
    }

    private void changeSelectedWord(InstanceHolder<? extends Instance> newSelection) {
        InstanceHolder<? extends Instance> oldSelection = this.selectedHolder;
        this.selectedHolder = newSelection;
        if (oldSelection != null) {
            Style oldHighlight = this.removeHighlight;
            if (oldSelection.getType() == this.listSelected) {
                oldHighlight = this.mainHighlight;
            }
            oldSelection.setAllInstancesHighlights(docModel.getDoc(), oldHighlight);
        }
        if (this.selectedHolder != null) {
            this.selectedHolder.setAllInstancesHighlights(docModel.getDoc(), this.selectedHighlight);
        }
    }

    private void updateAttributesViewWithAttributesOfRange(int start, int end) throws BadLocationException {
        String font = "";
        int size = 0;
        boolean boldDisagree = false;
        boolean italicDisagree = false;
        boolean underlineDisagree = false;
        boolean sizeDisagree = false;
        boolean fontDisagree = false;
        while (!docModel.isCharAtPosLetter(start) && start < end - 1) {
            ++start;
        }
        AttributeSet cas = docModel.getAttributesAtPos(start);
        boolean bold = StyleConstants.isBold(cas);
        boolean italic = StyleConstants.isItalic(cas);
        boolean underline = StyleConstants.isUnderline(cas);
        font = StyleConstants.getFontFamily(cas);
        size = StyleConstants.getFontSize(cas);
        int i = start + 1;
        while (i < end) {
            if (docModel.isCharAtPosLetter(i)) {
                cas = docModel.getAttributesAtPos(i);
                if (!boldDisagree && StyleConstants.isBold(cas) != bold) {
                    bold = false;
                    boldDisagree = true;
                }
                if (!italicDisagree && StyleConstants.isItalic(cas) != italic) {
                    italic = false;
                    italicDisagree = true;
                }
                if (!underlineDisagree && StyleConstants.isUnderline(cas) != underline) {
                    underline = false;
                    underlineDisagree = true;
                }
                if (!fontDisagree && !StyleConstants.getFontFamily(cas).equals(font)) {
                    font = "";
                    fontDisagree = true;
                }
                if (!sizeDisagree && StyleConstants.getFontSize(cas) != size) {
                    size = 0;
                    sizeDisagree = true;
                }
            }
            ++i;
        }
        this.fontComboBox.setActionCommand("skip");
        this.fontComboBox.setSelectedItem(font);
        this.fontComboBox.setActionCommand("do it");
        this.sizeComboBox.setActionCommand("skip");
        if (size == 0) {
            this.sizeComboBox.setSelectedItem("");
        } else {
            this.sizeComboBox.setSelectedItem(size);
        }
        this.sizeComboBox.setActionCommand("do it");
        this.boldToggle.getModel().setSelected(bold);
        this.italicToggle.getModel().setSelected(italic);
        this.underlineToggle.getModel().setSelected(underline);
    }

    private void clearText() {
        this.selectedHolder = null;
        this.setSelectedInstance(null);
        this.textPane.setDocument(new DefaultStyledDocument());
    }

    private void showText() {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Displaying Text");
        this.textPane.setDocument(docModel.getDoc());
        this.global.finishProgress();
    }

    private void setupTextPane() {
        this.getActionByName("Copy").setEnabled(false);
        this.getActionByName("Join").setEnabled(false);
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.updateList(type);
            ++n2;
        }
        this.undoManager.discardAllEdits();
        this.undoManager.refreshUndoRedoUI();
        this.currentFile = null;
        this.currentFileType = -1;
        this.showText();
        try {
            this.updateAttributesViewWithAttributesOfRange(docModel.getStartOfDoc(), docModel.getEndOfDoc());
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred reading document's attributes.", ex);
        }
    }

    private void setSelectedInstance(Instance instance) {
        Style atts = this.removeHighlight;
        if (this.selectedHolder != null && this.selectedHolder.contains(this.selectedInstance)) {
            atts = this.selectedHighlight;
        } else if (this.selectedInstance != null && this.selectedInstance.getType() == this.listSelected) {
            atts = this.mainHighlight;
        }
        if (this.selectedInstance != null) {
            this.selectedInstance.changeHighlight(docModel.getDoc(), atts);
        }
        this.selectedInstance = instance;
        if (this.selectedInstance != null) {
            if (this.instancesControl == 56) {
                this.wordList.setSelectedValue(this.selectedInstance.getInstanceHolder(), true);
            }
            this.selectedInstance.changeHighlight(docModel.getDoc(), this.instanceHighlight);
            this.textPane.setCaretPosition(this.selectedInstance.getEndOffset());
            switch (this.instancesControl) {
                case 55: {
                    this.nextPreviousLabel.setText(String.valueOf(this.selectedHolder.getPosition(this.selectedInstance)) + " of " + this.selectedHolder.size());
                    break;
                }
                case 56: {
                    this.nextPreviousLabel.setText(String.valueOf(docModel.getPosition(this.selectedInstance)) + " of " + docModel.getTokenCount(this.selectedInstance.getType()));
                }
            }
            this.stepPanel.show(this.selectedInstance.getType());
            this.stepPanel.getCurrentCard().changeInstance(this.selectedInstance);
        } else {
            this.nextPreviousLabel.setText(" ");
            this.stepPanel.getCurrentCard().emptyInstance();
            this.stepPanel.show(0);
        }
    }

    private void changeList(int whichList) {
        this.global.lockFinishProgress();
        this.clearText();
        this.changeSelectedWord(null);
        int oldSelected = this.listSelected;
        this.listSelected = whichList;
        if (oldSelected != -1) {
            this.removeAllHighlights();
        }
        int rb = 0;
        int i = 0;
        while (i < WordHolder.types.length) {
            if (WordHolder.types[i] == whichList) {
                rb = i;
            }
            ++i;
        }
        this.radioButtonArray[rb].setSelected(true);
        TreeSet<InstanceHolder<? extends Instance>> hl = docModel.getHolderList(whichList);
        if (this.wordListFreq.isSelected()) {
            TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
            resorted.addAll(hl);
            hl = resorted;
        }
        Object[] holderList = hl.toArray();
        this.wordList.setListData(holderList);
        this.listHeader.setText(" " + WordHolder.getTypeName(whichList) + " (" + holderList.length + " types):");
        this.giveAllHighlightsOfType(whichList);
        this.showText();
        this.stepPanel.show(0);
        this.global.unlockFinishProgress();
        this.global.finishProgress();
    }

    private void removeAllHighlights() {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Removing highlights...");
        docModel.setAllHighlights(this.removeHighlight);
        this.global.finishProgress();
    }

    private void giveAllHighlightsOfType(int type) {
        docModel.reIgnoreAllIgnored();
        TreeSet<InstanceHolder<? extends Instance>> hl = docModel.getHolderList(type);
        this.global.startProgress(hl.size());
        this.global.writeProgressMessage("Renewing highlights...");
        int count = 0;
        for (InstanceHolder instanceHolder : hl) {
            if (this.selectedHolder != null && this.selectedHolder.equals(instanceHolder)) {
                instanceHolder.setAllInstancesHighlights(docModel.getDoc(), this.selectedHighlight);
            } else {
                instanceHolder.setAllInstancesHighlights(docModel.getDoc(), this.mainHighlight);
            }
            this.global.setProgressCurrent(++count);
        }
        this.global.finishProgress();
    }

    private void setLoading(boolean loading) {
        this.allowEditing = !loading;
        this.setAllActionsEnabled(this.allowEditing);
        this.wordList.setEnabled(this.allowEditing);
        JRadioButton[] jRadioButtonArray = this.radioButtonArray;
        int n = this.radioButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRadioButton rb = jRadioButtonArray[n2];
            rb.setEnabled(this.allowEditing);
            ++n2;
        }
        Collection<InstanceStepPanel> stepPanels = this.stepPanel.getCards();
        for (InstanceStepPanel sp : stepPanels) {
            sp.setEnabled(this.allowEditing);
        }
        if (this.allowEditing) {
            this.undoManager.refreshUndoRedoUI();
            this.getActionByName("Copy").setEnabled(false);
            this.getActionByName("Join").setEnabled(false);
            this.getActionByName("Save Rule List").setEnabled(LookUpDictionary.isRulesChanged());
            this.getActionByName("Save Variant List").setEnabled(LookUpDictionary.isVariantsChanged());
            this.getActionByName("Save Dictionary").setEnabled(LookUpDictionary.isWordsChanged());
            this.getActionByName("Save Confidence Weights").setEnabled(ConfidenceWeights.hasChanged());
        }
    }

    private void openFile(File file) {
        try {
            try {
                this.global.lockFinishProgress();
                this.clearText();
                docModel.processNewFile(file);
                this.setupTextPane();
                frame.setTitle("VARD 2.4 - " + file.getName());
            }
            catch (InvalidInstanceChangeException e) {
                this.global.showException("Error occurred reading xml tag.", e);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
            }
            catch (BadLocationException e) {
                this.global.showException("Error occurred parsing words in text", e);
                this.global.unlockFinishProgress();
                this.global.finishProgress();
            }
        }
        finally {
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    private boolean save() {
        Object[] options;
        Object o;
        if (this.currentFile != null) {
            if (this.currentFileType == 88) {
                this.clearText();
                if (this.currentFile.getName().endsWith("rtf")) {
                    this.removeAllHighlights();
                }
                boolean saved = docModel.saveToFile(this.currentFile);
                if (this.currentFile.getName().endsWith("rtf")) {
                    this.giveAllHighlightsOfType(this.listSelected);
                }
                this.showText();
                return saved;
            }
            if (this.currentFileType == 66) {
                if (this.currentFile.getName().endsWith("rtf")) {
                    this.displayError("You cannot save an rtf file with xml tags, please save as plain text (i.e. .txt) or without tags");
                    this.currentFile = null;
                    return false;
                }
                this.clearText();
                boolean saved = docModel.exportToXML(this.currentFile);
                this.showText();
                return saved;
            }
        }
        if ((o = JOptionPane.showInputDialog(frame, "How would you like to save the file?", "Save as?", 3, null, options = new Object[]{"Save with XML tags", "Save without XML tags"}, options[0])) == null) {
            return false;
        }
        if (o.equals(options[0])) {
            return this.exportToXML();
        }
        if (o.equals(options[1])) {
            return this.saveAs();
        }
        return false;
    }

    private boolean saveAs() {
        int returnVal = this.fileChooser.showSaveDialog(frame);
        if (returnVal == 0) {
            int yn;
            File fileSelected = this.fileChooser.getSelectedFile();
            if (fileSelected.exists() && (yn = JOptionPane.showConfirmDialog(frame, "You are overwriting an existing file, continue?", "Overwrite?", 2)) == 2) {
                return false;
            }
            this.currentFile = fileSelected;
            this.currentFileType = 88;
            frame.setTitle("VARD 2.4 - " + fileSelected.getName());
            return this.save();
        }
        return false;
    }

    private boolean exportToXML() {
        int returnVal = this.fileChooser.showSaveDialog(frame);
        if (returnVal == 0) {
            int yn;
            File fileSelected = this.fileChooser.getSelectedFile();
            if (fileSelected.exists() && (yn = JOptionPane.showConfirmDialog(frame, "You are overwriting an existing file, continue?", "Overwrite?", 2)) == 2) {
                return false;
            }
            this.currentFile = fileSelected;
            this.currentFileType = 66;
            frame.setTitle("VARD 2.4 - " + fileSelected.getName());
            return this.save();
        }
        return false;
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.setProgressBarLabelLoading(message);
    }

    @Override
    public void rulesChanged(boolean changed) {
        this.getActionByName("Save Rule List").setEnabled(changed);
    }

    @Override
    public void variantsChanged(boolean changed) {
        this.getActionByName("Save Variant List").setEnabled(changed);
    }

    @Override
    public void wordsChanged(boolean changed) {
        this.getActionByName("Save Dictionary").setEnabled(changed);
    }

    @Override
    public void changeUpdate(boolean changed) {
        this.getActionByName("Save Confidence Weights").setEnabled(changed);
        this.updateMethodLabels();
        if (this.stepPanel.isShowing(101)) {
            this.stepPanel.getCurrentCard().changeInstance(this.selectedInstance);
        }
    }

    @Override
    public void setProgressCurrent(final int current) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.progressBar.setValue(current);
            }
        });
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.progressBar.setIndeterminate(true);
                MainScreen.this.setLoading(true);
            }
        });
    }

    @Override
    public void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.resetProgressBarLabel();
                MainScreen.this.progressBar.setIndeterminate(false);
                MainScreen.this.setLoading(false);
            }
        });
    }

    @Override
    public void startProgress(final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainScreen.this.progressBar.setIndeterminate(false);
                MainScreen.this.progressBar.setMaximum(max);
                MainScreen.this.setLoading(true);
            }
        });
    }

    public void displayError(String message) {
        JOptionPane.showMessageDialog(frame, message, "Error", 0);
    }

    /* synthetic */ MainScreen(MainScreen mainScreen) {
        this();
    }

    public final class ClipboardTextTransfer
    implements ClipboardOwner {
        @Override
        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
        }

        public void setClipboardContents(String text) {
            try {
                StringSelection stringSelection = new StringSelection(text);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, this);
            }
            catch (IllegalStateException ex) {
                MainScreen.this.global.showException("Error occurred whilst copying list to clipboard.", ex);
            }
        }
    }

    private class CopyListAction
    extends AbstractAction {
        private static final long serialVersionUID = -562300188506750751L;

        CopyListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardTextTransfer ctt = new ClipboardTextTransfer();
            String cb = "";
            for (InstanceHolder<? extends Instance> ih : docModel.getHolderList(MainScreen.this.listSelected)) {
                cb = String.valueOf(cb) + ih.tabbedString() + "\r";
            }
            ctt.setClipboardContents(cb);
        }
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 6496262943261420464L;

        ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.doExit();
        }
    }

    private class ExportToXMLAction
    extends AbstractAction {
        private static final long serialVersionUID = 2998037746672741986L;

        ExportToXMLAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.exportToXML();
                }
            }.start();
        }
    }

    private class FindWordInListAction
    extends AbstractAction {
        private static final long serialVersionUID = 7144807205585186906L;
        Instance instance;

        private FindWordInListAction(Instance instance) {
            this.putValue("Name", "Find word in list");
            this.instance = instance;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int type = this.instance.getType();
            if (MainScreen.this.listSelected != type) {
                MainScreen.this.changeList(type);
            }
            MainScreen.this.wordList.setSelectedValue(this.instance.getInstanceHolder(), true);
            MainScreen.this.instancesControl = 55;
            MainScreen.this.typeInstancesTB.setSelected(true);
            MainScreen.this.setSelectedInstance(this.instance);
        }
    }

    private class FirstInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = 6157373229601202571L;

        FirstInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (MainScreen.this.instancesControl) {
                case 56: {
                    MainScreen.this.setSelectedInstance(docModel.getFirstInstance(MainScreen.this.listSelected));
                    break;
                }
                case 55: {
                    if (MainScreen.this.selectedHolder == null) break;
                    MainScreen.this.setSelectedInstance(MainScreen.this.selectedHolder.firstInstance());
                }
            }
        }
    }

    private class InteractiveTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 6231756482449647494L;

        private InteractiveTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return true;
            }
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files;
                try {
                    files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    JOptionPane.showMessageDialog(null, "Error occurred selecting setup folder.\n\n" + ex.getMessage(), "Error", 0);
                    return false;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Error occurred selecting setup folder.\n\n" + ex.getMessage(), "Error", 0);
                    return false;
                }
                if (files.isEmpty()) {
                    return false;
                }
                if (files.size() > 1) {
                    JOptionPane.showMessageDialog(null, "The interactive mode can only be used with one file at a time. Please use the Batch mode to process multiple texts.", "Warning", 2);
                    return false;
                }
                final File file = (File)files.get(0);
                if (file.isDirectory()) {
                    JOptionPane.showMessageDialog(null, "The interactive mode can only be used with one file at a time. Please use the Batch mode to process multiple texts.", "Warning", 2);
                    return false;
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (MainScreen.this.checkSave()) {
                            MainScreen.this.openFile(file);
                        }
                    }
                }.start();
                return true;
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text;
                MainScreen.this.global.startIndeterminateProgress();
                MainScreen.this.global.writeProgressMessage("Pasting text...");
                MainScreen.this.global.lockFinishProgress();
                try {
                    text = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    MainScreen.this.global.showException("Error occurred dragging and dropping text.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return false;
                }
                catch (IOException ex) {
                    MainScreen.this.global.showException("Error occurred dragging and dropping text.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return false;
                }
                if (text == null || text.equals("")) {
                    return false;
                }
                StyleConstants.setBold(MainScreen.this.currentViewAttributes, MainScreen.this.boldToggle.isSelected());
                StyleConstants.setItalic(MainScreen.this.currentViewAttributes, MainScreen.this.italicToggle.isSelected());
                StyleConstants.setUnderline(MainScreen.this.currentViewAttributes, MainScreen.this.underlineToggle.isSelected());
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            try {
                                MainScreen.this.clearText();
                                docModel.processNewText(text, MainScreen.this.currentViewAttributes);
                                MainScreen.this.showText();
                            }
                            catch (InvalidInstanceChangeException e) {
                                MainScreen.this.global.showException("Error occurred reading xml tag.", e);
                                MainScreen.this.global.unlockFinishProgress();
                                MainScreen.this.global.finishProgress();
                            }
                            catch (BadLocationException e) {
                                MainScreen.this.global.showException("Error occurred parsing words.", e);
                                MainScreen.this.global.unlockFinishProgress();
                                MainScreen.this.global.finishProgress();
                            }
                        }
                        finally {
                            MainScreen.this.global.unlockFinishProgress();
                            MainScreen.this.global.finishProgress();
                        }
                    }
                }.start();
                return true;
            }
            return false;
        }
    }

    private class JoinAction
    extends AbstractAction {
        private static final long serialVersionUID = 5061994287539564528L;

        private JoinAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = MainScreen.this.textPane.getSelectionStart();
            int end = MainScreen.this.textPane.getSelectionEnd();
            if (end - start > 0) {
                try {
                    DocumentModel.JoinEdit je = docModel.getJoinEdit(start, end);
                    if (je.isValid()) {
                        je.execute();
                        undoSupport.postEdit(je);
                    } else {
                        MainScreen.this.displayError(je.getWhyInvalid());
                    }
                }
                catch (BadLocationException ex) {
                    MainScreen.this.global.showException("Join Failed.", ex);
                }
                catch (InvalidInstanceChangeException ex) {
                    MainScreen.this.global.showException("Join Failed.", ex);
                }
            }
        }
    }

    private class LastInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = 6157373229601202571L;

        LastInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (MainScreen.this.instancesControl) {
                case 56: {
                    MainScreen.this.setSelectedInstance(docModel.getLastInstance(MainScreen.this.listSelected));
                    break;
                }
                case 55: {
                    if (MainScreen.this.selectedHolder == null) break;
                    MainScreen.this.setSelectedInstance(MainScreen.this.selectedHolder.lastInstance());
                }
            }
        }
    }

    private class NewAction
    extends AbstractAction {
        private static final long serialVersionUID = -6218890096674492767L;

        NewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.currentFile = null;
            docModel.clear();
            frame.setTitle(MainScreen.PROGRAM_TITLE);
            MainScreen.this.setupTextPane();
        }
    }

    private class NextInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = 6157373229601202571L;

        NextInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (MainScreen.this.instancesControl) {
                case 56: {
                    MainScreen.this.setSelectedInstance(docModel.getNextInstance(MainScreen.this.listSelected, MainScreen.this.selectedInstance));
                    break;
                }
                case 55: {
                    if (MainScreen.this.selectedHolder == null) break;
                    MainScreen.this.setSelectedInstance(MainScreen.this.selectedHolder.nextInstance(MainScreen.this.selectedInstance));
                }
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = -2167496422726054143L;

        OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    int returnVal;
                    if (MainScreen.this.checkSave() && (returnVal = MainScreen.this.fileChooser.showOpenDialog(frame)) == 0) {
                        File fileSelected = MainScreen.this.fileChooser.getSelectedFile();
                        if (fileSelected == null) {
                            MainScreen.this.displayError("No file selected");
                            return;
                        }
                        MainScreen.this.openFile(fileSelected);
                    }
                }
            }.start();
        }
    }

    private class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = -4304408041448008546L;
        String cbText;

        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MainScreen.this.global.startIndeterminateProgress();
            MainScreen.this.global.writeProgressMessage("Pasting clipboard text...");
            MainScreen.this.global.lockFinishProgress();
            this.cbText = "";
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable cbContents = cb.getContents(null);
            if (cbContents != null && cbContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    this.cbText = (String)cbContents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    MainScreen.this.global.showException("Error occurred pasting from the clipboard.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return;
                }
                catch (IOException ex) {
                    MainScreen.this.global.showException("Error occurred pasting from the clipboard.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return;
                }
            } else {
                MainScreen.this.displayError("Pasted text not supported");
                return;
            }
            if (this.cbText == null || this.cbText.equals("")) {
                return;
            }
            StyleConstants.setBold(MainScreen.this.currentViewAttributes, MainScreen.this.boldToggle.isSelected());
            StyleConstants.setItalic(MainScreen.this.currentViewAttributes, MainScreen.this.italicToggle.isSelected());
            StyleConstants.setUnderline(MainScreen.this.currentViewAttributes, MainScreen.this.underlineToggle.isSelected());
            new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            MainScreen.this.clearText();
                            docModel.processNewText(PasteAction.this.cbText, MainScreen.this.currentViewAttributes);
                            MainScreen.this.showText();
                        }
                        catch (InvalidInstanceChangeException e) {
                            MainScreen.this.global.showException("Error occurred reading xml tag.", e);
                            MainScreen.this.global.unlockFinishProgress();
                            MainScreen.this.global.finishProgress();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("Error occurred parsing words.", e);
                            MainScreen.this.global.unlockFinishProgress();
                            MainScreen.this.global.finishProgress();
                        }
                    }
                    finally {
                        MainScreen.this.global.unlockFinishProgress();
                        MainScreen.this.global.finishProgress();
                    }
                }
            }.start();
        }
    }

    private class PreviousInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = -6606047809322370718L;

        private PreviousInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (MainScreen.this.instancesControl) {
                case 56: {
                    MainScreen.this.setSelectedInstance(docModel.getPreviousInstance(MainScreen.this.listSelected, MainScreen.this.selectedInstance));
                    break;
                }
                case 55: {
                    if (MainScreen.this.selectedHolder == null) break;
                    MainScreen.this.setSelectedInstance(MainScreen.this.selectedHolder.previousInstance(MainScreen.this.selectedInstance));
                }
            }
        }
    }

    private class ProcessAllVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4429003620159727500L;

        ProcessAllVariantsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int threshold = (Integer)MainScreen.this.thresholdSpinner.getValue();
            DocumentModel.ProcessAllVariantsEdit edit = docModel.getProcessAllVariantsEdit(threshold, false);
            ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
            tEdit.execute();
            undoSupport.postEdit(tEdit);
        }
    }

    private class RadioButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = -934709526028658245L;
        private int whichList;

        RadioButtonAction(int whichList) {
            this.whichList = whichList;
            this.putValue("Name", WordHolder.getTypeName(whichList));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.whichList == MainScreen.this.listSelected) {
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.changeList(RadioButtonAction.this.whichList);
                    MainScreen.this.wordList.ensureIndexIsVisible(0);
                }
            }.start();
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.undoManager.redo();
        }
    }

    private class RuleListManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RuleListManagerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new RuleManager(frame);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1035721027447348802L;

        SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.save();
                }
            }.start();
        }
    }

    private class SaveAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -7275830361201799128L;

        SaveAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.checkSave();
        }
    }

    private class SaveAsPlainAction
    extends AbstractAction {
        private static final long serialVersionUID = 3551298055490692028L;

        SaveAsPlainAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.saveAs();
                }
            }.start();
        }
    }

    private class SaveConfidenceWeightsAction
    extends AbstractAction {
        private static final long serialVersionUID = -7275830361201799128L;

        SaveConfidenceWeightsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.confidenceWeights.save();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing confidence weights.", ex);
                    }
                }
            }).start();
        }
    }

    private class SaveDictionaryAction
    extends AbstractAction {
        private static final long serialVersionUID = 7397383512576562239L;

        SaveDictionaryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        lud.writeWordsToFile();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing words.txt.", ex);
                    }
                }
            }).start();
        }
    }

    private class SaveRulesAction
    extends AbstractAction {
        private static final long serialVersionUID = 7397383512576562239L;

        SaveRulesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        lud.writeRulesToFile();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing rules.txt.", ex);
                    }
                }
            }).start();
        }
    }

    private class SaveVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 7397383512576562239L;

        SaveVariantsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        lud.writeVariantsToFile();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing variants.txt.", ex);
                    }
                }
            }).start();
        }
    }

    private class TextInstancesControlAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        TextInstancesControlAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.instancesControl = 56;
            MainScreen.this.setSelectedInstance(MainScreen.this.selectedInstance);
        }
    }

    private class TypeInstancesControlAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        TypeInstancesControlAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.instancesControl = 55;
            MainScreen.this.setSelectedInstance(MainScreen.this.selectedInstance);
        }
    }

    private class UIUpdatingUndoManager
    extends UndoManager {
        private static final long serialVersionUID = 1L;
        private StackListModel<String> undoList;
        private StackListModel<String> redoList;

        private UIUpdatingUndoManager() {
            this.setLimit(1000);
            this.undoList = new StackListModel();
            this.redoList = new StackListModel();
        }

        @Override
        public void discardAllEdits() {
            this.undoList.clear();
            this.redoList.clear();
            super.discardAllEdits();
        }

        public void redo(int n) {
            int i = 0;
            while (i < n && this.canRedo()) {
                this.redo();
                ++i;
            }
        }

        public void undo(int n) {
            int i = 0;
            while (i < n && this.canUndo()) {
                this.undo();
                ++i;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                super.undo();
                this.undoList.remove();
                this.redoList.add(this.getRedoPresentationName());
                this.refreshUndoRedoUI();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                super.redo();
                this.redoList.remove();
                this.undoList.add(this.getUndoPresentationName());
                this.refreshUndoRedoUI();
            }
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            boolean toReturn = super.addEdit(edit);
            this.refreshUndoRedoUI();
            this.undoList.add(this.getUndoPresentationName());
            this.redoList.clear();
            return toReturn;
        }

        private void refreshUndoRedoUI() {
            Action undoAction = MainScreen.this.getActionByName("Undo");
            undoAction.setEnabled(this.canUndo());
            if (this.canUndo()) {
                undoAction.putValue("ShortDescription", this.getUndoPresentationName());
            } else {
                undoAction.putValue("ShortDescription", "Nothing to undo");
            }
            Action redoAction = MainScreen.this.getActionByName("Redo");
            redoAction.setEnabled(this.canRedo());
            if (this.canRedo()) {
                redoAction.putValue("ShortDescription", this.getRedoPresentationName());
            } else {
                redoAction.putValue("ShortDescription", "Nothing to redo");
            }
        }

        public StackListModel<String> getRedoList() {
            return this.redoList;
        }

        public StackListModel<String> getUndoList() {
            return this.undoList;
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.undoManager.undo();
        }
    }
}

