/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.Position;
import model.SuggestedReplacement;
import model.doc.CorrectInstance;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.ReplacedInstance;
import model.doc.VariantInstance;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class WordHolder
implements Comparable<WordHolder> {
    public static final int VARIANT = 101;
    public static final int REPLACED = 102;
    public static final int CORRECT = 103;
    public static final int[] types = new int[]{101, 102, 103};
    private String word;
    private String soundexCode;
    private InstanceHolder<VariantInstance> asVariant;
    private TreeSet<InstanceHolder<ReplacedInstance>> asReplaced;
    private InstanceHolder<CorrectInstance> asCorrect;
    private boolean inDictionary;
    private boolean isLowFreq;
    private Word dictionaryRef;
    private List<SuggestedReplacement> replacements;
    private boolean areReplacementsSet;

    public static String getTypeName(int type) {
        switch (type) {
            case 101: {
                return "Variants";
            }
            case 102: {
                return "Normalised";
            }
            case 103: {
                return "Not variants";
            }
        }
        return "Unknown";
    }

    public WordHolder(String word) {
        this.word = word;
        this.asVariant = new InstanceHolder(word, this);
        this.asReplaced = new TreeSet();
        this.asCorrect = new InstanceHolder(word, this);
        this.soundexCode = WordUtilities.getSoundexCode(word);
        this.replacements = new Vector<SuggestedReplacement>();
    }

    static String getTypeString(int type) {
        switch (type) {
            case 101: {
                return "Variant";
            }
            case 102: {
                return "Replaced";
            }
            case 103: {
                return "Not variant";
            }
        }
        return "Type unrecognized";
    }

    @Override
    public int compareTo(WordHolder wh) {
        return this.word.compareToIgnoreCase(wh.word);
    }

    public boolean equals(WordHolder wh) {
        return this.compareTo(wh) == 0;
    }

    public VariantInstance addVariant(Position start, Position end, String actual) {
        VariantInstance newInstance = new VariantInstance(start, end, this, this.asVariant, actual);
        if (!this.asVariant.addInstance(newInstance)) {
            return this.asVariant.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public CorrectInstance addCorrect(Position start, Position end, String actual) {
        CorrectInstance newInstance = new CorrectInstance(start, end, this, this.asCorrect, actual);
        if (!this.asCorrect.addInstance(newInstance)) {
            return this.asCorrect.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public void addVariant(VariantInstance vi) {
        this.asVariant.addInstance(vi);
    }

    public void addCorrect(CorrectInstance ci) {
        this.asCorrect.addInstance(ci);
    }

    public boolean removeVariant(VariantInstance vi) {
        return this.asVariant.removeInstance(vi);
    }

    public boolean removeCorrect(CorrectInstance ci) {
        return this.asCorrect.removeInstance(ci);
    }

    public Instance getInstanceAt(int caretPos) {
        Instance toReturn = this.asVariant.getInstanceAtPos(caretPos);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = this.asCorrect.getInstanceAtPos(caretPos);
        if (toReturn != null) {
            return toReturn;
        }
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            toReturn = ih.getInstanceAtPos(caretPos);
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    public boolean isInDictionary() {
        return this.inDictionary;
    }

    public Word getDictionaryRef() {
        return this.dictionaryRef;
    }

    public boolean isLowFreq() {
        return this.isLowFreq;
    }

    public void setDictionaryRef(Word dictionaryRef) {
        this.dictionaryRef = dictionaryRef;
        this.inDictionary = dictionaryRef != null;
        this.isLowFreq = this.inDictionary ? dictionaryRef.isLowFreq() : false;
    }

    public String getWord() {
        return this.word;
    }

    public boolean areReplacementsSet() {
        return this.areReplacementsSet;
    }

    public List<SuggestedReplacement> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(List<SuggestedReplacement> replacements) {
        this.replacements = replacements;
        this.areReplacementsSet = true;
    }

    public String getSoundexCode() {
        return this.soundexCode;
    }

    public SuggestedReplacement getTopReplacement() {
        if (this.replacements.size() > 0) {
            return this.replacements.iterator().next();
        }
        return null;
    }

    public TreeSet<Instance> getInstances() {
        TreeSet<Instance> toReturn = new TreeSet<Instance>();
        toReturn.addAll((Collection)this.asVariant.getInstances());
        toReturn.addAll((Collection)this.asCorrect.getInstances());
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            toReturn.addAll((Collection<Instance>)ih.getInstances());
        }
        return toReturn;
    }

    public boolean isAtleastOneInstanceAVariant() {
        return !this.asVariant.isEmpty();
    }

    public boolean isAtleastOneInstanceAReplaced() {
        return !this.asReplaced.isEmpty();
    }

    public boolean isAtleastOneInstanceACorrect() {
        return !this.asCorrect.isEmpty();
    }

    public int getVariantsSize() {
        return this.asVariant.getInstancesSize();
    }

    public int getReplacedSize() {
        int toReturn = 0;
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            toReturn += ih.getInstancesSize();
        }
        return toReturn;
    }

    public int getCorrectSize() {
        return this.asCorrect.getInstancesSize();
    }

    public InstanceHolder<VariantInstance> getAsVariant() {
        return this.asVariant;
    }

    public TreeSet<InstanceHolder<ReplacedInstance>> getAsReplaced() {
        return this.asReplaced;
    }

    public InstanceHolder<CorrectInstance> getAsCorrect() {
        return this.asCorrect;
    }
}

