/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.doc.DocumentModel;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class RevertReplacedInstanceEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    VariantInstance vi;
    ReplacedInstance ri;
    int toType;
    InstanceHolder<ReplacedInstance> from = null;
    boolean isAlone = false;
    WordHolder wh;
    StyledDocument doc;
    boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
    boolean executed = false;
    boolean undone = false;

    public RevertReplacedInstanceEdit(ReplacedInstance ri, StyledDocument doc) throws InvalidInstanceChangeException {
        this.ri = ri;
        this.wh = ri.holder;
        this.doc = doc;
        this.vi = ri.getPreviousInstance();
        this.toType = this.vi.getType();
        for (InstanceHolder<ReplacedInstance> ih : this.wh.getAsReplaced()) {
            if (ih.isEmpty() || !ih.getInstances().first().getReplacement().equals(ri.getReplacement())) continue;
            this.from = ih;
            if (ih.getInstances().size() != 1) break;
            this.isAlone = true;
            break;
        }
        if (this.from == null) {
            throw new InvalidInstanceChangeException("Replacement not found.");
        }
    }

    public void execute() throws InvalidInstanceChangeException, BadLocationException {
        if (!this.executed) {
            this.ri.revertInText(this.doc);
            if (this.from.removeInstance(this.ri)) {
                if (this.toType == 101) {
                    if (!this.wh.getAsVariant().addInstance(this.vi)) {
                        this.from.addInstance(this.ri);
                        throw new InvalidInstanceChangeException(this.ri + " could not be reverted.");
                    }
                } else {
                    this.from.addInstance(this.ri);
                    throw new InvalidInstanceChangeException(this.ri + " could not be reverted, invalid state to revert to.");
                }
                if (this.isAlone) {
                    this.wh.getAsReplaced().remove(this.from);
                }
                this.executed = true;
                return;
            }
            throw new InvalidInstanceChangeException(this.ri + " could not be reverted.");
        }
        throw new InvalidInstanceChangeException("Can only execute once. Revert " + this.ri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void undo() throws CannotUndoException {
        if (!this.executed) throw new CannotUndoException();
        try {
            this.ri.setupInText(this.doc);
        }
        catch (BadLocationException ex) {
            throw new CannotUndoException();
        }
        if (this.toType != 101) throw new CannotUndoException();
        if (!this.wh.getAsVariant().removeInstance(this.vi)) throw new CannotUndoException();
        if (!this.from.addInstance(this.ri)) {
            this.wh.getAsVariant().addInstance(this.vi);
            throw new CannotUndoException();
        }
        if (this.isAlone) {
            this.wh.getAsReplaced().add(this.from);
        }
        this.undone = true;
        DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            try {
                this.ri.revertInText(this.doc);
            }
            catch (BadLocationException ex) {
                throw new CannotRedoException();
            }
            if (this.from.removeInstance(this.ri)) {
                if (this.toType == 101) {
                    if (!this.wh.getAsVariant().addInstance(this.vi)) {
                        this.from.addInstance(this.ri);
                        throw new CannotRedoException();
                    }
                } else {
                    this.from.addInstance(this.ri);
                    throw new CannotRedoException();
                }
                if (this.isAlone) {
                    this.wh.getAsReplaced().remove(this.from);
                }
                this.undone = false;
                return;
            }
            throw new CannotRedoException();
        }
        throw new CannotRedoException();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return "Revert (" + this.ri.revertString() + ")";
    }

    public String getActionName() {
        return "Revert to " + WordHolder.getTypeString(this.toType);
    }
}

