/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.Entity;
import model.doc.IgnorableText;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.VariantInstance;

public class ReplacedInstance
extends Instance {
    private SuggestedReplacement replacement;
    private String replacementString;
    private VariantInstance previousInstance;
    private static Globals global = Globals.getInstance();
    private Collection<Entity> entitiesRemoved = null;
    private int restorePos;
    private boolean setup = false;
    private boolean reverted = false;
    private boolean auto;

    public ReplacedInstance(VariantInstance instance, InstanceHolder<ReplacedInstance> instanceHolder, SuggestedReplacement replacement, boolean auto) {
        super(instance);
        this.instanceHolder = instanceHolder;
        if (replacement == null) {
            throw new NullPointerException("Replacement Null");
        }
        this.replacement = replacement;
        replacement.setCapitalization(this.capitalization);
        this.replacementString = replacement.getReplacementString();
        this.previousInstance = instance;
        this.auto = auto;
    }

    @Override
    public String getDisplayString() {
        return this.replacementString;
    }

    @Override
    public boolean isXMLRequired() {
        return true;
    }

    @Override
    public void insertXMLTags(Document doc) throws BadLocationException {
        String variant = this.getOriginal();
        if (this.entitiesRemoved != null && !this.entitiesRemoved.isEmpty()) {
            int offset = 0;
            for (Entity entity : this.entitiesRemoved) {
                if (!entity.isReplaced()) continue;
                int posInString = entity.getSavedStartInt() - this.restorePos;
                variant = String.valueOf(variant.substring(0, posInString + offset)) + entity.getOriginal() + variant.substring(posInString + offset + entity.getReplacement().length());
                offset = entity.getOriginal().length() - entity.getReplacement().length();
            }
        }
        String xml = "<normalised orig=\"" + variant + "\" auto=\"" + this.auto + "\">";
        super.insertXMLTags(doc, xml, "</normalised>");
    }

    @Override
    public String toString() {
        return String.valueOf(this.getOriginal()) + " -> " + this.replacementString;
    }

    public String revertString() {
        return String.valueOf(this.getOriginal()) + " <- " + this.replacementString;
    }

    public void setupInText(StyledDocument doc) throws BadLocationException {
        this.setStart(this.previousInstance.getStart());
        this.entitiesRemoved = global.getGlobalReplacementListener().removeEntities(this.previousInstance.getStart(), this.previousInstance.getEnd());
        AttributeSet atts = this.getAttributesAtStart(doc);
        int startInt = this.getStartOffset();
        this.previousInstance.saveStart();
        Collection<IgnorableText> ignoredRemoved = global.getGlobalReplacementListener().removeIgnored(this.previousInstance.getStart(), this.previousInstance.getEnd());
        doc.remove(startInt, this.getOriginal().length());
        doc.insertString(startInt, this.replacementString, atts);
        global.getGlobalReplacementListener().restoreIgnored(ignoredRemoved, 0);
        this.previousInstance.restoreStart(doc, 0);
        this.setStart(this.previousInstance.getStart());
        this.restorePos = startInt;
        this.setup = true;
        this.reverted = false;
    }

    public void revertInText(StyledDocument doc) throws BadLocationException {
        AttributeSet atts = this.getAttributesAtStart(doc);
        int startInt = this.getStartOffset();
        this.saveStart();
        this.previousInstance.saveStart();
        Collection<IgnorableText> ignoredRemoved = global.getGlobalReplacementListener().removeIgnored(this.getStart(), this.getEnd());
        doc.remove(startInt, this.replacementString.length());
        doc.insertString(startInt, this.getOriginal(), atts);
        global.getGlobalReplacementListener().restoreIgnored(ignoredRemoved, 0);
        this.restoreStart(doc, 0);
        this.previousInstance.restoreStart(doc, 0);
        global.getGlobalReplacementListener().restoreEntities(this.entitiesRemoved, startInt - this.restorePos);
        this.entitiesRemoved = null;
        this.reverted = true;
        this.setup = false;
    }

    private AttributeSet getAttributesAtStart(StyledDocument doc) {
        return doc.getCharacterElement(this.getStartOffset()).getAttributes();
    }

    public SuggestedReplacement getReplacement() {
        return this.replacement;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public int compareAlphabeticallyTo(Instance other) {
        int c = super.compareAlphabeticallyTo(other);
        if (c == 0) {
            return this.replacementString.compareToIgnoreCase(((ReplacedInstance)other).replacementString);
        }
        return c;
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public VariantInstance getPreviousInstance() {
        return this.previousInstance;
    }

    @Override
    public boolean removeSelfFromHolder() {
        return false;
    }

    @Override
    public void addSelfToHolder() {
    }

    public boolean isSetup() {
        return this.setup;
    }

    public boolean isReverted() {
        return this.reverted;
    }
}

