/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledDocument;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.DocumentElement;
import model.doc.Instance;
import model.doc.ReplacedInstance;
import model.doc.WordHolder;
import model.lookup.WordUtilities;

public class InstanceHolder<E extends Instance>
implements Comparable<InstanceHolder<E>> {
    private TreeSet<E> instances;
    private String word;
    private int capitalization;
    private int type;
    private WordHolder wordHolder;
    private static Globals global;

    void setWord(String word) {
        this.word = word;
    }

    InstanceHolder(String word, WordHolder wordHolder) {
        global = Globals.getInstance();
        this.word = word;
        this.instances = new TreeSet();
        this.wordHolder = wordHolder;
    }

    public boolean contains(Instance instance) {
        if (instance == null) {
            return false;
        }
        return this.instances.contains(instance);
    }

    public int getCapitalization() {
        if (this.isEmpty()) {
            return 51;
        }
        return this.capitalization;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "0 instances error";
        }
        this.word = WordUtilities.capitalize(this.word, this.getCapitalization());
        if (this.type == 102) {
            SuggestedReplacement rep = ((ReplacedInstance)this.instances.first()).getReplacement();
            return String.valueOf(this.word) + " -> " + rep.getReplacementString() + " (" + this.instances.size() + ")";
        }
        return String.valueOf(this.word) + " (" + this.instances.size() + ")";
    }

    public String toRevertString() {
        if (this.isEmpty()) {
            return "0 instances error";
        }
        this.word = WordUtilities.capitalize(this.word, this.getCapitalization());
        if (this.type == 102) {
            SuggestedReplacement rep = ((ReplacedInstance)this.instances.first()).getReplacement();
            return String.valueOf(this.word) + " <- " + rep.getReplacementString() + " (" + this.instances.size() + ")";
        }
        return String.valueOf(this.word) + " (" + this.instances.size() + ")";
    }

    public String tabbedString() {
        if (this.isEmpty()) {
            return "";
        }
        this.word = WordUtilities.capitalize(this.word, this.getCapitalization());
        if (this.type == 102) {
            SuggestedReplacement rep = ((ReplacedInstance)this.instances.first()).getReplacement();
            return String.valueOf(rep.getOldWord()) + "\t" + rep.getReplacementString() + "\t" + this.instances.size();
        }
        return String.valueOf(this.word) + "\t" + this.instances.size();
    }

    boolean removeInstance(E toRemove) {
        global.getGlobalHolderChangeListener().instanceAboutToChange((Instance)toRemove, this.type);
        if (this.instances.remove(toRemove)) {
            if (this.instances.isEmpty()) {
                this.capitalization = 51;
                global.getGlobalHolderChangeListener().holderEmptied(this, (Instance)toRemove, this.type);
            } else {
                this.capitalization = ((Instance)this.instances.first()).capitalization;
                for (Instance i : this.instances) {
                    if (i.capitalization == this.capitalization) continue;
                    this.capitalization = 52;
                    break;
                }
            }
            global.getGlobalHolderChangeListener().listChanged(this, this.type);
            return true;
        }
        return false;
    }

    boolean addInstance(E toAdd) {
        this.type = ((Instance)toAdd).getType();
        boolean fireFilled = false;
        if (this.instances.isEmpty()) {
            fireFilled = true;
        }
        if (this.instances.add(toAdd)) {
            if (fireFilled) {
                this.capitalization = ((Instance)toAdd).capitalization;
                global.getGlobalHolderChangeListener().holderFilled(this, (Instance)toAdd, this.type);
            } else if (this.capitalization != ((Instance)toAdd).capitalization) {
                this.capitalization = 52;
            }
            global.getGlobalHolderChangeListener().instanceChanged((Instance)toAdd, this.type);
            global.getGlobalHolderChangeListener().listChanged(this, this.type);
            return true;
        }
        return false;
    }

    TreeSet<E> getInstances() {
        return this.instances;
    }

    void emptyInstances() {
        if (!this.instances.isEmpty()) {
            this.capitalization = 51;
            for (Instance instance : this.instances) {
                global.getGlobalHolderChangeListener().instanceAboutToChange(instance, this.type);
            }
            Instance lastRemoved = (Instance)this.instances.first();
            this.instances.clear();
            global.getGlobalHolderChangeListener().holderEmptied(this, lastRemoved, this.type);
            global.getGlobalHolderChangeListener().listChanged(this, this.type);
        }
    }

    boolean addInstances(TreeSet<E> newInstances) {
        if (!newInstances.isEmpty()) {
            this.type = ((Instance)newInstances.first()).getType();
            boolean fireFilled = false;
            if (this.instances.isEmpty()) {
                fireFilled = true;
            }
            if (this.instances.addAll(newInstances)) {
                int newCap = this.capitalization;
                for (Instance i : newInstances) {
                    if (newCap == i.capitalization) continue;
                    newCap = 52;
                    break;
                }
                this.capitalization = newCap;
                if (fireFilled) {
                    global.getGlobalHolderChangeListener().holderFilled(this, (Instance)this.instances.last(), this.type);
                }
                for (Instance instance : newInstances) {
                    global.getGlobalHolderChangeListener().instanceChanged(instance, this.type);
                }
                global.getGlobalHolderChangeListener().listChanged(this, this.type);
                return true;
            }
        }
        return false;
    }

    void removeInstances(TreeSet<E> toRemove) {
        if (!toRemove.isEmpty()) {
            for (Instance instance : toRemove) {
                global.getGlobalHolderChangeListener().instanceAboutToChange(instance, this.type);
            }
            Instance lastRemoved = (Instance)toRemove.first();
            this.instances.removeAll(toRemove);
            if (this.instances.isEmpty()) {
                this.capitalization = 51;
                global.getGlobalHolderChangeListener().holderEmptied(this, lastRemoved, this.type);
            } else {
                this.capitalization = ((Instance)this.instances.first()).capitalization;
                for (Instance i : this.instances) {
                    if (i.capitalization == this.capitalization) continue;
                    this.capitalization = 52;
                    break;
                }
            }
            global.getGlobalHolderChangeListener().listChanged(this, this.type);
        }
    }

    @Override
    public int compareTo(InstanceHolder<E> ih) {
        if (this.instances.isEmpty()) {
            if (ih.instances.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (ih.instances.isEmpty()) {
            return 1;
        }
        int c = ((Instance)this.instances.first()).compareAlphabeticallyTo((DocumentElement)ih.instances.first());
        if (c == 0 && this.type == 102) {
            return ((ReplacedInstance)this.instances.first()).getReplacement().getReplacementString().compareToIgnoreCase(((ReplacedInstance)ih.instances.first()).getReplacement().getReplacementString());
        }
        return c;
    }

    public int compareToNonGeneric(InstanceHolder<? extends Instance> ih) {
        if (this.instances.isEmpty()) {
            if (ih.instances.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (ih.instances.isEmpty()) {
            return 1;
        }
        int c = ((Instance)this.instances.first()).compareAlphabeticallyTo((Instance)ih.instances.first());
        if (c == 0 && this.type == 102) {
            return ((ReplacedInstance)this.instances.first()).getReplacement().getReplacementString().compareToIgnoreCase(((ReplacedInstance)ih.instances.first()).getReplacement().getReplacementString());
        }
        return c;
    }

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    public E getInstanceAtPos(int caretPos) {
        for (Instance i : this.instances) {
            if (i.containsPosition(caretPos)) {
                return (E)i;
            }
            if (i.getStartOffset() <= caretPos) continue;
            return null;
        }
        return null;
    }

    public void setAllInstancesHighlights(StyledDocument doc, AttributeSet atts) {
        for (Instance instance : this.instances) {
            instance.changeHighlight(doc, atts);
        }
    }

    public E firstInstance() {
        if (this.instances.isEmpty()) {
            return null;
        }
        return (E)((Instance)this.instances.first());
    }

    public E lastInstance() {
        if (this.instances.isEmpty()) {
            return null;
        }
        return (E)((Instance)this.instances.last());
    }

    public E nextInstance(Instance instance) {
        if (this.instances.isEmpty()) {
            return null;
        }
        if (instance == null) {
            return (E)((Instance)this.instances.first());
        }
        Instance nextInstance = this.instances.higher(instance);
        if (nextInstance == null) {
            nextInstance = (Instance)this.instances.first();
        }
        return (E)nextInstance;
    }

    public E previousInstance(Instance instance) {
        if (this.instances.isEmpty()) {
            return null;
        }
        if (instance == null) {
            return (E)((Instance)this.instances.last());
        }
        Instance prevInstance = this.instances.lower(instance);
        if (prevInstance == null) {
            prevInstance = (Instance)this.instances.last();
        }
        return (E)prevInstance;
    }

    public int getPosition(Instance instance) {
        if (instance == null) {
            return 0;
        }
        return this.instances.headSet(instance).size() + 1;
    }

    public int size() {
        return this.instances.size();
    }

    public int getType() {
        if (this.instances.isEmpty()) {
            return -1;
        }
        return this.type;
    }

    public WordHolder getWordHolder() {
        return this.wordHolder;
    }

    public int getInstancesSize() {
        return this.instances.size();
    }

    public static class AlphaComparator
    implements Comparator<InstanceHolder<? extends Instance>> {
        @Override
        public int compare(InstanceHolder<? extends Instance> ih1, InstanceHolder<? extends Instance> ih2) {
            int c = ((InstanceHolder)ih1).word.compareToIgnoreCase(((InstanceHolder)ih2).word);
            if (c == 0) {
                return ih1.compareToNonGeneric(ih2);
            }
            return c;
        }
    }
}

