/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import model.doc.DocumentElement;

public class Entity
extends DocumentElement {
    private String replacement;
    private boolean isReplaced;
    private AttributeSet atts;

    public Entity(Position start, Position end, String original) {
        super(start, end, original);
        this.isReplaced = false;
    }

    public Entity(Position start, Position end, String original, String replacement) {
        super(start, end, original);
        this.replacement = replacement;
        this.isReplaced = true;
    }

    public void revertInText(StyledDocument doc) throws BadLocationException {
        if (this.isReplaced) {
            int startInt = this.getStartOffset();
            this.atts = doc.getCharacterElement(startInt).getAttributes();
            doc.remove(startInt, this.replacement.length());
            doc.insertString(startInt, this.getOriginal(), this.atts);
            this.setStart(doc.createPosition(startInt));
        }
    }

    public void reReplaceInText(StyledDocument doc) throws BadLocationException {
        if (this.isReplaced) {
            int startInt = this.getStartOffset();
            doc.remove(startInt, this.getOriginal().length());
            doc.insertString(startInt, this.replacement, this.atts);
            this.setStart(doc.createPosition(startInt));
            this.atts = null;
        }
    }

    @Override
    public String toString() {
        String toReturn = super.toString();
        if (this.isReplaced) {
            toReturn = String.valueOf(toReturn) + " -> " + this.replacement;
        }
        return toReturn;
    }

    @Override
    public String getDisplayString() {
        if (this.isReplaced) {
            return this.replacement;
        }
        return this.getOriginal();
    }

    public boolean isReplaced() {
        return this.isReplaced;
    }

    public String getReplacement() {
        return this.replacement;
    }
}

