/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.Globals;
import model.MethodScores;
import model.MethodScoresUpdate;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.CorrectInstance;
import model.doc.Entity;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InstanceStartMovedListener;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplaceAllFInstancesEdit;
import model.doc.ReplaceFInstanceEdit;
import model.doc.ReplacementListener;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class DocumentModel
implements HolderChangeListener,
ReplacementListener,
InstanceStartMovedListener {
    private static final long serialVersionUID = 6180371772133602545L;
    private Charset charset;
    private TreeSet<WordHolder> words;
    private TreeMap<Integer, TreeSet<InstanceHolder<? extends Instance>>> holderLists = new TreeMap();
    private TreeMap<Integer, Vector<HolderChangeListener>> changeListeners = new TreeMap();
    private StyledDocument doc;
    protected static ConfidenceWeights confidenceWeights;
    private static LookUpDictionary lud;
    private String[] shortCounts = new String[5];
    private Globals global = Globals.getInstance();
    private TreeMap<Position, IgnorableText> ignored;
    private TreeMap<Position, Entity> entities;
    private TreeMap<Position, Instance> instances;
    private TreeMap<Position, Instance> oldInstances;
    private TreeMap<Integer, TreeSet<Instance>> typeInstances;
    private static DocumentModel _instance;

    public void addChangeListener(HolderChangeListener hcl, int type) {
        Vector<HolderChangeListener> hcls = this.changeListeners.get(type);
        if (hcls == null) {
            hcls = new Vector();
            this.changeListeners.put(type, hcls);
        }
        hcls.add(hcl);
    }

    public StyledDocument getDoc() {
        return this.doc;
    }

    private int getDocLength() {
        return this.doc.getLength();
    }

    public TreeSet<InstanceHolder<? extends Instance>> getHolderList(int type) {
        return this.holderLists.get(type);
    }

    public static DocumentModel getInstance() {
        if (_instance == null) {
            _instance = new DocumentModel();
        }
        return _instance;
    }

    public void processNewFile(File file) throws BadLocationException, InvalidInstanceChangeException {
        this.global.lockFinishProgress();
        try {
            this.clear();
            this.readFile(file);
            this.ignoreText(this.getStartOfDoc());
            this.parseSpecialEntities(this.getStartOfDoc(), this.getEndOfDoc());
            Collection<ReplacementTempClass> rtcs = this.parseXMLTags(this.getStartOfDoc());
            this.xmlReplace(rtcs);
            this.newReadWords(this.getStartOfDoc(), this.getEndOfDoc());
        }
        finally {
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    public void processNewText(String text, AttributeSet atts) throws BadLocationException, InvalidInstanceChangeException {
        this.global.lockFinishProgress();
        try {
            int start = this.insertText(text, atts);
            this.ignoreText(start);
            this.parseSpecialEntities(start, this.getEndOfDoc());
            Collection<ReplacementTempClass> rtcs = this.parseXMLTags(start);
            this.xmlReplace(rtcs);
            this.newReadWords(start, this.getEndOfDoc());
        }
        finally {
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    private DocumentModel() {
        this.global.setGlobalHolderChangeListener(this);
        this.global.setGlobalReplacementListener(this);
        lud = LookUpDictionary.getInstance();
        confidenceWeights = ConfidenceWeights.getInstance();
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            this.holderLists.put(t, new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.AlphaComparator()));
            this.addChangeListener(new HolderChangeListener(){

                @Override
                public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
                }

                @Override
                public void instanceAboutToChange(Instance instance, int type) {
                    Instance old = (Instance)DocumentModel.this.instances.remove(instance.getStart());
                    if (old != null) {
                        ((TreeSet)DocumentModel.this.typeInstances.get(type)).remove(old);
                        DocumentModel.this.oldInstances.put(old.getStart(), old);
                    }
                }

                @Override
                public void instanceChanged(Instance instance, int type) {
                    DocumentModel.this.instances.put(instance.getStart(), instance);
                    ((TreeSet)DocumentModel.this.typeInstances.get(type)).add(instance);
                }

                @Override
                public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                    ((TreeSet)DocumentModel.this.holderLists.get(type)).remove(holder);
                }

                @Override
                public void holderFilled(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                    ((TreeSet)DocumentModel.this.holderLists.get(type)).add(holder);
                }
            }, t);
            ++n2;
        }
        this.addChangeListener(confidenceWeights, 102);
        this.clear();
    }

    public void clear() {
        this.doc = new DefaultStyledDocument();
        this.words = new TreeSet();
        this.instances = new TreeMap(new PosCompare());
        this.typeInstances = new TreeMap();
        this.typeInstances.put(101, new TreeSet());
        this.typeInstances.put(102, new TreeSet());
        this.typeInstances.put(103, new TreeSet());
        this.oldInstances = new TreeMap(new PosCompare());
        this.entities = new TreeMap(new PosCompare());
        this.ignored = new TreeMap(new PosCompare());
        for (TreeSet<InstanceHolder<? extends Instance>> ts : this.holderLists.values()) {
            ts.clear();
        }
        this.charset = Charset.defaultCharset();
    }

    private WordHolder getReferenceTo(String word) {
        WordHolder newWH = new WordHolder(word);
        if (!this.words.add(newWH)) {
            return this.words.floor(newWH);
        }
        newWH.setDictionaryRef(lud.checkWords(word));
        return newWH;
    }

    public JoinEdit getJoinEdit(int start, int end) throws BadLocationException {
        return new JoinEdit(start, end);
    }

    public ProcessAllVariantsEdit getProcessAllVariantsEdit(double threshold, boolean updateConfidenceWeights) {
        return new ProcessAllVariantsEdit(threshold, updateConfidenceWeights);
    }

    private String getRevertedEntitiesText(Position start, Position end) throws BadLocationException {
        this.revertEntities(start, end);
        String text = this.doc.getText(start.getOffset(), end.getOffset() - start.getOffset());
        this.reReplaceEntities(start, end);
        return text;
    }

    private void parseSpecialEntities(int start, int end) throws BadLocationException {
        if (end - start < 1) {
            return;
        }
        if (end > this.getEndOfDoc()) {
            end = this.getEndOfDoc();
        }
        this.global.startProgress(end - start);
        this.global.writeProgressMessage("Checking entities...");
        int offset = 0;
        try {
            for (Map.Entry<String, String> entityMapping : this.global.getEntities().entrySet()) {
                offset = 0;
                Pattern emPattern = Pattern.compile(entityMapping.getKey());
                Matcher emMatcher = emPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
                while (emMatcher.find()) {
                    int emStart = start + emMatcher.start() - offset;
                    int emEnd = start + emMatcher.end() - offset;
                    if (this.isIgnored(this.doc.createPosition(emStart))) continue;
                    AttributeSet atts = this.getAttributesAtPos(emStart);
                    this.doc.remove(emStart, emEnd - emStart);
                    this.doc.insertString(emStart, entityMapping.getValue(), atts);
                    offset += emEnd - emStart - entityMapping.getValue().length();
                    Position entityStartPos = this.doc.createPosition(emStart);
                    Position entityEndPos = this.doc.createPosition(emEnd);
                    this.entities.put(entityStartPos, new Entity(entityStartPos, entityEndPos, emMatcher.group(), entityMapping.getValue()));
                }
            }
            Pattern entityPattern = Pattern.compile("&[#]?[x]?([a-zA-Z0-9]+);");
            Matcher entityMatcher = entityPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            offset = 0;
            while (entityMatcher.find()) {
                String entity = entityMatcher.group(1);
                String wholeEntity = entityMatcher.group();
                int entityStart = start + entityMatcher.start() - offset;
                int entityEnd = start + entityMatcher.end() - offset;
                if (!this.isIgnored(this.doc.createPosition(entityStart))) {
                    if (entity.matches("^[a-fA-F0-9]+$")) {
                        int hex = Integer.parseInt(entity, 16);
                        char c = (char)hex;
                        String entityRep = String.valueOf(c);
                        AttributeSet atts = this.getAttributesAtPos(entityStart);
                        this.doc.remove(entityStart, entityEnd - entityStart);
                        this.doc.insertString(entityStart, entityRep, atts);
                        offset += entityEnd - entityStart - entityRep.length();
                        Position entityStartPos = this.doc.createPosition(entityStart);
                        Position entityEndPos = this.doc.createPosition(entityEnd);
                        this.entities.put(entityStartPos, new Entity(entityStartPos, entityEndPos, wholeEntity, entityRep));
                    } else {
                        Position entityStartPos = this.doc.createPosition(entityStart);
                        Position entityEndPos = this.doc.createPosition(entityEnd);
                        this.entities.put(entityStartPos, new Entity(entityStartPos, entityEndPos, wholeEntity));
                    }
                }
                this.global.setProgressCurrent(entityEnd);
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private void ignoreText(int start) throws BadLocationException {
        try {
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Ignoring text which should be ignored...");
            for (String ignore : this.global.getIgnored()) {
                Pattern tagPattern = Pattern.compile(ignore);
                Matcher tagMatcher = tagPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
                while (tagMatcher.find()) {
                    String match = tagMatcher.group();
                    if (match.matches("<[/]?(normalised|join|replaced)[^<>]*>") || match.matches("<[/]?(not)?variant>") || match.matches("<[/]?correct>")) continue;
                    int tagStart = start + tagMatcher.start();
                    int tagEnd = start + tagMatcher.end();
                    if (!this.isIgnored(this.doc.createPosition(tagStart))) {
                        IgnorableText toIgnore = new IgnorableText(this.doc.createPosition(tagStart), this.doc.createPosition(tagEnd), tagMatcher.group());
                        this.global.getGlobalIgnorableTextListener().ignore(toIgnore);
                        IgnorableText previous = this.ignored.put(this.doc.createPosition(tagStart), toIgnore);
                        if (previous != null && previous.getOriginal().length() > toIgnore.getOriginal().length()) {
                            this.ignored.put(previous.getStart(), previous);
                        }
                    }
                    this.global.setProgressCurrent(tagEnd);
                }
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private Collection<ReplacementTempClass> parseXMLTags(int start) throws BadLocationException, InvalidInstanceChangeException {
        Vector<ReplacementTempClass> rtcs = new Vector<ReplacementTempClass>();
        if (this.getDocLength() - start < 1) {
            return rtcs;
        }
        try {
            int tagStart;
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Reading <variant> xml tags...");
            int offset = 0;
            Pattern variantPattern = Pattern.compile("(<join original=\"([^\"]*)\">)?<variant>([^<>]*)</variant>(</join>)?");
            Matcher variantMatcher = variantPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (variantMatcher.find()) {
                String variant = variantMatcher.group(3);
                int tagStart2 = start + variantMatcher.start() - offset;
                int tagEnd = start + variantMatcher.end() - offset;
                int variantStart = start + variantMatcher.start(3) - offset;
                int variantEnd = start + variantMatcher.end(3) - offset;
                int firstRemoveLength = variantStart - tagStart2;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (variantEnd -= firstRemoveLength);
                boolean join = false;
                String joinString = null;
                if (variantMatcher.group(2) != null) {
                    join = true;
                    int joinStart = start + variantMatcher.start(2) - offset;
                    int joinEnd = start + variantMatcher.end(2) - offset;
                    Position startPos = this.doc.createPosition(joinStart);
                    Position endPos = this.doc.createPosition(joinEnd);
                    joinString = this.getRevertedEntitiesText(startPos, endPos);
                    this.removeEntities(startPos, endPos);
                }
                this.doc.remove(tagStart2, firstRemoveLength);
                this.doc.remove(variantEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                String currentWordStringLC = variant.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                VariantInstance added = wh.addVariant(this.doc.createPosition(tagStart2), this.doc.createPosition(variantEnd), variant);
                added.setUserChanged(true);
                if (join) {
                    added.setJoin(true);
                    added.setJoinString(joinString);
                }
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Reading <notvariant> xml tags...");
            offset = 0;
            Pattern correctPattern = Pattern.compile("(<join original=\"([^\"]*)\">)?<(notvariant|correct)>([^<>]*)</(notvariant|correct)>(</join>)?");
            Matcher correctMatcher = correctPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (correctMatcher.find()) {
                String word = correctMatcher.group(4);
                int tagStart3 = start + correctMatcher.start() - offset;
                int tagEnd = start + correctMatcher.end() - offset;
                int correctStart = start + correctMatcher.start(4) - offset;
                int correctEnd = start + correctMatcher.end(4) - offset;
                int firstRemoveLength = correctStart - tagStart3;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (correctEnd -= firstRemoveLength);
                boolean join = false;
                String joinString = null;
                if (correctMatcher.group(2) != null) {
                    join = true;
                    int joinStart = start + correctMatcher.start(2) - offset;
                    int joinEnd = start + correctMatcher.end(2) - offset;
                    Position startPos = this.doc.createPosition(joinStart);
                    Position endPos = this.doc.createPosition(joinEnd);
                    joinString = this.getRevertedEntitiesText(startPos, endPos);
                    this.removeEntities(startPos, endPos);
                }
                this.doc.remove(tagStart3, firstRemoveLength);
                this.doc.remove(correctEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                String currentWordStringLC = word.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                CorrectInstance added = wh.addCorrect(this.doc.createPosition(tagStart3), this.doc.createPosition(correctEnd), word);
                added.setUserChanged(true);
                if (join) {
                    added.setJoin(true);
                    added.setJoinString(joinString);
                }
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Reading <normalised> xml tags...");
            offset = 0;
            Pattern replacedPattern = Pattern.compile("(<join original=\"([^\"]*)\">)?<(normalised|replaced) (orig|variant)=\"([^\"]*)\"([^<>]*)>([^<>]*)</(normalised|replaced)>(</join>)?");
            Matcher replacedMatcher = replacedPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            Pattern autoPattern = Pattern.compile("auto=\"(true|false)\"");
            while (replacedMatcher.find()) {
                String variant = replacedMatcher.group(5);
                String replacement = replacedMatcher.group(7);
                tagStart = start + replacedMatcher.start() - offset;
                int tagEnd = start + replacedMatcher.end() - offset;
                int variantStart = start + replacedMatcher.start(5) - offset;
                int variantEnd = start + replacedMatcher.end(5) - offset;
                int firstRemoveLength = variantStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (variantEnd -= firstRemoveLength);
                boolean join = false;
                String joinString = null;
                if (replacedMatcher.group(2) != null) {
                    join = true;
                    int joinStart = start + replacedMatcher.start(2) - offset;
                    int joinEnd = start + replacedMatcher.end(2) - offset;
                    Position startPos = this.doc.createPosition(joinStart);
                    Position endPos = this.doc.createPosition(joinEnd);
                    joinString = this.getRevertedEntitiesText(startPos, endPos);
                    this.removeEntities(startPos, endPos);
                }
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(variantEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                ReplacementTempClass replacementInfo = new ReplacementTempClass();
                String currentWordStringLC = variant.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                VariantInstance added = wh.addVariant(this.doc.createPosition(tagStart), this.doc.createPosition(variantEnd), variant);
                replacementInfo.isJoin = join;
                if (join) {
                    replacementInfo.joinString = joinString;
                }
                added.setJoin(replacementInfo.isJoin);
                added.setJoinString(replacementInfo.joinString);
                replacementInfo.variant = added;
                replacementInfo.start = this.doc.createPosition(tagStart);
                replacementInfo.replacement = replacement;
                Matcher autoMatcher = autoPattern.matcher(replacedMatcher.group(6));
                if (autoMatcher.find()) {
                    replacementInfo.isAuto = Boolean.parseBoolean(autoMatcher.group(1));
                }
                rtcs.add(replacementInfo);
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Dealing with <join> xml tags...");
            offset = 0;
            Pattern joinPattern = Pattern.compile("<join original=\"([^\"]*)\">([^<>]*)</join>");
            Matcher joinMatcher = joinPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (joinMatcher.find()) {
                tagStart = start + joinMatcher.start() - offset;
                int tagEnd = start + joinMatcher.end() - offset;
                String joinNew = joinMatcher.group(2);
                int wordStart = start + joinMatcher.start(2) - offset;
                int wordEnd = start + joinMatcher.end(2) - offset;
                int firstRemoveLength = wordStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (wordEnd -= firstRemoveLength);
                int joinStart = start + joinMatcher.start(1) - offset;
                int joinEnd = start + joinMatcher.end(1) - offset;
                Position startPos = this.doc.createPosition(joinStart);
                Position endPos = this.doc.createPosition(joinEnd);
                String joinOriginal = this.getRevertedEntitiesText(startPos, endPos);
                this.removeEntities(startPos, endPos);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(wordEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                this.newReadWords(tagStart, tagStart + joinNew.length());
                Instance added = this.getWordAt(tagStart);
                added.setJoin(true);
                added.setJoinString(joinOriginal);
                this.global.setProgressCurrent(tagEnd);
            }
        }
        finally {
            this.global.finishProgress();
        }
        return rtcs;
    }

    private void newReadWords(int start, int end) throws BadLocationException {
        if (end - start < 1) {
            return;
        }
        if (end > this.getEndOfDoc()) {
            end = this.getEndOfDoc();
        }
        this.global.startProgress(end - start);
        this.global.writeProgressMessage("Evaluating words...");
        try {
            String text = this.doc.getText(start, end - start);
            Pattern wordPattern = Pattern.compile(this.global.getWordRegex());
            Matcher wordMatcher = wordPattern.matcher(text);
            int textLength = text.length();
            while (wordMatcher.find()) {
                int wmStart = wordMatcher.start();
                this.global.setProgressCurrent(wmStart);
                int wmEnd = wordMatcher.end();
                int wordStart = start + wmStart;
                String currentWordString = wordMatcher.group();
                char charBefore = 'S';
                if (wmStart > 0) {
                    charBefore = text.charAt(wmStart - 1);
                }
                char charAfter = 'E';
                if (wmEnd < textLength) {
                    charAfter = text.charAt(wmEnd);
                }
                if (!this.isValidWord(currentWordString) || this.isIgnored(this.doc.createPosition(wordStart)) || Character.isDigit(charBefore) || Character.isDigit(charAfter) || this.getWordAt(wordStart) != null) continue;
                String currentWordStringLC = currentWordString.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                int wordEnd = wordStart + currentWordString.length();
                if (wh.isInDictionary()) {
                    wh.addCorrect(this.doc.createPosition(wordStart), this.doc.createPosition(wordEnd), currentWordString);
                    continue;
                }
                wh.addVariant(this.doc.createPosition(wordStart), this.doc.createPosition(wordEnd), currentWordString);
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private boolean isIgnored(Position pos) {
        Position closestKey = this.ignored.floorKey(pos);
        return closestKey != null && this.ignored.get(closestKey).containsPosition(pos.getOffset());
    }

    private IgnorableText getIgnored(Position pos) {
        Position closestKey = this.ignored.floorKey(pos);
        if (closestKey == null) {
            return null;
        }
        IgnorableText it = this.ignored.get(closestKey);
        if (it.containsPosition(pos.getOffset()) || it.getEnd().equals(pos)) {
            return it;
        }
        return null;
    }

    private int insertText(String text, AttributeSet textStyle) throws BadLocationException {
        if (text.length() < 1) {
            return this.getEndOfDoc();
        }
        try {
            if (this.doc.getLength() > 0) {
                this.doc.insertString(this.getEndOfDoc(), "\n\n", null);
            } else {
                this.doc.insertString(0, "\n", null);
            }
            int start = this.getEndOfDoc();
            this.doc.insertString(start, text, textStyle);
            return start;
        }
        catch (BadLocationException e) {
            this.global.showException("Error occurred inserting text.", e);
            return this.getEndOfDoc();
        }
    }

    private boolean isValidWord(String word) {
        return !word.contains("--") && !word.equals("-");
    }

    public Instance getWordAt(int caretPos) throws BadLocationException {
        Instance toReturn;
        Map.Entry<Position, Instance> entry = this.instances.floorEntry(this.doc.createPosition(caretPos));
        Instance instance = toReturn = entry == null ? null : entry.getValue();
        if (toReturn != null && toReturn.containsPosition(caretPos)) {
            return toReturn;
        }
        return null;
    }

    public void printInstances() {
        for (Map.Entry<Position, Instance> ei : this.instances.entrySet()) {
            System.out.println(String.valueOf(ei.getKey().getOffset()) + ": " + ei.getValue());
        }
        System.out.println();
        System.out.println("Old:");
        for (Map.Entry<Position, Instance> ei : this.oldInstances.entrySet()) {
            System.out.println(String.valueOf(ei.getKey().getOffset()) + ": " + ei.getValue());
        }
    }

    private void revertEntities(Position start, Position end) throws BadLocationException {
        TreeMap<Position, Entity> newEntities = new TreeMap<Position, Entity>(new PosCompare());
        newEntities.putAll(this.entities);
        for (Entity entity : this.entities.subMap(start, end).values()) {
            Instance oldInstanceAtSamePos;
            newEntities.remove(entity.getStart());
            Instance instanceAtSamePos = this.instances.get(entity.getStart());
            if (instanceAtSamePos != null) {
                instanceAtSamePos.saveStart();
            }
            if ((oldInstanceAtSamePos = this.oldInstances.get(entity.getStart())) != null) {
                oldInstanceAtSamePos.saveStart();
            }
            entity.revertInText(this.doc);
            if (instanceAtSamePos != null) {
                instanceAtSamePos.restoreStart(this.doc, 0);
            }
            if (oldInstanceAtSamePos != null) {
                oldInstanceAtSamePos.restoreStart(this.doc, 0);
            }
            newEntities.put(entity.getStart(), entity);
        }
        this.entities = newEntities;
    }

    private void reReplaceEntities(Position start, Position end) throws BadLocationException {
        TreeMap<Position, Entity> newEntities = new TreeMap<Position, Entity>(new PosCompare());
        newEntities.putAll(this.entities);
        for (Entity entity : this.entities.subMap(start, end).values()) {
            Instance oldInstanceAtSamePos;
            newEntities.remove(entity.getStart());
            Instance instanceAtSamePos = this.instances.get(entity.getStart());
            if (instanceAtSamePos != null) {
                instanceAtSamePos.saveStart();
            }
            if ((oldInstanceAtSamePos = this.oldInstances.get(entity.getStart())) != null) {
                oldInstanceAtSamePos.saveStart();
            }
            entity.reReplaceInText(this.doc);
            if (instanceAtSamePos != null) {
                instanceAtSamePos.restoreStart(this.doc, 0);
            }
            if (oldInstanceAtSamePos != null) {
                oldInstanceAtSamePos.restoreStart(this.doc, 0);
            }
            newEntities.put(entity.getStart(), entity);
        }
        this.entities = newEntities;
    }

    private void revertEntities() {
        this.global.startProgress(this.entities.size());
        this.global.writeProgressMessage("Reverting entities to original state");
        try {
            try {
                TreeMap<Position, Entity> newEntities = new TreeMap<Position, Entity>(new PosCompare());
                for (Entity entity : this.entities.values()) {
                    Instance oldInstanceAtSamePos;
                    Instance instanceAtSamePos = this.instances.get(entity.getStart());
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.saveStart();
                    }
                    if ((oldInstanceAtSamePos = this.oldInstances.get(entity.getStart())) != null) {
                        oldInstanceAtSamePos.saveStart();
                    }
                    entity.revertInText(this.doc);
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.restoreStart(this.doc, 0);
                    }
                    if (oldInstanceAtSamePos != null) {
                        oldInstanceAtSamePos.restoreStart(this.doc, 0);
                    }
                    newEntities.put(entity.getStart(), entity);
                }
                this.entities = newEntities;
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred reverting entities to original state", ex);
                this.global.finishProgress();
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private void reReplaceEntities() {
        this.global.startProgress(this.entities.size());
        this.global.writeProgressMessage("Reverting entities to VARD state");
        try {
            try {
                TreeMap<Position, Entity> newEntities = new TreeMap<Position, Entity>(new PosCompare());
                for (Entity entity : this.entities.values()) {
                    Instance oldInstanceAtSamePos;
                    Instance instanceAtSamePos = this.instances.get(entity.getStart());
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.saveStart();
                    }
                    if ((oldInstanceAtSamePos = this.oldInstances.get(entity.getStart())) != null) {
                        oldInstanceAtSamePos.saveStart();
                    }
                    entity.reReplaceInText(this.doc);
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.restoreStart(this.doc, 0);
                    }
                    if (oldInstanceAtSamePos != null) {
                        oldInstanceAtSamePos.restoreStart(this.doc, 0);
                    }
                    newEntities.put(entity.getStart(), entity);
                }
                this.entities = newEntities;
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred reverting entities to VARD state", ex);
                this.global.finishProgress();
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    public void setAllHighlights(AttributeSet atts) {
        this.doc.setCharacterAttributes(0, this.doc.getLength(), atts, false);
    }

    public void reIgnoreAllIgnored() {
        for (IgnorableText it : this.ignored.values()) {
            this.global.getGlobalIgnorableTextListener().ignore(it);
        }
    }

    /*
     * Exception decompiling
     */
    private void readFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean saveToFile(File file) {
        this.global.lockFinishProgress();
        this.revertEntities();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Saving without tags: " + file.getName() + "...");
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            if (file.getName().endsWith("rtf")) {
                new RTFEditorKit().write(fileOut, (Document)this.doc, 1, this.doc.getLength() - 1);
            } else {
                OutputStreamWriter plainOut = new OutputStreamWriter((OutputStream)fileOut, this.charset);
                new DefaultEditorKit().write(plainOut, (Document)this.doc, 1, this.doc.getLength() - 1);
                plainOut.close();
            }
            fileOut.close();
            return true;
        }
        catch (BadLocationException e) {
            this.global.showException("Error occurred saving document: " + file.getAbsolutePath(), e);
            return false;
        }
        catch (IOException e) {
            this.global.showException("Error occurred saving document: " + file.getAbsolutePath(), e);
            return false;
        }
        finally {
            this.global.finishProgress();
            this.reReplaceEntities();
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportToXML(File file) {
        this.global.lockFinishProgress();
        this.revertEntities();
        try {
            this.global.startProgress(this.instances.size());
            this.global.writeProgressMessage("Saving with xml tags: " + file.getName() + "...");
            Collection backwardsInstances = this.instances.descendingMap().values();
            int count = 0;
            Iterator iterator = backwardsInstances.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    OutputStreamWriter plainOut = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
                    new DefaultEditorKit().write(plainOut, (Document)this.doc, 1, this.doc.getLength() - 1);
                    plainOut.close();
                }
                Instance instance = (Instance)iterator.next();
                if (instance.isXMLRequired()) {
                    instance.insertXMLTags(this.doc);
                }
                this.global.setProgressCurrent(++count);
            }
        }
        catch (BadLocationException e) {
            this.global.showException("Error occurred saving xml file: " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            this.global.showException("Error occurred saving xml file: " + file.getAbsolutePath(), e);
        }
        finally {
            this.global.finishProgress();
            try {
                for (Instance instance : this.instances.values()) {
                    instance.removeLastXMLTags(this.doc);
                }
            }
            catch (BadLocationException e) {
                this.global.showException("Error occurred removing xml tags for display: " + file.getAbsolutePath(), e);
                return false;
            }
        }
        this.reReplaceEntities();
        this.global.unlockFinishProgress();
        this.global.finishProgress();
        return false;
    }

    public AttributeSet getAttributesAtPos(int pos) {
        return this.doc.getCharacterElement(pos).getAttributes();
    }

    public boolean isCharAtPosLetter(int pos) throws BadLocationException {
        return Character.isLetter(this.doc.getText(pos, 1).charAt(0));
    }

    public int getStartOfDoc() {
        return 0;
    }

    public int getEndOfDoc() {
        return this.getDocLength();
    }

    public void findReplacementsForWord(WordHolder word, int limit) {
        word.setReplacements(lud.findReplacements(word.getWord(), word.getSoundexCode(), limit));
    }

    private void getReplacements(int limit) {
        TreeSet<InstanceHolder<? extends Instance>> varIHs = this.getHolderList(101);
        this.global.startProgress(varIHs.size());
        this.global.writeProgressMessage("Finding replacements...");
        int currentPos = 0;
        for (InstanceHolder instanceHolder : varIHs) {
            this.findReplacementsForWord(instanceHolder.getWordHolder(), limit);
            this.global.setProgressCurrent(++currentPos);
        }
        this.global.finishProgress();
    }

    public String[] getShortCounts() {
        return this.shortCounts;
    }

    private void xmlReplace(ReplacementTempClass rtc) throws InvalidInstanceChangeException, BadLocationException {
        boolean wordNotInDic = false;
        Word wordInDic = lud.checkWords(rtc.replacement);
        if (wordInDic == null) {
            wordNotInDic = true;
            wordInDic = new Word(rtc.replacement, null, true, 1);
        }
        SuggestedReplacement rep = null;
        String variant = rtc.variant.getOriginal();
        List<SuggestedReplacement> reps = lud.findReplacements(variant, WordUtilities.getSoundexCode(variant), 0);
        if (wordNotInDic && this.global.isTrainFromXML() && this.global.isAddNewXMLRepsToDict() && !rtc.isAuto) {
            lud.addUserWord(rtc.replacement);
            wordInDic = lud.checkWords(rtc.replacement);
            lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + wordInDic);
        }
        for (SuggestedReplacement r : reps) {
            if (!r.getReplacement().equals(wordInDic)) continue;
            rep = r;
            break;
        }
        if (rep == null) {
            rep = new SuggestedReplacement(wordInDic, variant, false);
            if (reps.size() != 0) {
                SuggestedReplacement first = (SuggestedReplacement)reps.iterator().next();
                for (Map.Entry<String, MethodScoresUpdate> msu : first.getMethodScoresUpdates().entrySet()) {
                    MethodScores origUpdate = msu.getValue().getUpdate();
                    MethodScores newUpdate = new MethodScores(0.0, origUpdate.fp() + origUpdate.tp());
                    rep.setScoreUpdate(msu.getKey(), new MethodScoresUpdate(msu.getValue().getToUpdate(), newUpdate));
                }
            } else {
                Set<Map.Entry<String, MethodScores>> cwMSs = confidenceWeights.getScores().entrySet();
                for (Map.Entry<String, MethodScores> ms : cwMSs) {
                    rep.setScoreUpdate(ms.getKey(), new MethodScoresUpdate(ms.getValue(), new MethodScores(0.0, 0.0)));
                }
            }
            rep.reCalculateScore();
        }
        confidenceWeights.setUpdate(this.global.isTrainFromXML() && !rtc.isAuto);
        ReplaceFInstanceEdit<VariantInstance> edit = new ReplaceFInstanceEdit<VariantInstance>(rtc.variant, rep, this.doc, true, rtc.isAuto, this.global.isTrainFromXML() && !rtc.isAuto);
        edit.execute();
        confidenceWeights.setUpdateToDefault();
    }

    private void xmlReplace(Collection<ReplacementTempClass> rtcs) throws BadLocationException, InvalidInstanceChangeException {
        confidenceWeights.setUpdate(this.global.isTrainFromXML());
        for (ReplacementTempClass rtc : rtcs) {
            this.xmlReplace(rtc);
        }
        confidenceWeights.setUpdateToDefault();
    }

    public LookUpDictionary getLud() {
        return lud;
    }

    public void setLud(LookUpDictionary l) {
        lud = l;
    }

    public static String getStatsHeader() {
        return "File\tTotal Words\tVariants\tNormalised\tNon-variants\tTotal Tokens\tVariant Tokens\tNormalised Tokens\tNon-variant Tokens";
    }

    public String getStats() {
        int wordsCount = this.words.size();
        int variantsCount = 0;
        int replacedCount = 0;
        int correctCount = 0;
        int variantTokenCount = 0;
        int replacedTokenCount = 0;
        int correctTokenCount = 0;
        for (WordHolder wh : this.words) {
            variantTokenCount += wh.getVariantsSize();
            replacedTokenCount += wh.getReplacedSize();
            correctTokenCount += wh.getCorrectSize();
            if (wh.isAtleastOneInstanceAVariant()) {
                ++variantsCount;
            }
            if (wh.isAtleastOneInstanceAReplaced()) {
                ++replacedCount;
            }
            if (!wh.isAtleastOneInstanceACorrect()) continue;
            ++correctCount;
        }
        int tokenCount = variantTokenCount + replacedTokenCount + correctTokenCount;
        return String.valueOf(wordsCount) + "\t" + variantsCount + "\t" + replacedCount + "\t" + correctCount + "\t" + tokenCount + "\t" + variantTokenCount + "\t" + replacedTokenCount + "\t" + correctTokenCount;
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance lastRemoved, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.holderEmptied(holder, lastRemoved, type);
        }
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance lastAdded, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.holderFilled(holder, lastAdded, type);
        }
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.instanceAboutToChange(instance, type);
        }
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.instanceChanged(instance, type);
        }
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.listChanged(holder, type);
        }
    }

    @Override
    public void restoreEntities(Collection<Entity> entitiesToRestore, int offset) {
        if (entitiesToRestore == null || entitiesToRestore.isEmpty()) {
            return;
        }
        try {
            for (Entity entity : entitiesToRestore) {
                entity.restoreStart(this.doc, offset);
                this.entities.put(entity.getStart(), entity);
            }
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred restoring entity", ex);
        }
    }

    @Override
    public Collection<Entity> removeEntities(Position start, Position end) {
        SortedMap<Position, Entity> toRemove = this.entities.subMap(start, end);
        ArrayList<Entity> removed = new ArrayList<Entity>();
        removed.addAll(toRemove.values());
        toRemove.clear();
        for (Entity entity : removed) {
            entity.saveStart();
        }
        return removed;
    }

    @Override
    public Collection<IgnorableText> removeIgnored(Position start, Position end) {
        IgnorableText startIT = this.getIgnored(start);
        if (startIT != null) {
            start = startIT.getStart();
        }
        SortedMap<Position, IgnorableText> toRemove = this.ignored.subMap(start, end);
        ArrayList<IgnorableText> removed = new ArrayList<IgnorableText>();
        removed.addAll(toRemove.values());
        toRemove.clear();
        for (IgnorableText it : removed) {
            it.saveStart();
        }
        return removed;
    }

    @Override
    public void restoreIgnored(Collection<IgnorableText> ignoredToRestore, int offset) {
        if (ignoredToRestore == null || ignoredToRestore.isEmpty()) {
            return;
        }
        try {
            for (IgnorableText it : ignoredToRestore) {
                it.restoreStart(this.doc, offset);
                it.restoreEnd(this.doc);
                this.ignored.put(it.getStart(), it);
                this.global.getGlobalIgnorableTextListener().ignore(it);
            }
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred restoring ignored text", ex);
        }
    }

    @Override
    public Collection<Instance> removeInstances(Position start, Position end) {
        SortedMap<Position, Instance> toRemove = this.instances.subMap(start, end);
        ArrayList<Instance> removed = new ArrayList<Instance>();
        removed.addAll(toRemove.values());
        for (Instance instance : removed) {
            instance.saveStart();
            instance.removeSelfFromHolder();
        }
        return removed;
    }

    @Override
    public void restoreInstances(Collection<Instance> instancesToRestore, int offset) {
        if (instancesToRestore == null || instancesToRestore.isEmpty()) {
            return;
        }
        for (Instance instance : instancesToRestore) {
            try {
                instance.restoreStart(this.doc, offset);
            }
            catch (BadLocationException ex) {
                this.global.showException("Failed to restore Instance: " + instance, ex);
            }
            instance.addSelfToHolder();
        }
    }

    @Override
    public void instanceStartMoved(Position oldStart, Position newStart, Instance instance) {
        Instance toRemove = this.instances.get(oldStart);
        if (toRemove == null || !toRemove.getDisplayString().equals(instance.getDisplayString())) {
            toRemove = this.oldInstances.get(oldStart);
            if (toRemove != null && toRemove.getDisplayString().equals(instance.getDisplayString())) {
                this.oldInstances.remove(oldStart);
                this.oldInstances.put(newStart, instance);
            }
        } else {
            this.instances.remove(oldStart);
            this.instances.put(newStart, instance);
        }
    }

    public TreeSet<Instance> getInstances(int type) {
        return this.typeInstances.get(type);
    }

    public Instance getFirstInstance(int type) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        return ti.first();
    }

    public Instance getLastInstance(int type) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        return ti.last();
    }

    public Instance getNextInstance(int type, Instance current) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        if (current == null) {
            return ti.first();
        }
        Instance nextInstance = ti.higher(current);
        if (nextInstance == null) {
            nextInstance = ti.first();
        }
        return nextInstance;
    }

    public Instance getPreviousInstance(int type, Instance current) {
        TreeSet<Instance> ti = this.typeInstances.get(type);
        if (ti.isEmpty()) {
            return null;
        }
        if (current == null) {
            return ti.last();
        }
        Instance prevInstance = ti.lower(current);
        if (prevInstance == null) {
            prevInstance = ti.last();
        }
        return prevInstance;
    }

    public int getPosition(Instance instance) {
        if (instance == null) {
            return 0;
        }
        return this.typeInstances.get(instance.getType()).headSet(instance).size() + 1;
    }

    public int getTokenCount(int type) {
        return this.typeInstances.get(type).size();
    }

    static /* synthetic */ void access$7(DocumentModel documentModel, int n) {
        documentModel.getReplacements(n);
    }

    public static class AddWordToDictionaryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        WordHolder wh;
        String word;

        public AddWordToDictionaryEdit(WordHolder wh, String word) {
            this.wh = wh;
            this.word = word;
        }

        public void execute() {
            if (!this.executed && lud.checkWords(this.word.toString()) == null) {
                this.wh.setDictionaryRef(lud.addUserWord(this.word.toString()));
                lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed) {
                if (lud.removeWord(this.word)) {
                    this.wh.setDictionaryRef(null);
                    lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                }
            } else {
                throw new CannotUndoException();
            }
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (!this.undone) {
                throw new CannotRedoException();
            }
            this.wh.setDictionaryRef(lud.addUserWord(this.word.toString()));
            lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Add " + this.word + " to dictionary.";
        }
    }

    public class JoinEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private boolean executed = false;
        private boolean undone = false;
        private boolean valid = false;
        private String whyInvalid = "";
        private TreeMap<Integer, String> textRemoved;
        private TreeMap<Integer, AttributeSet> attsRemoved;
        private Collection<Instance> instancesRemoved;
        private Collection<IgnorableText> ignoredTextRemoved;
        private Collection<Entity> entitiesRemoved;
        private String originalText;
        private String newWord;
        private int start;
        private int end;
        private Instance addedInstance;
        private Collection<Instance> undoneInstances;

        private JoinEdit(int start, int end) throws BadLocationException {
            TreeSet<Instance> wordsSelected = new TreeSet<Instance>();
            int i = start - 1;
            while (i <= end) {
                Instance toAdd = DocumentModel.this.getWordAt(i);
                if (toAdd != null) {
                    if (toAdd.getType() == 102) {
                        this.valid = false;
                        this.whyInvalid = "Cannot join a normalised string.";
                        return;
                    }
                    wordsSelected.add(toAdd);
                }
                ++i;
            }
            if (wordsSelected.size() < 2) {
                this.valid = false;
                this.whyInvalid = "At least 2 words need to be selected to join.";
                return;
            }
            int newStart = ((Instance)wordsSelected.first()).getStartOffset();
            int newEnd = ((Instance)wordsSelected.last()).getEndOffset();
            this.start = newStart;
            this.end = newEnd;
            this.newWord = "";
            for (Instance word : wordsSelected) {
                this.newWord = String.valueOf(this.newWord) + word.getDisplayString();
                if (this.newWord.endsWith("-")) {
                    this.newWord = this.newWord.substring(0, this.newWord.length() - 1);
                }
                if (!this.newWord.startsWith("-")) continue;
                this.newWord = this.newWord.substring(1);
            }
            if (!DocumentModel.this.isValidWord(this.newWord)) {
                this.valid = false;
                this.whyInvalid = "Joined word produced is invalid.";
                return;
            }
            this.originalText = DocumentModel.this.getRevertedEntitiesText(DocumentModel.this.doc.createPosition(this.start), DocumentModel.this.doc.createPosition(this.end));
            this.valid = true;
        }

        private void doJoin() throws BadLocationException {
            this.instancesRemoved = DocumentModel.this.global.getGlobalReplacementListener().removeInstances(DocumentModel.this.doc.createPosition(this.start), DocumentModel.this.doc.createPosition(this.end));
            for (Instance instance : this.instancesRemoved) {
                instance.saveStart();
            }
            this.entitiesRemoved = new ArrayList<Entity>();
            this.ignoredTextRemoved = new ArrayList<IgnorableText>();
            this.textRemoved = new TreeMap();
            this.attsRemoved = new TreeMap();
            int remStart = -1;
            int remEnd = -1;
            for (Instance instance : this.instancesRemoved) {
                remEnd = instance.getStartOffset();
                if (instance.getDisplayString().startsWith("-")) {
                    ++remEnd;
                }
                if (remStart != -1) {
                    this.textRemoved.put(remStart, DocumentModel.this.doc.getText(remStart, remEnd - remStart));
                    this.attsRemoved.put(remStart, DocumentModel.this.getAttributesAtPos(remStart));
                    Position remStartPos = DocumentModel.this.doc.createPosition(remStart);
                    Position remEndPos = DocumentModel.this.doc.createPosition(remEnd);
                    this.entitiesRemoved.addAll(DocumentModel.this.global.getGlobalReplacementListener().removeEntities(remStartPos, remEndPos));
                    this.ignoredTextRemoved.addAll(DocumentModel.this.global.getGlobalReplacementListener().removeIgnored(remStartPos, remEndPos));
                    DocumentModel.this.doc.remove(remStart, remEnd - remStart);
                }
                remStart = instance.getEndOffset();
                if (!instance.getDisplayString().endsWith("-")) continue;
                --remStart;
            }
            if (this.undoneInstances != null) {
                DocumentModel.this.global.getGlobalReplacementListener().restoreInstances(this.undoneInstances, 0);
            } else {
                DocumentModel.this.newReadWords(this.start, this.end);
                this.addedInstance = (Instance)DocumentModel.this.instances.get(DocumentModel.this.doc.createPosition(this.start));
                this.addedInstance.setJoin(true);
                String originalJoin = this.originalText;
                for (Instance instance : this.instancesRemoved) {
                    if (!instance.isJoin()) continue;
                    originalJoin = originalJoin.replaceFirst(instance.getDisplayString(), instance.getJoinString());
                }
                this.addedInstance.setJoinString(originalJoin);
            }
            for (Instance instance : this.instancesRemoved) {
                instance.restoreStart(DocumentModel.this.doc, 0);
                instance.restoreEnd(DocumentModel.this.doc);
            }
        }

        private void undoJoin() throws BadLocationException {
            if (this.addedInstance != null) {
                this.undoneInstances = DocumentModel.this.global.getGlobalReplacementListener().removeInstances(DocumentModel.this.doc.createPosition(this.start), DocumentModel.this.doc.createPosition(this.start + 1));
            }
            for (Instance instance : this.instancesRemoved) {
                instance.restoreStart(DocumentModel.this.doc, 0);
                instance.saveStart();
            }
            int offset = 0;
            for (Map.Entry<Integer, String> stringToRestore : this.textRemoved.entrySet()) {
                DocumentModel.this.doc.insertString(stringToRestore.getKey() + offset, stringToRestore.getValue(), this.attsRemoved.get(stringToRestore.getKey()));
                offset += stringToRestore.getValue().length();
            }
            for (Instance instance : this.instancesRemoved) {
                instance.restoreStart(DocumentModel.this.doc, 0);
                instance.restoreEnd(DocumentModel.this.doc);
            }
            DocumentModel.this.global.getGlobalReplacementListener().restoreInstances(this.instancesRemoved, 0);
            DocumentModel.this.global.getGlobalReplacementListener().restoreEntities(this.entitiesRemoved, 0);
            DocumentModel.this.global.getGlobalReplacementListener().restoreIgnored(this.ignoredTextRemoved, 0);
        }

        public void execute() throws BadLocationException, InvalidInstanceChangeException {
            if (!this.executed && this.valid) {
                try {
                    this.doJoin();
                    this.executed = true;
                }
                catch (BadLocationException ex) {
                    this.undoJoin();
                    throw ex;
                }
            } else {
                throw new InvalidInstanceChangeException("Join is invalid");
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                try {
                    this.undoJoin();
                    this.undone = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.doJoin();
                    }
                    catch (BadLocationException e) {
                        throw new CannotUndoException();
                    }
                }
            } else {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                try {
                    this.doJoin();
                    this.undone = false;
                }
                catch (BadLocationException ex) {
                    throw new CannotUndoException();
                }
            } else {
                throw new CannotRedoException();
            }
        }

        @Override
        public boolean canUndo() {
            return this.executed && this.valid;
        }

        @Override
        public boolean canRedo() {
            return this.undone && this.valid;
        }

        @Override
        public String getPresentationName() {
            return "Join words (" + this.originalText + " -> " + this.newWord + ")";
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getWhyInvalid() {
            return this.whyInvalid;
        }
    }

    public static class PosCompare
    implements Comparator<Position> {
        @Override
        public int compare(Position p1, Position p2) {
            return p1.getOffset() - p2.getOffset();
        }
    }

    public class ProcessAllVariantsEdit
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 1L;
        private boolean executed;
        private boolean undone;
        private boolean update;
        private boolean hasChangedBefore = ConfidenceWeights.hasChanged();
        private double threshold;
        private int currentPos;
        private ArrayList<ReplaceAllFInstancesEdit<VariantInstance>> edits;
        private ArrayList<ReplaceAllFInstancesEdit<VariantInstance>> editsUndone;
        private ArrayList<ReplaceAllFInstancesEdit<VariantInstance>> editsRedone;

        private ProcessAllVariantsEdit(double threshold, boolean updateConfidenceWeights) {
            this.threshold = threshold;
            this.update = updateConfidenceWeights;
            this.edits = new ArrayList();
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed) {
                block9: {
                    DocumentModel.access$7(DocumentModel.this, 1);
                    varIHs = new TreeSet<InstanceHolder<? extends Instance>>();
                    varIHs.addAll(DocumentModel.this.getHolderList(101));
                    DocumentModel.access$3(DocumentModel.this).startProgress(varIHs.size());
                    DocumentModel.access$3(DocumentModel.this).writeProgressMessage("Replacing variants...");
                    DocumentModel.confidenceWeights.setUpdate(this.update);
                    this.currentPos = 0;
                    try {
                        try {
                            for (InstanceHolder varIH : varIHs) {
                                top = varIH.getWordHolder().getTopReplacement();
                                if (top != null && top.getScoreWithoutUpdating() >= this.threshold) {
                                    edit = new ReplaceAllFInstancesEdit<VariantInstance>(varIH.getWordHolder(), new VariantInstance(), top, DocumentModel.access$1(DocumentModel.this), true, true, false);
                                    edit.execute();
                                    this.edits.add(edit);
                                }
                                DocumentModel.access$3(DocumentModel.this).setProgressCurrent(++this.currentPos);
                            }
                            break block9;
                        }
                        catch (InvalidInstanceChangeException ex) {
                            ** for (edit : this.edits)
                        }
lbl-1000:
                        // 1 sources

                        {
                            edit.undo();
                            continue;
                        }
lbl26:
                        // 1 sources

                        throw new CannotExecuteException(ex.getMessage());
                    }
                    finally {
                        DocumentModel.confidenceWeights.setUpdateToDefault();
                        DocumentModel.access$3(DocumentModel.this).finishProgress();
                    }
                }
                this.executed = true;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void undo() throws CannotUndoException {
            block9: {
                if (this.canUndo()) {
                    DocumentModel.access$3(DocumentModel.this).startIndeterminateProgress();
                    this.editsUndone = new ArrayList<E>();
                    toUse = this.edits;
                    if (this.editsRedone != null && !this.editsRedone.isEmpty()) {
                        toUse = this.editsRedone;
                    }
                    DocumentModel.confidenceWeights.setUpdate(this.update);
                    DocumentModel.confidenceWeights.setHasChanged(this.hasChangedBefore);
                    DocumentModel.access$3(DocumentModel.this).startProgress(toUse.size());
                    DocumentModel.access$3(DocumentModel.this).writeProgressMessage("Undoing replacing variants...");
                    this.currentPos = 0;
                    try {
                        try {
                            for (ReplaceAllFInstancesEdit<VariantInstance> edit : toUse) {
                                edit.undo();
                                this.editsUndone.add(edit);
                                DocumentModel.access$3(DocumentModel.this).setProgressCurrent(++this.currentPos);
                            }
                            break block9;
                        }
                        catch (CannotUndoException ex) {
                            ** for (edit : this.editsUndone)
                        }
lbl-1000:
                        // 1 sources

                        {
                            edit.redo();
                            continue;
                        }
lbl25:
                        // 1 sources

                        throw ex;
                    }
                    finally {
                        DocumentModel.confidenceWeights.setUpdateToDefault();
                        DocumentModel.access$3(DocumentModel.this).finishProgress();
                    }
                }
                throw new CannotUndoException();
            }
            this.undone = true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void redo() throws CannotRedoException {
            block8: {
                if (this.canRedo()) {
                    DocumentModel.access$3(DocumentModel.this).startProgress(this.editsUndone.size());
                    DocumentModel.access$3(DocumentModel.this).writeProgressMessage("Redoing replacing variants...");
                    this.editsRedone = new ArrayList<E>();
                    DocumentModel.confidenceWeights.setUpdate(this.update);
                    this.currentPos = 0;
                    try {
                        try {
                            for (ReplaceAllFInstancesEdit<VariantInstance> edit : this.editsUndone) {
                                edit.redo();
                                this.editsRedone.add(edit);
                                DocumentModel.access$3(DocumentModel.this).setProgressCurrent(++this.currentPos);
                            }
                            break block8;
                        }
                        catch (CannotRedoException ex) {
                            ** for (edit : this.editsRedone)
                        }
lbl-1000:
                        // 1 sources

                        {
                            edit.undo();
                            continue;
                        }
lbl20:
                        // 1 sources

                        throw ex;
                    }
                    finally {
                        DocumentModel.confidenceWeights.setUpdateToDefault();
                        DocumentModel.access$3(DocumentModel.this).finishProgress();
                    }
                }
                throw new CannotRedoException();
            }
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Process all variants (" + this.threshold + "%)";
        }
    }

    public static class RemoveWordFromDictionaryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        WordHolder wh;
        String word;

        public RemoveWordFromDictionaryEdit(WordHolder wh, String word) {
            this.wh = wh;
            this.word = word;
        }

        public void execute() {
            if (!this.executed) {
                if (lud.removeWord(this.word)) {
                    this.wh.setDictionaryRef(null);
                    lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                }
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (!this.executed) {
                throw new CannotUndoException();
            }
            this.wh.setDictionaryRef(lud.addUserWord(this.word.toString()));
            lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                if (lud.removeWord(this.word)) {
                    lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                    this.wh.setDictionaryRef(null);
                }
            } else {
                throw new CannotRedoException();
            }
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Remove " + this.word + " from dictionary.";
        }
    }

    public class ReplacementTempClass {
        public Position start;
        public String replacement;
        public boolean isJoin;
        public String joinString;
        public VariantInstance variant;
        public boolean isAuto;
    }
}

