/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.text.Position;
import model.ExceptionMessageHandler;
import model.ProgressListener;
import model.doc.Entity;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.IgnorableTextListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.ReplacementListener;

public class Globals
implements ProgressListener,
ExceptionMessageHandler,
Thread.UncaughtExceptionHandler {
    private static int lockCount = 0;
    private static int keyCount = 0;
    boolean stopProgressMessages = false;
    int stopCount = 0;
    int resumeCount = 0;
    private static Globals _instance = null;
    private HolderChangeListener globalHolderChangeListener;
    private ReplacementListener globalReplacementListener;
    private IgnorableTextListener globalIgnorableTextListener;
    private static int soundexCodeLength = 6;
    private String wordRegex = "([\\p{L}\\'\\-\\^~=]|(&[#]?[a-zA-Z0-9]+;))+";
    private String encoding = "detect";
    private boolean addNewXMLRepsToDict = true;
    private boolean trainFromXML = false;
    private boolean searchSubfolders = false;
    private TreeMap<String, String> entities;
    private Collection<String> ignored;
    private ProgressListener progressHandler;
    private String lastProgressMessage = "";
    private String progressMessagePrefix = "";
    private int lastProgressMax = 0;
    private boolean finishProgressLocked = false;
    private boolean inValuedProgress = false;
    private int currentProgress = 0;
    public static int PROGRESS_DELAY = 250;
    private Timer progressTimer;
    protected ExceptionMessageHandler exceptionHandler;
    public static final String NEW_LINE = System.getProperty("line.separator");

    public boolean isAddNewXMLRepsToDict() {
        return this.addNewXMLRepsToDict;
    }

    public boolean isTrainFromXML() {
        return this.trainFromXML;
    }

    public void setTrainFromXML(boolean trainFromXML) {
        this.trainFromXML = trainFromXML;
    }

    public String getWordRegex() {
        return this.wordRegex;
    }

    public boolean isSearchSubfolders() {
        return this.searchSubfolders;
    }

    protected Globals() {
        Thread.setDefaultUncaughtExceptionHandler(this);
        try {
            File outFile = new File("logs/error_log.txt");
            outFile.getParentFile().mkdirs();
            PrintStream outStream = new PrintStream(outFile);
            System.setErr(outStream);
        }
        catch (IOException ex) {
            this.showException("Error occurred creating ouput.txt", ex);
        }
        this.progressHandler = new ProgressListener(){

            @Override
            public void finishProgress() {
            }

            @Override
            public void setProgressCurrent(int current) {
            }

            @Override
            public void startIndeterminateProgress() {
            }

            @Override
            public void startProgress(int max) {
            }

            @Override
            public void terminateProgressDisplay() {
            }

            @Override
            public void writeProgressMessage(String message) {
            }
        };
        this.exceptionHandler = new ExceptionMessageHandler(){

            @Override
            public void showException(String message, Throwable e) {
            }
        };
        this.globalHolderChangeListener = new HolderChangeListener(){

            @Override
            public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance lastRemoved, int type) {
            }

            @Override
            public void holderFilled(InstanceHolder<? extends Instance> holder, Instance lastAdded, int type) {
            }

            @Override
            public void instanceAboutToChange(Instance instance, int type) {
            }

            @Override
            public void instanceChanged(Instance instance, int type) {
            }

            @Override
            public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
            }
        };
        this.globalReplacementListener = new ReplacementListener(){

            @Override
            public Collection<Entity> removeEntities(Position Start, Position End) {
                return null;
            }

            @Override
            public void restoreEntities(Collection<Entity> entitiesToRestore, int offset) {
            }

            @Override
            public Collection<IgnorableText> removeIgnored(Position start, Position end) {
                return null;
            }

            @Override
            public void restoreIgnored(Collection<IgnorableText> ignoredToRestore, int offset) {
            }

            @Override
            public Collection<Instance> removeInstances(Position start, Position end) {
                return null;
            }

            @Override
            public void restoreInstances(Collection<Instance> instancesToRestore, int offset) {
            }
        };
        this.globalIgnorableTextListener = new IgnorableTextListener(){

            @Override
            public void ignore(IgnorableText it) {
            }

            @Override
            public void unIgnore(IgnorableText it) {
            }
        };
        this.entities = new TreeMap();
        try {
            String currentLine;
            LineNumberReader entitiesIn;
            File entitiesSource = new File("saved data/entities.txt");
            entitiesSource.getParentFile().mkdirs();
            boolean saveEntities = false;
            if (entitiesSource.exists()) {
                entitiesIn = new LineNumberReader(new InputStreamReader(new FileInputStream(entitiesSource)));
            } else {
                entitiesIn = new LineNumberReader(new InputStreamReader(Globals.class.getResourceAsStream("predef/default_entities.txt")));
                saveEntities = true;
            }
            while ((currentLine = entitiesIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                if (currentLineArray.length <= 1) continue;
                this.entities.put(currentLineArray[0], currentLineArray[1]);
            }
            entitiesIn.close();
            if (saveEntities) {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(entitiesSource)));
                for (Map.Entry<String, String> pair : this.entities.entrySet()) {
                    writer.println(String.valueOf(pair.getKey()) + "\t" + pair.getValue());
                }
                writer.close();
            }
        }
        catch (IOException ex) {
            this.showException("Error occurred reading/writing entities file", ex);
        }
        this.ignored = new ArrayList<String>();
        try {
            String currentLine;
            LineNumberReader ignoredIn;
            File ignoredSource = new File("saved data/text_to_ignore.txt");
            ignoredSource.getParentFile().mkdirs();
            boolean saveIgnored = false;
            if (ignoredSource.exists()) {
                ignoredIn = new LineNumberReader(new InputStreamReader(new FileInputStream(ignoredSource)));
            } else {
                ignoredIn = new LineNumberReader(new InputStreamReader(Globals.class.getResourceAsStream("predef/default_ignore.txt")));
                saveIgnored = true;
            }
            while ((currentLine = ignoredIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                if (currentLineArray.length <= 0) continue;
                this.ignored.add(currentLineArray[0]);
            }
            ignoredIn.close();
            if (saveIgnored) {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(ignoredSource)));
                for (String ignore : this.ignored) {
                    writer.println(ignore);
                }
                writer.close();
            }
        }
        catch (IOException ex) {
            this.showException("Error occurred reading/writing text_to_ignore file", ex);
        }
        try {
            String currentLine;
            LineNumberReader optionsIn;
            File optionsSource = new File("saved data/options.txt");
            optionsSource.getParentFile().mkdirs();
            boolean saveOptions = false;
            if (optionsSource.exists()) {
                optionsIn = new LineNumberReader(new InputStreamReader(new FileInputStream(optionsSource)));
            } else {
                optionsIn = new LineNumberReader(new InputStreamReader(Globals.class.getResourceAsStream("predef/default_options.txt")));
                saveOptions = true;
            }
            while ((currentLine = optionsIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                if (currentLineArray.length <= 1) continue;
                if (currentLineArray[0].equals("search_subfolders")) {
                    this.searchSubfolders = currentLineArray[1].equals("true");
                    continue;
                }
                if (currentLineArray[0].equals("interactive_train_from_xml")) {
                    this.trainFromXML = currentLineArray[1].equals("true");
                    continue;
                }
                if (currentLineArray[0].equals("add_new_xml_reps_to_dict")) {
                    this.addNewXMLRepsToDict = currentLineArray[1].equals("true");
                    continue;
                }
                if (currentLineArray[0].equals("word_regex")) {
                    this.wordRegex = currentLineArray[1];
                    continue;
                }
                if (!currentLineArray[0].equals("encoding")) continue;
                this.encoding = currentLineArray[1];
            }
            optionsIn.close();
            if (saveOptions) {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(optionsSource)));
                writer.println("search_subfolders\t" + (this.searchSubfolders ? "true" : "false"));
                writer.println("interactive_train_from_xml\t" + (this.trainFromXML ? "true" : "false"));
                writer.println("add_new_xml_reps_to_dict\t" + (this.addNewXMLRepsToDict ? "true" : "false"));
                writer.println("word_regex\t" + this.wordRegex);
                writer.println("encoding\t" + this.encoding);
                writer.close();
            }
        }
        catch (IOException ex) {
            this.showException("Error occurred reading/writing options file", ex);
        }
        this.progressTimer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (Globals.this.inValuedProgress) {
                    Globals.this.progressHandler.setProgressCurrent(Globals.this.currentProgress);
                }
            }
        };
        this.progressTimer.schedule(task, PROGRESS_DELAY, (long)PROGRESS_DELAY);
    }

    public static Globals getInstance() {
        if (_instance == null) {
            _instance = new Globals();
        }
        return _instance;
    }

    public static int getSoundexCodeLength() {
        return soundexCodeLength;
    }

    public static void setSoundexCodeLength(int length) throws IllegalArgumentException {
        soundexCodeLength = length;
    }

    public void setExceptionHandler(ExceptionMessageHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setProgressHandler(ProgressListener progressHandler) {
        ProgressListener previousPL = this.progressHandler;
        this.progressHandler = progressHandler;
        previousPL.finishProgress();
        previousPL.terminateProgressDisplay();
    }

    public void finalize() {
        this.progressTimer.cancel();
    }

    @Override
    public void finishProgress() {
        if (this.stopProgressMessages) {
            return;
        }
        this.inValuedProgress = false;
        this.lastProgressMax = 0;
        this.setProgressCurrent(0);
        this.writeProgressMessage("");
        if (!this.finishProgressLocked) {
            this.progressHandler.finishProgress();
        }
    }

    @Override
    public void setProgressCurrent(int current) {
        if (this.stopProgressMessages) {
            return;
        }
        this.currentProgress = current;
        if (current == 0) {
            this.progressHandler.setProgressCurrent(current);
        }
    }

    @Override
    public void startIndeterminateProgress() {
        if (this.stopProgressMessages) {
            return;
        }
        this.progressHandler.startIndeterminateProgress();
    }

    @Override
    public void startProgress(int max) {
        if (this.stopProgressMessages) {
            return;
        }
        this.inValuedProgress = true;
        this.setProgressCurrent(0);
        this.lastProgressMax = max;
        this.progressHandler.startProgress(max);
    }

    @Override
    public void terminateProgressDisplay() {
        this.finishProgress();
        this.progressHandler.terminateProgressDisplay();
    }

    @Override
    public void writeProgressMessage(String message) {
        if (this.stopProgressMessages) {
            return;
        }
        if (message.length() == 0) {
            this.lastProgressMessage = String.valueOf(this.lastProgressMessage) + " (cleared)";
            this.progressHandler.writeProgressMessage("");
        } else {
            this.lastProgressMessage = String.valueOf(this.progressMessagePrefix) + " " + message;
            this.progressHandler.writeProgressMessage(this.lastProgressMessage);
        }
    }

    @Override
    public void showException(String message, Throwable e) {
        System.err.println();
        System.err.println();
        System.err.println("Exception Occurred.");
        System.err.println();
        if (this.lastProgressMessage != "") {
            // empty if block
        }
        System.err.println("Last progress message: " + this.lastProgressMessage);
        if (this.lastProgressMax != 0) {
            System.err.println("Progress: " + this.currentProgress + "/" + this.lastProgressMax);
        }
        System.err.println();
        System.err.println("Exception message:");
        System.err.println(message);
        System.err.println();
        e.printStackTrace();
        this.exceptionHandler.showException(message, e);
    }

    public void setProgressMessagePrefix(String progressMessagePrefix) {
        this.progressMessagePrefix = progressMessagePrefix;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.showException("Uncaught Exception occurred in thread " + t.getName(), e);
    }

    public void stopProgressMessages() {
        this.stopProgressMessages = true;
        ++this.stopCount;
    }

    public void resumeProgressMessages() {
        ++this.resumeCount;
        if (this.resumeCount == this.stopCount) {
            this.stopProgressMessages = false;
        }
    }

    public void lockFinishProgress() {
        this.finishProgressLocked = true;
        ++lockCount;
    }

    public void unlockFinishProgress() {
        if (++keyCount == lockCount) {
            this.finishProgressLocked = false;
        }
    }

    public HolderChangeListener getGlobalHolderChangeListener() {
        return this.globalHolderChangeListener;
    }

    public void setGlobalHolderChangeListener(HolderChangeListener globalHolderChangeListener) {
        this.globalHolderChangeListener = globalHolderChangeListener;
    }

    public IgnorableTextListener getGlobalIgnorableTextListener() {
        return this.globalIgnorableTextListener;
    }

    public void setGlobalIgnorableTextListener(IgnorableTextListener globalIgnorableTextListener) {
        this.globalIgnorableTextListener = globalIgnorableTextListener;
    }

    public ReplacementListener getGlobalReplacementListener() {
        return this.globalReplacementListener;
    }

    public void setGlobalReplacementListener(ReplacementListener globalReplacementListener) {
        this.globalReplacementListener = globalReplacementListener;
    }

    public Collection<String> getIgnored() {
        return this.ignored;
    }

    public TreeMap<String, String> getEntities() {
        return this.entities;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

