/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import model.ExceptionMessageHandler;
import model.Globals;
import model.ProgressListener;
import model.doc.DocumentModel;

public class TrainingScreen
implements ActionListener,
ProgressListener,
ExceptionMessageHandler {
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private JButton[] buttons = new JButton[]{new JButton("Add file(s)"), new JButton("Add folder(s)"), new JButton("Remove selected file(s)"), new JButton("Clear list"), new JButton("Process listed file(s)"), new JButton("Exit")};
    private JList fileList;
    private TreeSet<File> files = new TreeSet();
    private JScrollPane fileListSP;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JFileChooser fc;
    private JFrame frame;
    private static Globals global;
    private static DocumentModel docModel;

    public static void run() {
        global = Globals.getInstance();
        new Thread(){

            @Override
            public void run() {
                global.startIndeterminateProgress();
                global.writeProgressMessage("Loading user interface...");
                TrainingScreen ui = new TrainingScreen(null);
                global.finishProgress();
                global.setProgressHandler(ui);
                global.setExceptionHandler(ui);
                docModel = DocumentModel.getInstance();
            }
        }.start();
    }

    private TrainingScreen() {
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(10);
        this.fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.fileListSP.setAlignmentX(0.0f);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            ++n2;
        }
        JPanel inputButtonsPanel = new JPanel(new GridLayout(6, 1));
        int i = 0;
        while (i < 4) {
            inputButtonsPanel.add(this.buttons[i]);
            ++i;
        }
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        inputPanel.add((Component)this.fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        JPanel bottomButtons = new JPanel(new GridLayout(1, 2));
        bottomButtons.add(this.buttons[4]);
        bottomButtons.add(this.buttons[5]);
        this.progressLabel = new JLabel("");
        this.progressBar = new JProgressBar(0);
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        progressPanel.add(this.progressLabel);
        progressPanel.add(this.progressBar);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)inputPanel, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)progressPanel, "Center");
        bottomPanel.add((Component)bottomButtons, "South");
        this.fc = new JFileChooser();
        this.frame = new JFrame("VARD 2 Training");
        this.frame.getContentPane().add((Component)topPanel, "Center");
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setLocation(TrainingScreen.SCREEN_SIZE.width / 2 - this.frame.getWidth() / 2, TrainingScreen.SCREEN_SIZE.height / 2 - this.frame.getHeight() / 2);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        int buttonNumber = -1;
        int i = 0;
        while (i < this.buttons.length) {
            if (a.getSource().equals(this.buttons[i])) {
                buttonNumber = i;
            }
            ++i;
        }
        switch (buttonNumber) {
            case 0: {
                this.fc.setFileSelectionMode(0);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal = this.fc.showOpenDialog(this.frame);
                if (returnVal != 0) break;
                new Thread(){

                    @Override
                    public void run() {
                        File[] filesSelected = TrainingScreen.this.fc.getSelectedFiles();
                        global.startProgress(filesSelected.length);
                        global.writeProgressMessage("Adding files...");
                        int count = 0;
                        File[] fileArray = filesSelected;
                        int n = filesSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            TrainingScreen.this.files.add(file);
                            global.setProgressCurrent(++count);
                            ++n2;
                        }
                        TrainingScreen.this.fileList.setListData(TrainingScreen.this.files.toArray());
                        global.finishProgress();
                    }
                }.start();
                break;
            }
            case 1: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal2 = this.fc.showOpenDialog(this.frame);
                if (returnVal2 != 0) break;
                new Thread(){

                    @Override
                    public void run() {
                        global.startIndeterminateProgress();
                        File[] foldersSelected = TrainingScreen.this.fc.getSelectedFiles();
                        int totalFolders = foldersSelected.length;
                        int folderCount = 0;
                        File[] fileArray = foldersSelected;
                        int n = foldersSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File folder = fileArray[n2];
                            if (global.isSearchSubfolders()) {
                                TrainingScreen.walkFolder(TrainingScreen.this.files, folder);
                            } else {
                                File[] filesFromFolder = folder.listFiles();
                                global.startProgress(filesFromFolder.length);
                                global.writeProgressMessage("Adding files from " + folder.getName() + "(" + ++folderCount + "/" + totalFolders + ")...");
                                int fileCount = 0;
                                File[] fileArray2 = filesFromFolder;
                                int n3 = filesFromFolder.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file = fileArray2[n4];
                                    if (!(file.isDirectory() || file.isHidden() || TrainingScreen.this.files.contains(file))) {
                                        TrainingScreen.this.files.add(file);
                                    }
                                    global.setProgressCurrent(++fileCount);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        TrainingScreen.this.fileList.setListData(TrainingScreen.this.files.toArray());
                        global.finishProgress();
                    }
                }.start();
                break;
            }
            case 2: {
                Object[] objectArray = this.fileList.getSelectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    this.files.remove(file);
                    ++n2;
                }
                this.fileList.setListData(this.files.toArray());
                break;
            }
            case 3: {
                this.files.clear();
                this.fileList.setListData(this.files.toArray());
                break;
            }
            case 4: {
                if (this.files.size() == 0) {
                    this.displayError("Please provide atleast one file to process.");
                    return;
                }
                new Thread(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }.start();
                break;
            }
            case 5: {
                System.exit(0);
            }
        }
    }

    private void setButtonsEnabled(boolean e) {
        this.buttons[0].setEnabled(e);
        this.buttons[1].setEnabled(e);
        this.buttons[2].setEnabled(e);
        this.buttons[3].setEnabled(e);
        this.buttons[4].setEnabled(e);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.progressLabel.setText(message);
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(MainScreen.frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    public void displayError(String message) {
        JOptionPane.showMessageDialog(MainScreen.frame, message, "Error", 0);
    }

    public String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    @Override
    public void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrainingScreen.this.progressBar.setIndeterminate(false);
                TrainingScreen.this.setButtonsEnabled(true);
            }
        });
    }

    @Override
    public void setProgressCurrent(final int current) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrainingScreen.this.progressBar.setValue(current);
            }
        });
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrainingScreen.this.progressBar.setIndeterminate(true);
                TrainingScreen.this.setButtonsEnabled(false);
            }
        });
    }

    @Override
    public void startProgress(final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TrainingScreen.this.progressBar.setIndeterminate(false);
                TrainingScreen.this.progressBar.setMaximum(max);
                TrainingScreen.this.setButtonsEnabled(false);
            }
        });
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                TrainingScreen.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    /* synthetic */ TrainingScreen(TrainingScreen trainingScreen) {
        this();
    }

    static /* synthetic */ DocumentModel access$7() {
        return docModel;
    }
}

