/*
 * Decompiled with CFR 0.152.
 */
package gui;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.Globals;
import model.doc.CannotExecuteException;
import model.doc.ThreadableEdit;

class ThreadedProcessEditHolder
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private ThreadableEdit edit;
    private boolean executed = false;
    private boolean undone = false;
    Globals global = Globals.getInstance();

    ThreadedProcessEditHolder(ThreadableEdit edit) {
        this.edit = edit;
    }

    public void execute() {
        this.executed = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadedProcessEditHolder.this.global.lockFinishProgress();
                    ThreadedProcessEditHolder.this.global.startIndeterminateProgress();
                    ThreadedProcessEditHolder.this.global.writeProgressMessage("Executing");
                    ThreadedProcessEditHolder.this.edit.execute();
                    ThreadedProcessEditHolder.this.global.unlockFinishProgress();
                    ThreadedProcessEditHolder.this.global.finishProgress();
                }
                catch (CannotExecuteException ex) {
                    ThreadedProcessEditHolder.this.executed = false;
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst replacing variants", ex);
                }
            }
        }).start();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.undone = true;
        new Thread(){

            @Override
            public void run() {
                try {
                    ThreadedProcessEditHolder.this.global.lockFinishProgress();
                    ThreadedProcessEditHolder.this.global.startIndeterminateProgress();
                    ThreadedProcessEditHolder.this.global.writeProgressMessage("Undoing");
                    ThreadedProcessEditHolder.this.edit.undo();
                    ThreadedProcessEditHolder.this.global.unlockFinishProgress();
                    ThreadedProcessEditHolder.this.global.finishProgress();
                }
                catch (CannotUndoException ex) {
                    ThreadedProcessEditHolder.this.undone = false;
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst undoing replacing variants", ex);
                }
            }
        }.start();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.undone = false;
        new Thread(){

            @Override
            public void run() {
                try {
                    ThreadedProcessEditHolder.this.global.lockFinishProgress();
                    ThreadedProcessEditHolder.this.global.startIndeterminateProgress();
                    ThreadedProcessEditHolder.this.global.writeProgressMessage("Executing");
                    ThreadedProcessEditHolder.this.edit.redo();
                    ThreadedProcessEditHolder.this.global.unlockFinishProgress();
                    ThreadedProcessEditHolder.this.global.finishProgress();
                }
                catch (CannotRedoException ex) {
                    ThreadedProcessEditHolder.this.undone = true;
                    ThreadedProcessEditHolder.this.global.showException("Error occurred whilst redoing replacing variants", ex);
                }
            }
        }.start();
    }

    @Override
    public String getPresentationName() {
        return this.edit.getPresentationName();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }
}

