/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplaceFInstanceEdit;
import model.doc.VariantInstance;

class ReplaceFInstanceAction<F extends VariantInstance>
extends AbstractAction {
    private static final long serialVersionUID = -7964139713034760680L;
    ReplaceFInstanceEdit<F> edit;
    SuggestedReplacement rep;
    int fromType;

    ReplaceFInstanceAction(F fi, SuggestedReplacement rep, StyledDocument doc) {
        this.rep = rep;
        this.fromType = ((VariantInstance)fi).getType();
        try {
            this.edit = new ReplaceFInstanceEdit<F>(fi, rep, doc, true, false, true);
            this.putValue("Name", this.edit.getActionName());
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred in replacing instance prep.", ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            this.edit.execute();
            MainScreen.undoSupport.postEdit(this.edit);
        }
        catch (InvalidInstanceChangeException ex) {
            Globals.getInstance().showException("Error occurred replacing instance.", ex);
        }
        catch (BadLocationException ex) {
            Globals.getInstance().showException("Error occurred replacing instance in text", ex);
        }
    }
}

