/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import model.Globals;

public class WordUtilities {
    public static final int EMPTY = 66;
    public static final int ALL_CAPITALS = 51;
    public static final int NO_CAPITALS = 52;
    public static final int FIRST_CAPITAL = 53;

    public static int getCapitalization(String word) {
        if (word == null || word.equals("")) {
            return 66;
        }
        if (word.length() == 1) {
            if (Character.isUpperCase(word.charAt(0))) {
                return 53;
            }
            return 52;
        }
        int capitalization = 51;
        int i = 0;
        while (i < word.length()) {
            if (Character.isLowerCase(word.charAt(i))) {
                capitalization = 52;
            }
            ++i;
        }
        char firstLetter = word.charAt(0);
        if (firstLetter == '\'') {
            firstLetter = word.charAt(1);
        }
        if (capitalization == 52 && Character.isUpperCase(firstLetter)) {
            return 53;
        }
        return capitalization;
    }

    public static String capitalize(String w, int capitalization) {
        if (w == null || w.equals("")) {
            return w;
        }
        String word = new String(w);
        if (capitalization == 51) {
            return word.toUpperCase();
        }
        if (capitalization == 52) {
            return word.toLowerCase();
        }
        if (capitalization == 53) {
            return String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1);
        }
        return word;
    }

    public static String getSoundexCode(String word) {
        if (word == null) {
            return "";
        }
        int soundexLength = Globals.getSoundexCodeLength();
        String UCWord = new String(word).toUpperCase();
        if (UCWord.length() == 1) {
            String code = String.valueOf(UCWord.charAt(0));
            int i = 0;
            while (i < soundexLength - 1) {
                code = String.valueOf(code) + "0";
                ++i;
            }
            return code;
        }
        String toConvert = "";
        int wordLength = UCWord.length();
        int i = 0;
        while (i < wordLength) {
            char currentChar = UCWord.charAt(i);
            if (Character.isLetter(currentChar)) {
                toConvert = String.valueOf(toConvert) + currentChar;
            }
            ++i;
        }
        toConvert.toUpperCase();
        toConvert = toConvert.replaceAll("DG", "G");
        toConvert = toConvert.replaceAll("GH", "H");
        toConvert = toConvert.replaceAll("GN", "N");
        toConvert = toConvert.replaceAll("KN", "N");
        toConvert = toConvert.replaceAll("PH", "F");
        toConvert = toConvert.replaceAll("MB", "M");
        toConvert = toConvert.replaceAll("TCH", "CH");
        if (toConvert.startsWith("PS") || toConvert.startsWith("PF") || toConvert.startsWith("H")) {
            toConvert = toConvert.substring(1);
        }
        if (toConvert.equals("")) {
            return "";
        }
        String code = toConvert.substring(0, 1);
        if (code.equals("E") || code.equals("I") || code.equals("O") || code.equals("U")) {
            code = "A";
        }
        toConvert = toConvert.substring(1);
        int i2 = 0;
        while (i2 < soundexLength - 1) {
            toConvert = String.valueOf(toConvert) + "0";
            ++i2;
        }
        char[] chars = toConvert.toCharArray();
        int i3 = 0;
        while (i3 < chars.length) {
            if (chars[i3] == 'A' || chars[i3] == 'E' || chars[i3] == 'I' || chars[i3] == 'O' || chars[i3] == 'U' || chars[i3] == 'H' || chars[i3] == 'W' || chars[i3] == 'Y') {
                chars[i3] = 48;
            } else if (chars[i3] == 'B' || chars[i3] == 'F' || chars[i3] == 'P' || chars[i3] == 'V') {
                chars[i3] = 49;
            } else if (chars[i3] == 'C' || chars[i3] == 'G' || chars[i3] == 'J' || chars[i3] == 'K' || chars[i3] == 'Q' || chars[i3] == 'S' || chars[i3] == 'X' || chars[i3] == 'Z') {
                chars[i3] = 50;
            } else if (chars[i3] == 'D' || chars[i3] == 'T') {
                chars[i3] = 51;
            } else if (chars[i3] == 'L') {
                chars[i3] = 52;
            } else if (chars[i3] == 'M' || chars[i3] == 'N') {
                chars[i3] = 53;
            } else if (chars[i3] == 'R') {
                chars[i3] = 54;
            }
            ++i3;
        }
        code = String.valueOf(code) + chars[0];
        i3 = 1;
        while (i3 < chars.length) {
            if (chars[i3] != chars[i3 - 1]) {
                code = String.valueOf(code) + chars[i3];
            }
            ++i3;
        }
        code = code.replaceAll("0", "");
        i3 = 0;
        while (i3 < soundexLength - 1) {
            code = String.valueOf(code) + "0";
            ++i3;
        }
        return code.substring(0, soundexLength);
    }

    public static int getEditDistance(String word1, String word2) {
        char[] s = new String(word1).toUpperCase().toCharArray();
        char[] t = new String(word2).toUpperCase().toCharArray();
        int sLength = s.length;
        int tLength = t.length;
        if (sLength == 0) {
            return tLength;
        }
        if (tLength == 0) {
            return sLength;
        }
        int[][] matrix = new int[sLength + 1][tLength + 1];
        int i = 0;
        while (i < sLength + 1) {
            matrix[i][0] = i;
            ++i;
        }
        i = 1;
        while (i < tLength + 1) {
            matrix[0][i] = i;
            ++i;
        }
        int i2 = 0;
        while (i2 < sLength) {
            int j = 0;
            while (j < tLength) {
                int currentCost = s[i2] == t[j] ? 0 : 1;
                int aValue = matrix[i2][j + 1] + 1;
                int bValue = matrix[i2 + 1][j] + 1;
                int cValue = matrix[i2][j] + currentCost;
                int chosenValue = aValue;
                if (bValue < chosenValue) {
                    chosenValue = bValue;
                }
                if (cValue < chosenValue) {
                    chosenValue = cValue;
                }
                matrix[i2 + 1][j + 1] = chosenValue;
                ++j;
            }
            ++i2;
        }
        return matrix[sLength][tLength];
    }

    public static boolean isLikelyReplacement(String original, String rep, int editDistance) {
        return !original.equals(rep);
    }

    public static boolean isValidWord(String word) {
        if (word.length() < 1) {
            return false;
        }
        int i = 0;
        while (i < word.length()) {
            if (!WordUtilities.isValidCharacter(word.charAt(i))) {
                return false;
            }
            ++i;
        }
        return !word.contains("--");
    }

    public static boolean isLetter(char letter) {
        if (letter == '\'' || letter == '\u00ed' || letter == '\u00eb') {
            return true;
        }
        return Character.isLetter(letter);
    }

    public static boolean isValidCharacter(char letter) {
        if (letter == ' ' || letter == '-') {
            return true;
        }
        return WordUtilities.isLetter(letter);
    }
}

