/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Comparator;
import model.lookup.Node;
import model.lookup.WordUtilities;

public class Word
extends Node
implements Comparable<Word> {
    private static final long serialVersionUID = -8257792226836584638L;
    private static final int LOW_FREQ = 10;
    private String word;
    private String soundexCode;
    private int wordLength;
    private char[] letters = new char[3];
    static int num = 0;
    public int thisNum;
    private int freq;
    boolean userAdded;
    boolean real;
    boolean lowFreq;

    public Word(String w, Node node, boolean userAdded, boolean real, int freq) {
        super(Character.valueOf(w.charAt(w.length() - 1)));
        if (node != null) {
            this.next = node.next;
        }
        this.word = w.toLowerCase().trim();
        this.wordLength = this.word.length();
        this.soundexCode = WordUtilities.getSoundexCode(this.word);
        int i = 0;
        while (i < 3) {
            this.letters[i] = this.wordLength < i + 1 ? 126 : this.word.charAt(i);
            ++i;
        }
        this.thisNum = num++;
        this.userAdded = userAdded;
        this.real = real;
        this.freq = freq;
        this.lowFreq = freq < 10;
    }

    public void writeToFile(PrintWriter writer) {
        writer.println(String.valueOf(this.word) + "\t" + this.freq + (this.userAdded ? "\t#" : ""));
    }

    public String toString() {
        return this.word;
    }

    @Override
    boolean isWord() {
        return true;
    }

    public String getSoundexCode() {
        return this.soundexCode;
    }

    public char getChar(int i) {
        return this.letters[i];
    }

    @Override
    public int compareTo(Word w) {
        return this.toString().compareToIgnoreCase(w.toString());
    }

    public boolean equals(Word w) {
        return this.toString().equalsIgnoreCase(w.toString());
    }

    public boolean equals(String s) {
        return this.toString().equalsIgnoreCase(s);
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    public boolean isReal() {
        return this.real;
    }

    public static int getNum() {
        return num;
    }

    public static void setNum(int num) {
        Word.num = num;
    }

    public char[] getLetters() {
        return this.letters;
    }

    public void setLetters(char[] letters) {
        this.letters = letters;
    }

    public int getThisNum() {
        return this.thisNum;
    }

    public void setThisNum(int thisNum) {
        this.thisNum = thisNum;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    public void setWordLength(int wordLength) {
        this.wordLength = wordLength;
    }

    public void setReal(boolean real) {
        this.real = real;
    }

    public void setSoundexCode(String soundexCode) {
        this.soundexCode = soundexCode;
    }

    public void setUserAdded(boolean userAdded) {
        this.userAdded = userAdded;
    }

    public int getFreq() {
        return this.freq;
    }

    public boolean isLowFreq() {
        return this.lowFreq;
    }

    public void setFreq(int freq) {
        this.freq = freq;
        this.lowFreq = freq < 10;
    }

    static void readFile(File file, WordAction todo) throws IOException {
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-16"));
        String currentLine = "file not ready";
        while ((currentLine = textIn.readLine()) != null) {
            String[] currentLineArray = currentLine.split("\t");
            todo.process(currentLineArray[0], Integer.parseInt(currentLineArray[1]), currentLineArray.length > 2 && currentLineArray[2].equals("#"));
        }
        textIn.close();
    }

    public static class SoundexComparator
    implements Comparator<Word> {
        @Override
        public int compare(Word w1, Word w2) {
            return w1.getSoundexCode().compareTo(w2.getSoundexCode());
        }
    }

    static interface WordAction {
        public void process(String var1, int var2, boolean var3);
    }
}

