/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import model.doc.DocumentElement;

public class Entity
extends DocumentElement {
    private String replacement;
    private boolean isReplaced;
    private AttributeSet atts;

    public Entity(Position start, String original) {
        super(start, original);
        this.isReplaced = false;
    }

    public Entity(Position start, String original, String replacement) {
        super(start, original);
        this.replacement = replacement;
        this.isReplaced = true;
    }

    public void revertInText(StyledDocument doc) throws BadLocationException {
        if (this.isReplaced) {
            int startInt = this.start.getOffset();
            this.atts = doc.getCharacterElement(startInt).getAttributes();
            doc.remove(startInt, this.replacement.length());
            doc.insertString(startInt, this.original, this.atts);
            this.start = doc.createPosition(startInt);
        }
    }

    public void reReplaceInText(StyledDocument doc) throws BadLocationException {
        if (this.isReplaced) {
            int startInt = this.start.getOffset();
            doc.remove(startInt, this.original.length());
            doc.insertString(startInt, this.replacement, this.atts);
            this.start = doc.createPosition(startInt);
            this.atts = null;
        }
    }

    @Override
    public String toString() {
        String toReturn = super.toString();
        if (this.isReplaced) {
            toReturn = String.valueOf(toReturn) + " -> " + this.replacement;
        }
        return toReturn;
    }

    @Override
    public String getDisplayString() {
        if (this.isReplaced) {
            return this.replacement;
        }
        return this.original;
    }

    public boolean isReplaced() {
        return this.isReplaced;
    }

    public String getReplacement() {
        return this.replacement;
    }
}

