/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.Comparator;
import model.ConfidenceWeights;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class SuggestedReplacement
implements Comparable<SuggestedReplacement> {
    private static final long serialVersionUID = -1487581641966172547L;
    private Word replacement;
    private String oldWord;
    private String replacementString;
    private boolean isKnownVariant;
    private boolean isLetterReplacement;
    private boolean isSoundex;
    private boolean isUserAdded;
    private int editDistance;
    private double score = 0.0;
    private int capitalization;
    private ConfidenceWeights confidenceWeights;

    public SuggestedReplacement() {
    }

    public SuggestedReplacement(Word replacement, String oldWord, ConfidenceWeights rs) {
        this.replacement = replacement;
        this.oldWord = oldWord;
        this.confidenceWeights = rs;
        this.editDistance = WordUtilities.getEditDistance(replacement.toString(), oldWord);
        this.setCapitalization(WordUtilities.getCapitalization(oldWord));
    }

    @Override
    public int compareTo(SuggestedReplacement sr) {
        this.reCalculateScore();
        int r = Double.valueOf(sr.getScore()).compareTo(this.score);
        if (r == 0) {
            return new Integer(sr.getReplacement().getFreq()).compareTo(this.replacement.getFreq());
        }
        return r;
    }

    public boolean equals(SuggestedReplacement sr) {
        if (this.replacementString.equalsIgnoreCase(sr.getReplacementString())) {
            return this.oldWord.equalsIgnoreCase(sr.getOldWord());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof SuggestedReplacement) {
            return this.equals((SuggestedReplacement)object);
        }
        return false;
    }

    public Word getReplacement() {
        return this.replacement;
    }

    public String getOldWord() {
        return this.oldWord;
    }

    public boolean isKnownVariant() {
        return this.isKnownVariant;
    }

    public boolean isUserAdded() {
        return this.isUserAdded;
    }

    public boolean isLetterReplacement() {
        return this.isLetterReplacement;
    }

    public boolean isSoundex() {
        return this.isSoundex;
    }

    public boolean isInDictionary() {
        return this.replacement.isReal();
    }

    public boolean isReplacementUserAdded() {
        return this.replacement.isUserAdded();
    }

    public int getEditDistance() {
        return this.editDistance;
    }

    public double getScoreWithoutUpdating() {
        return this.score;
    }

    public double getScore() {
        this.reCalculateScore();
        return this.score;
    }

    public void reCalculateScore() {
        this.score = this.confidenceWeights.calculateScoreOfReplacement(this);
    }

    public void setSoundex(String soundexCode) {
        this.isSoundex = soundexCode.equals(this.replacement.getSoundexCode());
    }

    public void setSoundex(boolean isSoundex) {
        this.isSoundex = isSoundex;
    }

    public void setLetterReplacement(boolean lr) {
        this.isLetterReplacement = lr;
    }

    public void setKnownVariant(boolean kv, boolean ua) {
        this.isKnownVariant = kv;
        this.isUserAdded = ua;
    }

    public String toMenuString(int capitalization) {
        String scoreString = Double.toString(this.getScore());
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        this.setCapitalization(capitalization);
        return String.valueOf(this.replacementString) + " (" + scoreString + "%)";
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setCapitalization(int c) {
        this.capitalization = c;
        this.replacementString = WordUtilities.capitalize(this.replacement.toString(), this.capitalization);
    }

    public ConfidenceWeights getRatingScores() {
        return this.confidenceWeights;
    }

    public void setRatingScores(ConfidenceWeights confidenceWeights) {
        this.confidenceWeights = confidenceWeights;
    }

    public int getCapitalization() {
        return this.capitalization;
    }

    public void setEditDistance(int editDistance) {
        this.editDistance = editDistance;
    }

    public void setKnownVariant(boolean isKnownVariant) {
        this.isKnownVariant = isKnownVariant;
    }

    public void setUserAdded(boolean isUserAdded) {
        this.isUserAdded = isUserAdded;
    }

    public void setOldWord(String oldWord) {
        this.oldWord = oldWord;
    }

    public void setReplacement(Word replacement) {
        this.replacement = replacement;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public static class AlphaComparator
    implements Comparator<SuggestedReplacement> {
        @Override
        public int compare(SuggestedReplacement sr1, SuggestedReplacement sr2) {
            int c = sr1.getOldWord().compareToIgnoreCase(sr2.getOldWord());
            if (c == 0) {
                return sr1.getReplacementString().compareToIgnoreCase(sr2.getReplacementString());
            }
            return c;
        }
    }
}

