/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.ReplacedInstance;

public class ConfidenceWeights
implements HolderChangeListener {
    private static final long serialVersionUID = 1574820836410213387L;
    public static final int MAX_TOTAL = 100;
    public static final int MIN_TOTAL = 0;
    public static final int SUGGESTED_TOTAL = 50;
    public double KV_SCORE = 55.0;
    public double LR_SCORE = 22.5;
    public double SE_SCORE = 22.5;
    private static final double SCORE_MAX = 80.0;
    private static final double SCORE_MIN = 10.0;
    private static final double SCORE_CHANGE = 0.2;
    public double ED_REDUCTION = 2.0;
    private static final boolean DEFAULT_UPDATE = true;
    private static transient boolean hasChanged = false;
    private transient boolean update = true;
    private static transient Vector<ChangeListener> changeListeners = new Vector();
    private static ConfidenceWeights _instance = null;
    private static transient Globals global;

    protected ConfidenceWeights() {
        global = Globals.getInstance();
        File conf = new File("saved data/weights.txt");
        conf.getParentFile().mkdirs();
        try {
            if (conf.exists()) {
                this.loadWeights(conf);
            } else {
                this.save();
            }
        }
        catch (FileNotFoundException e) {
            global.showException("weights.txt not found when should exist, please reinstall if error persists", e);
        }
        catch (IOException e) {
            global.showException("Error reading weights.txt, please reinstall if error persists", e);
        }
        catch (NumberFormatException ex) {
            global.showException("Weights in weights.txt must be decimal values.", ex);
        }
    }

    public static ConfidenceWeights getInstance() {
        if (_instance == null) {
            _instance = new ConfidenceWeights();
        }
        return _instance;
    }

    public void loadWeights(File conf) throws IOException, NumberFormatException {
        LineNumberReader textIn = new LineNumberReader(new FileReader(conf));
        String currentLine = "file not ready";
        try {
            while ((currentLine = textIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                if (currentLineArray[0].contains("Known Variants List")) {
                    this.KV_SCORE = Double.parseDouble(currentLineArray[1].trim());
                    continue;
                }
                if (currentLineArray[0].contains("Letter Replacement Rules")) {
                    this.LR_SCORE = Double.parseDouble(currentLineArray[1].trim());
                    continue;
                }
                if (!currentLineArray[0].contains("Phonetic Matching")) continue;
                this.SE_SCORE = Double.parseDouble(currentLineArray[1].trim());
            }
        }
        finally {
            textIn.close();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        changeListeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        changeListeners.remove(cl);
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean newUpdate) {
        this.update = newUpdate;
    }

    public void setUpdateToDefault() {
        this.update = true;
    }

    public String getKnownVariantString() {
        String scoreString = Double.toString(Math.rint(this.KV_SCORE * 10.0) / 10.0);
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return "Known Variant List (" + scoreString + "%)";
    }

    public String getLetterReplacementString() {
        String scoreString = Double.toString(Math.rint(this.LR_SCORE * 10.0) / 10.0);
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return "Letter Replacement Rules (" + scoreString + "%)";
    }

    public String getSoundexString() {
        String scoreString = Double.toString(Math.rint(this.SE_SCORE * 10.0) / 10.0);
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return "Phonetic Matching (" + scoreString + "%)";
    }

    public String getEditDistanceString(SuggestedReplacement sr) {
        String scoreString = Double.toString(Math.rint((double)sr.getEditDistance() * this.ED_REDUCTION * -10.0) / 10.0);
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return "Edit Distance is " + sr.getEditDistance() + " (" + scoreString + "%)";
    }

    public String getNotInDictString(SuggestedReplacement sr) {
        String scoreString = Double.toString(Math.rint(sr.getScore() / 2.0 * -10.0) / 10.0);
        if (scoreString.endsWith(".0")) {
            scoreString = scoreString.substring(0, scoreString.length() - 2);
        }
        return "Not in dictionary (" + scoreString + "%)";
    }

    private ScoreAdjustment adjustValuesForReplacementSelected(SuggestedReplacement sr) {
        double startKV = this.KV_SCORE;
        double startLR = this.LR_SCORE;
        double startSE = this.SE_SCORE;
        boolean kv = sr.isKnownVariant();
        boolean lr = sr.isLetterReplacement();
        boolean se = sr.isSoundex();
        int amountOfTypes = 0;
        if (kv) {
            ++amountOfTypes;
        }
        if (lr) {
            ++amountOfTypes;
        }
        if (se) {
            ++amountOfTypes;
        }
        switch (amountOfTypes) {
            case 0: {
                break;
            }
            case 1: {
                if (kv && this.KV_SCORE >= 80.0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                if (lr && this.LR_SCORE >= 80.0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                if (se && this.SE_SCORE >= 80.0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                int decreased = 0;
                if (!kv && this.KV_SCORE > 10.0) {
                    this.KV_SCORE -= 0.2;
                    ++decreased;
                }
                if (!lr && this.LR_SCORE > 10.0) {
                    this.LR_SCORE -= 0.2;
                    ++decreased;
                }
                if (!se && this.SE_SCORE > 10.0) {
                    this.SE_SCORE -= 0.2;
                    ++decreased;
                }
                if (decreased == 0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                if (kv) {
                    this.KV_SCORE += 0.2;
                    if (decreased == 2) {
                        this.KV_SCORE += 0.2;
                    }
                }
                if (lr) {
                    this.LR_SCORE += 0.2;
                    if (decreased == 2) {
                        this.LR_SCORE += 0.2;
                    }
                }
                if (se) {
                    this.SE_SCORE += 0.2;
                    if (decreased == 2) {
                        this.SE_SCORE += 0.2;
                    }
                }
                this.KV_SCORE = Math.rint(this.KV_SCORE * 10.0) / 10.0;
                this.LR_SCORE = Math.rint(this.LR_SCORE * 10.0) / 10.0;
                this.SE_SCORE = Math.rint(this.SE_SCORE * 10.0) / 10.0;
                this.setHasChanged(true);
                break;
            }
            case 2: {
                if (!kv && this.KV_SCORE <= 10.0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                if (!lr && this.LR_SCORE <= 10.0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                if (!se && this.SE_SCORE <= 10.0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                int increased = 0;
                if (kv && this.KV_SCORE < 80.0) {
                    this.KV_SCORE += 0.2;
                    ++increased;
                }
                if (lr && this.LR_SCORE < 80.0) {
                    this.LR_SCORE += 0.2;
                    ++increased;
                }
                if (se && this.SE_SCORE < 80.0) {
                    this.SE_SCORE += 0.2;
                    ++increased;
                }
                if (increased == 0) {
                    return new ScoreAdjustment(0.0, 0.0, 0.0);
                }
                if (!kv) {
                    this.KV_SCORE -= 0.2;
                    if (increased == 2) {
                        this.KV_SCORE -= 0.2;
                    }
                }
                if (!lr) {
                    this.LR_SCORE -= 0.2;
                    if (increased == 2) {
                        this.LR_SCORE -= 0.2;
                    }
                }
                if (!se) {
                    this.SE_SCORE -= 0.2;
                    if (increased == 2) {
                        this.SE_SCORE -= 0.2;
                    }
                }
                this.KV_SCORE = Math.rint(this.KV_SCORE * 10.0) / 10.0;
                this.LR_SCORE = Math.rint(this.LR_SCORE * 10.0) / 10.0;
                this.SE_SCORE = Math.rint(this.SE_SCORE * 10.0) / 10.0;
                this.setHasChanged(true);
                break;
            }
            default: {
                return new ScoreAdjustment(0.0, 0.0, 0.0);
            }
        }
        if (hasChanged) {
            return new ScoreAdjustment(this.KV_SCORE - startKV, this.LR_SCORE - startLR, this.SE_SCORE - startSE);
        }
        return new ScoreAdjustment(0.0, 0.0, 0.0);
    }

    private void adjustValuesForScoreAdjustmentCancelled(ScoreAdjustment sa) {
        this.KV_SCORE -= sa.kvChange;
        this.LR_SCORE -= sa.lrChange;
        this.SE_SCORE -= sa.seChange;
        this.KV_SCORE = Math.rint(this.KV_SCORE * 10.0) / 10.0;
        this.LR_SCORE = Math.rint(this.LR_SCORE * 10.0) / 10.0;
        this.SE_SCORE = Math.rint(this.SE_SCORE * 10.0) / 10.0;
    }

    public double calculateScoreOfReplacement(SuggestedReplacement sr) {
        double score = 0.0;
        if (sr.isKnownVariant()) {
            score += this.KV_SCORE;
        }
        if (sr.isLetterReplacement()) {
            score += this.LR_SCORE;
        }
        if (sr.isSoundex()) {
            score += this.SE_SCORE;
        }
        int i = 0;
        while (i < sr.getEditDistance()) {
            score -= this.ED_REDUCTION;
            ++i;
        }
        score = Math.rint(score * 10.0) / 10.0;
        if (!sr.isInDictionary()) {
            score /= 2.0;
        }
        return Math.min(Math.max(score, 0.0), 100.0);
    }

    public static boolean hasChanged() {
        return hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        ConfidenceWeights.hasChanged = hasChanged;
        for (ChangeListener cl : changeListeners) {
            cl.changeUpdate(hasChanged);
        }
    }

    public void save() throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream("saved data/weights.txt")));
        try {
            writer.println("Known Variants List:\t" + this.KV_SCORE);
            writer.println("Letter Replacement Rules:\t" + this.LR_SCORE);
            writer.println("Phonetic Matching:\t" + this.SE_SCORE);
            this.setHasChanged(false);
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance ri, int type) {
        if (this.update && holder.getConfidenceWeightsAdjustment() != null) {
            this.adjustValuesForScoreAdjustmentCancelled(holder.getConfidenceWeightsAdjustment());
            holder.setConfidenceWeightsAdjustment(null);
        }
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance ri, int type) {
        if (this.update && type == 102) {
            holder.setConfidenceWeightsAdjustment(this.adjustValuesForReplacementSelected(((ReplacedInstance)ri).getReplacement()));
        }
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
    }

    public static interface ChangeListener {
        public void changeUpdate(boolean var1);
    }

    public static class ScoreAdjustment {
        double kvChange;
        double lrChange;
        double seChange;

        public ScoreAdjustment(double kvChange, double lrChange, double seChange) {
            this.kvChange = kvChange;
            this.lrChange = lrChange;
            this.seChange = seChange;
        }
    }
}

