/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.AddOwnVariantDialog;
import gui.DropDownButton;
import gui.RuleManager;
import gui.StackListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import model.ConfidenceWeights;
import model.ExceptionMessageHandler;
import model.Globals;
import model.ProgressListener;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.CorrectInstance;
import model.doc.DocumentElement;
import model.doc.DocumentModel;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.IgnorableTextListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class MainScreen
implements ProgressListener,
ExceptionMessageHandler,
LookUpDictionary.DataChangeListener,
ConfidenceWeights.ChangeListener {
    private boolean allowEditing = false;
    private static final String PROGRAM_TITLE = "VARD 2.2";
    private static final int XML = 66;
    private static final int TXT = 88;
    private int listSelected = WordHolder.types[0];
    public static ImageIcon LOADING_ICON;
    private final Integer[] fontSizes = new Integer[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48};
    private DocumentModel docModel;
    private Globals global;
    private JTextPane textPane;
    private JScrollPane textPaneSP;
    private JToolBar mainToolBar;
    private JToolBar standardToolBar;
    private JToolBar formattingToolBar;
    private Vector<JButton> fileTBButtons;
    private Vector<JButton> editTBButtons;
    private Vector<JToggleButton> formattingTBButtons;
    private Vector<JComponent> fontTBComponents;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu styleMenu;
    private JComboBox fontComboBox;
    private JComboBox sizeComboBox;
    private String[] systemFonts;
    private JFileChooser fileChooser;
    static JFrame frame;
    private JPanel main;
    private JPanel sidebar;
    private HashMap<String, Action> actions;
    private HashMap<String, Action> ekActions;
    private JProgressBar progressBar;
    private JLabel progressBarLabel;
    private JPanel progressBarPanel;
    private JRadioButton[] radioButtonArray;
    private ButtonGroup radioButtonGroup;
    private JLabel listHeader;
    private JLabel nextPreviousLabel;
    private JList wordList;
    private JScrollPane wordListSP;
    private InstanceHolder<? extends Instance> selectedHolder;
    private Instance selectedInstance;
    private JSlider thresholdSlider;
    private File currentFile;
    private int currentFileType;
    private JToggleButton boldToggle;
    private JToggleButton italicToggle;
    private JToggleButton underlineToggle;
    private Style currentViewAttributes;
    private Style removeHighlight;
    private Style mainHighlight;
    private Style selectedHighlight;
    private Style ignored;
    private static final Color SELECTION_COLOUR;
    private UIUpdatingUndoManager undoManager = new UIUpdatingUndoManager();
    private UndoableEditSupport undoSupport = new UndoableEditSupport();
    private ConfidenceWeights confidenceWeights;
    private LookUpDictionary lud;

    static {
        SELECTION_COLOUR = new Color(120, 220, 120);
    }

    private MainScreen() {
        this.global = Globals.getInstance();
        this.docModel = DocumentModel.getInstance();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Loading user interface...");
        this.global.lockFinishProgress();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.textPane = new JTextPane();
        this.currentViewAttributes = this.textPane.addStyle("Current View", null);
        this.removeHighlight = this.textPane.addStyle("Remove Highlight", null);
        StyleConstants.setBackground(this.removeHighlight, Color.WHITE);
        StyleConstants.setForeground(this.removeHighlight, Color.BLACK);
        this.mainHighlight = this.textPane.addStyle("Highlight Yellow", null);
        StyleConstants.setBackground(this.mainHighlight, Color.YELLOW);
        StyleConstants.setForeground(this.mainHighlight, Color.BLACK);
        this.selectedHighlight = this.textPane.addStyle("Highlight Selected", null);
        StyleConstants.setBackground(this.selectedHighlight, SELECTION_COLOUR);
        StyleConstants.setForeground(this.selectedHighlight, Color.BLACK);
        this.ignored = this.textPane.addStyle("Ignored", null);
        StyleConstants.setBackground(this.ignored, Color.WHITE);
        StyleConstants.setForeground(this.ignored, Color.LIGHT_GRAY);
        this.ekActions = new HashMap();
        Action[] aa = this.textPane.getEditorKit().getActions();
        int i = 0;
        while (i < aa.length) {
            Action a = aa[i];
            this.ekActions.put((String)a.getValue("Name"), a);
            ++i;
        }
        this.actions = new HashMap();
        this.actions.put("New", this.fixAction(new NewAction(), "New", "page_white_text", "Create a new file", 78, KeyStroke.getKeyStroke(78, 2)));
        this.actions.put("Open", this.fixAction(new OpenAction(), "Open", "folder_page", "Open a file to analyse", 79, KeyStroke.getKeyStroke(79, 2)));
        this.actions.put("Save", this.fixAction(new SaveAction(), "Save", "disk", "Save current file", 83, KeyStroke.getKeyStroke(83, 2)));
        this.actions.put("Save As Plain", this.fixAction(new SaveAsPlainAction(), "Save Without XML Tags", "script_save", "Save the file in it's original format, but with variants replaced (unmarked).", 84, null));
        this.actions.put("Save As XML", this.fixAction(new ExportToXMLAction(), "Save With XML Tags", "script_code_red", "Saves the file with variants replaced and marked. No formatting will be saved.", 88, null));
        this.actions.put("Save Dictionary", this.fixAction(new SaveDictionaryAction(), "Save Dictionary", "book_add", "Save changes to dictionary", 68, null));
        this.actions.put("Save Variant List", this.fixAction(new SaveVariantsAction(), "Save Variant List", "table_add", "Save changes to known variants list", 86, null));
        this.actions.put("Save Rule List", this.fixAction(new SaveRulesAction(), "Save Rule List", "brick_add", "Save changes to rule list", 82, null));
        this.actions.put("Save Confidence Weights", this.fixAction(new SaveConfidenceWeightsAction(), "Save Confidence Weights", "chart_pie_add", "Save changes to replacement method confidence weights", 67, null));
        this.actions.put("Save All", this.fixAction(new SaveAllAction(), "Save All", "disk_multiple", "Save document, dictionary, variant list, rule list and confidence weights", 65, null));
        this.actions.put("Exit", this.fixAction(new ExitAction(), "Exit", "door", null, 88, null));
        this.actions.put("Copy", this.fixAction(new DefaultEditorKit.CopyAction(), "Copy", "page_copy", "Copy selected text to clipboard", 67, KeyStroke.getKeyStroke(67, 2)));
        this.actions.put("Paste", this.fixAction(new PasteAction(), "Paste", "paste_plain", "Paste text from clipboard into document", 80, KeyStroke.getKeyStroke(86, 2)));
        this.actions.put("Bold", this.fixAction(new StyledEditorKit.BoldAction(), "Bold", "text_bold", "Toggle Bold on selected text", 66, KeyStroke.getKeyStroke(66, 2)));
        this.actions.put("Italic", this.fixAction(new StyledEditorKit.ItalicAction(), "Italic", "text_italic", "Toggle Italic on selected text", 73, KeyStroke.getKeyStroke(73, 2)));
        this.actions.put("Underline", this.fixAction(new StyledEditorKit.UnderlineAction(), "Underline", "text_underline", "Toggle Underline on selected text", 85, KeyStroke.getKeyStroke(85, 2)));
        this.actions.put("Select All", this.fixAction(this.getDefaultActionByName("select-all"), "Select All", "arrow_out", "Select All Text In Document", 65, KeyStroke.getKeyStroke(65, 2)));
        this.actions.put("Correct All", this.fixAction(new ProcessAllVariantsAction(), "Process All Variants", null, "Replace all variants with top replacement when above threshold", -1, null));
        this.actions.put("Copy List", this.fixAction(new CopyListAction(), "Copy Current List", null, "Copy current list to system's clipboard", -1, null));
        this.actions.put("Show Replacement Analysis", this.fixAction(new ShowReplacementAnalysisAction(), "Show Replacment Analysis", null, "Displays counts of replacement methods", -1, null));
        this.actions.put("Join", this.fixAction(new JoinAction(), "Join", "arrow_join", "Join two or more words.", -1, null));
        this.actions.put("Undo", this.fixAction(new UndoAction(), "Undo", "arrow_undo", "Undo last edit", 85, KeyStroke.getKeyStroke(90, 2)));
        this.actions.put("Redo", this.fixAction(new RedoAction(), "Redo", "arrow_redo", "Redo last edit which was undone", 82, KeyStroke.getKeyStroke(89, 2)));
        this.actions.put("Rule List Manager", this.fixAction(new RuleListManagerAction(), "Rule List Manager", "brick_edit", "Open rule list manager", 82, KeyStroke.getKeyStroke(82, 2)));
        this.actions.put("Next Instance", this.fixAction(new NextInstanceAction(), "Next Instance", "arrow_right", "Find the next instance of the selected word.", 39, KeyStroke.getKeyStroke(39, 0)));
        this.actions.put("Previous Instance", this.fixAction(new PreviousInstanceAction(), "Previous Instance", "arrow_left", "Find the previous instance of the selected word.", 37, KeyStroke.getKeyStroke(37, 0)));
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.main = new JPanel(new BorderLayout());
        this.textPane.setEditable(false);
        this.textPaneSP = new JScrollPane(this.textPane, 22, 31);
        this.currentFile = null;
        this.textPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                if (MainScreen.this.allowEditing) {
                    int end;
                    int start = evt.getMark();
                    if (start == (end = evt.getDot())) {
                        start = MainScreen.this.docModel.getStartOfDoc();
                        end = MainScreen.this.docModel.getEndOfDoc();
                        MainScreen.this.getActionByName("Copy").setEnabled(false);
                        MainScreen.this.getActionByName("Join").setEnabled(false);
                    } else {
                        MainScreen.this.getActionByName("Copy").setEnabled(true);
                        MainScreen.this.getActionByName("Join").setEnabled(true);
                    }
                    if (start > end) {
                        start = evt.getDot();
                        end = evt.getMark();
                    }
                    try {
                        MainScreen.this.updateAttributesViewWithAttributesOfRange(start, end);
                    }
                    catch (BadLocationException ex) {
                        MainScreen.this.global.showException("Error occurred whilst finding the attributes for the selected word.\n\n", ex);
                    }
                }
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MainScreen.this.allowEditing && e.getButton() == 3) {
                    Rectangle wordRect;
                    Instance instance;
                    block22: {
                        int caretPos = MainScreen.this.textPane.viewToModel(e.getPoint());
                        MainScreen.this.textPane.setCaretPosition(caretPos);
                        instance = null;
                        try {
                            try {
                                instance = MainScreen.this.docModel.getWordAt(caretPos);
                            }
                            catch (BadLocationException ex) {
                                MainScreen.this.global.showException("Error occurred finding word.", ex);
                                if (instance == null) {
                                    return;
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            if (instance == null) {
                                return;
                            }
                            throw throwable;
                        }
                        if (instance == null) {
                            return;
                        }
                    }
                    WordHolder wh = instance.getHolder();
                    try {
                        wordRect = MainScreen.this.textPane.modelToView(instance.getEndOffset());
                    }
                    catch (BadLocationException ex) {
                        MainScreen.this.global.showException("Error occurred trying to find word.", ex);
                        return;
                    }
                    switch (instance.getType()) {
                        case 101: {
                            JPopupMenu popup = new JPopupMenu();
                            JMenuItem wait = new JMenuItem("Please Wait...");
                            wait.setEnabled(false);
                            popup.add(wait);
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            JMenu more = new JMenu("More Suggestions...");
                            JMenu nid = new JMenu("Suggestions not in dictionary...");
                            int added = 0;
                            int nidAdded = 0;
                            MainScreen.this.docModel.findReplacementsForWord(wh);
                            Vector<SuggestedReplacement> reps = wh.getReplacements();
                            Collections.sort(reps);
                            for (SuggestedReplacement replacement : reps) {
                                if (!replacement.isInDictionary() && !replacement.isKnownVariant()) {
                                    nid.add(MainScreen.this.getReplacementPopupMenu(replacement, wh, (VariantInstance)instance, 101, instance.getCapitalization()));
                                    ++nidAdded;
                                    continue;
                                }
                                if (added < 5) {
                                    popup.add(MainScreen.this.getReplacementPopupMenu(replacement, wh, (VariantInstance)instance, 101, instance.getCapitalization()));
                                    ++added;
                                    continue;
                                }
                                more.add(MainScreen.this.getReplacementPopupMenu(replacement, wh, (VariantInstance)instance, 101, instance.getCapitalization()));
                                ++added;
                            }
                            if (added == 0) {
                                JMenuItem noneFound = new JMenuItem("No Replacements found");
                                noneFound.setEnabled(false);
                                popup.add(noneFound);
                            }
                            if (added > 5) {
                                popup.add(more);
                            }
                            if (nidAdded > 0) {
                                popup.add(nid);
                            }
                            popup.addSeparator();
                            popup.add(new ReplaceWithAction(MainScreen.this, (VariantInstance)instance));
                            popup.add(new MarkFInstanceAsTAction(MainScreen.this, (Instance)((VariantInstance)instance), (Instance)new CorrectInstance()));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new MarkAllFInstancesAsTAction(MainScreen.this, wh, (Instance)new VariantInstance(), (Instance)new CorrectInstance()));
                            popup.setVisible(false);
                            popup.remove(wait);
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            break;
                        }
                        case 103: {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new MarkFInstanceAsTAction(MainScreen.this, (Instance)((CorrectInstance)instance), (Instance)new VariantInstance()));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new MarkAllFInstancesAsTAction(MainScreen.this, wh, (Instance)new CorrectInstance(), (Instance)new VariantInstance()));
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                            break;
                        }
                        case 102: {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new RevertReplacedInstanceAction((ReplacedInstance)instance));
                            popup.addSeparator();
                            popup.add(new FindWordInListAction(instance));
                            popup.add(new RevertAllReplacedAction(wh, ((ReplacedInstance)instance).getReplacement()));
                            popup.show(MainScreen.this.textPane, wordRect.x + wordRect.width, wordRect.y + wordRect.height);
                        }
                    }
                }
            }
        });
        this.systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontComboBox = new JComboBox<String>(this.systemFonts);
        this.fontComboBox.setEditable(true);
        this.fontComboBox.addActionListener(new ActionListener(){
            boolean shownOnce = false;

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("skip")) {
                    return;
                }
                String f = (String)MainScreen.this.fontComboBox.getSelectedItem();
                if (Arrays.binarySearch(MainScreen.this.systemFonts, f) < 0) {
                    if (!this.shownOnce) {
                        this.shownOnce = true;
                        int yn = JOptionPane.showConfirmDialog(frame, "The font '" + f + "' is not available on this system, do you still wish to use it?", "' " + f + "' not found", 0);
                        if (yn == 1) {
                            return;
                        }
                    } else {
                        this.shownOnce = false;
                        return;
                    }
                }
                Style style = MainScreen.this.textPane.addStyle("Font " + f, null);
                StyleConstants.setFontFamily(style, f);
                StyleConstants.setFontFamily(MainScreen.this.currentViewAttributes, f);
                MainScreen.this.textPane.setCharacterAttributes(style, false);
                MainScreen.this.textPane.requestFocus();
            }
        });
        this.fontComboBox.setMaximumSize(this.fontComboBox.getPreferredSize());
        this.sizeComboBox = new JComboBox<Integer>(this.fontSizes);
        this.sizeComboBox.setEditable(true);
        this.sizeComboBox.addActionListener(new ActionListener(){
            boolean shownOnce = false;

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("skip")) {
                    return;
                }
                if (!(MainScreen.this.sizeComboBox.getSelectedItem() instanceof Integer)) {
                    if (!this.shownOnce) {
                        MainScreen.this.displayError("Not a valid font size");
                        this.shownOnce = true;
                    } else {
                        this.shownOnce = false;
                    }
                    return;
                }
                Integer s = (Integer)MainScreen.this.sizeComboBox.getSelectedItem();
                Style style = MainScreen.this.textPane.addStyle("Size " + s, null);
                StyleConstants.setFontSize(style, s);
                StyleConstants.setFontSize(MainScreen.this.currentViewAttributes, s);
                MainScreen.this.textPane.setCharacterAttributes(style, false);
                MainScreen.this.textPane.requestFocus();
            }
        });
        this.sizeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                MainScreen.this.textPane.requestFocus();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                MainScreen.this.textPane.requestFocus();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.sizeComboBox.setMaximumSize(this.sizeComboBox.getPreferredSize());
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setValue(0);
        this.progressBarLabel = new JLabel();
        this.resetProgressBarLabel();
        this.progressBarPanel = new JPanel(new BorderLayout());
        this.progressBarPanel.add((Component)this.progressBar, "Center");
        this.progressBarPanel.add((Component)this.progressBarLabel, "West");
        this.main.add((Component)this.progressBarPanel, "South");
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        this.mainToolBar = new JToolBar("Functions");
        this.mainToolBar.setFloatable(false);
        this.standardToolBar = new JToolBar("Standard");
        this.standardToolBar.setFloatable(false);
        this.fileTBButtons = new Vector();
        this.fileTBButtons.add(new JButton(this.getActionByName("New")));
        this.fileTBButtons.add(new JButton(this.getActionByName("Open")));
        this.fileTBButtons.add(new JButton(this.getActionByName("Save")));
        for (JButton button : this.fileTBButtons) {
            button.setFocusable(false);
            button.setText("");
            this.standardToolBar.add(button);
        }
        this.standardToolBar.addSeparator();
        DropDownButton undoDD = new DropDownButton(this.getActionByName("Undo"), this.undoManager.getUndoList());
        undoDD.addSelectionCompleteListener(new DropDownButton.SelectionCompleteListener(){

            @Override
            public void selectionComplete(int amountSelected) {
                final int amount = amountSelected;
                new Thread(){

                    @Override
                    public void run() {
                        MainScreen.this.undoManager.undo(amount);
                    }
                }.start();
            }
        });
        this.standardToolBar.add(undoDD);
        DropDownButton redoDD = new DropDownButton(this.getActionByName("Redo"), this.undoManager.getRedoList());
        redoDD.addSelectionCompleteListener(new DropDownButton.SelectionCompleteListener(){

            @Override
            public void selectionComplete(int amountSelected) {
                final int amount = amountSelected;
                new Thread(){

                    @Override
                    public void run() {
                        MainScreen.this.undoManager.redo(amount);
                    }
                }.start();
            }
        });
        this.standardToolBar.add(redoDD);
        this.editTBButtons = new Vector();
        this.editTBButtons.add(new JButton(this.getActionByName("Join")));
        this.editTBButtons.add(new JButton(this.getActionByName("Copy")));
        this.editTBButtons.add(new JButton(this.getActionByName("Paste")));
        this.editTBButtons.add(new JButton(this.getActionByName("Select All")));
        for (JButton jButton : this.editTBButtons) {
            jButton.setFocusable(false);
            jButton.setText("");
            this.standardToolBar.add(jButton);
        }
        this.mainToolBar.add(this.standardToolBar);
        this.formattingToolBar = new JToolBar("Formatting");
        this.formattingToolBar.setFloatable(false);
        this.fontTBComponents = new Vector();
        this.fontTBComponents.add(this.fontComboBox);
        this.fontTBComponents.add(this.sizeComboBox);
        for (JComponent jComponent : this.fontTBComponents) {
            this.formattingToolBar.add(jComponent);
        }
        this.formattingToolBar.addSeparator();
        this.formattingTBButtons = new Vector();
        this.boldToggle = new JToggleButton(this.getActionByName("Bold"));
        this.italicToggle = new JToggleButton(this.getActionByName("Italic"));
        this.underlineToggle = new JToggleButton(this.getActionByName("Underline"));
        this.formattingTBButtons.add(this.boldToggle);
        this.formattingTBButtons.add(this.italicToggle);
        this.formattingTBButtons.add(this.underlineToggle);
        for (JToggleButton jToggleButton : this.formattingTBButtons) {
            jToggleButton.setText("");
            jToggleButton.setFocusable(false);
            this.formattingToolBar.add(jToggleButton);
        }
        this.mainToolBar.add(this.formattingToolBar);
        this.mainToolBar.add(Box.createHorizontalGlue());
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.fileMenu.add(this.getActionByName("New"));
        this.fileMenu.add(this.getActionByName("Open"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getActionByName("Save"));
        this.fileMenu.add(this.getActionByName("Save As XML"));
        this.fileMenu.add(this.getActionByName("Save As Plain"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getActionByName("Save Dictionary"));
        this.fileMenu.add(this.getActionByName("Save Variant List"));
        this.fileMenu.add(this.getActionByName("Save Rule List"));
        this.fileMenu.add(this.getActionByName("Save Confidence Weights"));
        this.fileMenu.add(this.getActionByName("Save All"));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.getActionByName("Exit"));
        this.menuBar.add(this.fileMenu);
        this.getActionByName("Save Rule List").setEnabled(false);
        this.getActionByName("Save Variant List").setEnabled(false);
        this.getActionByName("Save Dictionary").setEnabled(false);
        this.getActionByName("Save Confidence Weights").setEnabled(false);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.editMenu.add(this.getActionByName("Undo"));
        this.editMenu.add(this.getActionByName("Redo"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("Join"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("Copy"));
        this.editMenu.add(this.getActionByName("Paste"));
        this.editMenu.addSeparator();
        this.editMenu.add(this.getActionByName("Select All"));
        this.menuBar.add(this.editMenu);
        this.styleMenu = new JMenu("Style");
        this.styleMenu.setMnemonic(83);
        this.styleMenu.add(this.getActionByName("Bold"));
        this.styleMenu.add(this.getActionByName("Italic"));
        this.styleMenu.add(this.getActionByName("Underline"));
        this.menuBar.add(this.styleMenu);
        JMenu jMenu = new JMenu("Advanced");
        jMenu.setMnemonic(65);
        jMenu.add(this.getActionByName("Rule List Manager"));
        this.menuBar.add(jMenu);
        this.radioButtonArray = new JRadioButton[WordHolder.types.length];
        this.radioButtonGroup = new ButtonGroup();
        this.sidebar = new JPanel();
        this.sidebar.setLayout(new BoxLayout(this.sidebar, 3));
        int i2 = 0;
        while (i2 < this.radioButtonArray.length) {
            this.radioButtonArray[i2] = new JRadioButton(new RadioButtonAction(WordHolder.types[i2]));
            this.radioButtonGroup.add(this.radioButtonArray[i2]);
            this.sidebar.add(this.radioButtonArray[i2]);
            this.radioButtonArray[i2].setAlignmentX(0.0f);
            this.radioButtonArray[i2].setFocusable(false);
            ++i2;
        }
        this.radioButtonArray[0].setSelected(true);
        this.listHeader = new JLabel("");
        this.listHeader.setAlignmentX(0.0f);
        this.wordList = new JList();
        this.wordList.setFocusable(false);
        this.wordList.setPrototypeCellValue("1234567890123456789012345");
        this.wordList.setVisibleRowCount(7);
        this.wordList.setSelectionBackground(SELECTION_COLOUR);
        this.wordList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!MainScreen.this.wordList.isSelectionEmpty()) {
                    InstanceHolder selectedValue = (InstanceHolder)MainScreen.this.wordList.getSelectedValue();
                    MainScreen.this.changeSelectedWord(selectedValue);
                }
            }
        });
        this.wordList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainScreen.this.allowEditing && e.getButton() == 3) {
                    int toSelect = MainScreen.this.wordList.locationToIndex(e.getPoint());
                    MainScreen.this.wordList.setSelectedIndex(toSelect);
                    InstanceHolder instanceHolder = (InstanceHolder)MainScreen.this.wordList.getSelectedValue();
                    WordHolder wordHolder = instanceHolder.getWordHolder();
                    Rectangle cellRect = MainScreen.this.wordList.getCellBounds(toSelect, toSelect);
                    switch (instanceHolder.getType()) {
                        case 101: {
                            JPopupMenu popup = new JPopupMenu();
                            JMenuItem wait = new JMenuItem("Please Wait...");
                            wait.setEnabled(false);
                            popup.add(wait);
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                            JMenu more = new JMenu("More Suggestions...");
                            JMenu nid = new JMenu("Suggestions not in dictionary...");
                            int added = 0;
                            int nidAdded = 0;
                            MainScreen.this.docModel.findReplacementsForWord(wordHolder);
                            Vector<SuggestedReplacement> reps = wordHolder.getReplacements();
                            Collections.sort(reps);
                            for (SuggestedReplacement replacement : reps) {
                                if (!replacement.isInDictionary() && !replacement.isKnownVariant()) {
                                    nid.add(MainScreen.this.getReplacementPopupMenu(replacement, wordHolder, null, 101, instanceHolder.getCapitalization()));
                                    ++nidAdded;
                                    continue;
                                }
                                if (added < 5) {
                                    popup.add(MainScreen.this.getReplacementPopupMenu(replacement, wordHolder, null, 101, instanceHolder.getCapitalization()));
                                    ++added;
                                    continue;
                                }
                                more.add(MainScreen.this.getReplacementPopupMenu(replacement, wordHolder, null, 101, instanceHolder.getCapitalization()));
                                ++added;
                            }
                            if (added == 0) {
                                JMenuItem noneFound = new JMenuItem("No Replacements found");
                                noneFound.setEnabled(false);
                                popup.add(noneFound);
                            }
                            if (added > 5) {
                                popup.add(more);
                            }
                            if (nidAdded > 0) {
                                popup.add(nid);
                            }
                            popup.addSeparator();
                            popup.add(new ReplaceWithAction(MainScreen.this, wordHolder, new VariantInstance()));
                            popup.add(new MarkAllFInstancesAsTAction(MainScreen.this, wordHolder, (Instance)new VariantInstance(), (Instance)new CorrectInstance()));
                            popup.setVisible(false);
                            popup.remove(wait);
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                            break;
                        }
                        case 103: {
                            JPopupMenu popup = new JPopupMenu();
                            popup.add(new MarkAllFInstancesAsTAction(MainScreen.this, wordHolder, (Instance)new CorrectInstance(), (Instance)new VariantInstance()));
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                            break;
                        }
                        case 102: {
                            JPopupMenu popup = new JPopupMenu();
                            ReplacedInstance first = (ReplacedInstance)instanceHolder.firstInstance();
                            if (first == null) break;
                            popup.add(new RevertAllReplacedAction(wordHolder, first.getReplacement()));
                            popup.show(MainScreen.this.wordList, cellRect.x, cellRect.y + cellRect.height);
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.wordListSP = new JScrollPane(this.wordList, 22, 31);
        this.wordListSP.setAlignmentX(0.0f);
        JButton copyListButton = new JButton(this.getActionByName("Copy List"));
        copyListButton.setFocusable(false);
        this.sidebar.add(copyListButton);
        this.nextPreviousLabel = new JLabel(" ", 0);
        this.nextPreviousLabel.setAlignmentX(0.5f);
        this.nextPreviousLabel.setMinimumSize(new Dimension(100, 20));
        this.nextPreviousLabel.setMaximumSize(new Dimension(100, 20));
        this.nextPreviousLabel.setPreferredSize(new Dimension(100, 20));
        JButton previousInstanceButton = new JButton(this.getActionByName("Previous Instance"));
        JButton nextInstanceButton = new JButton(this.getActionByName("Next Instance"));
        previousInstanceButton.setFocusable(false);
        nextInstanceButton.setFocusable(false);
        previousInstanceButton.setText("");
        nextInstanceButton.setText("");
        JPanel nextPreviousPanel = new JPanel();
        nextPreviousPanel.add(previousInstanceButton);
        nextPreviousPanel.add(this.nextPreviousLabel);
        nextPreviousPanel.add(nextInstanceButton);
        nextPreviousPanel.setAlignmentX(0.0f);
        this.thresholdSlider = new JSlider(0, 0, 100, 50);
        this.thresholdSlider.setMinorTickSpacing(1);
        this.thresholdSlider.setMajorTickSpacing(10);
        this.thresholdSlider.setPaintTicks(true);
        this.thresholdSlider.setPaintLabels(true);
        this.thresholdSlider.setSnapToTicks(true);
        this.thresholdSlider.setAlignmentX(0.0f);
        this.thresholdSlider.setFocusable(false);
        this.sidebar.add(Box.createRigidArea(new Dimension(0, 20)));
        this.sidebar.add(this.listHeader);
        this.sidebar.add(this.wordListSP);
        this.sidebar.add(nextPreviousPanel);
        this.sidebar.add(new JLabel(" Replacement Threshold:", 2));
        this.sidebar.add(this.thresholdSlider);
        JButton correctAllButton = new JButton(this.getActionByName("Correct All"));
        correctAllButton.setFocusable(false);
        this.sidebar.add(correctAllButton);
        this.sidebar.add(Box.createRigidArea(new Dimension(0, 20)));
        JButton countReplacementsButton = new JButton(this.getActionByName("Show Replacement Analysis"));
        countReplacementsButton.setFocusable(false);
        countReplacementsButton.setEnabled(false);
        this.sidebar.add(countReplacementsButton);
        this.sidebar.add(Box.createVerticalGlue());
        this.sidebar.add(Box.createVerticalGlue());
        this.main.add((Component)this.textPaneSP, "Center");
        this.main.add((Component)this.sidebar, "East");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxWinSize = ge.getMaximumWindowBounds();
        frame = new JFrame(PROGRAM_TITLE);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainScreen.this.doExit();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        frame.setJMenuBar(this.menuBar);
        frame.getContentPane().add((Component)this.main, "Center");
        frame.getContentPane().add((Component)this.mainToolBar, "North");
        frame.setMaximizedBounds(maxWinSize);
        frame.setBounds(maxWinSize.x, maxWinSize.y, maxWinSize.width, maxWinSize.height);
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            this.docModel.addChangeListener(new HolderChangeListener(){

                @Override
                public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
                    InstanceHolder prevSelectedHolder = MainScreen.this.selectedHolder;
                    Instance prevSelectedInstance = MainScreen.this.selectedInstance;
                    MainScreen.this.updateList(type);
                    MainScreen.this.selectedHolder = prevSelectedHolder;
                    MainScreen.this.selectedInstance = prevSelectedInstance;
                    if (MainScreen.this.selectedInstance != null && MainScreen.this.listSelected == type && MainScreen.this.selectedHolder == holder && !MainScreen.this.selectedHolder.contains(MainScreen.this.selectedInstance)) {
                        MainScreen.this.selectedInstance = MainScreen.this.selectedHolder.nextInstance(MainScreen.this.selectedInstance);
                    }
                    MainScreen.this.selectSelectedInstance();
                }

                @Override
                public void instanceAboutToChange(Instance instance, int type) {
                    instance.changeHighlight(MainScreen.this.docModel.getDoc(), MainScreen.this.removeHighlight);
                }

                @Override
                public void instanceChanged(Instance instance, int type) {
                    if (MainScreen.this.selectedHolder != null && MainScreen.this.selectedHolder.contains(instance)) {
                        instance.changeHighlight(MainScreen.this.docModel.getDoc(), MainScreen.this.selectedHighlight);
                    } else if (MainScreen.this.listSelected == type) {
                        instance.changeHighlight(MainScreen.this.docModel.getDoc(), MainScreen.this.mainHighlight);
                    } else {
                        instance.changeHighlight(MainScreen.this.docModel.getDoc(), MainScreen.this.removeHighlight);
                    }
                }

                @Override
                public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                }

                @Override
                public void holderFilled(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                }
            }, t);
            ++n2;
        }
        this.global.finishProgress();
        this.global.setProgressHandler(this);
        this.global.setExceptionHandler(this);
        this.show();
        this.lud = LookUpDictionary.getInstance();
        this.confidenceWeights = ConfidenceWeights.getInstance();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Completing statup...");
        this.setupTextPane();
        this.lud.addDataChangeListener(this);
        this.confidenceWeights.addChangeListener(this);
        this.global.setGlobalIgnorableTextListener(new IgnorableTextListener(){

            @Override
            public void ignore(IgnorableText it) {
                it.changeHighlight(MainScreen.this.docModel.getDoc(), MainScreen.this.ignored);
            }

            @Override
            public void unIgnore(IgnorableText it) {
                it.changeHighlight(MainScreen.this.docModel.getDoc(), MainScreen.this.removeHighlight);
            }
        });
        this.clearText();
        this.global.unlockFinishProgress();
        this.global.finishProgress();
    }

    private Action fixAction(Action action, String name, String icon, String description, int mnemonic, KeyStroke keyStroke) {
        URL iconURL;
        if (name != null) {
            action.putValue("Name", name);
        }
        if (icon != null && (iconURL = MainScreen.class.getResource("icons/" + icon + ".png")) != null) {
            action.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        if (description != null) {
            action.putValue("ShortDescription", description);
        }
        if (mnemonic != -1) {
            action.putValue("MnemonicKey", new Integer(mnemonic));
        }
        if (keyStroke != null) {
            action.putValue("AcceleratorKey", keyStroke);
        }
        return action;
    }

    private Action getDefaultActionByName(String name) {
        return this.ekActions.get(name);
    }

    private Action getActionByName(String name) {
        return this.actions.get(name);
    }

    private void setAllActionsEnabled(boolean enabled) {
        for (Action a : this.actions.values()) {
            a.setEnabled(enabled);
        }
    }

    private void updateList(int type) {
        TreeSet<InstanceHolder<? extends Instance>> ts = this.docModel.getHolderList(type);
        int radioButton = -1;
        int i = 0;
        while (i < WordHolder.types.length) {
            if (WordHolder.types[i] == type) {
                radioButton = i;
            }
            ++i;
        }
        this.radioButtonArray[radioButton].setText(String.valueOf(WordHolder.getTypeName(type)) + " (" + ts.size() + ")");
        if (this.listSelected == type) {
            Object currentListSelection = this.wordList.getSelectedValue();
            this.wordList.setListData(ts.toArray());
            this.listHeader.setText(" " + WordHolder.getTypeName(type) + " (" + ts.size() + "):");
            this.wordList.setSelectedValue(currentListSelection, true);
        }
    }

    private void show() {
        frame.setVisible(true);
        this.textPane.requestFocus();
    }

    private JMenu getReplacementPopupMenu(SuggestedReplacement replacement, WordHolder wh, VariantInstance instance, int type, int capitalization) {
        JMenu toReturn = new JMenu(replacement.toMenuString(capitalization));
        Vector<JCheckBoxMenuItem> cbs = new Vector<JCheckBoxMenuItem>(4);
        cbs.add(new JCheckBoxMenuItem(this.confidenceWeights.getKnownVariantString(), replacement.isKnownVariant()));
        cbs.add(new JCheckBoxMenuItem(this.confidenceWeights.getLetterReplacementString(), replacement.isLetterReplacement()));
        cbs.add(new JCheckBoxMenuItem(this.confidenceWeights.getSoundexString(), replacement.isSoundex()));
        cbs.add(new JCheckBoxMenuItem(this.confidenceWeights.getEditDistanceString(replacement), true));
        if (replacement.isInDictionary()) {
            cbs.add(new JCheckBoxMenuItem("Frequency is " + replacement.getReplacement().getFreq(), false));
        }
        if (!replacement.isInDictionary()) {
            cbs.add(new JCheckBoxMenuItem(this.confidenceWeights.getNotInDictString(replacement), true));
        }
        if (instance != null && instance.getType() == 101) {
            toReturn.add(new ReplaceFInstanceAction(this, instance, replacement));
        }
        if (type == 101) {
            toReturn.add(new ReplaceAllFInstancesAction(this, wh, new VariantInstance(), replacement));
        }
        toReturn.addSeparator();
        for (JCheckBoxMenuItem cb : cbs) {
            cb.setEnabled(false);
            toReturn.add(cb);
        }
        return toReturn;
    }

    private void resetProgressBarLabel() {
        this.progressBarLabel.setText("");
        this.progressBarLabel.setIcon(null);
    }

    private void setProgressBarLabelLoading(String text) {
        this.progressBarLabel.setText(text);
        this.progressBarLabel.setIcon(LOADING_ICON);
    }

    public static void run() {
        URL loadingURL = MainScreen.class.getResource("icons/loading.gif");
        if (loadingURL != null) {
            LOADING_ICON = new ImageIcon(loadingURL);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                new MainScreen(null);
            }
        };
        thread.setPriority(10);
        thread.start();
    }

    private void doExit() {
        Object[] options;
        int pc;
        JPanel savePanel = new JPanel(new GridLayout(0, 1));
        final JCheckBox docCB = new JCheckBox("Current Document", false);
        final JCheckBox cwCB = new JCheckBox("Confidence Weights", false);
        final JCheckBox dCB = new JCheckBox("Dictionary", false);
        final JCheckBox vCB = new JCheckBox("Variant list", false);
        final JCheckBox rCB = new JCheckBox("Letter replacement rules", false);
        savePanel.add(new JLabel("Tick changes to save:"));
        docCB.setSelected(true);
        savePanel.add(docCB);
        if (ConfidenceWeights.hasChanged()) {
            cwCB.setSelected(true);
            savePanel.add(cwCB);
        }
        if (LookUpDictionary.isWordsChanged()) {
            dCB.setSelected(true);
            savePanel.add(dCB);
        }
        if (LookUpDictionary.isVariantsChanged()) {
            vCB.setSelected(true);
            savePanel.add(vCB);
        }
        if (LookUpDictionary.isRulesChanged()) {
            rCB.setSelected(true);
            savePanel.add(rCB);
        }
        if ((pc = JOptionPane.showOptionDialog(frame, savePanel, "Save changes?", 1, 3, null, options = new Object[]{"Save changes", "Discard changes", "Cancel"}, options[0])) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (docCB.isSelected() && !MainScreen.this.save()) {
                        return;
                    }
                    try {
                        if (dCB.isSelected()) {
                            MainScreen.this.lud.writeWordsToFile();
                        }
                        if (vCB.isSelected()) {
                            MainScreen.this.lud.writeVariantsToFile();
                        }
                        if (rCB.isSelected()) {
                            MainScreen.this.lud.writeRulesToFile();
                        }
                        if (cwCB.isSelected()) {
                            MainScreen.this.confidenceWeights.save();
                        }
                        System.exit(0);
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing file.", ex);
                    }
                }
            }).start();
        } else if (pc == 1) {
            System.exit(0);
        }
    }

    private void changeSelectedWord(InstanceHolder<? extends Instance> newSelection) {
        InstanceHolder<? extends Instance> oldSelection = this.selectedHolder;
        this.selectedHolder = newSelection;
        this.selectedInstance = null;
        this.selectSelectedInstance();
        if (oldSelection != null) {
            Style oldHighlight = this.removeHighlight;
            if (oldSelection.getType() == this.listSelected) {
                oldHighlight = this.mainHighlight;
            }
            oldSelection.setAllInstancesHighlights(this.docModel.getDoc(), oldHighlight);
        }
        if (this.selectedHolder != null) {
            this.selectedHolder.setAllInstancesHighlights(this.docModel.getDoc(), this.selectedHighlight);
        }
    }

    private void updateAttributesViewWithAttributesOfRange(int start, int end) throws BadLocationException {
        String font = "";
        int size = 0;
        boolean boldDisagree = false;
        boolean italicDisagree = false;
        boolean underlineDisagree = false;
        boolean sizeDisagree = false;
        boolean fontDisagree = false;
        while (!this.docModel.isCharAtPosLetter(start) && start < end - 1) {
            ++start;
        }
        AttributeSet cas = this.docModel.getAttributesAtPos(start);
        boolean bold = StyleConstants.isBold(cas);
        boolean italic = StyleConstants.isItalic(cas);
        boolean underline = StyleConstants.isUnderline(cas);
        font = StyleConstants.getFontFamily(cas);
        size = StyleConstants.getFontSize(cas);
        int i = start + 1;
        while (i < end) {
            if (this.docModel.isCharAtPosLetter(i)) {
                cas = this.docModel.getAttributesAtPos(i);
                if (!boldDisagree && StyleConstants.isBold(cas) != bold) {
                    bold = false;
                    boldDisagree = true;
                }
                if (!italicDisagree && StyleConstants.isItalic(cas) != italic) {
                    italic = false;
                    italicDisagree = true;
                }
                if (!underlineDisagree && StyleConstants.isUnderline(cas) != underline) {
                    underline = false;
                    underlineDisagree = true;
                }
                if (!fontDisagree && !StyleConstants.getFontFamily(cas).equals(font)) {
                    font = "";
                    fontDisagree = true;
                }
                if (!sizeDisagree && StyleConstants.getFontSize(cas) != size) {
                    size = 0;
                    sizeDisagree = true;
                }
            }
            ++i;
        }
        this.fontComboBox.setActionCommand("skip");
        this.fontComboBox.setSelectedItem(font);
        this.fontComboBox.setActionCommand("do it");
        this.sizeComboBox.setActionCommand("skip");
        if (size == 0) {
            this.sizeComboBox.setSelectedItem("");
        } else {
            this.sizeComboBox.setSelectedItem(size);
        }
        this.sizeComboBox.setActionCommand("do it");
        this.boldToggle.getModel().setSelected(bold);
        this.italicToggle.getModel().setSelected(italic);
        this.underlineToggle.getModel().setSelected(underline);
    }

    private void clearText() {
        this.selectedInstance = null;
        this.selectedHolder = null;
        this.selectSelectedInstance();
        this.textPane.setDocument(new DefaultStyledDocument());
    }

    private void showText() {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Displaying Text");
        this.textPane.setDocument(this.docModel.getDoc());
        this.global.finishProgress();
    }

    private void setupTextPane() {
        this.getActionByName("Copy").setEnabled(false);
        this.getActionByName("Join").setEnabled(false);
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.updateList(type);
            ++n2;
        }
        this.undoManager.discardAllEdits();
        this.undoManager.refreshUndoRedoUI();
        this.currentFile = null;
        this.currentFileType = -1;
        this.showText();
        try {
            this.updateAttributesViewWithAttributesOfRange(this.docModel.getStartOfDoc(), this.docModel.getEndOfDoc());
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred reading document's attributes.", ex);
        }
    }

    private void selectSelectedInstance() {
        if (this.selectedInstance != null && this.selectedHolder.contains(this.selectedInstance)) {
            this.textPane.setSelectionStart(this.selectedInstance.getStartOffset());
            this.textPane.setSelectionEnd(this.selectedInstance.getEndOffset());
            this.nextPreviousLabel.setText(String.valueOf(this.selectedHolder.getPosition(this.selectedInstance)) + " of " + this.selectedHolder.size());
        } else {
            this.nextPreviousLabel.setText(" ");
            this.textPane.setSelectionEnd(this.textPane.getSelectionStart());
        }
    }

    private void changeList(int whichList) {
        this.global.lockFinishProgress();
        this.clearText();
        this.changeSelectedWord(null);
        int oldSelected = this.listSelected;
        this.listSelected = whichList;
        if (oldSelected != -1) {
            this.removeAllHighlights();
        }
        int rb = 0;
        int i = 0;
        while (i < WordHolder.types.length) {
            if (WordHolder.types[i] == whichList) {
                rb = i;
            }
            ++i;
        }
        this.radioButtonArray[rb].setSelected(true);
        Object[] holderList = this.docModel.getHolderList(whichList).toArray();
        this.wordList.setListData(holderList);
        this.listHeader.setText(" " + WordHolder.getTypeName(whichList) + " (" + holderList.length + "):");
        this.giveAllHighlightsOfType(whichList);
        this.showText();
        this.global.unlockFinishProgress();
        this.global.finishProgress();
    }

    private void removeAllHighlights() {
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Removing highlights...");
        this.docModel.setAllHighlights(this.removeHighlight);
        this.global.finishProgress();
    }

    private void giveAllHighlightsOfType(int type) {
        this.docModel.reIgnoreAllIgnored();
        TreeSet<InstanceHolder<? extends Instance>> hl = this.docModel.getHolderList(type);
        this.global.startProgress(hl.size());
        this.global.writeProgressMessage("Renewing highlights...");
        int count = 0;
        for (InstanceHolder instanceHolder : hl) {
            if (this.selectedHolder != null && this.selectedHolder.equals(instanceHolder)) {
                instanceHolder.setAllInstancesHighlights(this.docModel.getDoc(), this.selectedHighlight);
            } else {
                instanceHolder.setAllInstancesHighlights(this.docModel.getDoc(), this.mainHighlight);
            }
            this.global.setProgressCurrent(++count);
        }
        this.global.finishProgress();
    }

    private void setLoading(boolean loading) {
        this.allowEditing = !loading;
        this.setAllActionsEnabled(this.allowEditing);
        this.wordList.setEnabled(this.allowEditing);
        JRadioButton[] jRadioButtonArray = this.radioButtonArray;
        int n = this.radioButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRadioButton rb = jRadioButtonArray[n2];
            rb.setEnabled(this.allowEditing);
            ++n2;
        }
        if (this.allowEditing) {
            this.undoManager.refreshUndoRedoUI();
            this.getActionByName("Copy").setEnabled(false);
            this.getActionByName("Join").setEnabled(false);
            this.getActionByName("Save Rule List").setEnabled(LookUpDictionary.isRulesChanged());
            this.getActionByName("Save Variant List").setEnabled(LookUpDictionary.isVariantsChanged());
            this.getActionByName("Save Dictionary").setEnabled(LookUpDictionary.isWordsChanged());
            this.getActionByName("Save Confidence Weights").setEnabled(ConfidenceWeights.hasChanged());
        }
    }

    private boolean save() {
        Object[] options;
        Object o;
        if (this.currentFile != null) {
            if (this.currentFileType == 88) {
                this.clearText();
                if (this.currentFile.getName().endsWith("rtf")) {
                    this.removeAllHighlights();
                }
                boolean saved = this.docModel.saveToFile(this.currentFile);
                if (this.currentFile.getName().endsWith("rtf")) {
                    this.giveAllHighlightsOfType(this.listSelected);
                }
                this.showText();
                return saved;
            }
            if (this.currentFileType == 66) {
                if (this.currentFile.getName().endsWith("rtf")) {
                    this.displayError("You cannot save an rtf file with xml tags, please save as plain text (i.e. .txt) or without tags");
                    this.currentFile = null;
                    return false;
                }
                this.clearText();
                boolean saved = this.docModel.exportToXML(this.currentFile);
                this.showText();
                return saved;
            }
        }
        if ((o = JOptionPane.showInputDialog(frame, "How would you like to save the file?", "Save as?", 3, null, options = new Object[]{"Save with XML tags", "Save without XML tags"}, options[0])) == null) {
            return false;
        }
        if (o.equals(options[0])) {
            return this.exportToXML();
        }
        if (o.equals(options[1])) {
            return this.saveAs();
        }
        return false;
    }

    private boolean saveAs() {
        int returnVal = this.fileChooser.showSaveDialog(frame);
        if (returnVal == 0) {
            int yn;
            File fileSelected = this.fileChooser.getSelectedFile();
            if (fileSelected.exists() && (yn = JOptionPane.showConfirmDialog(frame, "You are overwriting an existing file, continue?", "Overwrite?", 2)) == 2) {
                return false;
            }
            this.currentFile = fileSelected;
            this.currentFileType = 88;
            frame.setTitle("VARD 2.2 - " + fileSelected.getName());
            return this.save();
        }
        return false;
    }

    private boolean exportToXML() {
        int returnVal = this.fileChooser.showSaveDialog(frame);
        if (returnVal == 0) {
            int yn;
            File fileSelected = this.fileChooser.getSelectedFile();
            if (fileSelected.exists() && (yn = JOptionPane.showConfirmDialog(frame, "You are overwriting an existing file, continue?", "Overwrite?", 2)) == 2) {
                return false;
            }
            this.currentFile = fileSelected;
            this.currentFileType = 66;
            frame.setTitle("VARD 2.2 - " + fileSelected.getName());
            return this.save();
        }
        return false;
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    @Override
    public void finishProgress() {
        this.resetProgressBarLabel();
        this.progressBar.setIndeterminate(false);
        this.setLoading(false);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.setProgressBarLabelLoading(message);
    }

    @Override
    public void rulesChanged(boolean changed) {
        this.getActionByName("Save Rule List").setEnabled(changed);
    }

    @Override
    public void variantsChanged(boolean changed) {
        this.getActionByName("Save Variant List").setEnabled(changed);
    }

    @Override
    public void wordsChanged(boolean changed) {
        this.getActionByName("Save Dictionary").setEnabled(changed);
    }

    @Override
    public void changeUpdate(boolean changed) {
        this.getActionByName("Save Confidence Weights").setEnabled(changed);
    }

    @Override
    public void setProgressCurrent(int current) {
        this.progressBar.setValue(current);
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        this.progressBar.setIndeterminate(true);
        this.setLoading(true);
    }

    @Override
    public void startProgress(int max) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(max);
        this.setLoading(true);
    }

    public void displayError(String message) {
        JOptionPane.showMessageDialog(frame, message, "Error", 0);
    }

    /* synthetic */ MainScreen(MainScreen mainScreen) {
        this();
    }

    public final class ClipboardTextTransfer
    implements ClipboardOwner {
        @Override
        public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
        }

        public void setClipboardContents(String text) {
            try {
                StringSelection stringSelection = new StringSelection(text);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, this);
            }
            catch (IllegalStateException ex) {
                MainScreen.this.global.showException("Error occurred whilst copying list to clipboard.", ex);
            }
        }
    }

    private class CopyListAction
    extends AbstractAction {
        private static final long serialVersionUID = -562300188506750751L;

        CopyListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClipboardTextTransfer ctt = new ClipboardTextTransfer();
            String cb = "";
            for (InstanceHolder<? extends Instance> ih : MainScreen.this.docModel.getHolderList(MainScreen.this.listSelected)) {
                cb = String.valueOf(cb) + ih.tabbedString() + "\r";
            }
            ctt.setClipboardContents(cb);
        }
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 6496262943261420464L;

        ExitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.doExit();
        }
    }

    private class ExportToXMLAction
    extends AbstractAction {
        private static final long serialVersionUID = 2998037746672741986L;

        ExportToXMLAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.exportToXML();
                }
            }.start();
        }
    }

    private class FindWordInListAction
    extends AbstractAction {
        private static final long serialVersionUID = 7144807205585186906L;
        Instance instance;

        private FindWordInListAction(Instance instance) {
            this.putValue("Name", "Find word in list");
            this.instance = instance;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int type = this.instance.getType();
            if (MainScreen.this.listSelected != type) {
                MainScreen.this.changeList(type);
            }
            MainScreen.this.wordList.setSelectedValue(this.instance.getInstanceHolder(), true);
            MainScreen.this.selectedInstance = this.instance;
            MainScreen.this.selectSelectedInstance();
        }
    }

    private class JoinAction
    extends AbstractAction {
        private static final long serialVersionUID = 5061994287539564528L;

        private JoinAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = MainScreen.this.textPane.getSelectionStart();
            int end = MainScreen.this.textPane.getSelectionEnd();
            if (end - start > 0) {
                try {
                    DocumentModel.JoinEdit je = MainScreen.this.docModel.getJoinEdit(start, end);
                    if (je.isValid()) {
                        je.execute();
                        MainScreen.this.undoSupport.postEdit(je);
                    } else {
                        MainScreen.this.displayError(je.getWhyInvalid());
                    }
                }
                catch (BadLocationException ex) {
                    MainScreen.this.global.showException("Join Failed.", ex);
                }
                catch (InvalidInstanceChangeException ex) {
                    MainScreen.this.global.showException("Join Failed.", ex);
                }
            }
        }
    }

    private static class MarkAllFInstancesAsTAction<F extends Instance, T extends Instance>
    extends AbstractAction {
        private static final long serialVersionUID = -7964139713034760680L;
        WordHolder.MarkAllFInstancesAsTEdit<F, T> edit;
        WordHolder wh;
        final /* synthetic */ MainScreen this$0;

        MarkAllFInstancesAsTAction(WordHolder wh, F tempFrom, T tempTo) {
            this.this$0 = var1_1;
            this.wh = wh;
            try {
                this.edit = new WordHolder.MarkAllFInstancesAsTEdit<F, T>(wh, tempFrom, tempTo);
                this.putValue("Name", this.edit.getActionName());
            }
            catch (InvalidInstanceChangeException ex) {
                var1_1.showException("Error occurred in marking all instances prep.", ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int o;
            ThreadedProcessEditHolder tEdit = this.this$0.new ThreadedProcessEditHolder(this.edit);
            tEdit.execute();
            this.this$0.undoSupport.postEdit(tEdit);
            if (this.edit.getToType() == 103 && !this.wh.isInDictionary()) {
                int o2 = JOptionPane.showOptionDialog(frame, "Would you like to add this word to the dictionary?", "Add to dictionary?", 0, 3, null, null, null);
                if (o2 == 0) {
                    DocumentModel.AddWordToDictionaryEdit addEdit = new DocumentModel.AddWordToDictionaryEdit(this.wh, this.wh.getWord());
                    addEdit.execute();
                    this.this$0.undoSupport.postEdit(addEdit);
                }
            } else if (this.edit.getToType() == 101 && (o = JOptionPane.showOptionDialog(frame, "Would you like to remove this word from the dictionary?\nThis will result in the word being marked as a variant in future.", "Remove from dictionary?", 0, 3, null, null, null)) == 0) {
                DocumentModel.RemoveWordFromDictionaryEdit removeEdit = new DocumentModel.RemoveWordFromDictionaryEdit(this.wh, this.wh.getWord());
                removeEdit.execute();
                this.this$0.undoSupport.postEdit(removeEdit);
            }
        }
    }

    private static class MarkFInstanceAsTAction<F extends Instance, T extends Instance>
    extends AbstractAction {
        private static final long serialVersionUID = -7964139713034760680L;
        WordHolder.MarkFInstanceAsTEdit<F, T> edit;
        final /* synthetic */ MainScreen this$0;

        MarkFInstanceAsTAction(F fi, T tempTo) {
            this.this$0 = var1_1;
            try {
                this.edit = new WordHolder.MarkFInstanceAsTEdit<F, T>(fi, tempTo);
                this.putValue("Name", this.edit.getActionName());
            }
            catch (InvalidInstanceChangeException ex) {
                ((MainScreen)var1_1).global.showException("Error occurred in marking instance prep.", ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int o;
            try {
                this.edit.execute();
                this.this$0.undoSupport.postEdit(this.edit);
            }
            catch (InvalidInstanceChangeException ex) {
                this.this$0.global.showException("Error occurred marking instance.", ex);
            }
            WordHolder wh = ((Instance)this.edit.getToInstance()).getHolder();
            if (this.edit.getToType() == 103 && !wh.isInDictionary()) {
                int o2 = JOptionPane.showOptionDialog(frame, "Would you like to add this word to the dictionary?", "Add to dictionary?", 0, 3, null, null, null);
                if (o2 == 0) {
                    DocumentModel.AddWordToDictionaryEdit addEdit = new DocumentModel.AddWordToDictionaryEdit(wh, wh.getWord());
                    addEdit.execute();
                    this.this$0.undoSupport.postEdit(addEdit);
                }
            } else if (this.edit.getToType() == 101 && (o = JOptionPane.showOptionDialog(frame, "Would you like to remove this word from the dictionary?\nThis will result in the word being marked as a variant in future.", "Remove from dictionary?", 0, 3, null, null, null)) == 0) {
                DocumentModel.RemoveWordFromDictionaryEdit removeEdit = new DocumentModel.RemoveWordFromDictionaryEdit(wh, wh.getWord());
                removeEdit.execute();
                this.this$0.undoSupport.postEdit(removeEdit);
            }
        }
    }

    private class NewAction
    extends AbstractAction {
        private static final long serialVersionUID = -6218890096674492767L;

        NewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.currentFile = null;
            MainScreen.this.docModel.clear();
            frame.setTitle(MainScreen.PROGRAM_TITLE);
            MainScreen.this.setupTextPane();
        }
    }

    private class NextInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = 6157373229601202571L;

        NextInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainScreen.this.selectedHolder != null) {
                MainScreen.this.selectedInstance = MainScreen.this.selectedHolder.nextInstance(MainScreen.this.selectedInstance);
                MainScreen.this.selectSelectedInstance();
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = -2167496422726054143L;

        OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal = MainScreen.this.fileChooser.showOpenDialog(frame);
            if (returnVal == 0) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            File fileSelected = MainScreen.this.fileChooser.getSelectedFile();
                            if (fileSelected == null) {
                                MainScreen.this.displayError("No file selected");
                                return;
                            }
                            try {
                                MainScreen.this.global.lockFinishProgress();
                                MainScreen.this.clearText();
                                MainScreen.this.docModel.processNewFile(fileSelected);
                                MainScreen.this.setupTextPane();
                                frame.setTitle("VARD 2.2 - " + fileSelected.getName());
                            }
                            catch (InvalidInstanceChangeException e) {
                                MainScreen.this.global.showException("Error occurred reading xml tag.", e);
                            }
                            catch (BadLocationException e) {
                                MainScreen.this.global.showException("Error occurred parsing words in text", e);
                            }
                        }
                        finally {
                            MainScreen.this.global.unlockFinishProgress();
                            MainScreen.this.global.finishProgress();
                        }
                    }
                }.start();
            }
        }
    }

    private class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = -4304408041448008546L;
        String cbText;

        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MainScreen.this.global.startIndeterminateProgress();
            MainScreen.this.global.writeProgressMessage("Pasting clipboard text...");
            MainScreen.this.global.lockFinishProgress();
            this.cbText = "";
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable cbContents = cb.getContents(null);
            if (cbContents != null && cbContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    this.cbText = (String)cbContents.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ex) {
                    MainScreen.this.global.showException("Error occurred pasting from the clipboard.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return;
                }
                catch (IOException ex) {
                    MainScreen.this.global.showException("Error occurred pasting from the clipboard.", ex);
                    MainScreen.this.global.unlockFinishProgress();
                    MainScreen.this.global.finishProgress();
                    return;
                }
            } else {
                MainScreen.this.displayError("Pasted text not supported");
                return;
            }
            if (this.cbText == "") {
                return;
            }
            StyleConstants.setBold(MainScreen.this.currentViewAttributes, MainScreen.this.boldToggle.isSelected());
            StyleConstants.setItalic(MainScreen.this.currentViewAttributes, MainScreen.this.italicToggle.isSelected());
            StyleConstants.setUnderline(MainScreen.this.currentViewAttributes, MainScreen.this.underlineToggle.isSelected());
            new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            MainScreen.this.clearText();
                            MainScreen.this.docModel.processNewText(PasteAction.this.cbText, MainScreen.this.currentViewAttributes);
                            MainScreen.this.showText();
                        }
                        catch (InvalidInstanceChangeException e) {
                            MainScreen.this.global.showException("Error occurred reading xml tag.", e);
                            MainScreen.this.global.unlockFinishProgress();
                            MainScreen.this.global.finishProgress();
                        }
                        catch (BadLocationException e) {
                            MainScreen.this.global.showException("Error occurred parsing words.", e);
                            MainScreen.this.global.unlockFinishProgress();
                            MainScreen.this.global.finishProgress();
                        }
                    }
                    finally {
                        MainScreen.this.global.unlockFinishProgress();
                        MainScreen.this.global.finishProgress();
                    }
                }
            }.start();
        }
    }

    private class PreviousInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = -6606047809322370718L;

        private PreviousInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainScreen.this.selectedHolder != null) {
                MainScreen.this.selectedInstance = MainScreen.this.selectedHolder.previousInstance(MainScreen.this.selectedInstance);
                MainScreen.this.selectSelectedInstance();
            }
        }
    }

    private class ProcessAllVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4429003620159727500L;
        private boolean update;

        ProcessAllVariantsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] options = new String[]{"No", "Yes"};
            int o = JOptionPane.showOptionDialog(frame, "Would you like the confidence weights to be adjusted by the replacements made?", "Adjust confidence weights?", 0, 3, null, options, options[0]);
            this.update = o == 1;
            int threshold = MainScreen.this.thresholdSlider.getValue();
            DocumentModel.ProcessAllVariantsEdit edit = MainScreen.this.docModel.getProcessAllVariantsEdit(threshold, this.update);
            ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
            tEdit.execute();
            MainScreen.this.undoSupport.postEdit(tEdit);
        }
    }

    private class RadioButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = -934709526028658245L;
        private int whichList;

        RadioButtonAction(int whichList) {
            this.whichList = whichList;
            this.putValue("Name", WordHolder.getTypeName(whichList));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.whichList == MainScreen.this.listSelected) {
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.changeList(RadioButtonAction.this.whichList);
                    MainScreen.this.wordList.ensureIndexIsVisible(0);
                }
            }.start();
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.undoManager.redo();
        }
    }

    private static class ReplaceAllFInstancesAction<F extends VariantInstance>
    extends AbstractAction {
        private static final long serialVersionUID = -7964139713034760680L;
        WordHolder.ReplaceAllFInstancesEdit<F> edit;
        SuggestedReplacement rep;
        WordHolder wh;
        int fromType;
        final /* synthetic */ MainScreen this$0;

        ReplaceAllFInstancesAction(WordHolder wh, F tempFrom, SuggestedReplacement rep) {
            this.this$0 = var1_1;
            this.rep = rep;
            this.wh = wh;
            try {
                this.edit = new WordHolder.ReplaceAllFInstancesEdit<F>(wh, tempFrom, rep, ((MainScreen)var1_1).docModel.getDoc(), true);
                this.putValue("Name", this.edit.getActionName());
                this.fromType = ((VariantInstance)tempFrom).getType();
            }
            catch (InvalidInstanceChangeException ex) {
                var1_1.showException("Error occurred in replacing instance prep.", ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractUndoableEdit addEdit;
            int o;
            ThreadedProcessEditHolder tEdit = this.this$0.new ThreadedProcessEditHolder(this.edit);
            tEdit.execute();
            this.this$0.undoSupport.postEdit(tEdit);
            if (!this.rep.isInDictionary() && (o = JOptionPane.showOptionDialog(frame, "Would you like to add this word to the dictionary?", "Add to dictionary?", 0, 3, null, null, null)) == 0) {
                addEdit = new DocumentModel.AddWordToDictionaryEdit(this.wh, this.rep.getReplacementString());
                ((DocumentModel.AddWordToDictionaryEdit)addEdit).execute();
                this.this$0.undoSupport.postEdit(addEdit);
            }
            if (!this.rep.isKnownVariant() && (o = JOptionPane.showOptionDialog(frame, "Would you like to add this replacement to the Known Variant Replacement list?", "Remember replacement?", 0, 3, null, null, null)) == 0) {
                addEdit = new DocumentModel.AddVariantToLookUpEdit(this.rep);
                ((DocumentModel.AddVariantToLookUpEdit)addEdit).execute();
                this.this$0.undoSupport.postEdit(addEdit);
            }
        }
    }

    private static class ReplaceFInstanceAction<F extends VariantInstance>
    extends AbstractAction {
        private static final long serialVersionUID = -7964139713034760680L;
        WordHolder.ReplaceFInstanceEdit<F> edit;
        SuggestedReplacement rep;
        int fromType;
        final /* synthetic */ MainScreen this$0;

        ReplaceFInstanceAction(F fi, SuggestedReplacement rep) {
            this.this$0 = var1_1;
            this.rep = rep;
            this.fromType = ((VariantInstance)fi).getType();
            try {
                this.edit = new WordHolder.ReplaceFInstanceEdit<F>(fi, rep, ((MainScreen)var1_1).docModel.getDoc(), true);
                this.putValue("Name", this.edit.getActionName());
            }
            catch (InvalidInstanceChangeException ex) {
                var1_1.showException("Error occurred in replacing instance prep.", ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            AbstractUndoableEdit addEdit;
            int o;
            try {
                this.edit.execute();
                this.this$0.undoSupport.postEdit(this.edit);
            }
            catch (InvalidInstanceChangeException ex) {
                this.this$0.showException("Error occurred replacing instance.", ex);
            }
            catch (BadLocationException ex) {
                this.this$0.showException("Error occurred replacing instance in text", ex);
            }
            if (!this.rep.isInDictionary() && (o = JOptionPane.showOptionDialog(frame, "Would you like to add this word to the dictionary?", "Add to dictionary?", 0, 3, null, null, null)) == 0) {
                addEdit = new DocumentModel.AddWordToDictionaryEdit(this.edit.getWordHolder(), this.rep.getReplacementString());
                ((DocumentModel.AddWordToDictionaryEdit)addEdit).execute();
                this.this$0.undoSupport.postEdit(addEdit);
            }
            if (!this.rep.isKnownVariant() && (o = JOptionPane.showOptionDialog(frame, "Would you like to add this replacement to the Known Variant Replacement list?", "Remember replacement?", 0, 3, null, null, null)) == 0) {
                addEdit = new DocumentModel.AddVariantToLookUpEdit(this.rep);
                ((DocumentModel.AddVariantToLookUpEdit)addEdit).execute();
                this.this$0.undoSupport.postEdit(addEdit);
            }
        }
    }

    private static class ReplaceWithAction<F extends VariantInstance>
    extends AbstractAction {
        private static final long serialVersionUID = 6659037788557951900L;
        F fi;
        WordHolder wh;
        boolean isInstance;
        int fromType;
        final /* synthetic */ MainScreen this$0;

        ReplaceWithAction(F fi) {
            this.this$0 = var1_1;
            this.isInstance = true;
            this.fi = fi;
            this.wh = ((Instance)fi).getHolder();
            this.fromType = ((VariantInstance)fi).getType();
            this.putValue("Name", "Replace with...");
        }

        ReplaceWithAction(WordHolder wh, F temp) {
            this.this$0 = var1_1;
            this.isInstance = false;
            this.wh = wh;
            this.fi = temp;
            this.fromType = ((VariantInstance)this.fi).getType();
            this.putValue("Name", "Replace with...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractUndoableEdit addEdit;
            String variantString = this.isInstance ? ((DocumentElement)this.fi).getOriginal() : this.wh.getWord();
            AddOwnVariantDialog.UserInput userInput = new AddOwnVariantDialog().showDialog(frame, variantString, this.isInstance);
            if (userInput == null) {
                return;
            }
            Word newWord = new Word(userInput.getReplacement(), null, true, userInput.isAddRepToDictionary(), 1);
            SuggestedReplacement replacement = new SuggestedReplacement(newWord, variantString, this.this$0.confidenceWeights);
            replacement.setKnownVariant(userInput.isAddVarToUDV(), true);
            replacement.setSoundex(WordUtilities.getSoundexCode(variantString));
            Vector<SuggestedReplacement> wordReplacements = this.wh.getReplacements();
            int where = wordReplacements.indexOf(replacement);
            if (where > -1) {
                replacement = wordReplacements.get(where);
            }
            try {
                AbstractUndoableEdit edit;
                if (userInput.isReplaceAllInstancesOfWord()) {
                    edit = new WordHolder.ReplaceAllFInstancesEdit<F>(this.wh, this.fi, replacement, this.this$0.docModel.getDoc(), true);
                    ThreadedProcessEditHolder tEdit = this.this$0.new ThreadedProcessEditHolder((ThreadableEdit)((Object)edit));
                    tEdit.execute();
                    this.this$0.undoSupport.postEdit(tEdit);
                } else {
                    edit = new WordHolder.ReplaceFInstanceEdit<F>(this.fi, replacement, this.this$0.docModel.getDoc(), true);
                    edit.execute();
                    this.this$0.undoSupport.postEdit(edit);
                }
            }
            catch (BadLocationException ex) {
                this.this$0.showException("Error occurred replacing word", ex);
            }
            catch (InvalidInstanceChangeException ex) {
                this.this$0.showException("Error occurred replacing word", ex);
            }
            if (userInput.isAddRepToDictionary()) {
                addEdit = new DocumentModel.AddWordToDictionaryEdit(this.wh, replacement.getReplacementString());
                ((DocumentModel.AddWordToDictionaryEdit)addEdit).execute();
                this.this$0.undoSupport.postEdit(addEdit);
            }
            if (userInput.isAddVarToUDV()) {
                addEdit = new DocumentModel.AddVariantToLookUpEdit(replacement);
                ((DocumentModel.AddVariantToLookUpEdit)addEdit).execute();
                this.this$0.undoSupport.postEdit(addEdit);
            }
        }
    }

    private class RevertAllReplacedAction
    extends AbstractAction {
        private static final long serialVersionUID = -7964139713034760680L;
        WordHolder.RevertAllReplacedEdit edit;

        RevertAllReplacedAction(WordHolder wh, SuggestedReplacement rep) {
            try {
                this.edit = new WordHolder.RevertAllReplacedEdit(wh, rep, MainScreen.this.docModel.getDoc());
                this.putValue("Name", this.edit.getActionName());
            }
            catch (InvalidInstanceChangeException ex) {
                MainScreen.this.showException("Error occurred in reverting all instances prep.", ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(this.edit);
            tEdit.execute();
            MainScreen.this.undoSupport.postEdit(tEdit);
        }
    }

    private class RevertReplacedInstanceAction
    extends AbstractAction {
        private static final long serialVersionUID = -7964139713034760680L;
        WordHolder.RevertReplacedInstanceEdit edit;

        RevertReplacedInstanceAction(ReplacedInstance ri) {
            try {
                this.edit = new WordHolder.RevertReplacedInstanceEdit(ri, MainScreen.this.docModel.getDoc());
                this.putValue("Name", this.edit.getActionName());
            }
            catch (InvalidInstanceChangeException ex) {
                MainScreen.this.showException("Error occurred in reverting instance prep.", ex);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                this.edit.execute();
                MainScreen.this.undoSupport.postEdit(this.edit);
            }
            catch (InvalidInstanceChangeException ex) {
                MainScreen.this.showException("Error occurred reverting instance.", ex);
            }
            catch (BadLocationException ex) {
                MainScreen.this.showException("Error occurred reverting instance in text", ex);
            }
        }
    }

    private class RuleListManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RuleListManagerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new RuleManager(frame);
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1035721027447348802L;

        SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.save();
                }
            }.start();
        }
    }

    private class SaveAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -7275830361201799128L;

        SaveAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] options;
            int pc;
            JPanel savePanel = new JPanel(new GridLayout(0, 1));
            final JCheckBox docCB = new JCheckBox("Current Document", false);
            final JCheckBox cwCB = new JCheckBox("Confidence Weights", false);
            final JCheckBox dCB = new JCheckBox("Dictionary", false);
            final JCheckBox vCB = new JCheckBox("Variant list", false);
            final JCheckBox rCB = new JCheckBox("Letter replacement rules", false);
            savePanel.add(new JLabel("Tick changes to save:"));
            docCB.setSelected(true);
            savePanel.add(docCB);
            if (ConfidenceWeights.hasChanged()) {
                cwCB.setSelected(true);
                savePanel.add(cwCB);
            }
            if (LookUpDictionary.isWordsChanged()) {
                dCB.setSelected(true);
                savePanel.add(dCB);
            }
            if (LookUpDictionary.isVariantsChanged()) {
                vCB.setSelected(true);
                savePanel.add(vCB);
            }
            if (LookUpDictionary.isRulesChanged()) {
                rCB.setSelected(true);
                savePanel.add(rCB);
            }
            if ((pc = JOptionPane.showOptionDialog(frame, savePanel, "Save changes?", 2, 3, null, options = new Object[]{"Save changes", "Cancel"}, options[0])) == 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (docCB.isSelected() && !MainScreen.this.save()) {
                            return;
                        }
                        try {
                            if (dCB.isSelected()) {
                                MainScreen.this.lud.writeWordsToFile();
                            }
                            if (vCB.isSelected()) {
                                MainScreen.this.lud.writeVariantsToFile();
                            }
                            if (rCB.isSelected()) {
                                MainScreen.this.lud.writeRulesToFile();
                            }
                            if (cwCB.isSelected()) {
                                MainScreen.this.confidenceWeights.save();
                            }
                        }
                        catch (IOException ex) {
                            MainScreen.this.global.showException("Error writing file.", ex);
                        }
                    }
                }).start();
            }
        }
    }

    private class SaveAsPlainAction
    extends AbstractAction {
        private static final long serialVersionUID = 3551298055490692028L;

        SaveAsPlainAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(){

                @Override
                public void run() {
                    MainScreen.this.saveAs();
                }
            }.start();
        }
    }

    private class SaveConfidenceWeightsAction
    extends AbstractAction {
        private static final long serialVersionUID = -7275830361201799128L;

        SaveConfidenceWeightsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.confidenceWeights.save();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing confidence weights.", ex);
                    }
                }
            }).start();
        }
    }

    private class SaveDictionaryAction
    extends AbstractAction {
        private static final long serialVersionUID = 7397383512576562239L;

        SaveDictionaryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.lud.writeWordsToFile();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing words.txt.", ex);
                    }
                }
            }).start();
        }
    }

    private class SaveRulesAction
    extends AbstractAction {
        private static final long serialVersionUID = 7397383512576562239L;

        SaveRulesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.lud.writeRulesToFile();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing rules.txt.", ex);
                    }
                }
            }).start();
        }
    }

    private class SaveVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 7397383512576562239L;

        SaveVariantsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.lud.writeVariantsToFile();
                    }
                    catch (IOException ex) {
                        MainScreen.this.global.showException("Error writing variants.txt.", ex);
                    }
                }
            }).start();
        }
    }

    private class ShowReplacementAnalysisAction
    extends AbstractAction {
        private static final long serialVersionUID = 755767731579580411L;

        ShowReplacementAnalysisAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.docModel.countReplacements();
            String analysis = "Replacement Analysis:";
            int i = 0;
            while (i < 5) {
                analysis = String.valueOf(analysis) + Globals.NEW_LINE + " " + MainScreen.this.docModel.getShortReplacementAnalysis(i);
                ++i;
            }
            Object[] options = new Object[]{"Copy Full Analysis", "Close"};
            int n = JOptionPane.showOptionDialog(frame, analysis, "Replacement Analysis", 2, 1, null, options, options[1]);
            if (n == 0) {
                ClipboardTextTransfer ctt = new ClipboardTextTransfer();
                ctt.setClipboardContents(MainScreen.this.docModel.getReplacementAnalysis());
            }
        }
    }

    private class ThreadedProcessEditHolder
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private ThreadableEdit edit;
        private boolean executed = false;
        private boolean undone = false;

        private ThreadedProcessEditHolder(ThreadableEdit edit) {
            this.edit = edit;
        }

        public void execute() {
            this.executed = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.global.lockFinishProgress();
                        MainScreen.this.global.startIndeterminateProgress();
                        MainScreen.this.global.writeProgressMessage("Executing");
                        ThreadedProcessEditHolder.this.edit.execute();
                        MainScreen.this.global.unlockFinishProgress();
                        MainScreen.this.global.finishProgress();
                    }
                    catch (CannotExecuteException ex) {
                        ThreadedProcessEditHolder.this.executed = false;
                        MainScreen.this.global.showException("Error occurred whilst replacing variants", ex);
                    }
                }
            }).start();
        }

        @Override
        public void undo() throws CannotUndoException {
            this.undone = true;
            new Thread(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.global.lockFinishProgress();
                        MainScreen.this.global.startIndeterminateProgress();
                        MainScreen.this.global.writeProgressMessage("Undoing");
                        ThreadedProcessEditHolder.this.edit.undo();
                        MainScreen.this.global.unlockFinishProgress();
                        MainScreen.this.global.finishProgress();
                    }
                    catch (CannotUndoException ex) {
                        ThreadedProcessEditHolder.this.undone = false;
                        MainScreen.this.global.showException("Error occurred whilst undoing replacing variants", ex);
                    }
                }
            }.start();
        }

        @Override
        public void redo() throws CannotRedoException {
            this.undone = false;
            new Thread(){

                @Override
                public void run() {
                    try {
                        MainScreen.this.global.lockFinishProgress();
                        MainScreen.this.global.startIndeterminateProgress();
                        MainScreen.this.global.writeProgressMessage("Executing");
                        ThreadedProcessEditHolder.this.edit.redo();
                        MainScreen.this.global.unlockFinishProgress();
                        MainScreen.this.global.finishProgress();
                    }
                    catch (CannotRedoException ex) {
                        ThreadedProcessEditHolder.this.undone = true;
                        MainScreen.this.global.showException("Error occurred whilst redoing replacing variants", ex);
                    }
                }
            }.start();
        }

        @Override
        public String getPresentationName() {
            return this.edit.getPresentationName();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }
    }

    private class UIUpdatingUndoManager
    extends UndoManager {
        private static final long serialVersionUID = 1L;
        private StackListModel<String> undoList;
        private StackListModel<String> redoList;

        private UIUpdatingUndoManager() {
            this.setLimit(1000);
            this.undoList = new StackListModel();
            this.redoList = new StackListModel();
        }

        @Override
        public void discardAllEdits() {
            this.undoList.clear();
            this.redoList.clear();
            super.discardAllEdits();
        }

        public void redo(int n) {
            int i = 0;
            while (i < n && this.canRedo()) {
                this.redo();
                ++i;
            }
        }

        public void undo(int n) {
            int i = 0;
            while (i < n && this.canUndo()) {
                this.undo();
                ++i;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                super.undo();
                this.undoList.remove();
                this.redoList.add(this.getRedoPresentationName());
                this.refreshUndoRedoUI();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                super.redo();
                this.redoList.remove();
                this.undoList.add(this.getUndoPresentationName());
                this.refreshUndoRedoUI();
            }
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            boolean toReturn = super.addEdit(edit);
            this.refreshUndoRedoUI();
            this.undoList.add(this.getUndoPresentationName());
            this.redoList.clear();
            return toReturn;
        }

        private void refreshUndoRedoUI() {
            Action undoAction = MainScreen.this.getActionByName("Undo");
            undoAction.setEnabled(this.canUndo());
            if (this.canUndo()) {
                undoAction.putValue("Name", this.getUndoPresentationName());
            } else {
                undoAction.putValue("Name", "Nothing to undo");
            }
            Action redoAction = MainScreen.this.getActionByName("Redo");
            redoAction.setEnabled(this.canRedo());
            if (this.canRedo()) {
                redoAction.putValue("Name", this.getRedoPresentationName());
            } else {
                redoAction.putValue("Name", "Nothing to redo");
            }
        }

        public StackListModel<String> getRedoList() {
            return this.redoList;
        }

        public StackListModel<String> getUndoList() {
            return this.undoList;
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.this.undoManager.undo();
        }
    }
}

