/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import gui.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import model.ExceptionMessageHandler;
import model.Globals;
import model.ProgressListener;
import model.doc.DocumentModel;

public class BatchScreen
implements ActionListener,
ProgressListener,
ExceptionMessageHandler {
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private JButton[] buttons = new JButton[]{new JButton("Add file(s)"), new JButton("Add folder(s)"), new JButton("Remove selected file(s)"), new JButton("Clear list"), new JButton("Process listed file(s)"), new JButton("Exit"), new JButton("Browse")};
    private JList fileList;
    private TreeSet<File> files = new TreeSet();
    private JScrollPane fileListSP;
    private JTextField outputFolderTF;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JFileChooser fc;
    private JFrame frame;
    private JSpinner thresholdSpinner;
    private JCheckBox xmlCheckBox;
    private JCheckBox plainCheckBox;
    private static Globals global;
    private static DocumentModel docModel;

    private BatchScreen() {
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(10);
        this.fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.fileListSP.setAlignmentX(0.0f);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            ++n2;
        }
        JPanel inputButtonsPanel = new JPanel(new GridLayout(6, 1));
        int i = 0;
        while (i < 4) {
            inputButtonsPanel.add(this.buttons[i]);
            ++i;
        }
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        inputPanel.add((Component)this.fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        JPanel thresholdPanel = new JPanel(new SpringLayout());
        JLabel thresholdLabel = new JLabel("Threshold (/100%):", 11);
        thresholdPanel.add(thresholdLabel);
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 100, 5));
        thresholdLabel.setLabelFor(this.thresholdSpinner);
        thresholdPanel.add(this.thresholdSpinner);
        SpringUtilities.makeCompactGrid(thresholdPanel, 1, 2, 6, 6, 6, 6);
        JPanel threshPanel = new JPanel();
        threshPanel.setBorder(BorderFactory.createTitledBorder("Threshold"));
        threshPanel.add(thresholdPanel);
        JPanel outputTypePanel = new JPanel(new GridLayout(2, 1));
        this.plainCheckBox = new JCheckBox("Original Format (Changes Unmarked)");
        this.xmlCheckBox = new JCheckBox("XML Format (Changes Tagged)");
        outputTypePanel.add(this.plainCheckBox);
        outputTypePanel.add(this.xmlCheckBox);
        JPanel outputFilePanel = new JPanel(new SpringLayout());
        JLabel folderLabel = new JLabel("Output Folder:", 11);
        outputFilePanel.add(folderLabel);
        this.outputFolderTF = new JTextField(20);
        folderLabel.setLabelFor(this.outputFolderTF);
        outputFilePanel.add(this.outputFolderTF);
        outputFilePanel.add(this.buttons[6]);
        SpringUtilities.makeCompactGrid(outputFilePanel, 1, 3, 6, 6, 6, 6);
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        outputPanel.add((Component)outputTypePanel, "Center");
        outputPanel.add((Component)outputFilePanel, "South");
        JPanel bottomButtons = new JPanel(new GridLayout(1, 2));
        bottomButtons.add(this.buttons[4]);
        bottomButtons.add(this.buttons[5]);
        this.progressLabel = new JLabel("");
        this.progressBar = new JProgressBar(0);
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        progressPanel.add(this.progressLabel);
        progressPanel.add(this.progressBar);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)inputPanel, "Center");
        topPanel.add((Component)threshPanel, "South");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)progressPanel, "Center");
        bottomPanel.add((Component)bottomButtons, "South");
        this.fc = new JFileChooser();
        this.frame = new JFrame("VARD 2 Batch Process");
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)outputPanel, "Center");
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setLocation(BatchScreen.SCREEN_SIZE.width / 2 - this.frame.getWidth() / 2, BatchScreen.SCREEN_SIZE.height / 2 - this.frame.getHeight() / 2);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public static void run() {
        global = Globals.getInstance();
        new Thread(){

            @Override
            public void run() {
                global.startIndeterminateProgress();
                global.writeProgressMessage("Loading user interface...");
                BatchScreen ui = new BatchScreen(null);
                global.finishProgress();
                global.setProgressHandler(ui);
                global.setExceptionHandler(ui);
                docModel = DocumentModel.getInstance();
            }
        }.start();
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        int buttonNumber = -1;
        int i = 0;
        while (i < this.buttons.length) {
            if (a.getSource().equals(this.buttons[i])) {
                buttonNumber = i;
            }
            ++i;
        }
        switch (buttonNumber) {
            case 0: {
                this.fc.setFileSelectionMode(0);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal = this.fc.showOpenDialog(this.frame);
                if (returnVal != 0) break;
                new Thread(){

                    @Override
                    public void run() {
                        File[] filesSelected = BatchScreen.this.fc.getSelectedFiles();
                        global.startProgress(filesSelected.length);
                        global.writeProgressMessage("Adding files...");
                        int count = 0;
                        File[] fileArray = filesSelected;
                        int n = filesSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            BatchScreen.this.files.add(file);
                            global.setProgressCurrent(++count);
                            ++n2;
                        }
                        BatchScreen.this.fileList.setListData(BatchScreen.this.files.toArray());
                        global.finishProgress();
                    }
                }.start();
                break;
            }
            case 1: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal2 = this.fc.showOpenDialog(this.frame);
                if (returnVal2 != 0) break;
                new Thread(){

                    @Override
                    public void run() {
                        global.startIndeterminateProgress();
                        File[] foldersSelected = BatchScreen.this.fc.getSelectedFiles();
                        int totalFolders = foldersSelected.length;
                        int folderCount = 0;
                        File[] fileArray = foldersSelected;
                        int n = foldersSelected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File folder = fileArray[n2];
                            if (global.isSearchSubfolders()) {
                                BatchScreen.walkFolder(BatchScreen.this.files, folder);
                            } else {
                                File[] filesFromFolder = folder.listFiles();
                                global.startProgress(filesFromFolder.length);
                                global.writeProgressMessage("Adding files from " + folder.getName() + "(" + ++folderCount + "/" + totalFolders + ")...");
                                int fileCount = 0;
                                File[] fileArray2 = filesFromFolder;
                                int n3 = filesFromFolder.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File file = fileArray2[n4];
                                    if (!(file.isDirectory() || file.isHidden() || BatchScreen.this.files.contains(file))) {
                                        BatchScreen.this.files.add(file);
                                    }
                                    global.setProgressCurrent(++fileCount);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        BatchScreen.this.fileList.setListData(BatchScreen.this.files.toArray());
                        global.finishProgress();
                    }
                }.start();
                break;
            }
            case 2: {
                Object[] objectArray = this.fileList.getSelectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object file = objectArray[n2];
                    this.files.remove(file);
                    ++n2;
                }
                this.fileList.setListData(this.files.toArray());
                break;
            }
            case 3: {
                this.files.clear();
                this.fileList.setListData(this.files.toArray());
                break;
            }
            case 4: {
                String outputFolderString = this.outputFolderTF.getText();
                if (this.files.size() == 0) {
                    this.displayError("Please provide atleast one file to process.");
                    return;
                }
                if (outputFolderString.equals("")) {
                    this.displayError("Please provide an output folder.");
                    return;
                }
                File outputFolder = new File(outputFolderString);
                if (!outputFolder.isDirectory()) {
                    this.displayError("Output folder must not be a file.");
                    return;
                }
                new Thread(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }.start();
                break;
            }
            case 5: {
                System.exit(0);
                break;
            }
            case 6: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(false);
                int saveReturnVal = this.fc.showSaveDialog(this.frame);
                if (saveReturnVal != 0) break;
                String ofs = this.fc.getSelectedFile().getPath();
                ofs = ofs.substring(0, ofs.lastIndexOf(File.separator));
                this.outputFolderTF.setText(ofs);
            }
        }
    }

    private void setButtonsEnabled(boolean e) {
        this.buttons[0].setEnabled(e);
        this.buttons[1].setEnabled(e);
        this.buttons[2].setEnabled(e);
        this.buttons[3].setEnabled(e);
        this.buttons[4].setEnabled(e);
        this.buttons[6].setEnabled(e);
        this.thresholdSpinner.setEnabled(e);
        this.outputFolderTF.setEditable(e);
        this.xmlCheckBox.setEnabled(e);
        this.plainCheckBox.setEnabled(e);
    }

    @Override
    public void finishProgress() {
        this.progressBar.setIndeterminate(false);
        this.setButtonsEnabled(true);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.progressLabel.setText(message);
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(MainScreen.frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    public void displayError(String message) {
        JOptionPane.showMessageDialog(MainScreen.frame, message, "Error", 0);
    }

    public String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    @Override
    public void setProgressCurrent(int current) {
        this.progressBar.setValue(current);
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        this.progressBar.setIndeterminate(true);
        this.setButtonsEnabled(false);
    }

    @Override
    public void startProgress(int max) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(max);
        this.setButtonsEnabled(false);
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                BatchScreen.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    /* synthetic */ BatchScreen(BatchScreen batchScreen) {
        this();
    }

    static /* synthetic */ JTextField access$7(BatchScreen batchScreen) {
        return batchScreen.outputFolderTF;
    }

    static /* synthetic */ JSpinner access$8(BatchScreen batchScreen) {
        return batchScreen.thresholdSpinner;
    }

    static /* synthetic */ DocumentModel access$9() {
        return docModel;
    }

    static /* synthetic */ JCheckBox access$10(BatchScreen batchScreen) {
        return batchScreen.plainCheckBox;
    }

    static /* synthetic */ JCheckBox access$11(BatchScreen batchScreen) {
        return batchScreen.xmlCheckBox;
    }
}

