/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AddOwnVariantDialog {
    AddOwnVariantDialog() {
    }

    UserInput showDialog(JFrame owner, String variant, boolean isInstance) {
        JLabel variantLabel = new JLabel("Replace " + variant + " with:");
        JTextField replacementTF = new JTextField(15);
        replacementTF.setText(variant);
        JCheckBox replaceAllInstancesOfWordCB = new JCheckBox("Replace all instances of variant", false);
        JCheckBox addVarToUDVCB = new JCheckBox("Remember replacement", true);
        JCheckBox addRepToDictionaryCB = new JCheckBox("Add replacement to dictionary (if not already present)", true);
        if (!isInstance) {
            replaceAllInstancesOfWordCB.setSelected(true);
            replaceAllInstancesOfWordCB.setEnabled(false);
        }
        JPanel main = new JPanel(new GridLayout(5, 1));
        main.add(variantLabel);
        main.add(replacementTF);
        main.add(replaceAllInstancesOfWordCB);
        main.add(addVarToUDVCB);
        main.add(addRepToDictionaryCB);
        replacementTF.selectAll();
        int val = JOptionPane.showConfirmDialog(owner, main, "Replace " + variant, 2, -1);
        while (val == 0) {
            if (!replacementTF.getText().equals("")) {
                return new UserInput(variant, replacementTF.getText(), replaceAllInstancesOfWordCB.isSelected(), addVarToUDVCB.isSelected(), addRepToDictionaryCB.isSelected());
            }
            JOptionPane.showMessageDialog(owner, "Please enter a replacement", "Error", 2);
            val = JOptionPane.showConfirmDialog(owner, main, "Replace " + variant, 2, -1);
        }
        return null;
    }

    static class UserInput {
        String variant;
        String replacement;
        boolean addVarToUDV;
        boolean addRepToDictionary;
        boolean replaceAllInstancesOfWord;

        private UserInput(String variant, String replacement, boolean replaceAllInstancesOfWord, boolean addVarToUDV, boolean addRepToDictionary) {
            this.variant = variant;
            this.replacement = replacement;
            this.replaceAllInstancesOfWord = replaceAllInstancesOfWord;
            this.addVarToUDV = addVarToUDV;
            this.addRepToDictionary = addRepToDictionary;
        }

        String getVariant() {
            return this.variant;
        }

        String getReplacement() {
            return this.replacement;
        }

        boolean isAddVarToUDV() {
            return this.addVarToUDV;
        }

        boolean isAddRepToDictionary() {
            return this.addRepToDictionary;
        }

        boolean isReplaceAllInstancesOfWord() {
            return this.replaceAllInstancesOfWord;
        }
    }
}

