/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import gui.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import model.Globals;
import model.lookup.LookUpDictionary;
import model.lookup.Rule;

public class RuleManager
implements ActionListener {
    private JButton[] buttons = new JButton[]{new JButton("Remove selected rule(s)"), new JButton("Revert rule list"), new JButton("Add"), new JButton("Clear")};
    private JList ruleList;
    private JScrollPane ruleListSP;
    private JTextField origTF;
    private JTextField repTF;
    private JComboBox posCB;
    private String[] cbOps = new String[]{"Start", "End", "Anywhere"};
    private Vector<Rule> sessionRules;
    private static LookUpDictionary lud;
    private boolean ruleListChanged = false;
    private String ruleChangeLog = "";

    public RuleManager(JFrame owner) {
        lud = LookUpDictionary.getInstance();
        this.sessionRules = new Vector();
        this.sessionRules.addAll(lud.getRules());
        this.ruleList = new JList<Rule>(this.sessionRules);
        this.ruleList.setVisibleRowCount(10);
        this.ruleListSP = new JScrollPane(this.ruleList, 22, 32);
        this.ruleListSP.setAlignmentX(0.0f);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            ++n2;
        }
        JPanel ruleListButtonsPanel = new JPanel(new GridLayout(6, 1));
        ruleListButtonsPanel.add(this.buttons[0]);
        ruleListButtonsPanel.add(this.buttons[1]);
        ruleListButtonsPanel.add(Box.createVerticalGlue());
        ruleListButtonsPanel.add(Box.createVerticalGlue());
        ruleListButtonsPanel.add(Box.createVerticalGlue());
        ruleListButtonsPanel.add(Box.createVerticalGlue());
        JPanel ruleListPanel = new JPanel(new BorderLayout());
        ruleListPanel.setBorder(BorderFactory.createTitledBorder("Rule List"));
        ruleListPanel.add((Component)this.ruleListSP, "Center");
        ruleListPanel.add((Component)ruleListButtonsPanel, "East");
        this.origTF = new JTextField(8);
        this.repTF = new JTextField(8);
        this.posCB = new JComboBox<String>(this.cbOps);
        JPanel addRulePanel = new JPanel(new SpringLayout());
        JLabel origLabel = new JLabel("Original:", 11);
        addRulePanel.add(origLabel);
        origLabel.setLabelFor(this.origTF);
        addRulePanel.add(this.origTF);
        JLabel repLabel = new JLabel("Replacement:", 11);
        addRulePanel.add(repLabel);
        repLabel.setLabelFor(this.repTF);
        addRulePanel.add(this.repTF);
        JLabel posLabel = new JLabel("Position:", 11);
        addRulePanel.add(posLabel);
        posLabel.setLabelFor(this.posCB);
        addRulePanel.add(this.posCB);
        SpringUtilities.makeCompactGrid(addRulePanel, 3, 2, 6, 6, 6, 6);
        JPanel addRuleButtonsPanel = new JPanel(new GridLayout(1, 4));
        addRuleButtonsPanel.add(Box.createVerticalGlue());
        addRuleButtonsPanel.add(this.buttons[2]);
        addRuleButtonsPanel.add(this.buttons[3]);
        addRuleButtonsPanel.add(Box.createVerticalGlue());
        JPanel fullAddRulePanel = new JPanel(new BorderLayout());
        fullAddRulePanel.setBorder(BorderFactory.createTitledBorder("Add Rule"));
        fullAddRulePanel.add((Component)addRulePanel, "Center");
        fullAddRulePanel.add((Component)addRuleButtonsPanel, "South");
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)ruleListPanel, "North");
        main.add((Component)fullAddRulePanel, "South");
        Object[] options = new Object[]{"Finished", "Discard"};
        int n3 = JOptionPane.showOptionDialog(owner, main, "Rule List Manager", 2, -1, null, options, null);
        if (n3 == 0 && this.ruleListChanged) {
            lud.setRules(this.sessionRules);
            lud.setRulesChanged(true, this.ruleChangeLog);
            JOptionPane.showMessageDialog(owner, "Rule list updated successfully.\nRemember to save the rule list if you wish the rule changes to be applied in future sessions.");
        }
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        int buttonNumber = -1;
        int i = 0;
        while (i < this.buttons.length) {
            if (a.getSource().equals(this.buttons[i])) {
                buttonNumber = i;
            }
            ++i;
        }
        switch (buttonNumber) {
            case 0: {
                Object[] selectedRules = this.ruleList.getSelectedValues();
                int i2 = 0;
                while (i2 < selectedRules.length) {
                    this.sessionRules.remove(selectedRules[i2]);
                    this.ruleChangeLog = String.valueOf(this.ruleChangeLog) + Globals.NEW_LINE + "Removed: " + selectedRules[i2];
                    ++i2;
                }
                this.ruleList.setListData(this.sessionRules);
                this.ruleListChanged = true;
                break;
            }
            case 1: {
                this.sessionRules = new Vector();
                this.sessionRules.addAll(lud.getRules());
                this.ruleList.setListData(this.sessionRules);
                this.ruleListChanged = false;
                this.ruleChangeLog = "";
                break;
            }
            case 2: {
                if (this.origTF.getText().equals("") && this.repTF.getText().equals("")) {
                    JOptionPane.showMessageDialog(MainScreen.frame, "Original and Replacement fields can't both be empty.", "Error", 0);
                    return;
                }
                Rule.Position pos = Rule.Position.Anywhere;
                if (this.posCB.getSelectedIndex() == 0) {
                    pos = Rule.Position.Start;
                } else if (this.posCB.getSelectedIndex() == 1) {
                    pos = Rule.Position.End;
                }
                Rule r = new Rule(this.origTF.getText(), this.repTF.getText(), pos, true);
                this.sessionRules.add(r);
                this.ruleChangeLog = String.valueOf(this.ruleChangeLog) + Globals.NEW_LINE + "added: " + r;
                this.ruleList.setListData(this.sessionRules);
                this.ruleListChanged = true;
                break;
            }
            case 3: {
                this.origTF.setText("");
                this.repTF.setText("");
                this.posCB.setSelectedIndex(0);
            }
        }
    }
}

