/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainScreen;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import model.ProgressListener;

public class ProcessingScreen
implements ProgressListener {
    private JProgressBar progressBar;
    private JLabel label = new JLabel(MainScreen.LOADING_ICON);
    private JFrame frame;
    private static ProcessingScreen _instance = null;

    public static ProcessingScreen getInstance() {
        if (_instance == null) {
            _instance = new ProcessingScreen();
        }
        return _instance;
    }

    protected ProcessingScreen() {
        this.label.setFont(new Font("Verdana", 1, 14));
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.frame = new JFrame("Processing...");
        this.frame.setDefaultCloseOperation(3);
        Rectangle maxWinSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.frame.setLocation(maxWinSize.width / 2 - 150, maxWinSize.height / 2 - 75);
        this.frame.setSize(300, 150);
        this.frame.setResizable(false);
        this.frame.getContentPane().add((Component)this.label, "Center");
        this.frame.getContentPane().add((Component)this.progressBar, "South");
    }

    private void show() {
        this.frame.setVisible(true);
    }

    private void hide() {
        this.frame.setVisible(false);
    }

    private void setText(String text) {
        this.label.setText(text);
    }

    @Override
    public void writeProgressMessage(String message) {
        this.setText(message);
    }

    @Override
    public void finishProgress() {
        this.progressBar.setIndeterminate(false);
        this.hide();
    }

    @Override
    public void setProgressCurrent(int current) {
        this.progressBar.setValue(current);
    }

    @Override
    public void terminateProgressDisplay() {
        this.frame.dispose();
    }

    @Override
    public void startIndeterminateProgress() {
        this.progressBar.setIndeterminate(true);
        this.show();
    }

    @Override
    public void startProgress(int max) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(max);
        this.show();
    }
}

