/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.BatchScreen;
import gui.ExceptionDisplay;
import gui.MainScreen;
import gui.ProcessingScreen;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import model.Globals;

public class GUISelector
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    JButton[] buttons = new JButton[2];
    private static Globals global;

    public GUISelector() {
        this.setTitle("Select User Interface");
        this.buttons[0] = new JButton("Interactive");
        this.buttons[1] = new JButton("Batch");
        JPanel main = new JPanel(new GridLayout(this.buttons.length, 1));
        int i = 0;
        while (i < this.buttons.length) {
            main.add(this.buttons[i]);
            this.buttons[i].addActionListener(this);
            this.buttons[i].setFont(new Font("Verdana", 1, 20));
            ++i;
        }
        this.setSize(this.buttons.length * 200, 200);
        this.setDefaultCloseOperation(3);
        this.setContentPane(main);
        this.setLocation(GUISelector.SCREEN_SIZE.width / 2 - this.getWidth() / 2, GUISelector.SCREEN_SIZE.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error occurred setting look and feel.\n\n" + ex.getMessage(), "Error", 0);
        }
        global = Globals.getInstance();
        global.setExceptionHandler(ExceptionDisplay.getInstance());
        global.setProgressHandler(ProcessingScreen.getInstance());
        new GUISelector();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.buttons[0]) {
            this.dispose();
            MainScreen.run();
        } else if (ae.getSource() == this.buttons[1]) {
            this.dispose();
            BatchScreen.run();
        }
    }
}

