/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.PrintWriter;
import java.util.TreeSet;
import model.lookup.Node;
import model.lookup.Variant;
import model.lookup.Word;

public class VariantHolder
extends Node {
    private static final long serialVersionUID = 7030014296928387061L;
    private TreeSet<Variant> variants;
    private String variantString;

    public VariantHolder(String vs, Node node) {
        super(Character.valueOf(vs.charAt(vs.length() - 1)));
        if (node != null) {
            this.next = node.next;
        }
        this.variantString = vs;
        this.variants = new TreeSet();
    }

    @Override
    boolean isWord() {
        return true;
    }

    TreeSet<Variant> getVariants() {
        return this.variants;
    }

    public void writeToFile(PrintWriter writer) {
        for (Variant v : this.variants) {
            v.writeToFile(writer);
        }
    }

    boolean addVariant(Word rep, boolean userAdded) {
        Variant toAdd = new Variant(this.variantString, rep, userAdded);
        if (this.variants.contains(toAdd)) {
            return false;
        }
        this.variants.add(toAdd);
        return true;
    }

    String getVariantString() {
        return this.variantString;
    }
}

