/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import model.lookup.Word;

public class Variant
implements Comparable<Variant> {
    private static final long serialVersionUID = -6390838429688584138L;
    private String variant;
    private int variantLength;
    private Word actual;
    private char[] letters = new char[3];
    private boolean userAdded;

    public Variant(String v, Word a, boolean userAdded) throws NullPointerException {
        this.variant = v.toLowerCase().trim();
        this.variantLength = this.variant.length();
        this.actual = a;
        this.userAdded = userAdded;
        if (this.actual == null) {
            throw new NullPointerException("Word not found for " + v);
        }
        int i = 0;
        while (i < 3) {
            this.letters[i] = this.variantLength < i + 1 ? 126 : this.variant.charAt(i);
            ++i;
        }
    }

    public void writeToFile(PrintWriter writer) {
        writer.println(String.valueOf(this.variant) + "\t" + this.actual.getWord() + (this.userAdded ? "\t#" : ""));
    }

    public String getVariant() {
        return this.variant;
    }

    public Word getActual() {
        return this.actual;
    }

    public char getChar(int i) {
        return this.letters[i];
    }

    @Override
    public int compareTo(Variant v) {
        int c = this.getVariant().compareTo(v.getVariant());
        if (c == 0) {
            return this.getActual().compareTo(v.getActual());
        }
        return c;
    }

    public boolean equals(Variant v) {
        if (this.getVariant().equals(v.getVariant())) {
            return this.getActual().equals(v.getActual());
        }
        return false;
    }

    public boolean equals(String s) {
        return this.getVariant().equals(s);
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    public char[] getLetters() {
        return this.letters;
    }

    public void setLetters(char[] letters) {
        this.letters = letters;
    }

    public int getVariantLength() {
        return this.variantLength;
    }

    public void setVariantLength(int variantLength) {
        this.variantLength = variantLength;
    }

    public void setActual(Word actual) {
        this.actual = actual;
    }

    public void setUserAdded(boolean userAdded) {
        this.userAdded = userAdded;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    static void readFile(File file, VariantAction todo) throws IOException {
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-16"));
        String currentLine = "file not ready";
        try {
            while ((currentLine = textIn.readLine()) != null) {
                String[] currentLineArray = currentLine.split("\t");
                todo.process(currentLineArray[0], currentLineArray[1], currentLineArray.length > 2 && currentLineArray[2].equals("#"));
            }
        }
        finally {
            textIn.close();
        }
    }

    static interface VariantAction {
        public void process(String var1, String var2, boolean var3);
    }
}

