/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import model.ConfidenceWeights;
import model.Globals;
import model.SuggestedReplacement;
import model.lookup.FlaggedString;
import model.lookup.Node;
import model.lookup.Rule;
import model.lookup.SoundexHolder;
import model.lookup.Variant;
import model.lookup.VariantHolder;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class LookUpDictionary {
    private static final long serialVersionUID = 5689122285204299967L;
    private TreeMap<Character, Node> words;
    private TreeMap<Character, Node> variants;
    private TreeSet<Rule> rules;
    private TreeMap<Character, Node> soundex;
    private InputStream realListIS;
    private InputStream ruleListIS;
    private InputStream variantListIS;
    private static Globals global;
    private static boolean wordsChanged;
    private static boolean variantsChanged;
    private static boolean rulesChanged;
    private static String wordsLog;
    private static String variantsLog;
    private static String rulesLog;
    private static LookUpDictionary _instance;
    private static Vector<DataChangeListener> dataChangeListeners;

    static {
        wordsLog = "";
        variantsLog = "";
        rulesLog = "";
        _instance = null;
        dataChangeListeners = new Vector();
    }

    protected LookUpDictionary() {
        block11: {
            this.words = new TreeMap();
            this.variants = new TreeMap();
            this.rules = new TreeSet();
            this.soundex = new TreeMap();
            global = Globals.getInstance();
            this.words = new TreeMap();
            this.soundex = new TreeMap();
            global.startIndeterminateProgress();
            global.writeProgressMessage("Initializing...");
            global.lockFinishProgress();
            try {
                try {
                    File wordsSource = new File("saved data/words.txt");
                    File variantsSource = new File("saved data/variants.txt");
                    File rulesSource = new File("saved data/rules.txt");
                    wordsSource.getParentFile().mkdirs();
                    boolean writeWordsFile = false;
                    if (wordsSource.exists()) {
                        global.writeProgressMessage("Loading words.txt...");
                        Word.readFile(wordsSource, new Word.WordAction(){

                            @Override
                            public void process(String word, int freq, boolean userAdded) {
                                LookUpDictionary.this.addWord(word, freq, userAdded);
                            }
                        });
                    } else {
                        this.readInRealWordList();
                        this.readInScowlWordList();
                        writeWordsFile = true;
                    }
                    if (variantsSource.exists()) {
                        global.writeProgressMessage("Loading variants.txt...");
                        Variant.readFile(variantsSource, new Variant.VariantAction(){

                            @Override
                            public void process(String variant, String replacement, boolean userAdded) {
                                Word word = LookUpDictionary.this.findWord(replacement);
                                if (word == null) {
                                    word = new Word(replacement, null, false, true, 1);
                                }
                                LookUpDictionary.this.addVariant(variant, word, userAdded);
                            }
                        });
                    } else {
                        this.readInVariantList();
                        this.writeVariantsToFile();
                        writeWordsFile = true;
                    }
                    if (writeWordsFile) {
                        this.writeWordsToFile();
                    }
                    if (rulesSource.exists()) {
                        global.writeProgressMessage("Loading rules.txt...");
                        Rule.readFile(rulesSource, new Rule.RuleAction(){

                            @Override
                            public void process(String original, String replacement, Rule.Position position, boolean userAdded) {
                                LookUpDictionary.this.rules.add(new Rule(original, replacement, position, userAdded));
                            }
                        });
                        break block11;
                    }
                    this.readInRules();
                    this.writeRulesToFile();
                }
                catch (IOException e) {
                    global.showException("Error occurred during initializing, if problem persists, re-install.", e);
                    global.unlockFinishProgress();
                    global.finishProgress();
                }
            }
            finally {
                global.unlockFinishProgress();
                global.finishProgress();
            }
        }
    }

    public static LookUpDictionary getInstance() {
        if (_instance == null) {
            _instance = new LookUpDictionary();
        }
        return _instance;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(DataChangeListener listener) {
        dataChangeListeners.remove(listener);
    }

    private void readInVariantList() throws IOException {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Reading variant list...");
        this.variants = new TreeMap();
        this.variantListIS = LookUpDictionary.class.getResourceAsStream("predef/variantlist.txt");
        if (this.variantListIS == null) {
            global.showException("Error occurred reading default variant list", new FileNotFoundException("Default variant list not found"));
            global.finishProgress();
            return;
        }
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader(this.variantListIS));
        String currentLine = "file not ready";
        String[] currentLineArray = new String[3];
        boolean invalidWord = false;
        try {
            try {
                while (!currentLine.equals("end")) {
                    if (!textIn.ready() || (currentLine = textIn.readLine()).equals("end")) continue;
                    currentLineArray = currentLine.split("\t");
                    String currentVariant = currentLineArray[1].trim();
                    String currentWord = currentLineArray[2].trim();
                    invalidWord = false;
                    if (!WordUtilities.isValidWord(currentWord) || currentWord.endsWith("'") || currentWord.startsWith("'")) {
                        invalidWord = true;
                    }
                    if (!WordUtilities.isValidWord(currentVariant)) {
                        invalidWord = true;
                    }
                    if (invalidWord) continue;
                    Word word = this.findWord(currentWord);
                    if (word == null) {
                        word = new Word(currentWord, null, false, true, 1);
                    }
                    this.addVariant(currentVariant, word, false);
                }
                this.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "Variants list (re)initialized");
            }
            catch (IOException e) {
                global.showException("Error occurred reading default variant list", e);
                global.finishProgress();
                textIn.close();
            }
        }
        finally {
            global.finishProgress();
            textIn.close();
        }
    }

    private void readInScowlWordList() throws IOException {
        int wordCount = 0;
        File scowlFolder = new File("scowl/");
        File[] files = scowlFolder.listFiles();
        if (files == null || files.length < 1) {
            global.showException("Error occurred reading SCOWL word list, please reinstall.", new FileNotFoundException("SCOWL word lists not found"));
            global.finishProgress();
            return;
        }
        global.startProgress(files.length);
        global.writeProgressMessage("Reading SCOWL word lists...");
        int count = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                File file = fileArray[n2];
                LineNumberReader textIn = new LineNumberReader(new FileReader(file));
                try {
                    String currentLine = "file not ready";
                    int freq = 100 - Integer.parseInt(file.getName().substring(file.getName().lastIndexOf(46) + 1));
                    int notReadyCount = 0;
                    while (!textIn.ready() && notReadyCount < 1000) {
                        ++count;
                        System.out.println(String.valueOf(file.getName()) + " not ready.");
                    }
                    while ((currentLine = textIn.readLine()) != null) {
                        String currentWord;
                        if (currentLine.equals("") || !WordUtilities.isValidWord(currentWord = currentLine.trim()) || currentWord.endsWith("'") || currentWord.startsWith("'")) continue;
                        if (!this.addWord(currentWord, freq, false)) {
                            Word exists = this.findWord(currentWord);
                            exists.setFreq(Math.max(exists.getFreq(), freq));
                            continue;
                        }
                        ++wordCount;
                    }
                }
                catch (FileNotFoundException e) {
                    global.showException("Error occurred reading SCOWL word lists", e);
                    global.finishProgress();
                    textIn.close();
                    break block12;
                }
                catch (IOException e) {
                    try {
                        global.showException("Error occurred reading SCOWL word lists", e);
                        global.finishProgress();
                        break block12;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        textIn.close();
                    }
                }
                textIn.close();
            }
            global.setProgressCurrent(++count);
            ++n2;
        }
        global.finishProgress();
    }

    private void readInRealWordList() throws IOException {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Reading BNC Word List...");
        this.realListIS = LookUpDictionary.class.getResourceAsStream("predef/realwordlist.txt");
        if (this.realListIS == null) {
            global.showException("Error occurred reading BNC Word List", new FileNotFoundException("BNC Word list not found"));
            global.finishProgress();
            return;
        }
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader(this.realListIS));
        String currentLine = "file not ready";
        String[] currentLineArray = new String[7];
        int currentRange = 0;
        int currentFreq = 0;
        try {
            try {
                while (!currentLine.equals("end")) {
                    String currentWord;
                    if (!textIn.ready() || (currentLine = textIn.readLine()).equals("end")) continue;
                    currentLineArray = currentLine.split("\t");
                    if (currentLineArray[3].equals(":")) {
                        currentWord = currentLineArray[1].trim();
                        currentFreq = Integer.parseInt(currentLineArray[4]);
                        currentRange = Integer.parseInt(currentLineArray[5]);
                    } else if (currentLineArray[1].equals("@")) {
                        currentWord = currentLineArray[3].trim();
                        currentFreq = Integer.parseInt(currentLineArray[4]);
                    } else {
                        currentFreq = Integer.parseInt(currentLineArray[4]);
                        currentRange = Integer.parseInt(currentLineArray[5]);
                        continue;
                    }
                    if (!WordUtilities.isValidWord(currentWord) || currentWord.endsWith("'") || currentWord.startsWith("'") || currentRange < 50 || currentFreq < 1 || this.addWord(currentWord, currentFreq, false)) continue;
                    Word exists = this.findWord(currentWord);
                    exists.setFreq(exists.getFreq() + currentFreq);
                }
                this.addWord("I", 8875, false);
                this.addWord("a", 21626, false);
                this.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "Words list (re)initialized");
            }
            catch (IOException e) {
                global.showException("Error occurred reading BNC word list", e);
                global.finishProgress();
                textIn.close();
            }
        }
        finally {
            global.finishProgress();
            textIn.close();
        }
    }

    private void readInRules() throws IOException {
        global.startIndeterminateProgress();
        global.writeProgressMessage("Reading default rules list...");
        this.rules = new TreeSet();
        this.ruleListIS = LookUpDictionary.class.getResourceAsStream("predef/rulelist.txt");
        if (this.ruleListIS == null) {
            global.showException("Error occurred reading default rule list", new FileNotFoundException("Default rule list not found"));
            global.finishProgress();
            return;
        }
        LineNumberReader textIn = new LineNumberReader(new InputStreamReader(this.ruleListIS));
        String currentLine = "file not ready";
        Rule.Position currentPos = Rule.Position.Anywhere;
        try {
            try {
                while (!currentLine.equals("end")) {
                    if (!textIn.ready() || (currentLine = textIn.readLine()).equals("end") || currentLine.charAt(0) == '#') continue;
                    String[] currentLineArray = currentLine.split("\t");
                    if (currentLineArray[0].startsWith("^")) {
                        currentPos = Rule.Position.Start;
                        currentLineArray[0] = currentLineArray[0].substring(1);
                    } else if (currentLineArray[0].endsWith("$")) {
                        currentPos = Rule.Position.End;
                        currentLineArray[0] = currentLineArray[0].substring(0, currentLineArray[0].length() - 1);
                    } else {
                        currentPos = Rule.Position.Anywhere;
                    }
                    if (currentLineArray[1].equals(" ")) {
                        currentLineArray[1] = "";
                    }
                    Rule r = new Rule(currentLineArray[0], currentLineArray[1], currentPos, false);
                    this.rules.add(r);
                }
                this.setRulesChanged(true, String.valueOf(Globals.NEW_LINE) + "Rules list (re)initialized");
            }
            catch (IOException e) {
                global.showException("Error occurred reading default rule list", e);
                global.finishProgress();
                textIn.close();
            }
        }
        finally {
            global.finishProgress();
            textIn.close();
        }
    }

    private void postOrder(Node node, NodeProcessor processor) {
        for (Node n : node.next.values()) {
            this.postOrder(n, processor);
        }
        processor.processNode(node);
    }

    public void writeRulesToFile() throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("saved data/rules.txt"), "UTF-16"));
        File lFile = new File("logs/rules_change_log.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lFile, true), "UTF-16"));
        global.startProgress(this.rules.size());
        global.writeProgressMessage("Saving rules list");
        try {
            for (Rule r : this.rules) {
                r.writeToFile(writer);
            }
            if (rulesChanged) {
                logWriter.println(rulesLog);
                this.setRulesChanged(false, null);
            }
        }
        finally {
            global.finishProgress();
            writer.close();
            logWriter.close();
        }
    }

    public void writeVariantsToFile() throws IOException {
        final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("saved data/variants.txt"), "UTF-16"));
        File lFile = new File("logs/variants_change_log.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lFile, true), "UTF-16"));
        global.startIndeterminateProgress();
        global.writeProgressMessage("Saving variants list");
        try {
            Node variantsRoot = new Node(Character.valueOf('@'));
            variantsRoot.next = this.variants;
            this.postOrder(variantsRoot, new NodeProcessor(){

                @Override
                public void processNode(Node node) {
                    if (node.isWord()) {
                        ((VariantHolder)node).writeToFile(writer);
                    }
                }
            });
            if (variantsChanged) {
                logWriter.println(variantsLog);
                this.setVariantsChanged(false, null);
            }
        }
        finally {
            global.finishProgress();
            writer.close();
            logWriter.close();
        }
    }

    public void writeWordsToFile() throws IOException {
        final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("saved data/words.txt"), "UTF-16"));
        File lFile = new File("logs/words_change_log.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(lFile, true), "UTF-16"));
        global.startIndeterminateProgress();
        global.writeProgressMessage("Saving dictionary");
        try {
            Node wordsRoot = new Node(Character.valueOf('@'));
            wordsRoot.next = this.words;
            this.postOrder(wordsRoot, new NodeProcessor(){

                @Override
                public void processNode(Node node) {
                    if (node.isWord()) {
                        ((Word)node).writeToFile(writer);
                    }
                }
            });
            if (wordsChanged) {
                logWriter.println(wordsLog);
                this.setWordsChanged(false, null);
            }
        }
        finally {
            global.finishProgress();
            writer.close();
            logWriter.close();
        }
    }

    private Word findWord(String w) {
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return null;
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return null;
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return (Word)currentNode;
        }
        return null;
    }

    public Word addUserWord(String w) {
        Word toReturn = this.findWord(w);
        if (toReturn != null) {
            return toReturn;
        }
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return (Word)currentNode;
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        toReturn = new Word(word, currentNode, true, true, 10);
        current.put(Character.valueOf(lastletter), toReturn);
        this.addSoundex(toReturn);
        return toReturn;
    }

    public boolean removeVariant(String v) {
        Vector<Node> nodePath = new Vector<Node>();
        TreeMap<Character, Node> current = this.variants;
        String variant = v.toLowerCase();
        char[] letters = variant.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return false;
        }
        int i = 1;
        while (i < letters.length) {
            nodePath.add(0, currentNode);
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return false;
            }
            ++i;
        }
        if (!currentNode.isWord()) {
            return false;
        }
        VariantHolder foundVariant = (VariantHolder)currentNode;
        ((Node)nodePath.firstElement()).next.put(foundVariant.key, new Node(foundVariant));
        Node child = ((Node)nodePath.firstElement()).next.get(foundVariant.key);
        if (child.next.isEmpty()) {
            for (Node node : nodePath) {
                node.next.remove(child.key);
                if (node.next.isEmpty()) {
                    child = node;
                    continue;
                }
                return true;
            }
        }
        return true;
    }

    public boolean removeWord(String w) {
        Vector<Node> nodePath = new Vector<Node>();
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return false;
        }
        int i = 1;
        while (i < letters.length) {
            nodePath.add(0, currentNode);
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return false;
            }
            ++i;
        }
        if (!currentNode.isWord()) {
            return false;
        }
        Word foundWord = (Word)currentNode;
        ((Node)nodePath.firstElement()).next.put(foundWord.key, new Node(foundWord));
        Node child = ((Node)nodePath.firstElement()).next.get(foundWord.key);
        if (child.next.isEmpty()) {
            for (Node node : nodePath) {
                node.next.remove(child.key);
                if (node.next.isEmpty()) {
                    child = node;
                    continue;
                }
                return true;
            }
        }
        return true;
    }

    private boolean addWord(String w, int freq, boolean userAdded) {
        TreeMap<Character, Node> current = this.words;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return false;
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        Word newWord = new Word(word, currentNode, userAdded, true, freq);
        current.put(Character.valueOf(lastletter), newWord);
        this.addSoundex(newWord);
        return true;
    }

    private TreeSet<Variant> findVariant(String w) {
        TreeMap<Character, Node> current = this.variants;
        String word = w.toLowerCase();
        char[] letters = word.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return new TreeSet<Variant>();
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return new TreeSet<Variant>();
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((VariantHolder)currentNode).getVariants();
        }
        return new TreeSet<Variant>();
    }

    private boolean addSoundex(Word w) {
        TreeMap<Character, Node> current = this.soundex;
        String wordsoundex = w.getSoundexCode();
        char[] letters = wordsoundex.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((SoundexHolder)currentNode).addWord(w);
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        SoundexHolder sh = new SoundexHolder(wordsoundex, currentNode);
        current.put(Character.valueOf(lastletter), sh);
        return sh.addWord(w);
    }

    private TreeSet<Word> findWordWithSoundex(String s) {
        char[] letters = s.toCharArray();
        TreeMap<Character, Node> current = this.soundex;
        if (letters.length == 0) {
            return new TreeSet<Word>();
        }
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            return new TreeSet<Word>();
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                return new TreeSet<Word>();
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((SoundexHolder)currentNode).getWords();
        }
        return new TreeSet<Word>();
    }

    private boolean addVariant(String v, Word rep, boolean userAdded) {
        TreeMap<Character, Node> current = this.variants;
        String variant = v.toLowerCase();
        char[] letters = variant.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((VariantHolder)currentNode).addVariant(rep, userAdded);
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        VariantHolder vh = new VariantHolder(variant, currentNode);
        current.put(Character.valueOf(lastletter), vh);
        return vh.addVariant(rep, userAdded);
    }

    public boolean addUserVariant(String v, Word rep) {
        TreeMap<Character, Node> current = this.variants;
        String variant = v.toLowerCase();
        char[] letters = variant.toCharArray();
        Node currentNode = current.get(Character.valueOf(letters[0]));
        if (currentNode == null) {
            currentNode = new Node(Character.valueOf(letters[0]));
            current.put(Character.valueOf(letters[0]), currentNode);
        }
        int i = 1;
        while (i < letters.length) {
            current = currentNode.next;
            currentNode = current.get(Character.valueOf(letters[i]));
            if (currentNode == null) {
                currentNode = new Node(Character.valueOf(letters[i]));
                current.put(Character.valueOf(letters[i]), currentNode);
            }
            ++i;
        }
        if (currentNode.isWord()) {
            return ((VariantHolder)currentNode).addVariant(rep, false);
        }
        char lastletter = letters[letters.length - 1];
        current.remove(Character.valueOf(lastletter));
        VariantHolder vh = new VariantHolder(variant, currentNode);
        current.put(Character.valueOf(lastletter), vh);
        return vh.addVariant(rep, true);
    }

    public Word checkWords(String w) {
        Word word = this.findWord(w);
        if (word != null) {
            return word;
        }
        return null;
    }

    private SuggestedReplacement getHashRemovalMatch(String wtf, ConfidenceWeights rs) {
        String[] s = wtf.split("-");
        if (s.length < 2) {
            return null;
        }
        if (s[0].length() > 0 && this.checkWords(s[0]) == null) {
            return null;
        }
        if (s[1].equals("")) {
            String newWordString = String.valueOf(s[0]) + " -";
            SuggestedReplacement toReturn = new SuggestedReplacement(new Word(newWordString, null, false, true, 1), wtf, rs);
            toReturn.setLetterReplacement(true);
            toReturn.setSoundex(true);
            return toReturn;
        }
        String newWordString = s[0];
        int i = 1;
        while (i < s.length) {
            if (s[i].length() > 0 && this.checkWords(s[i]) == null) {
                return null;
            }
            newWordString = String.valueOf(newWordString) + " " + s[i];
            ++i;
        }
        SuggestedReplacement toReturn = new SuggestedReplacement(new Word(newWordString, null, false, true, 1), wtf, rs);
        toReturn.setLetterReplacement(true);
        toReturn.setSoundex(true);
        return toReturn;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<SuggestedReplacement> findReplacements(String wtf, String soundex, ConfidenceWeights rs) {
        int index;
        SuggestedReplacement toAdd;
        TreeSet<Variant> variantMatches = this.findVariant(wtf);
        TreeSet<String> lrMatches = this.checkLetterReplacements(wtf);
        TreeSet<Word> soundexMatches = this.findWordWithSoundex(soundex);
        Vector<String> stringResults = new Vector<String>(100, 50);
        Vector<SuggestedReplacement> results = new Vector<SuggestedReplacement>(100, 50);
        SuggestedReplacement hashRem = this.getHashRemovalMatch(wtf, rs);
        if (hashRem != null) {
            results.add(hashRem);
            stringResults.add(hashRem.getReplacement().toString());
        }
        for (Variant current : variantMatches) {
            if (stringResults.contains(current.getActual().toString())) continue;
            toAdd = new SuggestedReplacement(current.getActual(), wtf, rs);
            toAdd.setKnownVariant(true, current.isUserAdded());
            toAdd.setSoundex(soundex);
            results.add(toAdd);
            stringResults.add(current.getActual().toString());
        }
        for (String string : lrMatches) {
            index = stringResults.indexOf(string);
            if (index < 0) {
                Word realWordFound = this.checkWords(string);
                toAdd = realWordFound == null ? new SuggestedReplacement(new Word(string, null, false, false, 1), wtf, rs) : new SuggestedReplacement(realWordFound, wtf, rs);
                toAdd.setLetterReplacement(true);
                toAdd.setSoundex(soundex);
                results.add(toAdd);
                stringResults.add(string);
                continue;
            }
            ((SuggestedReplacement)results.get(index)).setLetterReplacement(true);
        }
        for (Word word : soundexMatches) {
            index = stringResults.indexOf(word.toString());
            if (index >= 0) continue;
            toAdd = new SuggestedReplacement(word, wtf, rs);
            toAdd.setSoundex(soundex);
            results.add(toAdd);
            stringResults.add(word.toString());
        }
        Collections.sort(results);
        boolean bl = false;
        int nonDictNotSoundexAdded = 0;
        int dictAdded = 0;
        Vector<SuggestedReplacement> filtered = new Vector<SuggestedReplacement>(30, 10);
        for (SuggestedReplacement rep : results) {
            if (!WordUtilities.isLikelyReplacement(wtf, rep.getReplacementString(), rep.getEditDistance())) continue;
            if (rep.isInDictionary()) {
                if (dictAdded >= 20) continue;
                filtered.add(rep);
                ++dictAdded;
                continue;
            }
            if (rep.isSoundex()) {
                void var13_16;
                if (var13_16 >= 6) continue;
                filtered.add(rep);
                ++var13_16;
                continue;
            }
            if (nonDictNotSoundexAdded >= 6) continue;
            filtered.add(rep);
            ++nonDictNotSoundexAdded;
        }
        return filtered;
    }

    private TreeSet<String> checkLetterReplacements(String wtf) {
        Vector<FlaggedString> toCheck = new Vector<FlaggedString>(300, 50);
        Vector found = new Vector(300, 50);
        Vector<Object> foundVariants = new Vector(200, 50);
        toCheck.add(new FlaggedString(wtf.toLowerCase()));
        while (!toCheck.isEmpty()) {
            FlaggedString current = (FlaggedString)toCheck.firstElement();
            for (Rule rule : this.rules) {
                foundVariants = current.applyRule(rule);
                if (toCheck.size() >= 5000) continue;
                found.addAll(foundVariants);
                toCheck.addAll(foundVariants);
            }
            toCheck.remove(current);
        }
        TreeSet<String> filtered = new TreeSet<String>();
        for (FlaggedString fs : found) {
            filtered.add(fs.toString());
        }
        return filtered;
    }

    public TreeSet<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> newRules) {
        this.rules = new TreeSet();
        this.rules.addAll(newRules);
    }

    public static boolean isRulesChanged() {
        return rulesChanged;
    }

    public static boolean isVariantsChanged() {
        return variantsChanged;
    }

    public static boolean isWordsChanged() {
        return wordsChanged;
    }

    public void setRulesChanged(boolean rc, String log) {
        rulesChanged = rc;
        rulesLog = rulesChanged ? String.valueOf(rulesLog) + log : "";
        for (DataChangeListener l : dataChangeListeners) {
            l.rulesChanged(rulesChanged);
        }
    }

    public void setVariantsChanged(boolean vc, String log) {
        variantsChanged = vc;
        variantsLog = variantsChanged ? String.valueOf(variantsLog) + log : "";
        for (DataChangeListener l : dataChangeListeners) {
            l.variantsChanged(variantsChanged);
        }
    }

    public void setWordsChanged(boolean wc, String log) {
        wordsChanged = wc;
        wordsLog = wordsChanged ? String.valueOf(wordsLog) + log : "";
        for (DataChangeListener l : dataChangeListeners) {
            l.wordsChanged(wordsChanged);
        }
    }

    public String getRulesLog() {
        return rulesLog;
    }

    public String getVariantsLog() {
        return variantsLog;
    }

    public String getWordsLog() {
        return wordsLog;
    }

    public void setRulesLog(String rulesLog) {
        LookUpDictionary.rulesLog = rulesLog;
    }

    public void setVariantsLog(String variantsLog) {
        LookUpDictionary.variantsLog = variantsLog;
    }

    public void setWordsLog(String wordsLog) {
        LookUpDictionary.wordsLog = wordsLog;
    }

    public static interface DataChangeListener {
        public void wordsChanged(boolean var1);

        public void variantsChanged(boolean var1);

        public void rulesChanged(boolean var1);
    }

    static interface NodeProcessor {
        public void processNode(Node var1);
    }
}

