/*
 * Decompiled with CFR 0.152.
 */
package model.lookup;

import java.util.Vector;
import model.lookup.Rule;

class FlaggedString
implements Cloneable {
    private String string;
    private boolean[] dirty;
    private int stringLength;
    private int rulesApplied;

    public FlaggedString() {
    }

    public FlaggedString(String s) {
        this.string = s;
        this.stringLength = this.string.length();
        this.dirty = new boolean[this.stringLength];
        this.rulesApplied = 0;
    }

    public FlaggedString(FlaggedString original) {
        this.string = new String(original.toString());
        this.stringLength = this.string.length();
        this.dirty = new boolean[this.stringLength];
        int i = 0;
        while (i < this.stringLength) {
            if (original.isDirty(i)) {
                this.dirty[i] = true;
            }
            ++i;
        }
        this.rulesApplied = original.getRulesApplied();
    }

    private void setRulesApplied(int rulesApplied) {
        this.rulesApplied = rulesApplied;
    }

    private void addRuleApplied() {
        ++this.rulesApplied;
    }

    private int getRulesApplied() {
        return this.rulesApplied;
    }

    public String toString() {
        return this.string;
    }

    private int length() {
        return this.stringLength;
    }

    private void setCharDirty(int i, boolean d) throws IndexOutOfBoundsException {
        if (i < 0 || i > this.stringLength - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.dirty[i] = d;
    }

    private void dirtyRange(int start, int end) throws IndexOutOfBoundsException {
        if (end < start || start < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = start;
        while (i < end && i < this.stringLength) {
            this.dirty[i] = true;
            ++i;
        }
    }

    private boolean isDirty(int start, int end) throws IndexOutOfBoundsException {
        if (end < start || start < 0 || end > this.stringLength) {
            throw new IndexOutOfBoundsException();
        }
        int i = start;
        while (i < end) {
            if (this.dirty[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDirty(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i > this.stringLength - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.dirty[i];
    }

    private boolean startsWith(String prefix) {
        if (prefix.length() > this.stringLength) {
            return false;
        }
        if (this.isDirty(0, prefix.length())) {
            return false;
        }
        return this.string.startsWith(prefix);
    }

    private boolean endsWith(String suffix) {
        if (suffix.length() > this.stringLength) {
            return false;
        }
        if (this.isDirty(this.stringLength - suffix.length(), this.stringLength)) {
            return false;
        }
        return this.string.endsWith(suffix);
    }

    private int indexOf(String toCheck) {
        int currentStart = 0;
        int toCheckLength = toCheck.length();
        if (toCheckLength > this.stringLength) {
            return -1;
        }
        int result = -1;
        for (int currentEnd = currentStart + toCheckLength; currentEnd < this.stringLength + 1; ++currentEnd) {
            result = this.string.indexOf(toCheck, currentStart);
            if (result == -1) {
                return -1;
            }
            currentStart = result;
            currentEnd = currentStart + toCheckLength;
            if (this.isDirty(currentStart, currentEnd)) {
                ++currentStart;
                continue;
            }
            return currentStart;
        }
        return -1;
    }

    public Vector<FlaggedString> applyRule(Rule rule) {
        Rule.Position where = rule.getWhereToApply();
        String original = rule.getOriginal();
        String replacement = rule.getReplacement();
        Vector<FlaggedString> toReturn = new Vector<FlaggedString>(10, 5);
        if (this.stringLength < 2) {
            return toReturn;
        }
        if (this.rulesApplied > 2) {
            return toReturn;
        }
        switch (where) {
            case Start: {
                if (this.startsWith(original) && !this.dirty[0]) {
                    toReturn.add(this.replace(original, replacement, 0));
                }
                return toReturn;
            }
            case End: {
                if (this.endsWith(original) && !this.dirty[this.stringLength - 1]) {
                    toReturn.add(this.replace(original, replacement, this.stringLength - original.length()));
                }
                return toReturn;
            }
            case Anywhere: {
                int start = this.indexOf(original);
                if (start > -1) {
                    Vector<FlaggedString> toCheck = new Vector<FlaggedString>(20, 5);
                    toCheck.add(new FlaggedString(this));
                    while (!toCheck.isEmpty()) {
                        FlaggedString current = (FlaggedString)toCheck.firstElement();
                        start = current.indexOf(original);
                        if (start == -1) {
                            toCheck.remove(0);
                            continue;
                        }
                        FlaggedString toAdd = current.replace(original, replacement, start);
                        toCheck.add(toAdd);
                        toReturn.add(toAdd);
                        current.dirtyRange(start, start + original.length());
                    }
                }
                return toReturn;
            }
        }
        return toReturn;
    }

    private FlaggedString substring(int start, int end) {
        FlaggedString toReturn = new FlaggedString(this.string.substring(start, end));
        int trPlace = 0;
        int i = start;
        while (i < end) {
            toReturn.setCharDirty(trPlace, this.dirty[i]);
            ++trPlace;
            ++i;
        }
        return toReturn;
    }

    private FlaggedString concat(FlaggedString newFS) {
        FlaggedString toReturn = new FlaggedString(String.valueOf(this.string) + newFS.toString());
        int i = 0;
        while (i < this.stringLength) {
            toReturn.setCharDirty(i, this.dirty[i]);
            ++i;
        }
        int toReturnLength = toReturn.length();
        int nfsPlace = 0;
        int i2 = this.stringLength;
        while (i2 < toReturnLength) {
            toReturn.setCharDirty(i2, newFS.isDirty(nfsPlace));
            ++nfsPlace;
            ++i2;
        }
        return toReturn;
    }

    private FlaggedString concat(String newS) {
        FlaggedString toReturn = new FlaggedString(String.valueOf(this.string) + newS);
        int i = 0;
        while (i < this.stringLength) {
            toReturn.setCharDirty(i, this.dirty[i]);
            ++i;
        }
        return toReturn;
    }

    private FlaggedString replace(String original, String replacement, int start) {
        FlaggedString before = this.substring(0, start);
        FlaggedString after = this.substring(start + original.length(), this.stringLength);
        FlaggedString toReturn = before.concat(replacement);
        toReturn = toReturn.concat(after);
        toReturn.dirtyRange(start, start + replacement.length());
        toReturn.setRulesApplied(this.rulesApplied);
        toReturn.addRuleApplied();
        return toReturn;
    }

    public boolean[] getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean[] dirty) {
        this.dirty = dirty;
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public int getStringLength() {
        return this.stringLength;
    }

    public void setStringLength(int stringLength) {
        this.stringLength = stringLength;
    }
}

