/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.CorrectInstance;
import model.doc.DocumentElement;
import model.doc.DocumentModel;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.lookup.Word;
import model.lookup.WordUtilities;

public class WordHolder
implements Comparable<WordHolder> {
    public static final int VARIANT = 101;
    public static final int REPLACED = 102;
    public static final int CORRECT = 103;
    public static final int[] types = new int[]{101, 102, 103};
    private String word;
    private String soundexCode;
    private InstanceHolder<VariantInstance> asVariant;
    private TreeSet<InstanceHolder<ReplacedInstance>> asReplaced;
    private InstanceHolder<CorrectInstance> asCorrect;
    private boolean inDictionary;
    private boolean isLowFreq;
    private Word dictionaryRef;
    private Vector<SuggestedReplacement> replacements;
    private boolean areReplacementsSet;

    public static String getTypeName(int type) {
        switch (type) {
            case 101: {
                return "Variant Forms";
            }
            case 102: {
                return "Replaced";
            }
            case 103: {
                return "Modern Forms";
            }
        }
        return "Unknown";
    }

    public WordHolder(String word) {
        this.word = word;
        this.asVariant = new InstanceHolder(word, this);
        this.asReplaced = new TreeSet();
        this.asCorrect = new InstanceHolder(word, this);
        this.soundexCode = WordUtilities.getSoundexCode(word);
        this.replacements = new Vector();
    }

    private static String getTypeString(int type) {
        switch (type) {
            case 101: {
                return "Variant";
            }
            case 102: {
                return "Replaced";
            }
            case 103: {
                return "Modern Form";
            }
        }
        return "Type unrecognized";
    }

    @Override
    public int compareTo(WordHolder wh) {
        return this.word.compareToIgnoreCase(wh.word);
    }

    public boolean equals(WordHolder wh) {
        return this.compareTo(wh) == 0;
    }

    public ReplacedInstance addReplaced(Position start, String variant, SuggestedReplacement replacement, StyledDocument doc) throws BadLocationException {
        ReplacedInstance newReplaced;
        VariantInstance newVariant = new VariantInstance(start, this, this.asVariant, variant);
        InstanceHolder<ReplacedInstance> to = new InstanceHolder<ReplacedInstance>(this.word, this);
        boolean toIsNew = true;
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            if (ih.isEmpty() || !ih.getInstances().first().getReplacement().equals(replacement)) continue;
            to = ih;
            toIsNew = false;
            break;
        }
        if (toIsNew) {
            this.asReplaced.add(to);
        }
        if (!to.addInstance(newReplaced = new ReplacedInstance(newVariant, to, replacement))) {
            return to.getInstanceAtPos(start.getOffset());
        }
        return newReplaced;
    }

    public VariantInstance addVariant(Position start, String actual) {
        VariantInstance newInstance = new VariantInstance(start, this, this.asVariant, actual);
        if (!this.asVariant.addInstance(newInstance)) {
            return this.asVariant.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public CorrectInstance addCorrect(Position start, String actual) {
        CorrectInstance newInstance = new CorrectInstance(start, this, this.asCorrect, actual);
        if (!this.asCorrect.addInstance(newInstance)) {
            return this.asCorrect.getInstanceAtPos(start.getOffset());
        }
        return newInstance;
    }

    public void addVariant(VariantInstance vi) {
        this.asVariant.addInstance(vi);
    }

    public void addCorrect(CorrectInstance ci) {
        this.asCorrect.addInstance(ci);
    }

    public boolean removeVariant(VariantInstance vi) {
        return this.asVariant.removeInstance(vi);
    }

    public boolean removeCorrect(CorrectInstance ci) {
        return this.asCorrect.removeInstance(ci);
    }

    public Instance getInstanceAt(int caretPos) {
        Instance toReturn = this.asVariant.getInstanceAtPos(caretPos);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = this.asCorrect.getInstanceAtPos(caretPos);
        if (toReturn != null) {
            return toReturn;
        }
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            toReturn = ih.getInstanceAtPos(caretPos);
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    public boolean isInDictionary() {
        return this.inDictionary;
    }

    public Word getDictionaryRef() {
        return this.dictionaryRef;
    }

    public boolean isLowFreq() {
        return this.isLowFreq;
    }

    public void setDictionaryRef(Word dictionaryRef) {
        this.dictionaryRef = dictionaryRef;
        this.inDictionary = dictionaryRef != null;
        this.isLowFreq = this.inDictionary ? dictionaryRef.isLowFreq() : false;
    }

    public String getWord() {
        return this.word;
    }

    public boolean areReplacementsSet() {
        return this.areReplacementsSet;
    }

    public Vector<SuggestedReplacement> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(Vector<SuggestedReplacement> replacements) {
        this.replacements = replacements;
        this.areReplacementsSet = true;
    }

    public String getSoundexCode() {
        return this.soundexCode;
    }

    public SuggestedReplacement getTopReplacement() {
        if (this.replacements.size() > 0) {
            return this.replacements.firstElement();
        }
        return null;
    }

    public TreeSet<Instance> getInstances() {
        TreeSet<Instance> toReturn = new TreeSet<Instance>();
        toReturn.addAll((Collection)this.asVariant.getInstances());
        toReturn.addAll((Collection)this.asCorrect.getInstances());
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            toReturn.addAll((Collection<Instance>)ih.getInstances());
        }
        return toReturn;
    }

    public TreeSet<SuggestedReplacement> getReplacementsUsed() {
        TreeSet<SuggestedReplacement> toReturn = new TreeSet<SuggestedReplacement>(new SuggestedReplacement.AlphaComparator());
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            ReplacedInstance ri = ih.firstInstance();
            if (ri == null) continue;
            toReturn.add(ri.getReplacement());
        }
        return toReturn;
    }

    public boolean isAtleastOneInstanceAVariant() {
        return !this.asVariant.isEmpty();
    }

    public boolean isAtleastOneInstanceAReplaced() {
        return !this.asReplaced.isEmpty();
    }

    public boolean isAtleastOneInstanceACorrect() {
        return !this.asCorrect.isEmpty();
    }

    public int getVariantsSize() {
        return this.asVariant.getInstancesSize();
    }

    public int getReplacedSize() {
        int toReturn = 0;
        for (InstanceHolder<ReplacedInstance> ih : this.asReplaced) {
            toReturn += ih.getInstancesSize();
        }
        return toReturn;
    }

    public int getCorrectSize() {
        return this.asCorrect.getInstancesSize();
    }

    public static class MarkAllFInstancesAsTEdit<F extends Instance, T extends Instance>
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 1L;
        private TreeSet<F> fis;
        private TreeSet<T> tis;
        private int fromType;
        private int toType;
        private InstanceHolder<F> from;
        private InstanceHolder<T> to;
        private boolean executed = false;
        private boolean undone = false;
        private String progressMessage;
        private Globals global = Globals.getInstance();

        public MarkAllFInstancesAsTEdit(WordHolder wh, F tempFrom, T tempTo) throws InvalidInstanceChangeException {
            this.fromType = ((Instance)tempFrom).getType();
            this.toType = ((Instance)tempTo).getType();
            switch (this.fromType) {
                case 101: {
                    this.from = wh.asVariant;
                    break;
                }
                case 103: {
                    this.from = wh.asCorrect;
                    break;
                }
                case 102: {
                    throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
                }
                default: {
                    throw new InvalidInstanceChangeException("From instance type not recognised.");
                }
            }
            switch (this.toType) {
                case 101: {
                    this.to = wh.asVariant;
                    break;
                }
                case 103: {
                    this.to = wh.asCorrect;
                    break;
                }
                case 102: {
                    throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
                }
                default: {
                    throw new InvalidInstanceChangeException("From instance type not recognised.");
                }
            }
            this.fis = new TreeSet();
            this.tis = new TreeSet();
            for (Instance fi : this.from.getInstances()) {
                Instance toAdd;
                this.fis.add(fi);
                switch (this.toType) {
                    case 101: {
                        toAdd = new VariantInstance(fi);
                        break;
                    }
                    case 103: {
                        toAdd = new CorrectInstance(fi);
                        break;
                    }
                    case 102: {
                        throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
                    }
                    default: {
                        throw new InvalidInstanceChangeException("From instance type not recognised.");
                    }
                }
                Instance p = fi;
                while ((p = p.getPreviousInstance()) != null) {
                    if (p.getType() != this.toType) continue;
                    toAdd = p;
                    break;
                }
                toAdd.setInstanceHolder(this.to);
                this.tis.add(toAdd);
            }
            this.progressMessage = "Mark all " + WordHolder.getTypeString(this.fromType) + " as " + WordHolder.getTypeString(this.toType) + " (" + ((Instance)this.tis.first()).getOriginal() + ")";
        }

        @Override
        public void execute() throws CannotExecuteException {
            if (this.executed) {
                throw new CannotExecuteException("Cannot execute twice.");
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Executing: " + this.progressMessage);
            this.to.addInstances(this.tis);
            this.from.emptyInstances();
            this.executed = true;
            this.global.finishProgress();
        }

        @Override
        public void undo() throws CannotUndoException {
            if (!this.executed) {
                throw new CannotUndoException();
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Undoing: " + this.progressMessage);
            this.from.addInstances(this.fis);
            this.to.removeInstances(this.tis);
            this.undone = true;
            this.global.finishProgress();
        }

        @Override
        public void redo() throws CannotRedoException {
            if (!this.undone) {
                throw new CannotRedoException();
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Redoing: " + this.progressMessage);
            this.to.addInstances(this.tis);
            this.from.removeInstances(this.fis);
            this.undone = false;
            this.global.finishProgress();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return this.progressMessage;
        }

        public String getActionName() {
            return "Mark all as " + WordHolder.getTypeString(this.toType);
        }

        public int getToType() {
            return this.toType;
        }
    }

    public static class MarkFInstanceAsTEdit<F extends Instance, T extends Instance>
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        F fi;
        T ti;
        int fromType;
        int toType;
        InstanceHolder<F> from;
        InstanceHolder<T> to;
        WordHolder wh;
        boolean executed = false;
        boolean undone = false;

        public MarkFInstanceAsTEdit(F fi, T tempToInstance) throws InvalidInstanceChangeException {
            this.fi = fi;
            this.ti = tempToInstance;
            this.wh = ((Instance)fi).holder;
            this.fromType = ((Instance)fi).getType();
            this.toType = ((Instance)this.ti).getType();
            if (this.fromType == this.toType) {
                throw new InvalidInstanceChangeException("Can't mark instance as same type of instance.");
            }
            switch (this.fromType) {
                case 101: {
                    this.from = this.wh.asVariant;
                    break;
                }
                case 103: {
                    this.from = this.wh.asCorrect;
                    break;
                }
                case 102: {
                    throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
                }
                default: {
                    throw new InvalidInstanceChangeException("From instance type not recognised.");
                }
            }
            switch (this.toType) {
                case 101: {
                    this.ti = new VariantInstance((Instance)fi);
                    this.to = this.wh.asVariant;
                    break;
                }
                case 103: {
                    this.ti = new CorrectInstance((Instance)fi);
                    this.to = this.wh.asCorrect;
                    break;
                }
                case 102: {
                    throw new InvalidInstanceChangeException("Can't mark instance as replaced, use replace instead.");
                }
                default: {
                    throw new InvalidInstanceChangeException("To instance type not recognised.");
                }
            }
            Object p = fi;
            while ((p = ((Instance)p).getPreviousInstance()) != null) {
                if (((Instance)p).getType() != this.toType) continue;
                this.ti = p;
                return;
            }
            ((Instance)this.ti).setInstanceHolder(this.to);
        }

        public void execute() throws InvalidInstanceChangeException {
            if (!this.executed) {
                if (this.from.removeInstance(this.fi)) {
                    if (this.to.addInstance(this.ti)) {
                        this.executed = true;
                        return;
                    }
                    this.from.addInstance(this.fi);
                }
            } else {
                throw new InvalidInstanceChangeException("Can only execute once. " + this.fi + " to " + WordHolder.getTypeString(this.toType));
            }
            throw new InvalidInstanceChangeException(this.fi + " could not be marked as " + WordHolder.getTypeString(this.toType));
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed && this.to.removeInstance(this.ti)) {
                if (this.from.addInstance(this.fi)) {
                    this.undone = true;
                    return;
                }
                this.to.addInstance(this.ti);
            }
            throw new CannotUndoException();
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone && this.from.removeInstance(this.fi)) {
                if (this.to.addInstance(this.ti)) {
                    this.undone = false;
                    return;
                }
                this.from.addInstance(this.fi);
            }
            throw new CannotRedoException();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Mark instance as " + WordHolder.getTypeString(this.toType) + " (" + ((DocumentElement)this.fi).getOriginal() + ")";
        }

        public String getActionName() {
            return "Mark instance as " + WordHolder.getTypeString(this.toType);
        }

        public int getToType() {
            return this.toType;
        }

        public T getToInstance() {
            return this.ti;
        }
    }

    public static class ReplaceAllFInstancesEdit<F extends VariantInstance>
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 1L;
        private TreeSet<F> fis;
        private TreeSet<ReplacedInstance> ris;
        private WordHolder wh;
        private int fromType;
        private InstanceHolder<F> from;
        private InstanceHolder<ReplacedInstance> to;
        private StyledDocument doc;
        private Globals global = Globals.getInstance();
        private String progressMessage;
        private boolean replaceInText;
        private boolean toIsNew = true;
        private boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
        private boolean executed = false;
        private boolean undone = false;

        public ReplaceAllFInstancesEdit(WordHolder wh, F tempFrom, SuggestedReplacement rep, StyledDocument doc, boolean replaceInText) throws InvalidInstanceChangeException {
            this.wh = wh;
            this.fromType = ((VariantInstance)tempFrom).getType();
            this.replaceInText = replaceInText;
            this.doc = doc;
            switch (this.fromType) {
                case 101: {
                    this.from = wh.asVariant;
                    break;
                }
                default: {
                    throw new InvalidInstanceChangeException("From instance type not recognised.");
                }
            }
            this.to = new InstanceHolder(wh.word, wh);
            for (InstanceHolder ih : wh.asReplaced) {
                if (ih.isEmpty() || !((ReplacedInstance)ih.getInstances().first()).getReplacement().equals(rep)) continue;
                this.to = ih;
                this.toIsNew = false;
                break;
            }
            this.fis = new TreeSet();
            this.ris = new TreeSet();
            for (VariantInstance fi : this.from.getInstances()) {
                this.fis.add(fi);
                this.ris.add(new ReplacedInstance(fi, this.to, rep));
            }
            this.progressMessage = "Replace all: " + this.ris.first().toString();
        }

        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed) {
                block13: {
                    if (this.replaceInText) {
                        this.global.startProgress(this.ris.size());
                        this.global.writeProgressMessage("Executing: " + this.progressMessage);
                        int count = 0;
                        try {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    ri.setupInText(this.doc);
                                    this.global.setProgressCurrent(++count);
                                }
                                break block13;
                            }
                            catch (BadLocationException e) {
                                try {
                                    for (ReplacedInstance ri : this.ris) {
                                        if (!ri.isSetup()) continue;
                                        ri.revertInText(this.doc);
                                        this.global.setProgressCurrent(--count);
                                    }
                                }
                                catch (BadLocationException ex) {
                                    this.global.showException("Reversing " + this.progressMessage + " failed.", ex);
                                }
                            }
                            this.global.showException(String.valueOf(this.progressMessage) + " failed.", e);
                            throw new CannotExecuteException(String.valueOf(this.progressMessage) + " failed.");
                        }
                        finally {
                            this.global.finishProgress();
                        }
                    }
                }
                this.global.startIndeterminateProgress();
                this.global.writeProgressMessage("Executing: " + this.progressMessage);
                this.from.emptyInstances();
                this.to.addInstances(this.ris);
                if (this.toIsNew) {
                    this.wh.asReplaced.add(this.to);
                }
            } else {
                throw new CannotExecuteException("Cannot execute twice.");
            }
            this.executed = true;
            this.global.finishProgress();
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed) {
                block13: {
                    if (this.replaceInText) {
                        this.global.startProgress(this.ris.size());
                        this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                        int count = 0;
                        try {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    ri.revertInText(this.doc);
                                    this.global.setProgressCurrent(++count);
                                }
                                break block13;
                            }
                            catch (BadLocationException e) {
                                try {
                                    for (ReplacedInstance ri : this.ris) {
                                        if (!ri.isReverted()) continue;
                                        ri.setupInText(this.doc);
                                        this.global.setProgressCurrent(--count);
                                    }
                                }
                                catch (BadLocationException ex) {
                                    this.global.showException("Reversing undo " + this.progressMessage + " failed.", ex);
                                }
                            }
                            this.global.showException("Undoing " + this.progressMessage + " failed.", e);
                            throw new CannotUndoException();
                        }
                        finally {
                            this.global.finishProgress();
                        }
                    }
                }
                this.global.startIndeterminateProgress();
                this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                this.to.removeInstances(this.ris);
                this.from.addInstances(this.fis);
                if (this.toIsNew) {
                    this.wh.asReplaced.remove(this.to);
                }
            } else {
                throw new CannotUndoException();
            }
            DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
            this.undone = true;
            this.global.finishProgress();
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                block13: {
                    if (this.replaceInText) {
                        this.global.startProgress(this.ris.size());
                        this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                        int count = 0;
                        try {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    ri.setupInText(this.doc);
                                    this.global.setProgressCurrent(++count);
                                }
                                break block13;
                            }
                            catch (BadLocationException e) {
                                try {
                                    for (ReplacedInstance ri : this.ris) {
                                        if (!ri.isSetup()) continue;
                                        ri.revertInText(this.doc);
                                        this.global.setProgressCurrent(--count);
                                    }
                                }
                                catch (BadLocationException ex) {
                                    this.global.showException("Reversing redo " + this.progressMessage + " failed.", ex);
                                }
                            }
                            this.global.showException("Redoing " + this.progressMessage + " failed.", e);
                            throw new CannotRedoException();
                        }
                        finally {
                            this.global.finishProgress();
                        }
                    }
                }
                this.global.startIndeterminateProgress();
                this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                this.from.removeInstances(this.fis);
                this.to.addInstances(this.ris);
                if (this.toIsNew) {
                    this.wh.asReplaced.add(this.to);
                }
            } else {
                throw new CannotRedoException();
            }
            this.undone = false;
            this.global.finishProgress();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return this.progressMessage;
        }

        public String getActionName() {
            return "Replace all";
        }
    }

    public static class ReplaceFInstanceEdit<F extends VariantInstance>
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        F fi;
        ReplacedInstance ri;
        boolean replaceText;
        int fromType;
        InstanceHolder<F> from;
        InstanceHolder<ReplacedInstance> to;
        boolean toIsNew = true;
        WordHolder wh;
        StyledDocument doc;
        SuggestedReplacement rep;
        boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
        boolean executed = false;
        boolean undone = false;

        public ReplaceFInstanceEdit(F fi, SuggestedReplacement rep, StyledDocument doc, boolean replaceText) throws InvalidInstanceChangeException {
            this.fi = fi;
            this.doc = doc;
            this.replaceText = replaceText;
            this.rep = rep;
            this.wh = ((VariantInstance)fi).holder;
            this.fromType = ((VariantInstance)fi).getType();
            switch (this.fromType) {
                case 101: {
                    this.from = this.wh.asVariant;
                    break;
                }
                default: {
                    throw new InvalidInstanceChangeException("From instance type not recognised.");
                }
            }
            this.to = new InstanceHolder(this.wh.word, this.wh);
            for (InstanceHolder ih : this.wh.asReplaced) {
                if (ih.isEmpty() || !((ReplacedInstance)ih.getInstances().first()).getReplacement().equals(rep)) continue;
                this.to = ih;
                this.toIsNew = false;
                break;
            }
            this.ri = new ReplacedInstance((VariantInstance)fi, this.to, rep);
        }

        public ReplacedInstance getReplacedInstance() {
            return this.ri;
        }

        public void execute() throws InvalidInstanceChangeException, BadLocationException {
            if (!this.executed) {
                if (this.replaceText) {
                    this.ri.setupInText(this.doc);
                }
                if (this.from.removeInstance(this.fi)) {
                    if (!this.to.addInstance(this.ri)) {
                        this.from.addInstance(this.fi);
                        throw new InvalidInstanceChangeException(this.fi + " could not be replaced");
                    }
                    if (this.toIsNew) {
                        this.wh.asReplaced.add(this.to);
                    }
                    this.executed = true;
                    return;
                }
                throw new InvalidInstanceChangeException(this.fi + " could not be replaced");
            }
            throw new InvalidInstanceChangeException("Can only execute once. Replace " + this.fi + " with " + this.ri.getReplacementString());
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed) {
                try {
                    this.ri.revertInText(this.doc);
                }
                catch (BadLocationException ex) {
                    throw new CannotUndoException();
                }
                if (this.to.removeInstance(this.ri)) {
                    if (!this.from.addInstance(this.fi)) {
                        this.to.addInstance(this.ri);
                        throw new CannotUndoException();
                    }
                    if (this.toIsNew) {
                        this.wh.asReplaced.remove(this.to);
                    }
                    DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
                    this.undone = true;
                    return;
                }
            }
            throw new CannotUndoException();
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                try {
                    if (this.replaceText) {
                        this.ri.setupInText(this.doc);
                    }
                }
                catch (BadLocationException ex) {
                    throw new CannotRedoException();
                }
                if (this.from.removeInstance(this.fi)) {
                    if (!this.to.addInstance(this.ri)) {
                        this.from.addInstance(this.fi);
                        throw new CannotRedoException();
                    }
                    if (this.toIsNew) {
                        this.wh.asReplaced.add(this.to);
                    }
                    this.undone = false;
                    return;
                }
                System.out.println("oops");
            }
            throw new CannotRedoException();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Replace (" + this.ri + ")";
        }

        public String getActionName() {
            return "Replace instance";
        }

        public WordHolder getWordHolder() {
            return this.wh;
        }
    }

    public static class RevertAllReplacedEdit
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 1L;
        private TreeSet<ReplacedInstance> ris;
        private TreeSet<VariantInstance> vis;
        private WordHolder wh;
        private InstanceHolder<ReplacedInstance> from;
        private StyledDocument doc;
        private Globals global = Globals.getInstance();
        private boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
        private boolean isAlone;
        private boolean executed = false;
        private boolean undone = false;
        private String progressMessage;

        public RevertAllReplacedEdit(WordHolder wh, SuggestedReplacement rep, StyledDocument doc) throws InvalidInstanceChangeException {
            this.wh = wh;
            this.doc = doc;
            for (InstanceHolder ih : wh.asReplaced) {
                if (ih.isEmpty() || !((ReplacedInstance)ih.getInstances().first()).getReplacement().equals(rep)) continue;
                this.from = ih;
                if (ih.getInstances().size() != 1) break;
                this.isAlone = true;
                break;
            }
            if (this.from == null) {
                throw new InvalidInstanceChangeException("Replacement not found.");
            }
            this.ris = new TreeSet();
            this.vis = new TreeSet();
            for (ReplacedInstance ri : this.from.getInstances()) {
                this.ris.add(ri);
                VariantInstance vi = ri.getPreviousInstance();
                if (vi.getType() == 101) {
                    this.vis.add(vi);
                    continue;
                }
                throw new InvalidInstanceChangeException("Replaced previous is not variant/RWE.");
            }
            this.progressMessage = "Revert all " + this.ris.first().toString();
        }

        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed) {
                block12: {
                    this.global.startProgress(this.ris.size());
                    this.global.writeProgressMessage("Executing: " + this.progressMessage);
                    int count = 0;
                    try {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                ri.revertInText(this.doc);
                                this.global.setProgressCurrent(++count);
                            }
                            break block12;
                        }
                        catch (BadLocationException e) {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    if (!ri.isReverted()) continue;
                                    ri.setupInText(this.doc);
                                    this.global.setProgressCurrent(--count);
                                }
                            }
                            catch (BadLocationException ex) {
                                this.global.showException("Reversing " + this.progressMessage + " failed.", ex);
                            }
                        }
                        this.global.showException(String.valueOf(this.progressMessage) + " failed.", e);
                        throw new CannotExecuteException(String.valueOf(this.progressMessage) + " failed.");
                    }
                    finally {
                        this.global.finishProgress();
                    }
                }
                this.global.startIndeterminateProgress();
                this.global.writeProgressMessage("Executing: " + this.progressMessage);
                this.from.emptyInstances();
                this.wh.asVariant.addInstances(this.vis);
                if (this.isAlone) {
                    this.wh.asReplaced.remove(this.from);
                }
            } else {
                throw new CannotExecuteException("Cannot execute twice.");
            }
            this.executed = true;
            this.global.finishProgress();
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed) {
                block12: {
                    this.global.startProgress(this.ris.size());
                    this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                    int count = 0;
                    try {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                ri.setupInText(this.doc);
                                this.global.setProgressCurrent(++count);
                            }
                            break block12;
                        }
                        catch (BadLocationException e) {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    if (!ri.isSetup()) continue;
                                    ri.revertInText(this.doc);
                                    this.global.setProgressCurrent(--count);
                                }
                            }
                            catch (BadLocationException ex) {
                                this.global.showException("Reversing undo " + this.progressMessage + " failed.", ex);
                            }
                        }
                        this.global.showException("Undoing " + this.progressMessage + " failed.", e);
                        throw new CannotUndoException();
                    }
                    finally {
                        this.global.finishProgress();
                    }
                }
                this.global.startIndeterminateProgress();
                this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                this.wh.asVariant.removeInstances(this.vis);
                this.from.addInstances(this.ris);
                if (this.isAlone) {
                    this.wh.asReplaced.add(this.from);
                }
            } else {
                throw new CannotUndoException();
            }
            DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
            this.undone = true;
            this.global.finishProgress();
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                block12: {
                    this.global.startProgress(this.ris.size());
                    this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                    int count = 0;
                    try {
                        try {
                            for (ReplacedInstance ri : this.ris) {
                                ri.revertInText(this.doc);
                                this.global.setProgressCurrent(++count);
                            }
                            break block12;
                        }
                        catch (BadLocationException e) {
                            try {
                                for (ReplacedInstance ri : this.ris) {
                                    if (!ri.isReverted()) continue;
                                    ri.setupInText(this.doc);
                                    this.global.setProgressCurrent(--count);
                                }
                            }
                            catch (BadLocationException ex) {
                                this.global.showException("Reversing redo " + this.progressMessage + " failed.", ex);
                            }
                        }
                        this.global.showException("Redoing " + this.progressMessage + " failed.", e);
                        throw new CannotRedoException();
                    }
                    finally {
                        this.global.finishProgress();
                    }
                }
                this.global.startIndeterminateProgress();
                this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                this.from.removeInstances(this.ris);
                this.wh.asVariant.addInstances(this.vis);
                if (this.isAlone) {
                    this.wh.asReplaced.remove(this.from);
                }
            } else {
                throw new CannotRedoException();
            }
            this.undone = false;
            this.global.finishProgress();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return this.progressMessage;
        }

        public String getActionName() {
            return "Revert all";
        }
    }

    public static class RevertReplacedInstanceEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        VariantInstance vi;
        ReplacedInstance ri;
        int toType;
        InstanceHolder<ReplacedInstance> from = null;
        boolean isAlone = false;
        WordHolder wh;
        StyledDocument doc;
        boolean rsHasChangedBefore = ConfidenceWeights.hasChanged();
        boolean executed = false;
        boolean undone = false;

        public RevertReplacedInstanceEdit(ReplacedInstance ri, StyledDocument doc) throws InvalidInstanceChangeException {
            this.ri = ri;
            this.wh = ri.holder;
            this.doc = doc;
            this.vi = ri.getPreviousInstance();
            this.toType = this.vi.getType();
            for (InstanceHolder ih : this.wh.asReplaced) {
                if (ih.isEmpty() || !((ReplacedInstance)ih.getInstances().first()).getReplacement().equals(ri.getReplacement())) continue;
                this.from = ih;
                if (ih.getInstances().size() != 1) break;
                this.isAlone = true;
                break;
            }
            if (this.from == null) {
                throw new InvalidInstanceChangeException("Replacement not found.");
            }
        }

        public void execute() throws InvalidInstanceChangeException, BadLocationException {
            if (!this.executed) {
                this.ri.revertInText(this.doc);
                if (this.from.removeInstance(this.ri)) {
                    if (this.toType == 101) {
                        if (!this.wh.asVariant.addInstance(this.vi)) {
                            this.from.addInstance(this.ri);
                            throw new InvalidInstanceChangeException(this.ri + " could not be reverted.");
                        }
                    } else {
                        this.from.addInstance(this.ri);
                        throw new InvalidInstanceChangeException(this.ri + " could not be reverted, invalid state to revert to.");
                    }
                    if (this.isAlone) {
                        this.wh.asReplaced.remove(this.from);
                    }
                    this.executed = true;
                    return;
                }
                throw new InvalidInstanceChangeException(this.ri + " could not be reverted.");
            }
            throw new InvalidInstanceChangeException("Can only execute once. Revert " + this.ri);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void undo() throws CannotUndoException {
            if (!this.executed) throw new CannotUndoException();
            try {
                this.ri.setupInText(this.doc);
            }
            catch (BadLocationException ex) {
                throw new CannotUndoException();
            }
            if (this.toType != 101) throw new CannotUndoException();
            if (!this.wh.asVariant.removeInstance(this.vi)) throw new CannotUndoException();
            if (!this.from.addInstance(this.ri)) {
                this.wh.asVariant.addInstance(this.vi);
                throw new CannotUndoException();
            }
            if (this.isAlone) {
                this.wh.asReplaced.add(this.from);
            }
            this.undone = true;
            DocumentModel.confidenceWeights.setHasChanged(this.rsHasChangedBefore);
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                try {
                    this.ri.revertInText(this.doc);
                }
                catch (BadLocationException ex) {
                    throw new CannotRedoException();
                }
                if (this.from.removeInstance(this.ri)) {
                    if (this.toType == 101) {
                        if (!this.wh.asVariant.addInstance(this.vi)) {
                            this.from.addInstance(this.ri);
                            throw new CannotRedoException();
                        }
                    } else {
                        this.from.addInstance(this.ri);
                        throw new CannotRedoException();
                    }
                    if (this.isAlone) {
                        this.wh.asReplaced.remove(this.from);
                    }
                    this.undone = false;
                    return;
                }
                throw new CannotRedoException();
            }
            throw new CannotRedoException();
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Revert (" + this.ri.revertString() + ")";
        }

        public String getActionName() {
            return "Revert to " + WordHolder.getTypeString(this.toType);
        }
    }
}

