/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.Entity;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.VariantInstance;

public class ReplacedInstance
extends Instance {
    private SuggestedReplacement replacement;
    private String replacementString;
    private VariantInstance previousInstance;
    private Globals global = Globals.getInstance();
    private Collection<Entity> entitiesRemoved = null;
    private int restorePos;
    private boolean setup = false;
    private boolean reverted = false;

    public ReplacedInstance(VariantInstance instance, InstanceHolder<ReplacedInstance> instanceHolder, SuggestedReplacement replacement) {
        super(instance);
        this.instanceHolder = instanceHolder;
        if (replacement == null) {
            throw new NullPointerException("Replacement Null");
        }
        this.replacement = replacement;
        replacement.setCapitalization(this.capitalization);
        this.replacementString = replacement.getReplacementString();
        this.previousInstance = instance;
    }

    @Override
    public String getDisplayString() {
        return this.replacementString;
    }

    @Override
    public boolean isXMLRequired() {
        return true;
    }

    @Override
    public String getXMLTaggedVersion() {
        String variant = this.original;
        if (this.entitiesRemoved != null && !this.entitiesRemoved.isEmpty()) {
            int offset = 0;
            for (Entity entity : this.entitiesRemoved) {
                if (!entity.isReplaced()) continue;
                int posInString = entity.getSavedStartInt() - this.restorePos;
                variant = String.valueOf(variant.substring(0, posInString + offset)) + entity.getOriginal() + variant.substring(posInString + offset + entity.getReplacement().length());
                offset = entity.getOriginal().length() - entity.getReplacement().length();
            }
        }
        String xml = "<replaced variant=\"" + variant + "\" foundBy=\"";
        if (this.replacement.isKnownVariant()) {
            xml = this.replacement.isUserAdded() ? String.valueOf(xml) + "u" : String.valueOf(xml) + "p";
        }
        if (this.replacement.isLetterReplacement()) {
            xml = String.valueOf(xml) + "l";
        }
        if (this.replacement.isSoundex()) {
            xml = String.valueOf(xml) + "s";
        }
        xml = String.valueOf(xml) + "\" replacementType=\"";
        xml = this.replacement.isReplacementUserAdded() ? String.valueOf(xml) + "u" : String.valueOf(xml) + "p";
        xml = this.replacement.isInDictionary() ? String.valueOf(xml) + "r" : String.valueOf(xml) + "n";
        xml = String.valueOf(xml) + "\" ed=\"" + this.replacement.getEditDistance() + "\">";
        return super.getXMLTaggedVersion(xml, "</replaced>");
    }

    @Override
    public String toString() {
        return String.valueOf(this.original) + " -> " + this.replacementString;
    }

    public String revertString() {
        return String.valueOf(this.original) + " <- " + this.replacementString;
    }

    public void setupInText(StyledDocument doc) throws BadLocationException {
        this.entitiesRemoved = this.global.getGlobalReplacementListener().removeEntities(this.previousInstance.start, doc.createPosition(this.previousInstance.getEndOffset()));
        AttributeSet atts = this.getAttributesAtStart(doc);
        int startInt = this.previousInstance.getStartOffset();
        doc.remove(startInt, this.original.length());
        doc.insertString(startInt, this.replacementString, atts);
        this.previousInstance.start = this.start = doc.createPosition(startInt);
        this.restorePos = startInt;
        this.setup = true;
        this.reverted = false;
    }

    public void revertInText(StyledDocument doc) throws BadLocationException {
        AttributeSet atts = this.getAttributesAtStart(doc);
        int startInt = this.getStartOffset();
        doc.remove(startInt, this.replacementString.length());
        doc.insertString(startInt, this.original, atts);
        this.start = this.previousInstance.start = doc.createPosition(startInt);
        this.global.getGlobalReplacementListener().restoreEntities(this.entitiesRemoved, startInt - this.restorePos);
        this.entitiesRemoved = null;
        this.reverted = true;
        this.setup = false;
    }

    private AttributeSet getAttributesAtStart(StyledDocument doc) {
        return doc.getCharacterElement(this.getStartOffset()).getAttributes();
    }

    public SuggestedReplacement getReplacement() {
        return this.replacement;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public int compareAlphabeticallyTo(Instance other) {
        int c = super.compareAlphabeticallyTo(other);
        if (c == 0) {
            return this.replacementString.compareToIgnoreCase(((ReplacedInstance)other).replacementString);
        }
        return c;
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public VariantInstance getPreviousInstance() {
        return this.previousInstance;
    }

    @Override
    public boolean removeSelfFromHolder() {
        return false;
    }

    @Override
    public void addSelfToHolder() {
    }

    public boolean isSetup() {
        return this.setup;
    }

    public boolean isReverted() {
        return this.reverted;
    }
}

