/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.Position;
import model.doc.DocumentElement;
import model.doc.InstanceHolder;
import model.doc.WordHolder;
import model.lookup.WordUtilities;

public abstract class Instance
extends DocumentElement {
    protected String joinString;
    protected boolean isJoin;
    protected int capitalization;
    protected WordHolder holder;
    protected Instance previousInstance;
    protected InstanceHolder<? extends Instance> instanceHolder;
    protected boolean userChanged = false;

    protected Instance() {
    }

    protected Instance(Position start, WordHolder holder, InstanceHolder<? extends Instance> instanceHolder, String original) {
        if (start == null) {
            throw new NullPointerException("Start null");
        }
        if (holder == null) {
            throw new NullPointerException("WordHolder null");
        }
        if (instanceHolder == null) {
            throw new NullPointerException("InstanceHolder null");
        }
        if (original == null) {
            throw new NullPointerException("Original null");
        }
        this.start = start;
        this.holder = holder;
        this.instanceHolder = instanceHolder;
        this.original = original;
        this.isJoin = false;
        this.joinString = null;
        this.capitalization = WordUtilities.getCapitalization(original);
        this.previousInstance = null;
    }

    protected Instance(Instance oldInstance) {
        this(oldInstance.start, oldInstance.holder, oldInstance.instanceHolder, oldInstance.original);
        this.previousInstance = oldInstance;
        this.isJoin = this.previousInstance.isJoin;
        this.joinString = this.previousInstance.joinString;
        this.userChanged = true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getType()) + ": " + this.getDisplayString() + " (" + this.getStartOffset() + " - " + this.getEndOffset() + ")";
    }

    public boolean isXMLRequired() {
        return this.isJoin;
    }

    public String getXMLTaggedVersion() {
        if (this.isJoin) {
            return "<join original=\"" + this.joinString + "\">" + this.getDisplayString() + "</join>";
        }
        return this.getDisplayString();
    }

    public String getXMLTaggedVersion(String startTag, String endTag) {
        if (this.isJoin) {
            return "<join original=\"" + this.joinString + "\">" + startTag + this.getDisplayString() + endTag + "</join>";
        }
        return String.valueOf(startTag) + this.getDisplayString() + endTag;
    }

    public abstract int getType();

    public boolean isJoin() {
        return this.isJoin;
    }

    public void setJoin(boolean isJoin) {
        this.isJoin = isJoin;
    }

    public String getJoinString() {
        return this.joinString;
    }

    public void setJoinString(String joinString) {
        this.joinString = joinString;
        if (joinString != null) {
            this.joinString = this.joinString.replaceAll("\r\n", "[n]");
            this.joinString = this.joinString.replaceAll("\n", "[n]");
            this.joinString = this.joinString.replaceAll("\r", "[n]");
        }
    }

    Instance getPreviousInstance() {
        return this.previousInstance;
    }

    void clearPreviousInstance() {
        this.previousInstance = null;
    }

    public int getCapitalization() {
        return this.capitalization;
    }

    public WordHolder getHolder() {
        return this.holder;
    }

    public abstract boolean removeSelfFromHolder();

    public abstract void addSelfToHolder();

    public InstanceHolder<? extends Instance> getInstanceHolder() {
        return this.instanceHolder;
    }

    public void setInstanceHolder(InstanceHolder<? extends Instance> instanceHolder) {
        this.instanceHolder = instanceHolder;
    }

    public boolean isUserChanged() {
        return this.userChanged;
    }

    public void setUserChanged(boolean userChanged) {
        this.userChanged = userChanged;
    }
}

