/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.CharsetToolkit;
import model.ConfidenceWeights;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.CorrectInstance;
import model.doc.Entity;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.ReplacementListener;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.Word;

public class DocumentModel
implements HolderChangeListener,
ReplacementListener {
    private static final long serialVersionUID = 6180371772133602545L;
    private Charset charset;
    private TreeSet<WordHolder> words;
    private TreeMap<Integer, TreeSet<InstanceHolder<? extends Instance>>> holderLists = new TreeMap();
    private TreeMap<Integer, Vector<HolderChangeListener>> changeListeners = new TreeMap();
    private StyledDocument doc;
    protected static ConfidenceWeights confidenceWeights;
    private static LookUpDictionary lud;
    private String[] shortCounts = new String[5];
    private Globals global = Globals.getInstance();
    private TreeMap<Position, IgnorableText> ignored;
    private TreeMap<Position, Entity> entities;
    private TreeMap<Position, Instance> instances;
    private static DocumentModel _instance;

    public void addChangeListener(HolderChangeListener hcl, int type) {
        Vector<HolderChangeListener> hcls = this.changeListeners.get(type);
        if (hcls == null) {
            hcls = new Vector();
            this.changeListeners.put(type, hcls);
        }
        hcls.add(hcl);
    }

    public StyledDocument getDoc() {
        return this.doc;
    }

    private int getDocLength() {
        return this.doc.getLength();
    }

    public TreeSet<InstanceHolder<? extends Instance>> getHolderList(int type) {
        return this.holderLists.get(type);
    }

    public static DocumentModel getInstance() {
        if (_instance == null) {
            _instance = new DocumentModel();
        }
        return _instance;
    }

    public void processNewFile(File file) throws BadLocationException, InvalidInstanceChangeException {
        this.global.lockFinishProgress();
        try {
            this.clear();
            this.readFile(file);
            this.parseXMLTags(this.getStartOfDoc());
            this.parseSpecialEntities(this.getStartOfDoc(), this.getEndOfDoc());
            this.newReadWords(this.getStartOfDoc(), this.getEndOfDoc());
        }
        finally {
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    public void processNewText(String text, AttributeSet atts) throws BadLocationException, InvalidInstanceChangeException {
        this.global.lockFinishProgress();
        try {
            int start = this.insertText(text, atts);
            this.parseXMLTags(start);
            this.parseSpecialEntities(start, this.getEndOfDoc());
            this.newReadWords(start, this.getEndOfDoc());
        }
        finally {
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    private DocumentModel() {
        this.global.setGlobalHolderChangeListener(this);
        this.global.setGlobalReplacementListener(this);
        lud = LookUpDictionary.getInstance();
        confidenceWeights = ConfidenceWeights.getInstance();
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            this.holderLists.put(t, new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.AlphaComparator()));
            this.addChangeListener(new HolderChangeListener(){

                @Override
                public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
                }

                @Override
                public void instanceAboutToChange(Instance instance, int type) {
                    DocumentModel.this.instances.remove(instance.start);
                }

                @Override
                public void instanceChanged(Instance instance, int type) {
                    DocumentModel.this.instances.put(instance.start, instance);
                }

                @Override
                public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                    ((TreeSet)DocumentModel.this.holderLists.get(type)).remove(holder);
                }

                @Override
                public void holderFilled(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                    ((TreeSet)DocumentModel.this.holderLists.get(type)).add(holder);
                }
            }, t);
            ++n2;
        }
        this.addChangeListener(confidenceWeights, 102);
        this.clear();
    }

    public void clear() {
        this.doc = new DefaultStyledDocument();
        this.words = new TreeSet();
        this.instances = new TreeMap(new PosCompare());
        this.entities = new TreeMap(new PosCompare());
        this.ignored = new TreeMap(new PosCompare());
        for (TreeSet<InstanceHolder<? extends Instance>> ts : this.holderLists.values()) {
            ts.clear();
        }
        this.charset = Charset.defaultCharset();
    }

    private WordHolder getReferenceTo(String word) {
        WordHolder newWH = new WordHolder(word);
        if (!this.words.add(newWH)) {
            return this.words.floor(newWH);
        }
        newWH.setDictionaryRef(lud.checkWords(word));
        return newWH;
    }

    public String getShortReplacementAnalysis(int line) {
        return this.shortCounts[line];
    }

    public void countReplacements() {
        int known = 0;
        int lr = 0;
        int soundex = 0;
        int[] editDistances = new int[11];
        int total = 0;
        TreeSet<SuggestedReplacement> replacements = new TreeSet<SuggestedReplacement>(new SuggestedReplacement.AlphaComparator());
        for (InstanceHolder<? extends Instance> repIH : this.getHolderList(102)) {
            replacements.addAll(repIH.getWordHolder().getReplacementsUsed());
        }
        for (SuggestedReplacement sr : replacements) {
            int currentED;
            ++total;
            if (sr.isKnownVariant()) {
                ++known;
            }
            if (sr.isLetterReplacement()) {
                ++lr;
            }
            if (sr.isSoundex()) {
                ++soundex;
            }
            if ((currentED = sr.getEditDistance()) > 10) {
                currentED = 10;
            }
            int n = currentED;
            editDistances[n] = editDistances[n] + 1;
        }
        int EDcount = 0;
        int i = 0;
        while (i < 11) {
            EDcount += i * editDistances[i];
            ++i;
        }
        double averageED = total != 0 ? new Double(EDcount) / new Double(total) : 0.0;
        this.shortCounts[0] = "Total: " + total;
        this.shortCounts[1] = "Known Variants: " + known;
        this.shortCounts[2] = "Letter Replacement Rules: " + lr;
        this.shortCounts[3] = "Phonetic Matching: " + soundex;
        String edDist = Double.toString(averageED);
        edDist = edDist.substring(0, Math.min(5, edDist.length()));
        this.shortCounts[4] = "Average Edit Distance: " + edDist;
    }

    public String getReplacementAnalysis() {
        int known = 0;
        int lr = 0;
        int soundex = 0;
        int[] editDistances = new int[11];
        int total = 0;
        TreeSet<SuggestedReplacement> replacements = new TreeSet<SuggestedReplacement>(new SuggestedReplacement.AlphaComparator());
        for (InstanceHolder<? extends Instance> repIH : this.getHolderList(102)) {
            replacements.addAll(repIH.getWordHolder().getReplacementsUsed());
        }
        for (SuggestedReplacement sr : replacements) {
            int currentED;
            ++total;
            if (sr.isKnownVariant()) {
                ++known;
            }
            if (sr.isLetterReplacement()) {
                ++lr;
            }
            if (sr.isSoundex()) {
                ++soundex;
            }
            if ((currentED = sr.getEditDistance()) > 10) {
                currentED = 10;
            }
            int n = currentED;
            editDistances[n] = editDistances[n] + 1;
        }
        if (total == 0) {
            return "No analysis possible";
        }
        int EDcount = 0;
        double[] editDistancePercents = new double[11];
        int i = 0;
        while (i < 11) {
            EDcount += i * editDistances[i];
            editDistancePercents[i] = new Double(editDistances[i]) / new Double(total) * 100.0;
            ++i;
        }
        double averageED = new Double(EDcount) / new Double(total);
        double knownPercent = new Double(known) / new Double(total) * 100.0;
        double lrPercent = new Double(lr) / new Double(total) * 100.0;
        double soundexPercent = new Double(soundex) / new Double(total) * 100.0;
        String toReturn = "\tCount\tPercent of total";
        toReturn = String.valueOf(toReturn) + "\rTotal Replacements:\t" + total;
        toReturn = String.valueOf(toReturn) + "\rFinding Method Analysis";
        toReturn = String.valueOf(toReturn) + "\rKnown Variant\t" + known + "\t" + knownPercent;
        toReturn = String.valueOf(toReturn) + "\rLetter Replacement\t" + lr + "\t" + lrPercent;
        toReturn = String.valueOf(toReturn) + "\rSoundex\t" + soundex + "\t" + soundexPercent;
        toReturn = String.valueOf(toReturn) + "\r";
        toReturn = String.valueOf(toReturn) + "\rEdit Distance Analysis";
        int i2 = 0;
        while (i2 < 11) {
            toReturn = String.valueOf(toReturn) + "\r" + i2 + " edits\t" + editDistances[i2] + "\t" + editDistancePercents[i2];
            ++i2;
        }
        toReturn = String.valueOf(toReturn) + "\r\rAverage Edit Distance:\t" + averageED;
        return toReturn;
    }

    public JoinEdit getJoinEdit(int start, int end) throws BadLocationException {
        return new JoinEdit(start, end);
    }

    public ProcessAllVariantsEdit getProcessAllVariantsEdit(double threshold, boolean updateConfidenceWeights) {
        return new ProcessAllVariantsEdit(threshold, updateConfidenceWeights);
    }

    private void parseSpecialEntities(int start, int end) throws BadLocationException {
        if (end - start < 1) {
            return;
        }
        if (end > this.getEndOfDoc()) {
            end = this.getEndOfDoc();
        }
        this.global.startProgress(end - start);
        this.global.writeProgressMessage("Checking entities...");
        int offset = 0;
        try {
            for (Map.Entry<String, String> entityMapping : this.global.getEntities().entrySet()) {
                Pattern emPattern = Pattern.compile(entityMapping.getKey());
                Matcher emMatcher = emPattern.matcher(this.doc.getText(start, end - start - offset));
                while (emMatcher.find()) {
                    int emStart = start + emMatcher.start() - offset;
                    int emEnd = start + emMatcher.end() - offset;
                    if (this.isIgnored(this.doc.createPosition(emStart))) continue;
                    AttributeSet atts = this.getAttributesAtPos(emStart);
                    this.doc.remove(emStart, emEnd - emStart);
                    this.doc.insertString(emStart, entityMapping.getValue(), atts);
                    offset += emEnd - emStart - entityMapping.getValue().length();
                    Position entityStartPos = this.doc.createPosition(emStart);
                    this.entities.put(entityStartPos, new Entity(entityStartPos, emMatcher.group(), entityMapping.getValue()));
                }
            }
            Pattern entityPattern = Pattern.compile("&[#]?[x]?([a-zA-Z0-9]+);");
            Matcher entityMatcher = entityPattern.matcher(this.doc.getText(start, end - start - offset));
            offset = 0;
            while (entityMatcher.find()) {
                String entity = entityMatcher.group(1);
                String wholeEntity = entityMatcher.group();
                int entityStart = start + entityMatcher.start() - offset;
                int entityEnd = start + entityMatcher.end() - offset;
                if (!this.isIgnored(this.doc.createPosition(entityStart))) {
                    if (entity.matches("^[a-fA-F0-9]+$")) {
                        int hex = Integer.parseInt(entity, 16);
                        char c = (char)hex;
                        String entityRep = String.valueOf(c);
                        AttributeSet atts = this.getAttributesAtPos(entityStart);
                        this.doc.remove(entityStart, entityEnd - entityStart);
                        this.doc.insertString(entityStart, entityRep, atts);
                        offset += entityEnd - entityStart - entityRep.length();
                        Position entityStartPos = this.doc.createPosition(entityStart);
                        this.entities.put(entityStartPos, new Entity(entityStartPos, wholeEntity, entityRep));
                    } else {
                        Position entityStartPos = this.doc.createPosition(entityStart);
                        this.entities.put(entityStartPos, new Entity(entityStartPos, wholeEntity));
                    }
                }
                this.global.setProgressCurrent(entityEnd);
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private void parseXMLTags(int start) throws BadLocationException, InvalidInstanceChangeException {
        if (this.getDocLength() - start < 1) {
            return;
        }
        try {
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Reading <variant> xml tags...");
            int offset = 0;
            Pattern variantPattern = Pattern.compile("(<join original=\"([^\"]*)\">)?<variant>([^<>]*)</variant>(</join>)?");
            Matcher variantMatcher = variantPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (variantMatcher.find()) {
                String variant = variantMatcher.group(3);
                int tagStart = start + variantMatcher.start() - offset;
                int tagEnd = start + variantMatcher.end() - offset;
                this.doc.remove(tagStart, tagEnd - tagStart);
                this.doc.insertString(tagStart, variant, null);
                offset += tagEnd - tagStart - variant.length();
                String currentWordStringLC = variant.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                VariantInstance added = wh.addVariant(this.doc.createPosition(tagStart), variant);
                added.setUserChanged(true);
                if (variantMatcher.group(2) != null) {
                    added.setJoin(true);
                    added.setJoinString(variantMatcher.group(2));
                }
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Reading <correct> xml tags...");
            offset = 0;
            Pattern correctPattern = Pattern.compile("(<join original=\"([^\"]*)\">)?<correct>([^<>]*)</correct>(</join>)?");
            Matcher correctMatcher = correctPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (correctMatcher.find()) {
                String word = correctMatcher.group(3);
                int tagStart = start + correctMatcher.start() - offset;
                int tagEnd = start + correctMatcher.end() - offset;
                this.doc.remove(tagStart, tagEnd - tagStart);
                this.doc.insertString(tagStart, word, null);
                offset += tagEnd - tagStart - word.length();
                String currentWordStringLC = word.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                CorrectInstance added = wh.addCorrect(this.doc.createPosition(tagStart), word);
                added.setUserChanged(true);
                if (correctMatcher.group(2) != null) {
                    added.setJoin(true);
                    added.setJoinString(correctMatcher.group(2));
                }
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Reading <replaced> xml tags...");
            offset = 0;
            confidenceWeights.setUpdate(this.global.isTrainFromXML());
            Pattern replacedPattern = Pattern.compile("(<join original=\"([^\"]*)\">)?<replaced variant=\"([^\"]*)\" foundBy=\"([a-z]*)\" replacementType=\"([a-z]*)\" ed=\"([1-9]+)\">([^<>]*)</replaced>(</join>)?");
            Matcher replacedMatcher = replacedPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (replacedMatcher.find()) {
                boolean isJoin;
                String variant = replacedMatcher.group(3);
                String foundBy = replacedMatcher.group(4);
                String repType = replacedMatcher.group(5);
                String ed = replacedMatcher.group(6);
                String replacement = replacedMatcher.group(7);
                int tagStart = start + replacedMatcher.start() - offset;
                int tagEnd = start + replacedMatcher.end() - offset;
                ReplacementTempClass replacementInfo = new ReplacementTempClass();
                replacementInfo.variant = variant;
                replacementInfo.ed = Integer.parseInt(ed);
                if (foundBy.contains("s")) {
                    replacementInfo.soundex = true;
                }
                if (foundBy.contains("l")) {
                    replacementInfo.lr = true;
                }
                if (foundBy.contains("p")) {
                    replacementInfo.knownpre = true;
                } else if (foundBy.contains("u")) {
                    replacementInfo.knownua = true;
                }
                if (repType.contains("u")) {
                    replacementInfo.uaToDic = true;
                }
                if (repType.contains("r")) {
                    replacementInfo.inDict = true;
                }
                this.doc.remove(tagStart, tagEnd - tagStart);
                this.doc.insertString(tagStart, replacement, null);
                offset += tagEnd - tagStart - replacement.length();
                String joinOriginal = null;
                boolean bl = isJoin = replacedMatcher.group(2) != null;
                if (isJoin) {
                    joinOriginal = replacedMatcher.group(2);
                }
                this.xmlReplaceWord(this.doc.createPosition(tagStart), replacement, replacementInfo, isJoin, joinOriginal);
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Dealing with <join> xml tags...");
            offset = 0;
            Pattern joinPattern = Pattern.compile("<join original=\"([^\"]*)\">([^<>]*)</join>");
            Matcher joinMatcher = joinPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
            while (joinMatcher.find()) {
                int tagStart = start + joinMatcher.start() - offset;
                int tagEnd = start + joinMatcher.end() - offset;
                String joinOriginal = joinMatcher.group(1);
                String joinNew = joinMatcher.group(2);
                this.doc.remove(tagStart, tagEnd - tagStart);
                this.doc.insertString(tagStart, joinNew, null);
                offset += tagEnd - tagStart - joinNew.length();
                this.newReadWords(tagStart, tagStart + joinNew.length());
                Instance added = this.getWordAt(tagStart);
                added.setJoin(true);
                added.setJoinString(joinOriginal);
                this.global.setProgressCurrent(tagEnd);
            }
            this.global.startProgress(this.getDocLength() - start);
            this.global.writeProgressMessage("Ignoring text which should be ignored...");
            for (String ignore : this.global.getIgnored()) {
                Pattern tagPattern = Pattern.compile(ignore);
                Matcher tagMatcher = tagPattern.matcher(this.doc.getText(start, this.getDocLength() - start));
                while (tagMatcher.find()) {
                    int tagStart = start + tagMatcher.start();
                    int tagEnd = start + tagMatcher.end();
                    IgnorableText toIgnore = new IgnorableText(this.doc.createPosition(tagStart), tagMatcher.group());
                    this.global.getGlobalIgnorableTextListener().ignore(toIgnore);
                    IgnorableText previous = this.ignored.put(this.doc.createPosition(tagStart), toIgnore);
                    if (previous != null && previous.original.length() > toIgnore.original.length()) {
                        this.ignored.put(previous.start, previous);
                    }
                    this.global.setProgressCurrent(tagEnd);
                }
            }
        }
        finally {
            confidenceWeights.setUpdateToDefault();
            this.global.finishProgress();
        }
    }

    private void newReadWords(int start, int end) throws BadLocationException {
        if (end - start < 1) {
            return;
        }
        if (end > this.getEndOfDoc()) {
            end = this.getEndOfDoc();
        }
        this.global.startProgress(end - start);
        this.global.writeProgressMessage("Evaluating words...");
        try {
            String text = this.doc.getText(start, end - start);
            Pattern wordPattern = Pattern.compile("([\\p{L}\\'\\-\\^~=]|(&[#]?[a-zA-Z0-9]+;))+");
            Matcher wordMatcher = wordPattern.matcher(text);
            int textLength = text.length();
            while (wordMatcher.find()) {
                int wmStart = wordMatcher.start();
                this.global.setProgressCurrent(wmStart);
                int wmEnd = wordMatcher.end();
                int wordStart = start + wmStart;
                String currentWordString = wordMatcher.group();
                char charBefore = 'S';
                if (wmStart > 0) {
                    charBefore = text.charAt(wmStart - 1);
                }
                char charAfter = 'E';
                if (wmEnd < textLength) {
                    charAfter = text.charAt(wmEnd);
                }
                if (!this.isValidWord(currentWordString) || this.isIgnored(this.doc.createPosition(wordStart)) || Character.isDigit(charBefore) || Character.isDigit(charAfter) || this.getWordAt(wordStart) != null) continue;
                String currentWordStringLC = currentWordString.toLowerCase();
                WordHolder wh = this.getReferenceTo(currentWordStringLC);
                if (wh.isInDictionary()) {
                    wh.addCorrect(this.doc.createPosition(wordStart), currentWordString);
                    continue;
                }
                wh.addVariant(this.doc.createPosition(wordStart), currentWordString);
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private boolean isIgnored(Position pos) {
        Position closestKey = this.ignored.floorKey(pos);
        return closestKey != null && this.ignored.get(closestKey).containsPosition(pos.getOffset());
    }

    private int insertText(String text, AttributeSet textStyle) throws BadLocationException {
        if (text.length() < 1) {
            return this.getEndOfDoc();
        }
        try {
            if (this.doc.getLength() > 0) {
                this.doc.insertString(this.getEndOfDoc(), "\n\n", textStyle);
            }
            int start = this.getEndOfDoc();
            this.doc.insertString(start, text, textStyle);
            return start;
        }
        catch (BadLocationException e) {
            this.global.showException("Error occurred inserting text.", e);
            return this.getEndOfDoc();
        }
    }

    private boolean isValidWord(String word) {
        return !word.contains("--") && !word.equals("-");
    }

    public Instance getWordAt(int caretPos) throws BadLocationException {
        Instance toReturn;
        Map.Entry<Position, Instance> entry = this.instances.floorEntry(this.doc.createPosition(caretPos));
        Instance instance = toReturn = entry == null ? null : entry.getValue();
        if (toReturn != null && toReturn.containsPosition(caretPos)) {
            return toReturn;
        }
        return null;
    }

    private void revertEntities() {
        this.global.startProgress(this.entities.size());
        this.global.writeProgressMessage("Reverting entities to original state");
        try {
            try {
                TreeMap<Position, Entity> newEntities = new TreeMap<Position, Entity>(new PosCompare());
                for (Entity entity : this.entities.values()) {
                    Instance instanceAtSamePos = this.instances.remove(entity.getStart());
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.saveStart();
                    }
                    entity.revertInText(this.doc);
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.restoreStart(this.doc, 0);
                        this.instances.put(instanceAtSamePos.start, instanceAtSamePos);
                    }
                    newEntities.put(entity.getStart(), entity);
                }
                this.entities = newEntities;
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred reverting entities to original state", ex);
                this.global.finishProgress();
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    private void reReplaceEntities() {
        this.global.startProgress(this.entities.size());
        this.global.writeProgressMessage("Reverting entities to VARD state");
        try {
            try {
                TreeMap<Position, Entity> newEntities = new TreeMap<Position, Entity>(new PosCompare());
                for (Entity entity : this.entities.values()) {
                    Instance instanceAtSamePos = this.instances.remove(entity.getStart());
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.saveStart();
                    }
                    entity.reReplaceInText(this.doc);
                    if (instanceAtSamePos != null) {
                        instanceAtSamePos.restoreStart(this.doc, 0);
                        this.instances.put(instanceAtSamePos.start, instanceAtSamePos);
                    }
                    newEntities.put(entity.getStart(), entity);
                }
                this.entities = newEntities;
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred reverting entities to VARD state", ex);
                this.global.finishProgress();
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    public void setAllHighlights(AttributeSet atts) {
        this.doc.setCharacterAttributes(0, this.doc.getLength(), atts, false);
    }

    public void reIgnoreAllIgnored() {
        for (IgnorableText it : this.ignored.values()) {
            this.global.getGlobalIgnorableTextListener().ignore(it);
        }
    }

    private void readFile(File file) {
        DefaultStyledDocument d = new DefaultStyledDocument();
        if (file == null) {
            this.global.showException("No File selected", new NullPointerException());
            return;
        }
        StyledEditorKit sek = file.getName().endsWith("rtf") ? new RTFEditorKit() : new StyledEditorKit();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Reading file: " + file.getName() + "...");
        try {
            try {
                this.charset = CharsetToolkit.guessEncoding(file, 4096);
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
                sek.read(isr, (Document)d, 0);
                this.doc = d;
            }
            catch (IOException ex) {
                this.global.showException("Error occurred reading file", ex);
                this.global.finishProgress();
            }
            catch (BadLocationException ex) {
                this.global.showException("Error occurred reading file", ex);
                this.global.finishProgress();
            }
        }
        finally {
            this.global.finishProgress();
        }
    }

    public boolean saveToFile(File file) {
        this.global.lockFinishProgress();
        this.revertEntities();
        this.global.startIndeterminateProgress();
        this.global.writeProgressMessage("Saving without tags: " + file.getName() + "...");
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            if (file.getName().endsWith("rtf")) {
                new RTFEditorKit().write(fileOut, (Document)this.doc, 0, this.doc.getLength());
            } else {
                OutputStreamWriter plainOut = new OutputStreamWriter((OutputStream)fileOut, this.charset);
                new DefaultEditorKit().write(plainOut, (Document)this.doc, 0, this.doc.getLength());
                plainOut.close();
            }
            fileOut.close();
            return true;
        }
        catch (BadLocationException e) {
            this.global.showException("Error occurred saving document: " + file.getAbsolutePath(), e);
            return false;
        }
        catch (IOException e) {
            this.global.showException("Error occurred saving document: " + file.getAbsolutePath(), e);
            return false;
        }
        finally {
            this.global.finishProgress();
            this.reReplaceEntities();
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    public boolean exportToXML(File file) {
        this.global.lockFinishProgress();
        this.revertEntities();
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
            this.global.startProgress(this.instances.size());
            this.global.writeProgressMessage("Saving with xml tags: " + file.getName() + "...");
            String text = this.doc.getText(this.getStartOfDoc(), this.doc.getLength());
            Collection backwardsInstances = this.instances.descendingMap().values();
            int count = 0;
            for (Instance instance : backwardsInstances) {
                if (instance.isXMLRequired()) {
                    text = String.valueOf(text.substring(0, instance.getStartOffset())) + instance.getXMLTaggedVersion() + text.substring(instance.getEndOffset());
                }
                this.global.setProgressCurrent(++count);
            }
            out.println(text);
            out.close();
            return true;
        }
        catch (BadLocationException e) {
            this.global.showException("Error occurred saving xml file: " + file.getAbsolutePath(), e);
            return false;
        }
        catch (IOException e) {
            this.global.showException("Error occurred saving xml file: " + file.getAbsolutePath(), e);
            return false;
        }
        finally {
            this.global.finishProgress();
            this.reReplaceEntities();
            this.global.unlockFinishProgress();
            this.global.finishProgress();
        }
    }

    public AttributeSet getAttributesAtPos(int pos) {
        return this.doc.getCharacterElement(pos).getAttributes();
    }

    public boolean isCharAtPosLetter(int pos) throws BadLocationException {
        return Character.isLetter(this.doc.getText(pos, 1).charAt(0));
    }

    public int getStartOfDoc() {
        return 0;
    }

    public int getEndOfDoc() {
        return this.getDocLength();
    }

    public void findReplacementsForWord(WordHolder word) {
        word.setReplacements(lud.findReplacements(word.getWord(), word.getSoundexCode(), confidenceWeights));
    }

    private void getReplacements() {
        TreeSet<InstanceHolder<? extends Instance>> varIHs = this.getHolderList(101);
        this.global.startProgress(varIHs.size());
        this.global.writeProgressMessage("Finding replacements...");
        int currentPos = 0;
        for (InstanceHolder instanceHolder : varIHs) {
            this.findReplacementsForWord(instanceHolder.getWordHolder());
            this.global.setProgressCurrent(++currentPos);
        }
        this.global.finishProgress();
    }

    public String[] getShortCounts() {
        return this.shortCounts;
    }

    private void xmlReplaceWord(Position start, String replacement, ReplacementTempClass rtc, boolean inJoin, String joinString) throws InvalidInstanceChangeException, BadLocationException {
        Word wordInDic;
        if (!rtc.inDict) {
            wordInDic = new Word(replacement, null, rtc.uaToDic, false, 1);
        } else {
            wordInDic = lud.checkWords(replacement);
            if (wordInDic == null && rtc.uaToDic) {
                wordInDic = lud.addUserWord(replacement);
            } else if (wordInDic == null) {
                wordInDic = new Word(replacement, null, rtc.uaToDic, false, 1);
            }
        }
        SuggestedReplacement rep = new SuggestedReplacement(wordInDic, rtc.variant, confidenceWeights);
        rep.setEditDistance(rtc.ed);
        rep.setKnownVariant(rtc.knownua || rtc.knownpre, rtc.knownua);
        rep.setLetterReplacement(rtc.lr);
        rep.setSoundex(rtc.soundex);
        WordHolder wh = this.getReferenceTo(rtc.variant.toLowerCase());
        ReplacedInstance ri = wh.addReplaced(start, rtc.variant, rep, this.doc);
        ri.setJoin(inJoin);
        ri.setJoinString(joinString);
    }

    public LookUpDictionary getLud() {
        return lud;
    }

    public void setLud(LookUpDictionary l) {
        lud = l;
    }

    public static String getStatsHeader() {
        return "File\tTotal Words\tVariants Forms\tReplaced\tModern Forms\tTotal Tokens\tVariant Tokens\tReplaced Tokens\tModern Tokens";
    }

    public String getStats() {
        int wordsCount = this.words.size();
        int variantsCount = 0;
        int replacedCount = 0;
        int correctCount = 0;
        int variantTokenCount = 0;
        int replacedTokenCount = 0;
        int correctTokenCount = 0;
        for (WordHolder wh : this.words) {
            variantTokenCount += wh.getVariantsSize();
            replacedTokenCount += wh.getReplacedSize();
            correctTokenCount += wh.getCorrectSize();
            if (wh.isAtleastOneInstanceAVariant()) {
                ++variantsCount;
            }
            if (wh.isAtleastOneInstanceAReplaced()) {
                ++replacedCount;
            }
            if (!wh.isAtleastOneInstanceACorrect()) continue;
            ++correctCount;
        }
        int tokenCount = variantTokenCount + replacedTokenCount + correctTokenCount;
        return String.valueOf(wordsCount) + "\t" + variantsCount + "\t" + replacedCount + "\t" + correctCount + "\t" + tokenCount + "\t" + variantTokenCount + "\t" + replacedTokenCount + "\t" + correctTokenCount;
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance lastRemoved, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.holderEmptied(holder, lastRemoved, type);
        }
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance lastAdded, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.holderFilled(holder, lastAdded, type);
        }
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.instanceAboutToChange(instance, type);
        }
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.instanceChanged(instance, type);
        }
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.listChanged(holder, type);
        }
    }

    @Override
    public void restoreEntities(Collection<Entity> entitiesToRestore, int offset) {
        if (entitiesToRestore == null || entitiesToRestore.isEmpty()) {
            return;
        }
        try {
            for (Entity entity : entitiesToRestore) {
                entity.restoreStart(this.doc, offset);
                this.entities.put(entity.getStart(), entity);
            }
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred restoring entity", ex);
        }
    }

    @Override
    public Collection<Entity> removeEntities(Position start, Position end) {
        SortedMap<Position, Entity> toRemove = this.entities.subMap(start, end);
        ArrayList<Entity> removed = new ArrayList<Entity>();
        removed.addAll(toRemove.values());
        toRemove.clear();
        for (Entity entity : removed) {
            entity.saveStart();
        }
        return removed;
    }

    @Override
    public Collection<IgnorableText> removeIgnored(Position start, Position end) {
        SortedMap<Position, IgnorableText> toRemove = this.ignored.subMap(start, end);
        ArrayList<IgnorableText> removed = new ArrayList<IgnorableText>();
        removed.addAll(toRemove.values());
        toRemove.clear();
        for (IgnorableText it : removed) {
            it.saveStart();
        }
        return removed;
    }

    @Override
    public void restoreIgnored(Collection<IgnorableText> ignoredToRestore, int offset) {
        if (ignoredToRestore == null || ignoredToRestore.isEmpty()) {
            return;
        }
        try {
            for (IgnorableText it : ignoredToRestore) {
                it.restoreStart(this.doc, offset);
                this.ignored.put(it.getStart(), it);
                this.global.getGlobalIgnorableTextListener().ignore(it);
            }
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred restoring ignored text", ex);
        }
    }

    @Override
    public Collection<Instance> removeInstances(Position start, Position end) {
        SortedMap<Position, Instance> toRemove = this.instances.subMap(start, end);
        ArrayList<Instance> removed = new ArrayList<Instance>();
        removed.addAll(toRemove.values());
        toRemove.clear();
        for (Instance instance : removed) {
            instance.saveStart();
            instance.removeSelfFromHolder();
        }
        return removed;
    }

    @Override
    public void restoreInstances(Collection<Instance> instancesToRestore, int offset) {
        if (instancesToRestore == null || instancesToRestore.isEmpty()) {
            return;
        }
        try {
            for (Instance instance : instancesToRestore) {
                instance.restoreStart(this.doc, offset);
                instance.addSelfToHolder();
                this.instances.put(instance.getStart(), instance);
            }
        }
        catch (BadLocationException ex) {
            this.global.showException("Error occurred restoring word after join", ex);
        }
    }

    static /* synthetic */ void access$6(DocumentModel documentModel) {
        documentModel.getReplacements();
    }

    public static class AddVariantToLookUpEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        SuggestedReplacement rep;

        public AddVariantToLookUpEdit(SuggestedReplacement rep) {
            this.rep = rep;
        }

        public void execute() {
            if (!this.executed) {
                if (lud.addUserVariant(this.rep.getOldWord(), this.rep.getReplacement())) {
                    lud.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.rep.getOldWord() + " -> " + this.rep.getReplacementString());
                }
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (!this.executed) {
                throw new CannotUndoException();
            }
            lud.removeVariant(this.rep.getOldWord());
            lud.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.rep.getOldWord() + " -> " + this.rep.getReplacementString());
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                if (lud.addUserVariant(this.rep.getOldWord(), this.rep.getReplacement())) {
                    lud.setVariantsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.rep.getOldWord() + " -> " + this.rep.getReplacementString());
                }
            } else {
                throw new CannotRedoException();
            }
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Add " + this.rep.getOldWord() + " -> " + this.rep.getReplacementString() + " to known variants list.";
        }
    }

    public static class AddWordToDictionaryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        WordHolder wh;
        String word;

        public AddWordToDictionaryEdit(WordHolder wh, String word) {
            this.wh = wh;
            this.word = word;
        }

        public void execute() {
            if (!this.executed && lud.checkWords(this.word.toString()) == null) {
                this.wh.setDictionaryRef(lud.addUserWord(this.word.toString()));
                lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed) {
                if (lud.removeWord(this.word)) {
                    this.wh.setDictionaryRef(null);
                    lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                }
            } else {
                throw new CannotUndoException();
            }
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (!this.undone) {
                throw new CannotRedoException();
            }
            this.wh.setDictionaryRef(lud.addUserWord(this.word.toString()));
            lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Add " + this.word + " to dictionary.";
        }
    }

    public class JoinEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private boolean executed = false;
        private boolean undone = false;
        private boolean valid = false;
        private String whyInvalid = "";
        private TreeMap<Integer, String> textRemoved;
        private TreeMap<Integer, AttributeSet> attsRemoved;
        private Collection<Instance> instancesRemoved;
        private Collection<IgnorableText> ignoredTextRemoved;
        private Collection<Entity> entitiesRemoved;
        private String originalText;
        private String newWord;
        private int start;
        private int end;
        private Instance addedInstance;
        private Collection<Instance> undoneInstances;

        private JoinEdit(int start, int end) throws BadLocationException {
            TreeSet<Instance> wordsSelected = new TreeSet<Instance>();
            int i = start - 1;
            while (i <= end) {
                Instance toAdd = DocumentModel.this.getWordAt(i);
                if (toAdd != null) {
                    if (toAdd.getType() == 102) {
                        this.valid = false;
                        this.whyInvalid = "Cannot join a replaced string.";
                        return;
                    }
                    wordsSelected.add(toAdd);
                }
                ++i;
            }
            if (wordsSelected.size() < 2) {
                this.valid = false;
                this.whyInvalid = "At least 2 words need to be selected to join.";
                return;
            }
            int newStart = ((Instance)wordsSelected.first()).getStartOffset();
            int newEnd = ((Instance)wordsSelected.last()).getEndOffset();
            this.start = newStart;
            this.end = newEnd;
            this.newWord = "";
            for (Instance word : wordsSelected) {
                this.newWord = String.valueOf(this.newWord) + word.getDisplayString();
                if (this.newWord.endsWith("-")) {
                    this.newWord = this.newWord.substring(0, this.newWord.length() - 1);
                }
                if (!this.newWord.startsWith("-")) continue;
                this.newWord = this.newWord.substring(1);
            }
            if (!DocumentModel.this.isValidWord(this.newWord)) {
                this.valid = false;
                this.whyInvalid = "Joined word produced is invalid.";
                return;
            }
            this.originalText = DocumentModel.this.doc.getText(this.start, this.end - this.start);
            this.valid = true;
        }

        private void doJoin() throws BadLocationException {
            this.instancesRemoved = DocumentModel.this.global.getGlobalReplacementListener().removeInstances(DocumentModel.this.doc.createPosition(this.start), DocumentModel.this.doc.createPosition(this.end));
            this.entitiesRemoved = new ArrayList<Entity>();
            this.ignoredTextRemoved = new ArrayList<IgnorableText>();
            this.textRemoved = new TreeMap();
            this.attsRemoved = new TreeMap();
            int remStart = -1;
            int remEnd = -1;
            for (Instance instance : this.instancesRemoved) {
                remEnd = instance.getStartOffset();
                if (instance.getDisplayString().startsWith("-")) {
                    ++remEnd;
                }
                if (remStart != -1) {
                    this.textRemoved.put(remStart, DocumentModel.this.doc.getText(remStart, remEnd - remStart));
                    this.attsRemoved.put(remStart, DocumentModel.this.getAttributesAtPos(remStart));
                    Position remStartPos = DocumentModel.this.doc.createPosition(remStart);
                    Position remEndPos = DocumentModel.this.doc.createPosition(remEnd);
                    this.entitiesRemoved.addAll(DocumentModel.this.global.getGlobalReplacementListener().removeEntities(remStartPos, remEndPos));
                    this.ignoredTextRemoved.addAll(DocumentModel.this.global.getGlobalReplacementListener().removeIgnored(remStartPos, remEndPos));
                    DocumentModel.this.doc.remove(remStart, remEnd - remStart);
                }
                remStart = instance.getEndOffset();
                if (!instance.getDisplayString().endsWith("-")) continue;
                --remStart;
            }
            if (this.undoneInstances != null) {
                DocumentModel.this.global.getGlobalReplacementListener().restoreInstances(this.undoneInstances, 0);
            } else {
                DocumentModel.this.newReadWords(this.start, this.end);
                this.addedInstance = (Instance)DocumentModel.this.instances.get(DocumentModel.this.doc.createPosition(this.start));
                this.addedInstance.setJoin(true);
                String originalJoin = this.originalText;
                for (Instance instance : this.instancesRemoved) {
                    if (!instance.isJoin()) continue;
                    originalJoin = originalJoin.replaceFirst(instance.getDisplayString(), instance.getJoinString());
                }
                this.addedInstance.setJoinString(originalJoin);
            }
        }

        private void undoJoin() throws BadLocationException {
            if (this.addedInstance != null) {
                this.undoneInstances = DocumentModel.this.global.getGlobalReplacementListener().removeInstances(DocumentModel.this.doc.createPosition(this.start), DocumentModel.this.doc.createPosition(this.end));
            }
            for (Map.Entry<Integer, String> stringToRestore : this.textRemoved.entrySet()) {
                DocumentModel.this.doc.insertString(stringToRestore.getKey(), stringToRestore.getValue(), this.attsRemoved.get(stringToRestore.getKey()));
            }
            DocumentModel.this.global.getGlobalReplacementListener().restoreInstances(this.instancesRemoved, 0);
            DocumentModel.this.global.getGlobalReplacementListener().restoreEntities(this.entitiesRemoved, 0);
            DocumentModel.this.global.getGlobalReplacementListener().restoreIgnored(this.ignoredTextRemoved, 0);
        }

        public void execute() throws BadLocationException, InvalidInstanceChangeException {
            if (!this.executed && this.valid) {
                try {
                    this.doJoin();
                    this.executed = true;
                }
                catch (BadLocationException ex) {
                    this.undoJoin();
                    throw ex;
                }
            } else {
                throw new InvalidInstanceChangeException("Join is invalid");
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                try {
                    this.undoJoin();
                    this.undone = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.doJoin();
                    }
                    catch (BadLocationException e) {
                        throw new CannotUndoException();
                    }
                }
            } else {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                try {
                    this.doJoin();
                    this.undone = false;
                }
                catch (BadLocationException ex) {
                    throw new CannotUndoException();
                }
            } else {
                throw new CannotRedoException();
            }
        }

        @Override
        public boolean canUndo() {
            return this.executed && this.valid;
        }

        @Override
        public boolean canRedo() {
            return this.undone && this.valid;
        }

        @Override
        public String getPresentationName() {
            return "Join words (" + this.originalText + " -> " + this.newWord + ")";
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getWhyInvalid() {
            return this.whyInvalid;
        }
    }

    public static class PosCompare
    implements Comparator<Position> {
        @Override
        public int compare(Position p1, Position p2) {
            return p1.getOffset() - p2.getOffset();
        }
    }

    public class ProcessAllVariantsEdit
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 1L;
        private boolean executed;
        private boolean undone;
        private boolean update;
        private boolean hasChangedBefore = ConfidenceWeights.hasChanged();
        private double threshold;
        private int currentPos;
        private ArrayList<WordHolder.ReplaceAllFInstancesEdit<VariantInstance>> edits;
        private ArrayList<WordHolder.ReplaceAllFInstancesEdit<VariantInstance>> editsUndone;
        private ArrayList<WordHolder.ReplaceAllFInstancesEdit<VariantInstance>> editsRedone;

        private ProcessAllVariantsEdit(double threshold, boolean updateConfidenceWeights) {
            this.threshold = threshold;
            this.update = updateConfidenceWeights;
            this.edits = new ArrayList();
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed) {
                block9: {
                    DocumentModel.access$6(DocumentModel.this);
                    varIHs = new TreeSet<InstanceHolder<? extends Instance>>();
                    varIHs.addAll(DocumentModel.this.getHolderList(101));
                    DocumentModel.access$2(DocumentModel.this).startProgress(varIHs.size());
                    DocumentModel.access$2(DocumentModel.this).writeProgressMessage("Replacing variants...");
                    DocumentModel.confidenceWeights.setUpdate(this.update);
                    this.currentPos = 0;
                    try {
                        try {
                            for (InstanceHolder varIH : varIHs) {
                                top = varIH.getWordHolder().getTopReplacement();
                                if (top != null && top.getScoreWithoutUpdating() >= this.threshold) {
                                    edit = new WordHolder.ReplaceAllFInstancesEdit<VariantInstance>(varIH.getWordHolder(), new VariantInstance(), top, DocumentModel.access$1(DocumentModel.this), true);
                                    edit.execute();
                                    this.edits.add(edit);
                                }
                                DocumentModel.access$2(DocumentModel.this).setProgressCurrent(++this.currentPos);
                            }
                            break block9;
                        }
                        catch (InvalidInstanceChangeException ex) {
                            ** for (edit : this.edits)
                        }
lbl-1000:
                        // 1 sources

                        {
                            edit.undo();
                            continue;
                        }
lbl26:
                        // 1 sources

                        throw new CannotExecuteException(ex.getMessage());
                    }
                    finally {
                        DocumentModel.confidenceWeights.setUpdateToDefault();
                        DocumentModel.access$2(DocumentModel.this).finishProgress();
                    }
                }
                this.executed = true;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void undo() throws CannotUndoException {
            block9: {
                if (this.canUndo()) {
                    DocumentModel.access$2(DocumentModel.this).startIndeterminateProgress();
                    this.editsUndone = new ArrayList<E>();
                    toUse = this.edits;
                    if (this.editsRedone != null && !this.editsRedone.isEmpty()) {
                        toUse = this.editsRedone;
                    }
                    DocumentModel.confidenceWeights.setUpdate(this.update);
                    DocumentModel.confidenceWeights.setHasChanged(this.hasChangedBefore);
                    DocumentModel.access$2(DocumentModel.this).startProgress(toUse.size());
                    DocumentModel.access$2(DocumentModel.this).writeProgressMessage("Undoing replacing variants...");
                    this.currentPos = 0;
                    try {
                        try {
                            for (WordHolder.ReplaceAllFInstancesEdit<VariantInstance> edit : toUse) {
                                edit.undo();
                                this.editsUndone.add(edit);
                                DocumentModel.access$2(DocumentModel.this).setProgressCurrent(++this.currentPos);
                            }
                            break block9;
                        }
                        catch (CannotUndoException ex) {
                            ** for (edit : this.editsUndone)
                        }
lbl-1000:
                        // 1 sources

                        {
                            edit.redo();
                            continue;
                        }
lbl25:
                        // 1 sources

                        throw ex;
                    }
                    finally {
                        DocumentModel.confidenceWeights.setUpdateToDefault();
                        DocumentModel.access$2(DocumentModel.this).finishProgress();
                    }
                }
                throw new CannotUndoException();
            }
            this.undone = true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void redo() throws CannotRedoException {
            block8: {
                if (this.canRedo()) {
                    DocumentModel.access$2(DocumentModel.this).startProgress(this.editsUndone.size());
                    DocumentModel.access$2(DocumentModel.this).writeProgressMessage("Redoing replacing variants...");
                    this.editsRedone = new ArrayList<E>();
                    DocumentModel.confidenceWeights.setUpdate(this.update);
                    this.currentPos = 0;
                    try {
                        try {
                            for (WordHolder.ReplaceAllFInstancesEdit<VariantInstance> edit : this.editsUndone) {
                                edit.redo();
                                this.editsRedone.add(edit);
                                DocumentModel.access$2(DocumentModel.this).setProgressCurrent(++this.currentPos);
                            }
                            break block8;
                        }
                        catch (CannotRedoException ex) {
                            ** for (edit : this.editsRedone)
                        }
lbl-1000:
                        // 1 sources

                        {
                            edit.undo();
                            continue;
                        }
lbl20:
                        // 1 sources

                        throw ex;
                    }
                    finally {
                        DocumentModel.confidenceWeights.setUpdateToDefault();
                        DocumentModel.access$2(DocumentModel.this).finishProgress();
                    }
                }
                throw new CannotRedoException();
            }
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Process all variants (" + this.threshold + "%)";
        }
    }

    public static class RemoveWordFromDictionaryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        WordHolder wh;
        String word;

        public RemoveWordFromDictionaryEdit(WordHolder wh, String word) {
            this.wh = wh;
            this.word = word;
        }

        public void execute() {
            if (!this.executed) {
                if (lud.removeWord(this.word)) {
                    this.wh.setDictionaryRef(null);
                    lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                }
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (!this.executed) {
                throw new CannotUndoException();
            }
            this.wh.setDictionaryRef(lud.addUserWord(this.word.toString()));
            lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                if (lud.removeWord(this.word)) {
                    lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                    this.wh.setDictionaryRef(null);
                }
            } else {
                throw new CannotRedoException();
            }
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Remove " + this.word + " from dictionary.";
        }
    }

    public class ReplacementTempClass {
        public boolean lr = false;
        public boolean soundex = false;
        public boolean knownpre = false;
        public boolean knownua = false;
        public boolean inDict = false;
        public boolean uaToDic = false;
        public String variant;
        public int ed;
    }
}

