/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

public abstract class DocumentElement
implements Comparable<DocumentElement> {
    protected Position start;
    protected String original;
    private int startInt1;

    public DocumentElement() {
    }

    protected DocumentElement(Position start, String original) {
        this.start = start;
        this.original = original;
    }

    public Position getStart() {
        return this.start;
    }

    public void saveStart() {
        this.startInt1 = this.start.getOffset();
    }

    public void restoreStart(StyledDocument doc, int offset) throws BadLocationException {
        this.start = doc.createPosition(this.startInt1 + offset);
    }

    public int getSavedStartInt() {
        return this.startInt1;
    }

    public String toString() {
        return String.valueOf(this.start.getOffset()) + ": " + this.original;
    }

    public String getDisplayString() {
        return this.original;
    }

    @Override
    public int compareTo(DocumentElement another) {
        return new Integer(this.getStartOffset()).compareTo(new Integer(another.getStartOffset()));
    }

    public boolean equals(DocumentElement another) {
        return this.compareTo(another) == 0;
    }

    public int compareAlphabeticallyTo(DocumentElement other) {
        return this.original.compareToIgnoreCase(other.original);
    }

    public int getStartOffset() {
        return this.start.getOffset();
    }

    public int getEndOffset() {
        return this.getStartOffset() + this.getDisplayString().length();
    }

    public boolean containsPosition(int caretPosition) {
        int startOffset = this.getStartOffset();
        return caretPosition >= startOffset && caretPosition < startOffset + this.getDisplayString().length();
    }

    public void changeHighlight(StyledDocument doc, AttributeSet atts) {
        doc.setCharacterAttributes(this.getStartOffset(), this.getDisplayString().length(), atts, false);
    }

    public String getOriginal() {
        return this.original;
    }
}

