package lookup;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Word extends Node implements Comparable<Word> {

	private static final long serialVersionUID = -8257792226836584638L;
	
	private static final int LOW_FREQ = 10;
	
	private String word, soundexCode;
	private int wordLength;
	private char[] letters = new char[3];  //for hashtable

	static int num = 0;
	public int thisNum;
	private int freq;

	boolean userAdded, real, lowFreq;
	
	public Word(String w, Node node, boolean userAdded, boolean real, int freq) {
		super(w.charAt(w.length()-1));
		if(node!=null)
			next = node.next;
		word = w.toLowerCase().trim();
		wordLength = word.length();
		soundexCode = WordUtilities.getSoundexCode(word);
		for(int i=0;i<3;i++) {
			if(wordLength < i+1)
				letters[i] = '~';
			else
				letters[i] = word.charAt(i);
		}
		thisNum = num++;
		this.userAdded = userAdded;
		this.real = real;
		this.freq = freq;
		lowFreq = (freq<LOW_FREQ);
	}
	
	public void writeToFile(PrintWriter writer) {
		writer.println(word + "\t" + freq + (userAdded ? "\t#" : ""));
	}
	
	public String toString() {
		return word;
	}
	
		
	boolean isWord() {
		return true;
	}

	public String getSoundexCode() {
		return soundexCode;
	}

	public char getChar(int i) { //0-2 only
		return letters[i];
	}

	public int compareTo(Word w) {
		return this.toString().compareToIgnoreCase(w.toString());
	}

/*	public  boolean equals(Object o) {
		if(!(o instanceof Word))
			throw new ClassCastException();
		else
			return equals((Word) o);
	}
*/

	public boolean equals(Word w) {
		return this.toString().equalsIgnoreCase(w.toString());
	}

	public boolean equals(String s) {
		return this.toString().equalsIgnoreCase(s);
	}


	public static class SoundexComparator implements java.util.Comparator<Word> {
		public SoundexComparator() {
		}

		public int compare(Word w1, Word w2) {
			return w1.getSoundexCode().compareTo(w2.getSoundexCode());
		}
	}

	public boolean isUserAdded() {
		return this.userAdded;
	}

	public boolean isReal() {
		return this.real;
	}

	public static int getNum() {
		return num;
	}

	public static void setNum(int num) {
		Word.num = num;
	}

	public char[] getLetters() {
		return this.letters;
	}

	public void setLetters(char[] letters) {
		this.letters = letters;
	}

	public int getThisNum() {
		return this.thisNum;
	}

	public void setThisNum(int thisNum) {
		this.thisNum = thisNum;
	}

	public String getWord() {
		return this.word;
	}

	public void setWord(String word) {
		this.word = word;
	}

	public int getWordLength() {
		return this.wordLength;
	}

	public void setWordLength(int wordLength) {
		this.wordLength = wordLength;
	}

	public void setReal(boolean real) {
		this.real = real;
	}

	public void setSoundexCode(String soundexCode) {
		this.soundexCode = soundexCode;
	}

	public void setUserAdded(boolean userAdded) {
		this.userAdded = userAdded;
	}

	/**
	 * @return the freq
	 */
	public int getFreq() {
		return freq;
	}

	/**
	 * @return the lowFreq
	 */
	public boolean isLowFreq() {
		return lowFreq;
	}

	/**
	 * @param freq the freq to set
	 */
	public void setFreq(int freq) {
		this.freq = freq;
		lowFreq = (freq<LOW_FREQ);
	}
	
	static interface WordAction {
		void process(String word, int freq, boolean userAdded);
	}
	
	static void readFile(File file, WordAction todo) throws IOException {
		LineNumberReader textIn = new LineNumberReader(new FileReader(file));
		String currentLine = "file not ready";
		String[] currentLineArray;
		
		while((currentLine = textIn.readLine()) != null) {
			currentLineArray = currentLine.split("\t");
			todo.process(currentLineArray[0], Integer.parseInt(currentLineArray[1]), (currentLineArray.length>2 && currentLineArray[2].equals("#")));
		}
	}

}
