/**
 * 
 */
package lookup;

import java.io.PrintWriter;
import java.util.TreeSet;

/**
 * @author barona
 *
 */
public class VariantHolder extends Node {
	
	private static final long serialVersionUID = 7030014296928387061L;
	private TreeSet<Variant> variants;
	private String variantString;
	
	public VariantHolder(String vs, Node node) {
		super(vs.charAt(vs.length()-1));
		if(node!=null)
			next = node.next;
		this.variantString = vs;
		variants = new TreeSet<Variant>();
	}
	
	boolean isWord() {
		return true;
	}

	/**
	 * @return the variants
	 */
	TreeSet<Variant> getVariants() {
		return variants;
	}
	
	public void writeToFile(PrintWriter writer) {
		for(Variant v : variants) {
			v.writeToFile(writer);
		}
	}
	
	boolean addVariant(Word rep, boolean userAdded) { //returns true if added
		Variant toAdd = new Variant(variantString, rep, userAdded);
		if(variants.contains(toAdd))
			return false;
		
		variants.add(toAdd);
		return true;
	}
	
	/**
	 * @return the variantString
	 */
	String getVariantString() {
		return variantString;
	}

}
