package lookup;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Variant implements Comparable<Variant> {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6390838429688584138L;
	private String variant;
	private int variantLength;
	private Word actual;
	private char[] letters = new char[3];
	private boolean userAdded;
	
	public Variant(String v, Word a, boolean userAdded) throws NullPointerException {
		variant = v.toLowerCase().trim();
		variantLength = variant.length();
		actual = a;
		this.userAdded = userAdded;
		if(actual == null)
			throw new NullPointerException("Word not found for " + v);

		for(int i=0;i<3;i++) {
			if(variantLength < i+1)
				letters[i] = '~';
			else
				letters[i] = variant.charAt(i);
		}
	}
	
	public void writeToFile(PrintWriter writer) {
		writer.println(variant + "\t" + actual.getWord() + (userAdded ? "\t#" : ""));
	}
	
	public String getVariant() {
		return this.variant;
	}

	public Word getActual() {
		return this.actual;
	}

	public char getChar(int i) { //0-2 only
		return letters[i];
	}

/*	public int compareTo(Object o) {
		if(!(o instanceof Variant))
      			throw new ClassCastException();
		else
			return compareTo((Variant) o);
	}
*/

	public int compareTo(Variant v) {
		int c;
		if((c = this.getVariant().compareTo(v.getVariant())) == 0) {
			return this.getActual().compareTo(v.getActual());
		}
		else
			return c;
	}

/*	public boolean equals(Object o) {
		if(!(o instanceof Variant))
			throw new ClassCastException();
		else
			return equals((Variant) o);
	}
*/

	public boolean equals(Variant v) {
		if(this.getVariant().equals(v.getVariant()))
			return this.getActual().equals(v.getActual());
		else
			return false;
	}

	public boolean equals(String s) {
		return this.getVariant().equals(s);
	}

	public boolean isUserAdded() {
		return this.userAdded;
	}

	public char[] getLetters() {
		return this.letters;
	}

	public void setLetters(char[] letters) {
		this.letters = letters;
	}

	public int getVariantLength() {
		return this.variantLength;
	}

	public void setVariantLength(int variantLength) {
		this.variantLength = variantLength;
	}

	public void setActual(Word actual) {
		this.actual = actual;
	}

	public void setUserAdded(boolean userAdded) {
		this.userAdded = userAdded;
	}

	public void setVariant(String variant) {
		this.variant = variant;
	}
	
	static interface VariantAction {
		void process(String variant, String replacement, boolean userAdded);
	}
	
	static void readFile(File file, VariantAction todo) throws IOException {
		LineNumberReader textIn = new LineNumberReader(new FileReader(file));
		String currentLine = "file not ready";
		String[] currentLineArray;
		
		try {	
		
			while((currentLine = textIn.readLine()) != null) {
				currentLineArray = currentLine.split("\t");
				todo.process(currentLineArray[0], currentLineArray[1], (currentLineArray.length>2 && currentLineArray[2].equals("#")));
			}
		}
		finally {
			textIn.close();
		}
	}
}
