package lookup;


public class SuggestedReplacement implements Comparable<SuggestedReplacement> {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1487581641966172547L;
	
	//private TreeSet<ReplacedInstance> instancesUsedIn;
	
	private Word replacement;
	private String oldWord, replacementString;
	private boolean isKnownVariant, isLetterReplacement, isSoundex, isUserAdded;
	private int editDistance;

	private double score = 0.0;

	//private int useCount = 0; //counts how many times used for analysis list.
	
	private int capitalization;

	private ConfidenceWeights confidenceWeights;
	
	public SuggestedReplacement() {
	}

	public SuggestedReplacement(Word replacement, String oldWord, ConfidenceWeights rs) {
		this.replacement = replacement;
		this.oldWord = oldWord;
		this.confidenceWeights = rs;

		editDistance = WordUtilities.getEditDistance(replacement.toString(), oldWord);
		setCapitalization(WordUtilities.getCapitalization(oldWord));
		
		//instancesUsedIn = new TreeSet<ReplacedInstance>();
	}

	public int compareTo(SuggestedReplacement sr) {
		reCalculateScore();
		int r = Double.valueOf(sr.getScore()).compareTo(Double.valueOf(score));
		if(r==0)
			return new Integer(sr.getReplacement().getFreq()).compareTo(Integer.valueOf(replacement.getFreq()));
		else
			return r;
	}
	
	public static class AlphaComparator implements java.util.Comparator<SuggestedReplacement> {
		public AlphaComparator() {
		}

		public int compare(SuggestedReplacement sr1, SuggestedReplacement sr2) {
			int c = sr1.getOldWord().compareToIgnoreCase(sr2.getOldWord());
			if(c==0)
				return sr1.getReplacementString().compareToIgnoreCase(sr2.getReplacementString());
			else
				return c;
	
		}
	}

/*	public void addUse(ReplacedInstance instance) {
		instancesUsedIn.add(instance);
		useCount++;
	}
	
	public void minusUse(ReplacedInstance instance) {
		instancesUsedIn.remove(instance);
		useCount--;
	}
*/
	
	public boolean equals(SuggestedReplacement sr) {
		if(replacementString.equalsIgnoreCase(sr.getReplacementString()))
			return oldWord.equalsIgnoreCase(sr.getOldWord());
		else
			return false;
	}

	public boolean equals(Object object) {
		if(object instanceof SuggestedReplacement)
			return equals((SuggestedReplacement) object);
		else
			return false;
	}

	public Word getReplacement() {
		return this.replacement;
	}

	public String getOldWord() {
		return this.oldWord;
	}

	public boolean isKnownVariant() {
		return isKnownVariant;
	}

	public boolean isUserAdded() {
		return isUserAdded;
	}

	public boolean isLetterReplacement() {
		return isLetterReplacement;
	}

	public boolean isSoundex() {
		return isSoundex;
	}

	public boolean isInDictionary() {
		return replacement.isReal();
	}

	public boolean isReplacementUserAdded() {
		return replacement.isUserAdded();
	}

	public int getEditDistance() {
		return this.editDistance;
	}
	
	
	//used when doing replace all, don't want to update as will use info from previous replaced during replace-all
	public double getScoreWithoutUpdating() {
		return this.score;
	}

	public double getScore() {
		reCalculateScore();
		return this.score;
	}

	public void reCalculateScore() {
		score = confidenceWeights.calculateScoreOfReplacement(this);
	}

	public void setSoundex(String soundexCode) {
		this.isSoundex = soundexCode.equals(replacement.getSoundexCode());
	}

	public void setSoundex(boolean isSoundex) { //for marking -removal as same soundex
		this.isSoundex = isSoundex;
	}

	public void setLetterReplacement(boolean lr) {
		this.isLetterReplacement = lr;
	}

	public void setKnownVariant(boolean kv, boolean ua) {
		this.isKnownVariant = kv;
		this.isUserAdded = ua;
	}
	
/*	public String toString() {
		return (oldWord + " -> " + replacementString + " (" + useCount + ")");
	}
	
	public String getAddionalToString() {
		return (" -> " + replacementString + " (" + useCount + ")");
	}
	
	public String getAddionalRevertString() {
		return (" <- " + replacementString + " (" + useCount + ")");
	}
*/

	public String toMenuString(int capitalization) {
		String scoreString = Double.toString(getScore());
		if(scoreString.endsWith(".0"))
			scoreString = scoreString.substring(0,scoreString.length()-2);
		setCapitalization(capitalization);
		return (replacementString + " (" + scoreString + "%)");
	}

	public String getReplacementString() {
		return this.replacementString;
	}

	public void setCapitalization(int c) {
		capitalization = c;
		replacementString = WordUtilities.capitalize(replacement.toString(), capitalization);
	}

	public ConfidenceWeights getRatingScores() {
		return this.confidenceWeights;
	}

	public void setRatingScores(ConfidenceWeights confidenceWeights) {
		this.confidenceWeights = confidenceWeights;
	}

	public int getCapitalization() {
		return this.capitalization;
	}

	public void setEditDistance(int editDistance) {
		this.editDistance = editDistance;
	}

	public void setKnownVariant(boolean isKnownVariant) {
		this.isKnownVariant = isKnownVariant;
	}

	public void setUserAdded(boolean isUserAdded) {
		this.isUserAdded = isUserAdded;
	}

	public void setOldWord(String oldWord) {
		this.oldWord = oldWord;
	}

	public void setReplacement(Word replacement) {
		this.replacement = replacement;
	}

	public void setReplacementString(String replacementString) {
		this.replacementString = replacementString;
	}

	public void setScore(double score) {
		this.score = score;
	}

/*	public int getUseCount() {
		return useCount;
	}

	public void setUseCount(int useCount) {
		this.useCount = useCount;
	}

	public TreeSet<ReplacedInstance> getInstancesUsedIn() {
		return instancesUsedIn;
	}	
*/
}