package lookup;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Rule implements Comparable<Rule> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6117641007894822767L;
	
	public static enum Position {Start, End, Anywhere};

	private String original, replacement;
	private Position pos;
	
	private boolean userAdded;
	
	public Rule() {
	}
	
	public Rule(String original, String replacement, Position pos, boolean userAdded) {
		this.original = original;
		this.replacement = replacement;
		this.pos = pos;
		this.userAdded = userAdded;
		
		if(original == null || replacement == null)
			throw new NullPointerException("Original and replacement must not be null");
		
		if(original.equals("") && replacement.equals(""))
			throw new IllegalArgumentException("Original and replacement must not both be empty");
	}
	
	public void writeToFile(PrintWriter fileWriter) {
		fileWriter.println(original + "\t" + replacement + "\t" + pos + (userAdded ? "\t#" : ""));
	}
	
	Position getWhereToApply() {
		return pos;
	}

	public String getOriginal() {
		return this.original;
	}

	public String getReplacement() {
		return this.replacement;
	}

	
	private String getRuleString() {
		if(original.equals(""))
			return "Insert " + replacement;
		
		else if(replacement.equals(""))
			return "Delete " + original;
		
		else
			return "Substitute " + original + " > " + replacement;
	}
	
	public String toString() {
		return (getRuleString() + " -- " + pos);
	}
	
	public boolean equals(Rule r) {
		return (compareTo(r) == 0);
	}

	public int compareTo(Rule r) {
		return toString().compareToIgnoreCase(r.toString());
	}

	/**
	 * @return the userAdded
	 */
	public boolean isUserAdded() {
		return userAdded;
	}
	
	static interface RuleAction {
		void process(String original, String replacement, Position position, boolean userAdded);
	}
	
	static void readFile(File file, RuleAction todo) throws IOException {
		LineNumberReader textIn = new LineNumberReader(new FileReader(file));
		String currentLine = "file not ready";
		String[] currentLineArray;
		
		while((currentLine = textIn.readLine()) != null) {
			currentLineArray = currentLine.split("\t");
			todo.process(currentLineArray[0], currentLineArray[1], Position.valueOf(currentLineArray[2]), (currentLineArray.length>3 && currentLineArray[3].equals("#")));
		}
	}
}
