package gui;

import java.util.ArrayList;

import javax.swing.AbstractListModel;

/**
 * 
 * @author Alistair Baron, 3/2008
 *
 *	ListModel for JList which maintains a stack ordered correctly, i.e. elements always added to and removed from front
 *
 * @param <E> Type to hold
 */

public class StackListModel<E> extends AbstractListModel {
	
	private static final long serialVersionUID = 1L;
	private ArrayList<E> data;
	
	/**
	 * Sets up a new StackListModel with an empty stack.
	 */
	public StackListModel() {
		data = new ArrayList<E>();
	}

	/**
	 * Returns the element at the given index.
	 * 
	 * @param i The index to find.
	 * @return The element found.
	 */
	public E getElementAt(int i) {
		return data.get(i);
	}

	/**
	 * Returns the size of the stack
	 * 
	 * @return The size of the stack.
	 */
	public int getSize() {
		return data.size();
	}
	
	/**
	 * adds element to the beginning of the stack.
	 * 
	 * @param element The element being added.
	 */
	public void add(E element) {
		data.add(0, element);
		fireIntervalAdded(this, 0, 0);
	}
	
	/**
	 * Removes and returns the element at the top of the stack.
	 * 
	 * @return the element at the top of the stack (the last added).
	 */
	public E remove() {
		E toReturn = data.remove(0);
		fireIntervalRemoved(this, 0, 0);
		return toReturn;
	}

	public void clear() {
		int amountRemoved = 0;
		while(!data.isEmpty()) {
			data.remove(0);
			amountRemoved++;
		}
		if(amountRemoved>0)
			fireIntervalRemoved(this, 0, amountRemoved-1);		
	}
}
