/**
 * 
 */
package gui;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

import lookup.LookUpDictionary;
import lookup.Rule;
import lookup.Rule.Position;

/**
 * @author barona
 *
 */
public class RuleManager implements ActionListener {
	private JButton[] buttons = {new JButton("Remove selected rule(s)"), new JButton("Revert rule list"), new JButton("Add"), new JButton("Clear")};
	private JList ruleList;
	private JScrollPane ruleListSP;
	
	private JTextField origTF, repTF;
	private JComboBox posCB;
	private String[] cbOps = {"Start", "End", "Anywhere"};
	
	private Vector<Rule> sessionRules;

	private static LookUpDictionary lud;
	
	private boolean ruleListChanged = false;
	
	private String ruleChangeLog = "";
	
	public RuleManager(JFrame owner) {
		lud = LookUpDictionary.getInstance();
		sessionRules = new Vector<Rule>();
		sessionRules.addAll(lud.getRules());
		
		ruleList = new JList(sessionRules);
		ruleList.setVisibleRowCount(10);
		ruleListSP = new JScrollPane(ruleList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		ruleListSP.setAlignmentX(JScrollPane.LEFT_ALIGNMENT);
		
		for(JButton button : buttons){
			button.addActionListener(this);
		}
		
		JPanel ruleListButtonsPanel = new JPanel(new GridLayout(6,1));		
		ruleListButtonsPanel.add(buttons[0]);
		ruleListButtonsPanel.add(buttons[1]);
		ruleListButtonsPanel.add(Box.createVerticalGlue());
		ruleListButtonsPanel.add(Box.createVerticalGlue());
		ruleListButtonsPanel.add(Box.createVerticalGlue());
		ruleListButtonsPanel.add(Box.createVerticalGlue());
		
		JPanel ruleListPanel = new JPanel(new BorderLayout());
		ruleListPanel.setBorder(BorderFactory.createTitledBorder("Rule List"));
		ruleListPanel.add(ruleListSP, BorderLayout.CENTER);
		ruleListPanel.add(ruleListButtonsPanel, BorderLayout.EAST);
		
		origTF = new JTextField(8);
		repTF = new JTextField(8);
		posCB = new JComboBox(cbOps);
		
		JPanel addRulePanel = new JPanel(new SpringLayout());
		JLabel origLabel = new JLabel("Original:", JLabel.TRAILING);
		addRulePanel.add(origLabel);
		origLabel.setLabelFor(origTF);
		addRulePanel.add(origTF);
		
		JLabel repLabel = new JLabel("Replacement:", JLabel.TRAILING);
		addRulePanel.add(repLabel);
		repLabel.setLabelFor(repTF);
		addRulePanel.add(repTF);
		
		JLabel posLabel = new JLabel("Position:", JLabel.TRAILING);
		addRulePanel.add(posLabel);
		posLabel.setLabelFor(posCB);
		addRulePanel.add(posCB);
		
		SpringUtilities.makeCompactGrid(addRulePanel, 3, 2, 6 , 6, 6, 6);
		
		JPanel addRuleButtonsPanel = new JPanel(new GridLayout(1,4));
		addRuleButtonsPanel.add(Box.createVerticalGlue());
		addRuleButtonsPanel.add(buttons[2]);
		addRuleButtonsPanel.add(buttons[3]);
		addRuleButtonsPanel.add(Box.createVerticalGlue());
		
		JPanel fullAddRulePanel = new JPanel(new BorderLayout());
		fullAddRulePanel.setBorder(BorderFactory.createTitledBorder("Add Rule"));
		fullAddRulePanel.add(addRulePanel, "Center");
		fullAddRulePanel.add(addRuleButtonsPanel, "South");
		
		
		JPanel main = new JPanel(new BorderLayout());
		main.add(ruleListPanel, "North");
		main.add(fullAddRulePanel, "South");
		
		//int val = JOptionPane.showConfirmDialog(owner, main, "Rule List Manager", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
		
		Object[] options = {"Finished", "Discard"};
		int n = JOptionPane.showOptionDialog(	owner,
												main,
												"Rule List Manager",
												JOptionPane.OK_CANCEL_OPTION,
												JOptionPane.PLAIN_MESSAGE,
												null,
												options,
												null);
		
		
		if(n == JOptionPane.OK_OPTION && ruleListChanged) {
			lud.setRules(sessionRules);
			lud.setRulesChanged(true, ruleChangeLog);
			JOptionPane.showMessageDialog(owner, "Rule list updated successfully.\nRemember to save the rule list if you wish the rule changes to be applied in future sessions.");
		}
	}

	public void actionPerformed(ActionEvent a) {
		int buttonNumber = -1;
		for(int i=0;i<buttons.length;i++) {
			if(a.getSource().equals(buttons[i]))
					buttonNumber = i;
		}
		
		/*
		 * 0 = remove selected rules
		 * 1 = revert list
		 * 2 = add rule
		 * 3 = clear add panel
		 */
		
		switch(buttonNumber) {
		case 0:
			Object[] selectedRules = ruleList.getSelectedValues();
			for(int i=0;i<selectedRules.length;i++) {
				sessionRules.remove(selectedRules[i]);
				ruleChangeLog += globals.Globals.NEW_LINE + "Removed: " + selectedRules[i];
			}
					
			ruleList.setListData(sessionRules);
			ruleListChanged = true;
			break;
			
		case 1:
			sessionRules = new Vector<Rule>();
			sessionRules.addAll(lud.getRules());
			ruleList.setListData(sessionRules);
			ruleListChanged = false;
			ruleChangeLog = "";
			break;
			
		case 2:
			if(origTF.getText().equals("") && repTF.getText().equals("")) {
				JOptionPane.showMessageDialog(MainScreen.frame, "Original and Replacement fields can't both be empty.", "Error", JOptionPane.ERROR_MESSAGE);
				return;
			}
			Position pos = Position.Anywhere;
			if(posCB.getSelectedIndex() == 0)
				pos = Position.Start;
			else if(posCB.getSelectedIndex() == 1)
				pos = Position.End;
			Rule r = new Rule(origTF.getText(), repTF.getText(), pos, true);
			sessionRules.add(r);
			ruleChangeLog += globals.Globals.NEW_LINE + "added: " + r;
			ruleList.setListData(sessionRules);
			ruleListChanged = true;
			break;
			
		case 3:
			origTF.setText("");
			repTF.setText("");
			posCB.setSelectedIndex(0);
			break;
			
		}
	}
}
