package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

import lookup.LookUpDictionary;
import lookup.ConfidenceWeights;
import lookup.SuggestedReplacement;
import lookup.Word;
import lookup.WordUtilities;
import doc.BadXMLSyntaxException;
import doc.CorrectInstance;
import doc.DocumentModel;
import doc.HolderChangeListener;
import doc.Instance;
import doc.InstanceHolder;
import doc.InvalidInstanceChangeException;
import doc.RealErrorInstance;
import doc.ReplacedInstance;
import doc.ThreadableEdit;
import doc.VariantInstance;
import doc.WordHolder;
import doc.DocumentModel.AddVariantToLookUpEdit;
import doc.DocumentModel.AddWordToDictionaryEdit;
import doc.DocumentModel.RemoveWordFromDictionaryEdit;
import doc.WordHolder.MarkAllFInstancesAsTEdit;
import doc.WordHolder.MarkFInstanceAsTEdit;
import doc.WordHolder.ReplaceAllFInstancesEdit;
import doc.WordHolder.ReplaceFInstanceEdit;
import doc.WordHolder.RevertAllReplacedEdit;
import doc.WordHolder.RevertReplacedInstanceEdit;

public class MainScreen implements globals.UserMessageListener, globals.ExceptionMessageHandler, LookUpDictionary.DataChangeListener, ConfidenceWeights.ChangeListener {
	
	private boolean allowEditing = false;
	
	private TreeSet<InstanceHolder<VariantInstance>> variantList;
	private TreeSet<InstanceHolder<ReplacedInstance>> replacedList;
	private TreeSet<InstanceHolder<CorrectInstance>> correctList;
	private TreeSet<InstanceHolder<RealErrorInstance>> realErrorList;

	private static final String PROGRAM_TITLE = "VARD 2";

	private static final String VARIANTS_LIST = "Variant Forms";
	private static final String REPLACED_LIST = "Replaced";
	private static final String CORRECT_LIST = "Modern Forms";
	private static final String REAL_ERROR_LIST = "Uncommon Words";
	
	private static final int XML = 66;
	private static final int TXT = 88;

	private String listSelected;

	public static ImageIcon LOADING_ICON;
	
	private final Integer[] fontSizes = {8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48};

	private static DocumentModel docModel;
	private static globals.Globals global;
	private StyledEditorKit sek;
	private JTextPane textPane;
	private JScrollPane textPaneSP;

	private JToolBar mainToolBar, standardToolBar, formattingToolBar;
	private Vector<JButton> fileTBButtons, editTBButtons;
	private Vector<JToggleButton> formattingTBButtons;
	private Vector<JComponent> fontTBComponents;

	private JMenuBar menuBar;
	private JMenu fileMenu, editMenu, styleMenu;

	private JComboBox fontComboBox, sizeComboBox;
	private String[] systemFonts;

	private JFileChooser fileChooser, exportChooser, plainSaveChooser;

	static JFrame frame;
	private JPanel main, sidebar;

	private HashMap<String,Action> actions, ekActions;

	private JProgressBar progressBar;
	private JLabel progressBarLabel;
	private JPanel progressBarPanel;

	private JRadioButton[] radioButtonArray;
	private ButtonGroup radioButtonGroup;
	private JLabel listHeader;

	private JList wordList;
	private JScrollPane wordListSP;

	private InstanceHolder<? extends Instance> selectedHolder;

	private JSlider thresholdSlider;

	private File currentFile;
	private int currentFileType;

	private JToggleButton boldToggle, italicToggle, underlineToggle;
	
	private JLabel counts1;
	private JLabel[] counts = new JLabel[5];
	
	private Style currentViewAttributes, removeHighlight, mainHighlight, selectedHighlight;
	private static final Color SELECTION_COLOUR = new Color(0,150,20);

	private UIUpdatingUndoManager undoManager = new UIUpdatingUndoManager();
	private UndoableEditSupport undoSupport = new UndoableEditSupport();
	
	private static ConfidenceWeights confidenceWeights;
	private static LookUpDictionary lud;
	
	private MainScreen() {
		undoSupport.addUndoableEditListener(undoManager);
		
		variantList = new TreeSet<InstanceHolder<VariantInstance>>(new InstanceHolder.AlphaComparator<VariantInstance>());
		replacedList = new TreeSet<InstanceHolder<ReplacedInstance>>(new InstanceHolder.AlphaComparator<ReplacedInstance>());
		correctList = new TreeSet<InstanceHolder<CorrectInstance>>(new InstanceHolder.AlphaComparator<CorrectInstance>());
		realErrorList = new TreeSet<InstanceHolder<RealErrorInstance>>(new InstanceHolder.AlphaComparator<RealErrorInstance>());
		construct();
		makeInterface();
	}
		
	private void construct() {
		textPane = new JTextPane();
		currentViewAttributes = textPane.addStyle("Current View", null);

		removeHighlight = textPane.addStyle("Remove Highlight", null);
		StyleConstants.setBackground(removeHighlight, Color.WHITE);
		StyleConstants.setForeground(removeHighlight, Color.BLACK);

		mainHighlight = textPane.addStyle("Highlight Yellow", null);
		StyleConstants.setBackground(mainHighlight, Color.YELLOW);
		StyleConstants.setForeground(mainHighlight, Color.BLACK);

		selectedHighlight = textPane.addStyle("Highlight Selected", null);
		StyleConstants.setBackground(selectedHighlight, SELECTION_COLOUR);
		StyleConstants.setForeground(selectedHighlight, Color.WHITE);


	//set up actions
		ekActions = new HashMap<String,Action>();
		Action[] aa = textPane.getEditorKit().getActions();
		for(int i=0;i<aa.length;i++) {
			Action a = aa[i];
			ekActions.put((String) a.getValue(Action.NAME), a);
		}

		actions = new HashMap<String,Action>();
		actions.put("New", fixAction(new NewAction(), "New", "newfile", "Create a new file", KeyEvent.VK_N, KeyStroke.getKeyStroke(KeyEvent.VK_N,InputEvent.CTRL_MASK)));
		actions.put("Open", fixAction(new OpenAction(),"Open", "openfile", "Open a file to analyse", KeyEvent.VK_O, KeyStroke.getKeyStroke(KeyEvent.VK_O,InputEvent.CTRL_MASK)));
		actions.put("Save", fixAction(new SaveAction(), "Save", "save", "Save current file", KeyEvent.VK_S, KeyStroke.getKeyStroke(KeyEvent.VK_S, InputEvent.CTRL_MASK)));
		actions.put("Save As Plain", fixAction(new SaveAsPlainAction(), "Save As Text", "saveplain", "Save with no XML tags", KeyEvent.VK_T, null));
		actions.put("Save As XML", fixAction(new ExportToXMLAction(), "Save As XML", "xml", "Save with XML tags", KeyEvent.VK_X, null));
		actions.put("Save Dictionary", fixAction(new SaveDictionaryAction(), "Save Dictionary", "plain", "Save changes to dictionary", KeyEvent.VK_D, null));
		actions.put("Save Variant List", fixAction(new SaveVariantsAction(), "Save Variant List", "plain", "Save changes to known variants list", KeyEvent.VK_V, null));
		actions.put("Save Rule List", fixAction(new SaveRulesAction(), "Save Rule List", "plain", "Save changes to rule list", KeyEvent.VK_R, null));
		actions.put("Save Confidence Weights", fixAction(new SaveConfidenceWeightsAction(), "Save Confidence Weights", "plain", "Save changes to replacement method confidence weights", KeyEvent.VK_C, null));
		actions.put("Save All", fixAction(new SaveAllAction(), "Save All", "plain", "Save document, dictionary, variant list, rule list and confidence weights", KeyEvent.VK_A, null));
		actions.put("Exit", fixAction(new ExitAction(), "Exit", "exit", null, KeyEvent.VK_X, null));
		actions.put("Copy", fixAction(new DefaultEditorKit.CopyAction(), "Copy", "copy", "Copy selected text to clipboard", KeyEvent.VK_C, KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_MASK)));
		actions.put("Paste", fixAction(new PasteAction(), "Paste", "paste", "Paste text from clipboard into document", KeyEvent.VK_P, KeyStroke.getKeyStroke(KeyEvent.VK_V, InputEvent.CTRL_MASK)));
		actions.put("Bold", fixAction(new StyledEditorKit.BoldAction(), "Bold", "bold", "Toggle Bold on selected text", KeyEvent.VK_B, KeyStroke.getKeyStroke(KeyEvent.VK_B,InputEvent.CTRL_MASK)));
		actions.put("Italic", fixAction(new StyledEditorKit.ItalicAction(), "Italic", "italic", "Toggle Italic on selected text", KeyEvent.VK_I, KeyStroke.getKeyStroke(KeyEvent.VK_I,InputEvent.CTRL_MASK)));
		actions.put("Underline", fixAction(new StyledEditorKit.UnderlineAction(), "Underline", "underline", "Toggle Underline on selected text", KeyEvent.VK_U, KeyStroke.getKeyStroke(KeyEvent.VK_U,InputEvent.CTRL_MASK)));
		actions.put("Select All", fixAction(getDefaultActionByName(DefaultEditorKit.selectAllAction), "Select All", "select_all", "Select All Text In Document", KeyEvent.VK_A, KeyStroke.getKeyStroke(KeyEvent.VK_A, InputEvent.CTRL_MASK)));
		actions.put("Correct All", fixAction(new ProcessAllVariantsAction(), "Process All Variants", null, "Replace all variants with top replacement when above threshold", -1, null));
		actions.put("Copy List", fixAction(new CopyListAction(), "Copy Current List", null, "Copy current list to system's clipboard", -1, null));
		actions.put("Copy Replacement Analysis", fixAction(new CopyReplacementAnalysisAction(), "Copy Replacement Analysis", null, "Copy full replacement analysis to system's clipboard", -1, null));
		actions.put("Count Replacements", fixAction(new CountReplacementsAction(), "Refresh Replacment Analysis", null, "Displays counts of replacement methods", -1, null));
		actions.put("Join", fixAction(new JoinAction(), "Join", "join", "Join two or more words.", -1, null));
		actions.put("Undo", fixAction(new UndoAction(), "Undo", "undo", "Undo last edit", KeyEvent.VK_U, KeyStroke.getKeyStroke(KeyEvent.VK_Z,InputEvent.CTRL_MASK)));
		actions.put("Redo", fixAction(new RedoAction(), "Redo", "redo", "Redo last edit which was undone", KeyEvent.VK_R, KeyStroke.getKeyStroke(KeyEvent.VK_Y,InputEvent.CTRL_MASK)));
		actions.put("Rule List Manager", fixAction(new RuleListManagerAction(), "Rule List Manager", null, "Open rule list manager", KeyEvent.VK_R, KeyStroke.getKeyStroke(KeyEvent.VK_R,InputEvent.CTRL_MASK)));
	}

	private Action fixAction(Action action, String name, String icon, String description, int mnemonic, KeyStroke keyStroke) { // mnemonic is key(eg KeyEvent.VK_A) used with alt the menuitems etc. keystroke is to set accelerator, eg. KeyStroke.getKeyStroke(KeyEvent.VK_A,InputEvent.CTRL_MASK)
		if(name!=null)
			action.putValue(Action.NAME, name);
		if(icon!=null) {
			URL iconURL = MainScreen.class.getResource("icons/" + icon + ".png");
			if (iconURL != null) {
				action.putValue(Action.SMALL_ICON, new ImageIcon(iconURL));
			}
		}
		if(description!=null)
			action.putValue(Action.SHORT_DESCRIPTION, description);
		if(mnemonic!=-1)
			action.putValue(Action.MNEMONIC_KEY, new Integer(mnemonic));
		if(keyStroke!=null)
			action.putValue(Action.ACCELERATOR_KEY, keyStroke);
		
		return action;
	}

	private Action getDefaultActionByName(String name) {
		return ekActions.get(name);
	}

	private Action getActionByName(String name) {
		return actions.get(name);
	}
	
	private void setAllActionsEnabled(boolean enabled) {
		for(Action a : actions.values()) {
			a.setEnabled(enabled);
		}
	}

	private void makeInterface() {
		JFrame.setDefaultLookAndFeelDecorated(true);
		main = new JPanel(new BorderLayout());

	//textpane
		textPane.setEditable(false);
		textPaneSP = new JScrollPane(textPane, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

		currentFile = null;
		textPane.setStyledDocument(new javax.swing.text.DefaultStyledDocument());

		textPane.addCaretListener(new CaretListener() {
			public void caretUpdate(CaretEvent evt) {
				int start = evt.getMark();
				int end = evt.getDot();
				if(start==end) { //no selection, set attributes to whole document
					start = docModel.getStartOfDoc();
					end = docModel.getEndOfDoc();
					getActionByName("Copy").setEnabled(false);
					getActionByName("Join").setEnabled(false);
				}
				else {
					getActionByName("Copy").setEnabled(true);
					getActionByName("Join").setEnabled(true);
				}
				
				if(start>end) {
					start = evt.getDot();
					end = evt.getMark();
				}

				try {
					updateAttributesViewWithAttributesOfRange(start,end);
				}
				catch(BadLocationException ex) {
					global.exceptionHandler.showException("Error occurred whilst finding the attributes for the selected word.\n\n", ex);
				}
			}
		});

		textPane.addMouseListener(new MouseAdapter() {
			//if right click move caret to pos clicked
			public void mouseReleased(MouseEvent e) {
				if(e.getButton() == MouseEvent.BUTTON3 && allowEditing) {
					int caretPos = textPane.viewToModel(e.getPoint());
					textPane.setCaretPosition(caretPos);
					Instance instance = docModel.getWordAt(caretPos);
					if(instance == null)
						return;

					WordHolder wh = instance.getHolder();

					java.awt.Rectangle wordRect;
					try {
						wordRect = textPane.modelToView(instance.getEndOffset());
					}
					catch(BadLocationException ex) {
						global.exceptionHandler.showException("Error occurred trying to find word.", ex);
						return;
					}
					
					JPopupMenu popup;
					JMenuItem wait;
					JMenu more;
					JMenu nid;
					int added;
					int nidAdded;
					Vector<SuggestedReplacement> reps;
					
					switch(instance.getType()) {
					case WordHolder.VARIANT:				
						popup = new JPopupMenu();

						wait = new JMenuItem("Please Wait...");
						wait.setEnabled(false);
						popup.add(wait);
						popup.show(textPane, (wordRect.x+wordRect.width), (wordRect.y+wordRect.height));

						more = new JMenu("More Suggestions...");
						nid = new JMenu("Suggestions not in dictionary...");
						added = 0;
						nidAdded = 0;
						docModel.findReplacementsForWord(wh);
						reps = wh.getReplacements();
						Collections.sort(reps);
						for(SuggestedReplacement replacement : reps) {
							if(!replacement.isInDictionary() && !replacement.isKnownVariant()) {
								nid.add(getReplacementPopupMenu(replacement, wh, (VariantInstance) instance, WordHolder.VARIANT, instance.getCapitalization()));
								nidAdded++;
							}
							
							else if(added<5) {
								popup.add(getReplacementPopupMenu(replacement, wh, (VariantInstance) instance, WordHolder.VARIANT, instance.getCapitalization()));
								added++;
							}
							else {
								more.add(getReplacementPopupMenu(replacement, wh, (VariantInstance) instance, WordHolder.VARIANT, instance.getCapitalization()));
								added++;
							}
						}
						if(added==0) {
							JMenuItem noneFound = new JMenuItem("No Replacements found");
							noneFound.setEnabled(false);
							popup.add(noneFound);
						}
						if(added>5)
							popup.add(more);

						if(nidAdded > 0)
							popup.add(nid);

						popup.addSeparator();
						popup.add(new ReplaceWithAction<VariantInstance>((VariantInstance) instance));
						popup.add(new MarkFInstanceAsTAction<VariantInstance, CorrectInstance>((VariantInstance) instance, new CorrectInstance()));
						popup.addSeparator();
						popup.add(new FindWordInListAction(instance));
						popup.add(new MarkAllFInstancesAsTAction<VariantInstance, CorrectInstance>(wh, new VariantInstance(), new CorrectInstance()));
						popup.setVisible(false);
						popup.remove(wait);
						popup.show(textPane, (wordRect.x+wordRect.width), (wordRect.y+wordRect.height));
						
						break;
						
					case WordHolder.CORRECT:
						popup = new JPopupMenu();
						popup.add(new MarkFInstanceAsTAction<CorrectInstance, VariantInstance>((CorrectInstance) instance, new VariantInstance()));
						popup.addSeparator();
						popup.add(new FindWordInListAction(instance));
						popup.add(new MarkAllFInstancesAsTAction<CorrectInstance, VariantInstance>(wh, new CorrectInstance(), new VariantInstance()));
						popup.show(textPane, (wordRect.x+wordRect.width), (wordRect.y+wordRect.height));
						
						break;
						

					case WordHolder.REPLACED:
						popup = new JPopupMenu();
						popup.add(new RevertReplacedInstanceAction((ReplacedInstance) instance));
						popup.addSeparator();
						popup.add(new FindWordInListAction(instance));
						popup.add(new RevertAllReplacedAction(wh, ((ReplacedInstance) instance).getReplacement()));
						popup.show(textPane, (wordRect.x+wordRect.width), (wordRect.y+wordRect.height));
						
						break;
						
					case WordHolder.REAL_ERROR:
						popup = new JPopupMenu();

						wait = new JMenuItem("Please Wait...");
						wait.setEnabled(false);
						popup.add(wait);
						popup.show(textPane, (wordRect.x+wordRect.width), (wordRect.y+wordRect.height));

						more = new JMenu("More Suggestions...");
						nid = new JMenu("Suggestions not in dictionary...");
						added = 0;
						nidAdded = 0;
						docModel.findReplacementsForWord(wh);
						reps = wh.getReplacements();
						Collections.sort(reps);
						for(SuggestedReplacement replacement : reps) {
							if(!replacement.isInDictionary() && !replacement.isKnownVariant()) {
								nid.add(getReplacementPopupMenu(replacement, wh, (RealErrorInstance) instance, WordHolder.REAL_ERROR, instance.getCapitalization()));
								nidAdded++;
							}
							
							else if(added<5) {
								popup.add(getReplacementPopupMenu(replacement, wh, (RealErrorInstance) instance, WordHolder.REAL_ERROR, instance.getCapitalization()));
								added++;
							}
							else {
								more.add(getReplacementPopupMenu(replacement, wh, (RealErrorInstance) instance, WordHolder.REAL_ERROR, instance.getCapitalization()));
								added++;
							}
						}
						if(added==0) {
							JMenuItem noneFound = new JMenuItem("No Replacements found");
							noneFound.setEnabled(false);
							popup.add(noneFound);
						}
						if(added>5)
							popup.add(more);

						if(nidAdded > 0)
							popup.add(nid);

						popup.addSeparator();
						popup.add(new ReplaceWithAction<RealErrorInstance>((RealErrorInstance) instance));
						popup.add(new MarkFInstanceAsTAction<RealErrorInstance, CorrectInstance>((RealErrorInstance) instance, new CorrectInstance()));
						popup.add(new MarkFInstanceAsTAction<RealErrorInstance, VariantInstance>((RealErrorInstance) instance, new VariantInstance()));
						popup.addSeparator();
						popup.add(new FindWordInListAction(instance));
						popup.add(new MarkAllFInstancesAsTAction<RealErrorInstance, CorrectInstance>(wh, new RealErrorInstance(), new CorrectInstance()));
						popup.add(new MarkAllFInstancesAsTAction<RealErrorInstance, VariantInstance>(wh, new RealErrorInstance(), new VariantInstance()));
						popup.setVisible(false);
						popup.remove(wait);
						popup.show(textPane, (wordRect.x+wordRect.width), (wordRect.y+wordRect.height));
						
						break;
					}	
				}
			}
		});
		
		main.add(textPaneSP, BorderLayout.CENTER);

	//font combo box
		systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
		fontComboBox = new JComboBox(systemFonts);
		fontComboBox.setEditable(true);
		fontComboBox.addActionListener(new ActionListener() {
			boolean shownOnce = false;
			public void actionPerformed(ActionEvent evt) {
				if(evt.getActionCommand().equals("skip"))
					return;

				String f = (String) fontComboBox.getSelectedItem();
				if(Arrays.binarySearch(systemFonts, f) < 0) {
					if(!shownOnce) {
						shownOnce = true;
						int yn = JOptionPane.showConfirmDialog(frame,("The font \'" + f + "\' is not available on this system, do you still wish to use it?"), ("\' " + f + "\' not found"), JOptionPane.YES_NO_OPTION);
						if(yn == JOptionPane.NO_OPTION)
							return;							
					}
					else {
						shownOnce = false;
						return;
					}
				}
				Style style = textPane.addStyle("Font " + f, null);
				StyleConstants.setFontFamily(style, f);
				StyleConstants.setFontFamily(currentViewAttributes, f);
				textPane.setCharacterAttributes(style, false);
				textPane.requestFocus();
			}
		});
		fontComboBox.setMaximumSize(fontComboBox.getPreferredSize());

	//fontsize combo box
		sizeComboBox = new JComboBox(fontSizes);
		sizeComboBox.setEditable(true);
		sizeComboBox.addActionListener(new ActionListener() {
			boolean shownOnce = false;
			public void actionPerformed(ActionEvent evt) {
				if(evt.getActionCommand().equals("skip"))
					return;

				Integer s;
				if(sizeComboBox.getSelectedItem() instanceof Integer) {
					s = (Integer) sizeComboBox.getSelectedItem();
				}
				else {
					if(!shownOnce) {
						displayError("Not a valid font size");
						shownOnce = true;
					}
					else
						shownOnce = false;
					return;
				}

				Style style = textPane.addStyle("Size " + s, null);
				StyleConstants.setFontSize(style, s);
				StyleConstants.setFontSize(currentViewAttributes, s);
				textPane.setCharacterAttributes(style, false);
				textPane.requestFocus();
			}
		});
		sizeComboBox.addPopupMenuListener(new PopupMenuListener() {
			public void popupMenuCanceled(PopupMenuEvent evt) {
				textPane.requestFocus();
			}
			public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
				textPane.requestFocus();
			}
			public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
			}
		});
		sizeComboBox.setMaximumSize(sizeComboBox.getPreferredSize());

	//progress bar
		progressBar = new JProgressBar(0,0);
		progressBar.setValue(0);

		progressBarLabel = new JLabel();
		resetProgressBarLabel();

		progressBarPanel = new JPanel(new BorderLayout());
		progressBarPanel.add(progressBar, BorderLayout.CENTER);
		progressBarPanel.add(progressBarLabel, BorderLayout.WEST);
		main.add(progressBarPanel, BorderLayout.SOUTH);

	//filechooser
		fileChooser = new JFileChooser();
		DocumentFileFilter defaultFF = new DocumentFileFilter(DocumentFileFilter.ALL_DOCS);
		fileChooser.addChoosableFileFilter(defaultFF);
		fileChooser.addChoosableFileFilter(new DocumentFileFilter(DocumentFileFilter.XML));
		fileChooser.addChoosableFileFilter(new DocumentFileFilter(DocumentFileFilter.TXT));
		fileChooser.addChoosableFileFilter(new DocumentFileFilter(DocumentFileFilter.RTF));
		fileChooser.setFileFilter(defaultFF);
		fileChooser.setAcceptAllFileFilterUsed(false);

	//save as plain text
		plainSaveChooser = new JFileChooser();
		DocumentFileFilter plainDefault = new DocumentFileFilter(DocumentFileFilter.TXT);
		DocumentFileFilter plainAlt = new DocumentFileFilter(DocumentFileFilter.RTF);
		plainSaveChooser.addChoosableFileFilter(plainDefault);
		plainSaveChooser.addChoosableFileFilter(plainAlt);
		plainSaveChooser.setFileFilter(plainDefault);
		
		
	//save as xml
		exportChooser = new JFileChooser();
		DocumentFileFilter exportDefault = new DocumentFileFilter(DocumentFileFilter.XML);
		exportChooser.addChoosableFileFilter(exportDefault);
		exportChooser.setFileFilter(exportDefault);

	//main toolbar
		mainToolBar = new JToolBar("Functions");
		mainToolBar.setFloatable(false);

	//standard toolbar
		standardToolBar = new JToolBar("Standard");
		standardToolBar.setFloatable(false);

	//file toolbar components
		fileTBButtons = new Vector<JButton>();
	//add new file tool bar buttons here, go in order of added
		fileTBButtons.add(new JButton(getActionByName("New")));
		fileTBButtons.add(new JButton(getActionByName("Open")));
		fileTBButtons.add(new JButton(getActionByName("Save")));
		for(JButton button : fileTBButtons) {
			button.setFocusable(false);
			button.setText("");
			standardToolBar.add(button);
			//button.addActionListener(getTextPaneReFocusActionListener());
		}
		standardToolBar.addSeparator();
						
		
		DropDownButton undoDD = new DropDownButton(getActionByName("Undo"), undoManager.getUndoList());
		//undoDD.addToToolBar(standardToolBar);
		//undoDD.addActionListener(getTextPaneReFocusActionListener());
		undoDD.addSelectionCompleteListener(new DropDownButton.SelectionCompleteListener() {
			public void selectionComplete(int amountSelected) {
				final int amount = amountSelected;
				new Thread() {
					public void run() {
						undoManager.undo(amount);
					}
				}.start();
			}
		 });
		
		standardToolBar.add(undoDD);
		
		DropDownButton redoDD = new DropDownButton(getActionByName("Redo"), undoManager.getRedoList());
		//redoDD.addActionListener(getTextPaneReFocusActionListener());
		redoDD.addSelectionCompleteListener(new DropDownButton.SelectionCompleteListener() {
			public void selectionComplete(int amountSelected) {
				final int amount = amountSelected;
				new Thread() {
					public void run() {
						undoManager.redo(amount);
					}
				}.start();
					
			}
		 });
		
		standardToolBar.add(redoDD);
		
		
	//edit toolbar components
		editTBButtons = new Vector<JButton>();
	//add new edit tool bar components here, go in order of added
		editTBButtons.add(new JButton(getActionByName("Join")));
		editTBButtons.add(new JButton(getActionByName("Copy")));
		editTBButtons.add(new JButton(getActionByName("Paste")));
		editTBButtons.add(new JButton(getActionByName("Select All")));

		for(JButton button : editTBButtons) {
			button.setFocusable(false);
			button.setText("");
			standardToolBar.add(button);
			//button.addActionListener(getTextPaneReFocusActionListener());
		}

		
		mainToolBar.add(standardToolBar);

	//formatting toolbar
		formattingToolBar = new JToolBar("Formatting");
		formattingToolBar.setFloatable(false);


	//font toolbar components
		fontTBComponents = new Vector<JComponent>();
	//add new font tool bar components here, go in order of added
		fontTBComponents.add(fontComboBox);
		fontTBComponents.add(sizeComboBox);

		for(JComponent component : fontTBComponents) {
			formattingToolBar.add(component);
		}

		formattingToolBar.addSeparator();

	//formatting toolbar components
		formattingTBButtons = new Vector<JToggleButton>();
	//add new formatting tool bar buttons here, go in order of added
		//need access to toggle button to reflect attributes of text selected
		boldToggle = new JToggleButton(getActionByName("Bold"));
		italicToggle = new JToggleButton(getActionByName("Italic"));
		underlineToggle = new JToggleButton(getActionByName("Underline"));
		formattingTBButtons.add(boldToggle);
		formattingTBButtons.add(italicToggle);
		formattingTBButtons.add(underlineToggle);

		for(JToggleButton button : formattingTBButtons) {
			button.setText("");
			button.setFocusable(false);
			formattingToolBar.add(button);
			//button.addActionListener(getTextPaneReFocusActionListener());
		}
		
		mainToolBar.add(formattingToolBar);
		mainToolBar.add(Box.createHorizontalGlue());

	


	//menu bar
		menuBar = new JMenuBar();

	//File Menu
		fileMenu = new JMenu("File");
		fileMenu.setMnemonic(KeyEvent.VK_F);
	//add new menuItems here for 'File'
		fileMenu.add(getActionByName("New"));
		fileMenu.add(getActionByName("Open"));
		fileMenu.addSeparator();
		fileMenu.add(getActionByName("Save"));
		fileMenu.add(getActionByName("Save As XML"));
		fileMenu.add(getActionByName("Save As Plain"));
		fileMenu.addSeparator();
		fileMenu.add(getActionByName("Save Dictionary"));
		fileMenu.add(getActionByName("Save Variant List"));
		fileMenu.add(getActionByName("Save Rule List"));
		fileMenu.add(getActionByName("Save Confidence Weights"));
		fileMenu.add(getActionByName("Save All"));
		fileMenu.addSeparator();
		fileMenu.add(getActionByName("Exit"));

		menuBar.add(fileMenu);
		
		getActionByName("Save Rule List").setEnabled(lud.isRulesChanged());
		getActionByName("Save Variant List").setEnabled(lud.isVariantsChanged());
		getActionByName("Save Dictionary").setEnabled(lud.isWordsChanged());
		getActionByName("Save Confidence Weights").setEnabled(confidenceWeights.hasChanged());
		
		

	//Edit Menu
		editMenu = new JMenu("Edit");
		editMenu.setMnemonic(KeyEvent.VK_E);
		
		editMenu.add(getActionByName("Undo"));
		editMenu.add(getActionByName("Redo"));
		editMenu.addSeparator();
		editMenu.add(getActionByName("Join"));
		editMenu.addSeparator();
		editMenu.add(getActionByName("Copy"));
		editMenu.add(getActionByName("Paste"));
		editMenu.addSeparator();
		editMenu.add(getActionByName("Select All"));

		menuBar.add(editMenu);



	//Style Menu
		styleMenu = new JMenu("Style");
		styleMenu.setMnemonic(KeyEvent.VK_S);
	//add new menuItems here for 'Edit'
		styleMenu.add(getActionByName("Bold"));
		styleMenu.add(getActionByName("Italic"));
		styleMenu.add(getActionByName("Underline"));		

		menuBar.add(styleMenu);
		
		JMenu advancedMenu = new JMenu("Advanced");
		advancedMenu.setMnemonic(KeyEvent.VK_A);
		advancedMenu.add(getActionByName("Rule List Manager"));
		
		menuBar.add(advancedMenu);

	//list radio buttons
		radioButtonArray = new JRadioButton[4];
		radioButtonGroup = new ButtonGroup();
		sidebar = new JPanel();
		sidebar.setLayout(new BoxLayout(sidebar, BoxLayout.PAGE_AXIS));

		radioButtonArray[0] = new JRadioButton(new RadioButtonAction(VARIANTS_LIST));
		radioButtonArray[1] = new JRadioButton(new RadioButtonAction(REPLACED_LIST));
		radioButtonArray[2] = new JRadioButton(new RadioButtonAction(CORRECT_LIST));
		radioButtonArray[3] = new JRadioButton(new RadioButtonAction(REAL_ERROR_LIST));

		for(int i=0;i<radioButtonArray.length;i++) {
			radioButtonGroup.add(radioButtonArray[i]);
			sidebar.add(radioButtonArray[i]);
			radioButtonArray[i].setAlignmentX(JRadioButton.LEFT_ALIGNMENT);
			radioButtonArray[i].setFocusable(false);
			//radioButtonArray[i].addActionListener(getTextPaneReFocusActionListener());
		}

	//word list header label

		listHeader = new JLabel(" ");
		listHeader.setAlignmentX(JLabel.LEFT_ALIGNMENT);
		listHeader.setMinimumSize(new java.awt.Dimension(140,20));
		listHeader.setMaximumSize(new java.awt.Dimension(140,20));
		listHeader.setPreferredSize(new java.awt.Dimension(140,20));


	//word list
		wordList = new JList();
		wordList.setFocusable(false);
		wordList.setPrototypeCellValue("1234567890123456789012345");
		wordList.setVisibleRowCount(7);
		wordList.setSelectionBackground(SELECTION_COLOUR);
		wordList.addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(ListSelectionEvent e) {
				if(!wordList.isSelectionEmpty()) {
					changeSelectedWord((InstanceHolder<? extends Instance>) wordList.getSelectedValue());
					//textPane.requestFocus();
				}
			}
		});


		wordList.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent e) {
				if(e.getButton() == MouseEvent.BUTTON3 && allowEditing) {
					int toSelect = wordList.locationToIndex(e.getPoint());
					wordList.setSelectedIndex(toSelect);
					
					InstanceHolder<? extends Instance> instanceHolder = (InstanceHolder<? extends Instance>) wordList.getSelectedValue();
					WordHolder wordHolder = instanceHolder.getWordHolder();

					java.awt.Rectangle cellRect = wordList.getCellBounds(toSelect, toSelect);
					
					
					JPopupMenu popup;
					JMenuItem wait;
					JMenu more;
					JMenu nid;
					int added;
					int nidAdded;
					Vector<SuggestedReplacement> reps;
					
					switch(instanceHolder.getType()) {
					case WordHolder.VARIANT:				
						popup = new JPopupMenu();

						wait = new JMenuItem("Please Wait...");
						wait.setEnabled(false);
						popup.add(wait);
						popup.show(wordList, cellRect.x, cellRect.y+cellRect.height);

						more = new JMenu("More Suggestions...");
						nid = new JMenu("Suggestions not in dictionary...");
						added = 0;
						nidAdded = 0;
						docModel.findReplacementsForWord(wordHolder);
						reps = wordHolder.getReplacements();
						Collections.sort(reps);
						for(SuggestedReplacement replacement : reps) {
							if(!replacement.isInDictionary() && !replacement.isKnownVariant()) {
								nid.add(getReplacementPopupMenu(replacement, wordHolder, null, WordHolder.VARIANT, instanceHolder.getCapitalization()));
								nidAdded++;
							}
							
							else if(added<5) {
								popup.add(getReplacementPopupMenu(replacement, wordHolder, null, WordHolder.VARIANT, instanceHolder.getCapitalization()));
								added++;
							}
							else {
								more.add(getReplacementPopupMenu(replacement, wordHolder, null, WordHolder.VARIANT, instanceHolder.getCapitalization()));
								added++;
							}
						}
						if(added==0) {
							JMenuItem noneFound = new JMenuItem("No Replacements found");
							noneFound.setEnabled(false);
							popup.add(noneFound);
						}
						if(added>5)
							popup.add(more);

						if(nidAdded > 0)
							popup.add(nid);

						popup.addSeparator();
						popup.add(new ReplaceWithAction<VariantInstance>(wordHolder, new VariantInstance()));
						popup.add(new MarkAllFInstancesAsTAction<VariantInstance, CorrectInstance>(wordHolder, new VariantInstance(), new CorrectInstance()));
						popup.setVisible(false);
						popup.remove(wait);
						popup.show(wordList, cellRect.x, cellRect.y+cellRect.height);
						
						break;
						
					case WordHolder.CORRECT:
						popup = new JPopupMenu();
						popup.add(new MarkAllFInstancesAsTAction<CorrectInstance, VariantInstance>(wordHolder, new CorrectInstance(), new VariantInstance()));
						popup.show(wordList, cellRect.x, cellRect.y+cellRect.height);
						
						break;
						

					case WordHolder.REPLACED:
						popup = new JPopupMenu();
						ReplacedInstance first = (ReplacedInstance) instanceHolder.firstInstance();
						if(first!=null) {
							popup.add(new RevertAllReplacedAction(wordHolder, first.getReplacement()));
							popup.show(wordList, cellRect.x, cellRect.y+cellRect.height);
						}
						break;
						
					case WordHolder.REAL_ERROR:
						popup = new JPopupMenu();

						wait = new JMenuItem("Please Wait...");
						wait.setEnabled(false);
						popup.add(wait);
						popup.show(wordList, cellRect.x, cellRect.y+cellRect.height);

						more = new JMenu("More Suggestions...");
						nid = new JMenu("Suggestions not in dictionary...");
						added = 0;
						nidAdded = 0;
						docModel.findReplacementsForWord(wordHolder);
						reps = wordHolder.getReplacements();
						Collections.sort(reps);
						for(SuggestedReplacement replacement : reps) {
							if(!replacement.isInDictionary() && !replacement.isKnownVariant()) {
								nid.add(getReplacementPopupMenu(replacement, wordHolder, null, WordHolder.REAL_ERROR, instanceHolder.getCapitalization()));
								nidAdded++;
							}
							
							else if(added<5) {
								popup.add(getReplacementPopupMenu(replacement, wordHolder, null, WordHolder.REAL_ERROR, instanceHolder.getCapitalization()));
								added++;
							}
							else {
								more.add(getReplacementPopupMenu(replacement, wordHolder, null, WordHolder.REAL_ERROR, instanceHolder.getCapitalization()));
								added++;
							}
						}
						if(added==0) {
							JMenuItem noneFound = new JMenuItem("No Replacements found");
							noneFound.setEnabled(false);
							popup.add(noneFound);
						}
						if(added>5)
							popup.add(more);

						if(nidAdded > 0)
							popup.add(nid);

						popup.addSeparator();
						popup.add(new ReplaceWithAction<RealErrorInstance>(wordHolder, new RealErrorInstance()));
						popup.add(new MarkAllFInstancesAsTAction<RealErrorInstance, CorrectInstance>(wordHolder, new RealErrorInstance(), new CorrectInstance()));
						popup.add(new MarkAllFInstancesAsTAction<RealErrorInstance, VariantInstance>(wordHolder, new RealErrorInstance(), new VariantInstance()));
						popup.setVisible(false);
						popup.remove(wait);
						popup.show(wordList, cellRect.x, cellRect.y+cellRect.height);
						
						break;
					}
				}
			}
			public void mouseEntered(MouseEvent e) {}
			public void mouseExited(MouseEvent e) {}
			public void mousePressed(MouseEvent e) {}
			public void mouseReleased(MouseEvent e) {}
		});

		wordListSP = new JScrollPane(wordList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		wordListSP.setAlignmentX(JScrollPane.LEFT_ALIGNMENT);
		
		JButton copyListButton = new JButton(getActionByName("Copy List"));
		copyListButton.setFocusable(false);
		//copyListButton.addActionListener(getTextPaneReFocusActionListener());
		sidebar.add(copyListButton);

		thresholdSlider = new JSlider(SwingConstants.HORIZONTAL, ConfidenceWeights.MIN_TOTAL, ConfidenceWeights.MAX_TOTAL, ConfidenceWeights.SUGGESTED_TOTAL);
		thresholdSlider.setMinorTickSpacing(1);
		thresholdSlider.setMajorTickSpacing(10);
		thresholdSlider.setPaintTicks(true);
		thresholdSlider.setPaintLabels(true);
		thresholdSlider.setSnapToTicks(true);
		thresholdSlider.setAlignmentX(JSlider.LEFT_ALIGNMENT);
		thresholdSlider.setFocusable(false);
	/*	thresholdSlider.addFocusListener(new java.awt.event.FocusListener() {
			public void focusGained(java.awt.event.FocusEvent evt) {
				textPane.requestFocus();
			}
			public void focusLost(java.awt.event.FocusEvent evt) {
			}
		});
	*/

		sidebar.add(Box.createRigidArea(new Dimension(0,20)));
		sidebar.add(listHeader);
		sidebar.add(wordListSP);
		sidebar.add(new JLabel(" Replacement Threshold:", SwingConstants.LEFT));
		sidebar.add(thresholdSlider);
		JButton correctAllButton = new JButton(getActionByName("Correct All"));
		correctAllButton.setFocusable(false);
		//correctAllButton.addActionListener(getTextPaneReFocusActionListener());
		sidebar.add(correctAllButton);
		sidebar.add(Box.createRigidArea(new Dimension(0,20)));
		
		JButton copyReplacementsAnalysisButton = new JButton(getActionByName("Copy Replacement Analysis"));
		copyReplacementsAnalysisButton.setFocusable(false);
		//copyReplacementsAnalysisButton.addActionListener(getTextPaneReFocusActionListener());
		copyReplacementsAnalysisButton.setEnabled(false);
		sidebar.add(copyReplacementsAnalysisButton);
		
		JButton countReplacementsButton = new JButton(getActionByName("Count Replacements"));
		countReplacementsButton.setFocusable(false);
		//countReplacementsButton.addActionListener(getTextPaneReFocusActionListener());
		countReplacementsButton.setEnabled(false);
		sidebar.add(countReplacementsButton);
		
		counts1 = new JLabel(" Replacement Analysis:");
		counts1.setAlignmentX(JLabel.LEFT_ALIGNMENT);
		counts1.setMinimumSize(new java.awt.Dimension(140,20));
		counts1.setMaximumSize(new java.awt.Dimension(140,20));
		counts1.setPreferredSize(new java.awt.Dimension(140,20));
		sidebar.add(counts1);
		
		for(int i=0;i<5;i++) {
			counts[i] = new JLabel("");
			counts[i].setAlignmentX(JLabel.LEFT_ALIGNMENT);
			counts[i].setMinimumSize(new java.awt.Dimension(140,20));
			counts[i].setMaximumSize(new java.awt.Dimension(140,20));
			counts[i].setPreferredSize(new java.awt.Dimension(140,20));
			sidebar.add(counts[i]);

		}
				
		sidebar.add(Box.createVerticalGlue());

		main.add(sidebar, BorderLayout.EAST);

		radioButtonArray[0].doClick();

	//get desktops max window size for setting size of frame
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		Rectangle maxWinSize = ge.getMaximumWindowBounds();

	//setup frame
		frame = new JFrame(PROGRAM_TITLE);
		frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		frame.addWindowListener(new WindowListener() {
			public void windowClosing(WindowEvent e) {
				doExit();
			}

			public void windowActivated(WindowEvent e) {
			}
			public void windowClosed(WindowEvent e) {
			}
		 	public void windowDeactivated(WindowEvent e) {
			}
			public void windowDeiconified(WindowEvent e) {
			}
			public void windowIconified(WindowEvent e) {
			}
			public void windowOpened(WindowEvent e) {
			}
		});



		frame.setJMenuBar(menuBar);
		frame.getContentPane().add(main, BorderLayout.CENTER);
		frame.getContentPane().add(mainToolBar, BorderLayout.NORTH);
		frame.setMaximizedBounds(maxWinSize);
		frame.setBounds(maxWinSize.x,maxWinSize.y,maxWinSize.width,maxWinSize.height);
		setupTextPane();
		

		docModel.addVariantChangeListener(new HolderChangeListener<VariantInstance>() {
			public void listChanged(InstanceHolder<VariantInstance> holder) {
				updateList(WordHolder.VARIANT);
			}
			public void instanceAboutToChange(VariantInstance instance) {
				instance.changeHighlight(removeHighlight);
			}

			public void instanceChanged(VariantInstance instance) {
				if(selectedHolder != null && selectedHolder.contains(instance))
					instance.changeHighlight(selectedHighlight);
				else if(listSelected.equals(VARIANTS_LIST))
					instance.changeHighlight(mainHighlight);	
			}

			public void holderEmptied(InstanceHolder<VariantInstance> holder, VariantInstance vi) {
				variantList.remove(holder);
			}

			public void holderFilled(InstanceHolder<VariantInstance> holder, VariantInstance vi) {
				variantList.add(holder);
			}		
		});
		
		docModel.addCorrectChangeListener(new HolderChangeListener<CorrectInstance>() {

			public void listChanged(InstanceHolder<CorrectInstance> holder) {
				updateList(WordHolder.CORRECT);
			}

			public void instanceAboutToChange(CorrectInstance instance) {
				instance.changeHighlight(removeHighlight);
			}

			public void instanceChanged(CorrectInstance instance) {
				if(selectedHolder != null && selectedHolder.contains(instance))
					instance.changeHighlight(selectedHighlight);
				else if(listSelected.equals(CORRECT_LIST))
					instance.changeHighlight(mainHighlight);
			}

			public void holderEmptied(InstanceHolder<CorrectInstance> holder, CorrectInstance ci) {
				correctList.remove(holder);
				
			}

			public void holderFilled(InstanceHolder<CorrectInstance> holder, CorrectInstance ci) {
				correctList.add(holder);
			}
			
		});
		
		docModel.addRealErrorChangeListener(new HolderChangeListener<RealErrorInstance>() {

			public void listChanged(InstanceHolder<RealErrorInstance> holder) {
				updateList(WordHolder.REAL_ERROR);
			}

			public void instanceAboutToChange(RealErrorInstance instance) {
				instance.changeHighlight(removeHighlight);
			}

			public void instanceChanged(RealErrorInstance instance) {
				if(selectedHolder != null && selectedHolder.contains(instance))
					instance.changeHighlight(selectedHighlight);
				else if(listSelected.equals(REAL_ERROR_LIST))
					instance.changeHighlight(mainHighlight);
			}

			public void holderEmptied(InstanceHolder<RealErrorInstance> holder, RealErrorInstance rei) {
				realErrorList.remove(holder);
				
			}

			public void holderFilled(InstanceHolder<RealErrorInstance> holder, RealErrorInstance rei) {
				realErrorList.add(holder);
			}
			
		});
		
		docModel.addReplacedChangeListener(new HolderChangeListener<ReplacedInstance>() {

			public void listChanged(InstanceHolder<ReplacedInstance> holder) {
				updateList(WordHolder.REPLACED);
			}

			public void instanceAboutToChange(ReplacedInstance instance) {
				instance.changeHighlight(removeHighlight);
			}

			public void instanceChanged(ReplacedInstance instance) {
				if(selectedHolder != null && selectedHolder.contains(instance))
					instance.changeHighlight(selectedHighlight);
				else if(listSelected.equals(REPLACED_LIST))
					instance.changeHighlight(mainHighlight);
			}

			public void holderEmptied(InstanceHolder<ReplacedInstance> holder, ReplacedInstance ri) {
				replacedList.remove(holder);
				
			}

			public void holderFilled(InstanceHolder<ReplacedInstance> holder, ReplacedInstance ri) {
				replacedList.add(holder);
			}
			
		});
	}
	
	private void updateList(int type) {
		String list = "";
		TreeSet ts = new TreeSet();
		int radioButton = -1;
		switch(type) {
		case WordHolder.CORRECT:
			list = CORRECT_LIST;
			ts = correctList;
			radioButton = 2;
			break;
		case WordHolder.REAL_ERROR:
			list = REAL_ERROR_LIST;
			ts = realErrorList;
			radioButton = 3;
			break;
		case WordHolder.REPLACED:
			list = REPLACED_LIST;
			ts = replacedList;
			radioButton = 1;
			break;
		case WordHolder.VARIANT:
			list = VARIANTS_LIST;
			ts = variantList;
			radioButton = 0;
			break;
		}
		radioButtonArray[radioButton].setText(list + " (" + ts.size() + ")");
		if(listSelected.equals(list)) {
			Object currentListSelection = wordList.getSelectedValue();
			wordList.setListData(ts.toArray());
			listHeader.setText(" " + list +  " (" + ts.size() + "):");
			wordList.setSelectedValue(currentListSelection, true);
		}
	}

	private void show() {
		frame.setVisible(true);
		textPane.requestFocus();
	}

	private JMenu getReplacementPopupMenu(SuggestedReplacement replacement, WordHolder wh, VariantInstance instance, int type, int capitalization) {
		JMenu toReturn = new JMenu(replacement.toMenuString(capitalization));
		Vector<JCheckBoxMenuItem> cbs = new Vector<JCheckBoxMenuItem>(4);
		cbs.add(new JCheckBoxMenuItem(confidenceWeights.getKnownVariantString(), replacement.isKnownVariant()));
		cbs.add(new JCheckBoxMenuItem(confidenceWeights.getLetterReplacementString(), replacement.isLetterReplacement()));
		cbs.add(new JCheckBoxMenuItem(confidenceWeights.getSoundexString(), replacement.isSoundex()));
		cbs.add(new JCheckBoxMenuItem(confidenceWeights.getEditDistanceString(replacement), true));
		if(replacement.isInDictionary())
			cbs.add(new JCheckBoxMenuItem("Frequency is " + replacement.getReplacement().getFreq(), false));
		if(!replacement.isInDictionary())
			cbs.add(new JCheckBoxMenuItem(confidenceWeights.getNotInDictString(replacement), true));
		if(instance != null) {
			if(instance.getType() == WordHolder.VARIANT)
				toReturn.add(new ReplaceFInstanceAction<VariantInstance>(instance, replacement));
			else if(instance.getType() == WordHolder.REAL_ERROR)
				toReturn.add(new ReplaceFInstanceAction<RealErrorInstance>((RealErrorInstance) instance, replacement));
			
		}
		if(type == WordHolder.VARIANT)
			toReturn.add(new ReplaceAllFInstancesAction<VariantInstance>(wh, new VariantInstance(), replacement));
		else if(type == WordHolder.REAL_ERROR)
			toReturn.add(new ReplaceAllFInstancesAction<RealErrorInstance>(wh, new RealErrorInstance(), replacement));

		toReturn.addSeparator();
		
		for(JCheckBoxMenuItem cb : cbs) {
			cb.setEnabled(false);
			toReturn.add(cb);
		}
		
		return toReturn;
	}

	private void resetProgressBarLabel() {
		progressBarLabel.setText("");
		progressBarLabel.setIcon(null);
	}

	private void setProgressBarLabelLoading(String text) {
		progressBarLabel.setText(text);
		progressBarLabel.setIcon(LOADING_ICON);
	}

	public static void run() {
		URL loadingURL = MainScreen.class.getResource("icons/loading.gif");
		if (loadingURL != null) {
			LOADING_ICON = new ImageIcon(loadingURL);
		}
		global = globals.Globals.getInstance();

		new Thread(new Runnable() {
			public void run() {
				docModel = new DocumentModel();
				
				confidenceWeights = ConfidenceWeights.getInstance();
				lud = LookUpDictionary.getInstance();
				
				global.processingMessager.writeMessage("Loading user interface...");
				MainScreen ms = new MainScreen();
				global.processingMessager.finishMessages();		
			
				global.processingMessager = ms;
				global.exceptionHandler = ms;
				
				lud.addDataChangeListener(ms);
				
				confidenceWeights.addChangeListener(ms);
				
				ms.show();
			}
		}).start();
	}

	private void doExit() {

		JPanel savePanel = new JPanel(new GridLayout(0,1));

		final JCheckBox docCB = new JCheckBox("Current Document", false);
		final JCheckBox cwCB = new JCheckBox("Confidence Weights", false);
		final JCheckBox dCB = new JCheckBox("Dictionary", false);
		final JCheckBox vCB = new JCheckBox("Variant list", false);
		final JCheckBox rCB = new JCheckBox("Letter replacement rules", false);

		savePanel.add(new JLabel("Tick changes to save:"));

		docCB.setSelected(true);
		savePanel.add(docCB);

		if(confidenceWeights.hasChanged()) {
			cwCB.setSelected(true);
			savePanel.add(cwCB);
		}
		
		if(lud.isWordsChanged()) {
			dCB.setSelected(true);
			savePanel.add(dCB);
		}
		
		if(lud.isVariantsChanged()) {
			vCB.setSelected(true);
			savePanel.add(vCB);
		}
		
		if(lud.isRulesChanged()) {
			rCB.setSelected(true);
			savePanel.add(rCB);
		}

		Object[] options = {"Save changes", "Discard changes", "Cancel"};
		int pc = JOptionPane.showOptionDialog(frame, savePanel, "Save changes?", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[0]);

		if(pc == JOptionPane.YES_OPTION) {
			
			new Thread(new Runnable() {
				public void run() {
					if(docCB.isSelected()) {
						save();
					}
					try {
						if(dCB.isSelected()) {
							lud.writeWordsToFile();
						}
						if(vCB.isSelected()) {
							lud.writeVariantsToFile();
						}
						if(rCB.isSelected()) {
							lud.writeRulesToFile();
						}
						if(cwCB.isSelected()) {
							confidenceWeights.save();
						}
						System.exit(0);
					}
					catch(IOException ex) {
						global.exceptionHandler.showException("Error writing file.", ex);
					}
				}
			}).start();
		}
		else if(pc == JOptionPane.NO_OPTION)
			System.exit(0);
	}

	private class FindWordInListAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 7144807205585186906L;
		Instance instance;
		private FindWordInListAction(Instance instance) {
			super();
			putValue(Action.NAME, "Find word in list");
			this.instance = instance;
		}
		public void actionPerformed(ActionEvent evt) {
			switch(instance.getType()) {

				case WordHolder.VARIANT:
					if(listSelected != VARIANTS_LIST)
						radioButtonArray[0].doClick();
					wordList.setSelectedValue(instance.getInstanceHolder(), true);
					break;

				case WordHolder.REPLACED:
					if(listSelected != REPLACED_LIST)
						radioButtonArray[1].doClick();
					wordList.setSelectedValue(instance.getInstanceHolder(), true);
					break;
	
				case WordHolder.CORRECT:
					if(listSelected != CORRECT_LIST)
						radioButtonArray[2].doClick();
					wordList.setSelectedValue(instance.getInstanceHolder(), true);
					break;
					
				case WordHolder.REAL_ERROR:
					if(listSelected != REAL_ERROR_LIST)
						radioButtonArray[3].doClick();
					wordList.setSelectedValue(instance.getInstanceHolder(), true);
					break;
			}
		}
	}
	
	private void changeSelectedWord(InstanceHolder<? extends Instance> newSelection) {
		InstanceHolder<? extends Instance> oldSelection = selectedHolder;
		selectedHolder = newSelection;
		
		if(oldSelection!=null) {
			oldSelection.resetAllInstancesHighlights();
		}
		if(selectedHolder!=null) {
			selectedHolder.resetAllInstancesHighlights();
		}
	}

	private void updateAttributesViewWithAttributesOfRange(int start, int end) throws BadLocationException {
		String font = "";
		int size = 0;
		boolean bold, italic, underline, boldDisagree = false, italicDisagree = false, underlineDisagree = false, sizeDisagree = false, fontDisagree = false;

		for(;!docModel.isCharAtPosLetter(start) && start<end-1;start++) {
		}

		AttributeSet cas = docModel.getAttributesAtPos(start);
		bold = StyleConstants.isBold(cas);
		italic = StyleConstants.isItalic(cas);
		underline = StyleConstants.isUnderline(cas);
		font = StyleConstants.getFontFamily(cas);
		size = StyleConstants.getFontSize(cas);


		for(int i=start+1;i<end;i++) {
			if(docModel.isCharAtPosLetter(i)) {
				cas = docModel.getAttributesAtPos(i);

				if(!boldDisagree) {
					if(StyleConstants.isBold(cas) != bold) {
						bold = false;
						boldDisagree = true;
					}
				}
	
				if(!italicDisagree) {
					if(StyleConstants.isItalic(cas) != italic) {
						italic = false;
						italicDisagree = true;
					}
				}

				if(!underlineDisagree) {
					if(StyleConstants.isUnderline(cas) != underline) {
						underline = false;
						underlineDisagree = true;
					}
				}

				if(!fontDisagree) {
					if(!StyleConstants.getFontFamily(cas).equals(font)) {
						font = "";
						fontDisagree = true;
					}
				}

				if(!sizeDisagree) {
					if(StyleConstants.getFontSize(cas) != size) {
						size = 0;
						sizeDisagree = true;
					}
				}
			}
		}
					
		fontComboBox.setActionCommand("skip");
		fontComboBox.setSelectedItem(font);
		fontComboBox.setActionCommand("do it");

		sizeComboBox.setActionCommand("skip");
		if(size==0)
			sizeComboBox.setSelectedItem("");
		else
			sizeComboBox.setSelectedItem(size);
		sizeComboBox.setActionCommand("do it");

		boldToggle.getModel().setSelected(bold);
		italicToggle.getModel().setSelected(italic);
		underlineToggle.getModel().setSelected(underline);

	}

	private void setupTextPane() {
		getActionByName("Copy").setEnabled(false);
		getActionByName("Join").setEnabled(false);
		docModel.setDocument(textPane.getStyledDocument());
		try {
			updateAttributesViewWithAttributesOfRange(docModel.getStartOfDoc(), docModel.getEndOfDoc());
		}
		catch(BadLocationException ex) {
			global.exceptionHandler.showException("Error occurred reading document's attributes.", ex);
		}
		variantList.clear();
		replacedList.clear();
		correctList.clear();
		realErrorList.clear();
		
		updateList(WordHolder.VARIANT);
		updateList(WordHolder.REPLACED);
		updateList(WordHolder.CORRECT);
		updateList(WordHolder.REAL_ERROR);
		
		undoManager.discardAllEdits();
		undoManager.refreshUndoRedoUI();
		
		currentFile = null;
		currentFileType = -1;
	}

	private class RadioButtonAction extends AbstractAction {
		private static final long serialVersionUID = -934709526028658245L;
		private String whichList;
		RadioButtonAction(String whichList) {
			super();
			this.whichList = whichList;
			putValue(Action.NAME, whichList);
		}

		public void actionPerformed(ActionEvent e) {
			changeSelectedWord(null);
			String oldSelected = listSelected;
			listSelected = whichList;
			if(oldSelected != null) {
				if(oldSelected.equals(VARIANTS_LIST))
					updateAllInVariantList();
				else if(oldSelected.equals(REPLACED_LIST))
					updateAllInReplacedList();
				else if(oldSelected.equals(CORRECT_LIST))
					updateAllInCorrectList();
				else if(oldSelected.equals(REAL_ERROR_LIST)) {
					updateAllInRealErrorList();
				}
			}
			if(whichList.equals(VARIANTS_LIST)) {
				wordList.setListData(variantList.toArray());
				listHeader.setText(" " + VARIANTS_LIST +  " (" + variantList.size() + "):");
				updateAllInVariantList();
			}

			else if(whichList.equals(REPLACED_LIST)) {
				wordList.setListData(replacedList.toArray());
				listHeader.setText(" " + REPLACED_LIST +  " (" + replacedList.size() + "):");
				updateAllInReplacedList();
			}

			else if(whichList.equals(CORRECT_LIST)) {
				wordList.setListData(correctList.toArray());
				listHeader.setText(" " + CORRECT_LIST +  " (" + correctList.size() + "):");
				updateAllInCorrectList();
			}
			
			else if(whichList.equals(REAL_ERROR_LIST)) {
				wordList.setListData(realErrorList.toArray());
				listHeader.setText(" " + REAL_ERROR_LIST +  " (" + realErrorList.size() + "):");
				updateAllInRealErrorList();
			}
		}
	}

	private void updateAllInVariantList() {
		for(InstanceHolder<VariantInstance> ih : variantList) {
			ih.resetAllInstancesHighlights();
		}
	}
	private void updateAllInReplacedList() {
		for(InstanceHolder<ReplacedInstance> ih : replacedList) {
			ih.resetAllInstancesHighlights();
		}
	}
	private void updateAllInCorrectList() {
		for(InstanceHolder<CorrectInstance> ih : correctList) {
			ih.resetAllInstancesHighlights();
		}
	}
	private void updateAllInRealErrorList() {
		for(InstanceHolder<RealErrorInstance> ih : realErrorList) {
			ih.resetAllInstancesHighlights();
		}
	}

	
	//needs making undoable
	private class ProcessAllVariantsAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 4429003620159727500L;
		Timer timer;
		
		private boolean update;

		ProcessAllVariantsAction() {
			super();
			
			timer = new Timer(50, new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					progressBar.setValue(docModel.getCurrentPosBeingRead());
					if(docModel.isReadFinished()) {
						timer.stop();
						final int threshold = thresholdSlider.getValue();
						DocumentModel.ProcessAllVariantsEdit edit = docModel.getProcessAllVariantsEdit(threshold, update);
						ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
						tEdit.execute();								
						undoSupport.postEdit(tEdit);
					}
				}
			});

		}

		public void actionPerformed(ActionEvent e) {
			int o = JOptionPane.showOptionDialog(frame,
                    "Would you like the confidence weights to be adjusted by the replacements made?",
                    "Adjust confidence weights?",
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE,
                    null,
                    null,
                    null);
			update = (o == JOptionPane.YES_OPTION);
		
			setLoading(true);
			progressBar.setValue(0);
			setProgressBarLabelLoading("Finding Replacements...");
			progressBar.setMaximum(docModel.getReplacements());
			timer.start();
		}
	}

	
	//added 16/7/07
	private class MarkFInstanceAsTAction<F extends Instance, T extends Instance> extends AbstractAction {
		private static final long serialVersionUID = -7964139713034760680L;
		
		MarkFInstanceAsTEdit<F, T> edit;
		
		MarkFInstanceAsTAction(F fi, T tempTo) {
			super();
			try {
				edit = new MarkFInstanceAsTEdit<F, T>(fi, tempTo);
				putValue(Action.NAME, edit.getActionName());
			}
			catch(InvalidInstanceChangeException ex) {
				global.exceptionHandler.showException("Error occurred in marking instance prep.", ex);
			}
		}

		public void actionPerformed(ActionEvent ae) {
			try {
				edit.execute();
				undoSupport.postEdit(edit);
			}
			catch(InvalidInstanceChangeException ex) {
				global.exceptionHandler.showException("Error occurred marking instance.", ex);
			}
			
			WordHolder wh = edit.getToInstance().getHolder();
			if(edit.getToType() == WordHolder.CORRECT && !wh.isInDictionary()) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to add this word to the dictionary?",
                        "Add to dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					AddWordToDictionaryEdit addEdit = new AddWordToDictionaryEdit(wh, wh.getWord());
					addEdit.execute();
					undoSupport.postEdit(addEdit);
				}
			}
			
			else if(edit.getToType() == WordHolder.VARIANT) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to remove this word from the dictionary?\nThis will result in the word being marked as a variant in future.",
                        "Remove from dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					RemoveWordFromDictionaryEdit removeEdit = new RemoveWordFromDictionaryEdit(wh, wh.getWord());
					removeEdit.execute();
					undoSupport.postEdit(removeEdit);
				}
			}
			
		}
	}
	
	//added 18/7/07
	private class ReplaceFInstanceAction<F extends VariantInstance> extends AbstractAction {
		private static final long serialVersionUID = -7964139713034760680L;
		
		ReplaceFInstanceEdit<F> edit;
		SuggestedReplacement rep;
		
		int fromType;
		
		ReplaceFInstanceAction(F fi, SuggestedReplacement rep) {
			super();
			this.rep = rep;
			this.fromType = fi.getType();
			try {
				edit = new ReplaceFInstanceEdit<F>(fi, rep, true);
				putValue(Action.NAME, edit.getActionName());
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred in replacing instance prep.", ex);
			}
		}

		public void actionPerformed(ActionEvent ae) {
			
			try {
				edit.execute();
				undoSupport.postEdit(edit);
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred replacing instance.", ex);
			}
			catch(BadLocationException ex) {
				showException("Error occurred replacing instance in text", ex);
			}
			
			if(fromType == WordHolder.REAL_ERROR) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to remove the original word from the dictionary?\nThis will result in the word being marked as a variant in future.",
                        "Remove from dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					RemoveWordFromDictionaryEdit removeEdit = new RemoveWordFromDictionaryEdit(edit.getWordHolder(), edit.getWordHolder().getWord());
					removeEdit.execute();
					undoSupport.postEdit(removeEdit);
				}
			}
			
			if(!rep.isInDictionary()) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to add this word to the dictionary?",
                        "Add to dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					AddWordToDictionaryEdit addEdit = new AddWordToDictionaryEdit(edit.getWordHolder(), rep.getReplacementString());
					addEdit.execute();
					undoSupport.postEdit(addEdit);
				}
			}
			
			if(!rep.isKnownVariant()) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to add this replacement to the Known Variant Replacement list?",
                        "Remember replacement?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					AddVariantToLookUpEdit addEdit = new AddVariantToLookUpEdit(rep);
					addEdit.execute();
					undoSupport.postEdit(addEdit);
				}
			}
		}
	}
	
	//added 18/7/07
	private class RevertReplacedInstanceAction extends AbstractAction {
		private static final long serialVersionUID = -7964139713034760680L;
		
		RevertReplacedInstanceEdit edit;
		
		RevertReplacedInstanceAction(ReplacedInstance ri) {
			super();
			try {
				edit = new RevertReplacedInstanceEdit(ri);
				putValue(Action.NAME, edit.getActionName());
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred in reverting instance prep.", ex);
			}
		}

		public void actionPerformed(ActionEvent ae) {
			try {
				edit.execute();
				undoSupport.postEdit(edit);
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred reverting instance.", ex);
			}
			catch(BadLocationException ex) {
				showException("Error occurred reverting instance in text", ex);
			}
		}
	}

	//added 18/7/07
	private class MarkAllFInstancesAsTAction<F extends Instance, T extends Instance> extends AbstractAction {
		private static final long serialVersionUID = -7964139713034760680L;
		
		MarkAllFInstancesAsTEdit<F, T> edit;
		WordHolder wh;
		
		MarkAllFInstancesAsTAction(WordHolder wh, F tempFrom, T tempTo) {
			super();
			this.wh = wh;
			try {
				edit = new MarkAllFInstancesAsTEdit<F, T>(wh, tempFrom, tempTo);
				putValue(Action.NAME, edit.getActionName());
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred in marking all instances prep.", ex);
			}
		}

		public void actionPerformed(ActionEvent ae) {
			try {
				edit.execute();
				undoSupport.postEdit(edit);
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred marking instance.", ex);
			}
			
			if(edit.getToType() == WordHolder.CORRECT && !wh.isInDictionary()) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to add this word to the dictionary?",
                        "Add to dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					AddWordToDictionaryEdit addEdit = new AddWordToDictionaryEdit(wh, wh.getWord());
					addEdit.execute();
					undoSupport.postEdit(addEdit);
				}
			}
			else if(edit.getToType() == WordHolder.VARIANT) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to remove this word from the dictionary?\nThis will result in the word being marked as a variant in future.",
                        "Remove from dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					RemoveWordFromDictionaryEdit removeEdit = new RemoveWordFromDictionaryEdit(wh, wh.getWord());
					removeEdit.execute();
					undoSupport.postEdit(removeEdit);
				}
			}
		}
	}
	
	//added 18/7/07
	private class ReplaceAllFInstancesAction<F extends VariantInstance> extends AbstractAction {
		private static final long serialVersionUID = -7964139713034760680L;
		
		ReplaceAllFInstancesEdit<F> edit;
		SuggestedReplacement rep;
		WordHolder wh;
		
		int fromType;
		
		ReplaceAllFInstancesAction(WordHolder wh, F tempFrom, SuggestedReplacement rep) {
			super();
			this.rep = rep;
			this.wh = wh;
			try {
				edit = new ReplaceAllFInstancesEdit<F>(wh, tempFrom, rep, true);
				putValue(Action.NAME, edit.getActionName());
				fromType = tempFrom.getType();
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred in replacing instance prep.", ex);
			}
		}

		public void actionPerformed(ActionEvent ae) {
			try {
				edit.execute();
				undoSupport.postEdit(edit);
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred replacing all instances.", ex);
			}
			catch(BadLocationException ex) {
				showException("Error occurred replacing all instances in text", ex);
			}
			
			if(fromType == WordHolder.REAL_ERROR) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to remove the original word from the dictionary?\nThis will result in the word being marked as a variant in future.",
                        "Remove from dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					RemoveWordFromDictionaryEdit removeEdit = new RemoveWordFromDictionaryEdit(wh, wh.getWord());
					removeEdit.execute();
					undoSupport.postEdit(removeEdit);
				}
			}
			
			if(!rep.isInDictionary()) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to add this word to the dictionary?",
                        "Add to dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					AddWordToDictionaryEdit addEdit = new AddWordToDictionaryEdit(wh, rep.getReplacementString());
					addEdit.execute();
					undoSupport.postEdit(addEdit);
				}
			}			
			
			if(!rep.isKnownVariant()) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to add this replacement to the Known Variant Replacement list?",
                        "Remember replacement?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					AddVariantToLookUpEdit addEdit = new AddVariantToLookUpEdit(rep);
					addEdit.execute();
					undoSupport.postEdit(addEdit);
				}
			}
		}
	}

	private class RevertAllReplacedAction extends AbstractAction {
		private static final long serialVersionUID = -7964139713034760680L;
		
		RevertAllReplacedEdit edit;
		
		RevertAllReplacedAction(WordHolder wh, SuggestedReplacement rep) {
			super();
			try {
				edit = new RevertAllReplacedEdit(wh, rep);
				putValue(Action.NAME, edit.getActionName());
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred in reverting all instances prep.", ex);
			}
		}

		public void actionPerformed(ActionEvent ae) {
			try {
				edit.execute();
				undoSupport.postEdit(edit);
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred reverting all instances.", ex);
			}
			catch(BadLocationException ex) {
				showException("Error occurred reverting all instance in text", ex);
			}
		}
	}
	
	private class ReplaceWithAction<F extends VariantInstance> extends AbstractAction {
		private static final long serialVersionUID = 6659037788557951900L;

		F fi;
		WordHolder wh;
		boolean isInstance;
		int fromType;
		
		//replaceAll edit
		//replaceInstance edit

		ReplaceWithAction(F fi) {
			super();
			isInstance = true;
			this.fi = fi;
			this.wh = fi.getHolder();
			fromType = fi.getType();
			putValue(Action.NAME, "Replace with...");
		}

		ReplaceWithAction(WordHolder wh, F temp) {
			super();
			isInstance = false;
			this.wh = wh;
			fi = temp;
			fromType = fi.getType();

			putValue(Action.NAME, "Replace with...");
		}

		public void actionPerformed(ActionEvent e) {
			String variantString;
			if(isInstance)
				variantString = fi.getOriginal();
			else
				variantString = wh.getWord();

			AddOwnVariantDialog.UserInput userInput = new AddOwnVariantDialog().showDialog(frame, variantString, isInstance);
			if(userInput==null)
				return;

			Word newWord = new Word(userInput.getReplacement(), null, true, userInput.isAddRepToDictionary(), 1);
			SuggestedReplacement replacement = new SuggestedReplacement(newWord, variantString, confidenceWeights);
			replacement.setKnownVariant(userInput.isAddVarToUDV(), true);
			replacement.setSoundex(WordUtilities.getSoundexCode(variantString));

			Vector<SuggestedReplacement> wordReplacements = wh.getReplacements();
			int where = wordReplacements.indexOf(replacement);
			if(where>-1)
				replacement = wordReplacements.get(where);

			try {
				if(userInput.isReplaceAllInstancesOfWord()) {
					ReplaceAllFInstancesEdit<F> edit = new ReplaceAllFInstancesEdit<F>(wh, fi, replacement, true);
					edit.execute();
					undoSupport.postEdit(edit);
				}
					
				else {
					ReplaceFInstanceEdit<F> edit = new ReplaceFInstanceEdit<F>(fi, replacement, true);
					edit.execute();
					undoSupport.postEdit(edit);
				}
			}
			catch(BadLocationException ex) {
				showException("Error occurred replacing word", ex);
			}
			catch(InvalidInstanceChangeException ex) {
				showException("Error occurred replacing word", ex);
			}
			
			if(userInput.isAddRepToDictionary()) {
				AddWordToDictionaryEdit addEdit = new AddWordToDictionaryEdit(wh, replacement.getReplacementString());
				addEdit.execute();
				undoSupport.postEdit(addEdit);
			}

			if(userInput.isAddVarToUDV()) {
				AddVariantToLookUpEdit addEdit = new AddVariantToLookUpEdit(replacement);
				addEdit.execute();
				undoSupport.postEdit(addEdit);
			}
			
			if(fromType == WordHolder.REAL_ERROR) {
				int o = JOptionPane.showOptionDialog(frame,
                        "Would you like to remove the original word from the dictionary?\nThis will result in the word being marked as a variant in future.",
                        "Remove from dictionary?",
                        JOptionPane.YES_NO_OPTION,
                        JOptionPane.QUESTION_MESSAGE,
                        null,
                        null,
                        null);
				if(o == JOptionPane.YES_OPTION) {
					RemoveWordFromDictionaryEdit removeEdit = new RemoveWordFromDictionaryEdit(wh, wh.getWord());
					removeEdit.execute();
					undoSupport.postEdit(removeEdit);
				}
			}
		}	
	}
			
	private class DocumentFileFilter extends FileFilter {
		static final int ALL_DOCS = 0;
		static final int RTF = 1;
		static final int TXT = 2;
		static final int XML = 3;
		static final int VDS = 4;

		private Vector<String> acceptedExtensions = new Vector<String>();
		private String description = "";

		DocumentFileFilter(int filter) {
			switch(filter) {
				case RTF:
					acceptedExtensions.add("rtf");
					description = "Rich Text Format (*.rtf)";
					break;
				case TXT:
					acceptedExtensions.add("txt");
					description = "Plain Text (*.txt)";
					break;
				case XML:
					acceptedExtensions.add("xml");
					description = "XML Tagged (*.xml)";
					break;
				case ALL_DOCS:
				default:
					acceptedExtensions.add("xml");
					acceptedExtensions.add("txt");
					acceptedExtensions.add("rtf");
					description = "All accepted files (*.xml, *.txt & *.rtf)";
					break;
			}
		}

		public boolean accept(File f) {
			if(f.isDirectory())
				return true;

			String fileName = f.getName();
			int dot = fileName.lastIndexOf('.');
			if(dot>0 && dot<fileName.length()-1) {
				String ext = fileName.substring(dot+1).toLowerCase();
				if(acceptedExtensions.contains(ext))
					return true;
				else
					return false;
			}
			else
				return false;
		}

		public String getDescription() {
			return description;
		}
	}

	private void setLoading(boolean loading) {
		allowEditing = !loading;
		setAllActionsEnabled(allowEditing);
		wordList.setEnabled(allowEditing);
		for(JRadioButton rb : radioButtonArray) {
			rb.setEnabled(allowEditing);
		}
		
		if(allowEditing == true) {
			undoManager.refreshUndoRedoUI();
			getActionByName("Copy").setEnabled(false);
			getActionByName("Join").setEnabled(false); //both these 2 will be enabled when selection is made
			
			getActionByName("Save Rule List").setEnabled(lud.isRulesChanged());
			getActionByName("Save Variant List").setEnabled(lud.isVariantsChanged());
			getActionByName("Save Dictionary").setEnabled(lud.isWordsChanged());
			getActionByName("Save Confidence Weights").setEnabled(confidenceWeights.hasChanged());
		}
	}



	//added 30/8/06
	private class CountReplacementsAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 755767731579580411L;

		CountReplacementsAction() {
			super();
		}
		
		public void actionPerformed(ActionEvent e) {
			docModel.countReplacements();
			for(int i=0;i<5;i++) {
				counts[i].setText(" " + docModel.getShortReplacementAnalysis(i));
			}
		}
	}
	
	//added 30/8/06
	private class CopyReplacementAnalysisAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 755767731579580411L;

		CopyReplacementAnalysisAction() {
			super();
		}
		
		public void actionPerformed(ActionEvent e) {
			ClipboardTextTransfer ctt = new ClipboardTextTransfer();
			ctt.setClipboardContents(docModel.getReplacementAnalysis());
		}
	}
	
	//added 29/8/06 - for copying list to clipboard
	private class CopyListAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = -562300188506750751L;
		
		CopyListAction() {
			super();
		}
		public void actionPerformed(ActionEvent e) {
			ClipboardTextTransfer ctt = new ClipboardTextTransfer();
			if(listSelected.equals(CORRECT_LIST)) {
				String cb = "";
				for(InstanceHolder<CorrectInstance> ih : correctList) {
					cb += ih.tabbedString() + "\r";
				}
				ctt.setClipboardContents(cb);
			}
			else if(listSelected.equals(REAL_ERROR_LIST)) {
				String cb = "";
				for(InstanceHolder<RealErrorInstance> ih : realErrorList) {
					cb += ih.tabbedString() + "\r";
				}
				ctt.setClipboardContents(cb);
			}
			else if(listSelected.equals(REPLACED_LIST)) {
				String cb = "";
				for(InstanceHolder<ReplacedInstance> ih : replacedList) {
					cb += ih.tabbedString() + "\r";
				}
				ctt.setClipboardContents(cb);
			}
			else if(listSelected.equals(VARIANTS_LIST)) {
				String cb = "";
				for(InstanceHolder<VariantInstance> ih : variantList) {
					cb += ih.tabbedString() + "\r";
				}
				ctt.setClipboardContents(cb);
			}
		}
	}
	
	public final class ClipboardTextTransfer implements ClipboardOwner {
		public void lostOwnership( Clipboard aClipboard, Transferable aContents) {
			//do nothing
		}
		
		public void setClipboardContents(String text) {
			try {
				StringSelection stringSelection = new StringSelection(text);
				Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
				clipboard.setContents( stringSelection, this );
			}
			catch(IllegalStateException ex) {
				global.exceptionHandler.showException("Error occurred whilst copying list to clipboard.", ex);
			}
		}
		
	}
	
	private class NewAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = -6218890096674492767L;

		NewAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			currentFile = null;
			frame.setTitle(PROGRAM_TITLE);
			textPane.setStyledDocument(new javax.swing.text.DefaultStyledDocument());
			setupTextPane();
		}
	}
			
	private class OpenAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = -2167496422726054143L;
		Timer timer, timer2;
		
		OpenAction() {
			super();
/*			timer = new Timer(50, new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					progressBar.setValue(docModel.getCurrentPosBeingRead());
					if(docModel.isReadFinished()) {
						timer.stop();
						progressBar.setValue(0);
						progressBar.setMaximum(docModel.getReplacements());
						setProgressBarLabelLoading("Finding replacements...");
						timer2.start();
					}
				}
			});
*/

			timer2 = new Timer(50, new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					progressBar.setValue(docModel.getCurrentPosBeingRead());
					if(docModel.isReadFinished()) {
						timer2.stop();
						progressBar.setValue(0);
						resetProgressBarLabel();
					}
				}
			});
			
		}
	
		public void actionPerformed(ActionEvent e) {
			int returnVal = fileChooser.showOpenDialog(frame);
			if(returnVal == JFileChooser.APPROVE_OPTION) {
				File fileSelected = fileChooser.getSelectedFile();
				try {
					Document d = new DefaultStyledDocument();
					if(fileSelected == null) {
						displayError("No file selected");
						return;
					}
					else if(fileSelected.getName().endsWith("xml")) {
						ImportXML ixml = new ImportXML();
						ixml.run();
						return;
					}
					
					else if(fileSelected.getName().endsWith("txt")) {
						sek = new StyledEditorKit();
						sek.read(new java.io.FileInputStream(fileSelected), d, 0);
						textPane.setDocument(d);
					}

					else if(fileSelected.getName().endsWith("rtf")) {
						sek = new RTFEditorKit();
						sek.read(new java.io.FileInputStream(fileSelected), d, 0);
						textPane.setDocument(d);
					}
					else
						throw new IOException("Not a valid file type");
					
					setLoading(true);

					frame.setTitle(PROGRAM_TITLE + " - " + fileSelected.getName());
					setupTextPane();

					progressBar.setMaximum(docModel.getDocLength());
					setProgressBarLabelLoading("Reading document...");
					Thread thread = new Thread(new Runnable() {
						public void run() {
							try {
								docModel.readWords();
							}
							catch(BadLocationException ex) {
								global.exceptionHandler.showException("Error occurred whilst reading the words in the document.", ex);
							}
							finally {
								setLoading(false);
							}
						}
					});
					thread.setPriority(6);
					thread.start();
					timer2.start();
				}
				catch(MalformedURLException ex) {
					global.exceptionHandler.showException("Bad file name", ex);
					return;
				}
				catch(BadLocationException ex) {
					global.exceptionHandler.showException("Error occurred whilst reading the words in the document.", ex);
					return;
				}
				catch(IOException ex) {
					global.exceptionHandler.showException("Error reading file", ex);
					return;
				}
			}
		}

	}

	private void save() {
		if(currentFile != null && currentFileType == TXT) {
			docModel.saveToFile(currentFile);
		}
		else if(currentFile != null && currentFileType == XML) {
			exportToXML(currentFile);
		}
		else {
			Object[] options = {"Save with XML tags", "Save without XML tags"};
			Object o = JOptionPane.showInputDialog(frame,
                    "How would you like to save the file?",
                    "Save as?",
                    JOptionPane.QUESTION_MESSAGE,
                    null,
                    options,
                    options[0]);
			if(o == null)
				return;
			if(o.equals(options[0])){
				saveAs();
			}
			else if(o.equals(options[1])) {
				exportToXML();
			}
		}
	}

	private void saveAs() {
		int returnVal = plainSaveChooser.showSaveDialog(frame);
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			File fileSelected = plainSaveChooser.getSelectedFile();
			if(fileSelected.exists()) {
				int yn = JOptionPane.showConfirmDialog(frame,("You are overwriting an existing file, continue?"), ("Overwrite?"), JOptionPane.OK_CANCEL_OPTION);
				if(yn == JOptionPane.CANCEL_OPTION)
					return;
			}
			docModel.saveToFile(fileSelected);
			currentFile = fileSelected;
			currentFileType = TXT;
			frame.setTitle(PROGRAM_TITLE + " - " + fileSelected.getName());
		}
	}
					
	private class SaveAsPlainAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 3551298055490692028L;

		SaveAsPlainAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			saveAs();
		}
	}

	private class ExportToXMLAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 2998037746672741986L;

		ExportToXMLAction() {
			super();
		}

		public void actionPerformed(ActionEvent evt) {
			exportToXML();
		}
	}
	
	private boolean finished  = false;
	
	Timer inputTimer = new Timer(50, new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
			progressBar.setMaximum(docModel.getHighestPosToRead());
			progressBar.setValue(docModel.getCurrentPosBeingRead());
			if(finished) {
				inputTimer.stop();
				progressBar.setValue(0);
				resetProgressBarLabel();
			}
		}
	});
	
	
	private void exportToXML() {
		int returnVal = exportChooser.showSaveDialog(frame);
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			final File fileSelected = exportChooser.getSelectedFile();
			if(fileSelected.exists()) {
				int yn = JOptionPane.showConfirmDialog(frame,("You are overwriting an existing file, continue?"), ("Overwrite?"), JOptionPane.OK_CANCEL_OPTION);
				if(yn == JOptionPane.CANCEL_OPTION)
					return;
			}
			exportToXML(exportChooser.getSelectedFile());
		}
	}
	
	private void exportToXML(File xmlFile) {
		final File fileSelected = xmlFile;
		setLoading(true);
		finished = false;
				
		Thread thread = new Thread(new Runnable() {
			public void run() {
				try {
					setProgressBarLabelLoading("Writing XML...");
					docModel.exportToXML(fileSelected);
					currentFile = fileSelected;
					currentFileType = XML;
					frame.setTitle(PROGRAM_TITLE + " - " + fileSelected.getName());
				}
				catch(IOException ex) {
					showException("Error writing XML file.", ex);
				}
				catch(BadLocationException ex) {
					showException("Error writing XML file.", ex);
				}
				finally {
					setLoading(false);
					finished = true;
				}
			}
		});
		thread.setPriority(6);
		thread.start();
		inputTimer.start();
	}

	private class SaveAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1035721027447348802L;

		SaveAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			save();
		}
	}

	private class SaveDictionaryAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 7397383512576562239L;

		SaveDictionaryAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			new Thread(new Runnable() {
				public void run() {
					try {
						lud.writeWordsToFile();
					}
					catch(IOException ex) {
						global.exceptionHandler.showException("Error writing words.txt.", ex);
					}
				}
			}).start();
		}
	}
	
	private class SaveVariantsAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 7397383512576562239L;

		SaveVariantsAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			new Thread(new Runnable() {
				public void run() {
					try {
						lud.writeVariantsToFile();
					}
					catch(IOException ex) {
						global.exceptionHandler.showException("Error writing variants.txt.", ex);
					}
				}
			}).start();
		}
	}
	
	private class SaveRulesAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 7397383512576562239L;

		SaveRulesAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			new Thread(new Runnable() {
				public void run() {
					try {
						lud.writeRulesToFile();
					}
					catch(IOException ex) {
						global.exceptionHandler.showException("Error writing rules.txt.", ex);
					}
				}
			}).start();
		}
	}

	private class SaveConfidenceWeightsAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = -7275830361201799128L;

		SaveConfidenceWeightsAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			new Thread(new Runnable() {
				public void run() {
					try {
						confidenceWeights.save();
					}
					catch(IOException ex) {
						global.exceptionHandler.showException("Error writing confidence weights.", ex);
					}
				}
			}).start();
		}
	}
	
	private class SaveAllAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = -7275830361201799128L;

		SaveAllAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			JPanel savePanel = new JPanel(new GridLayout(0,1));

			final JCheckBox docCB = new JCheckBox("Current Document", false);
			final JCheckBox cwCB = new JCheckBox("Confidence Weights", false);
			final JCheckBox dCB = new JCheckBox("Dictionary", false);
			final JCheckBox vCB = new JCheckBox("Variant list", false);
			final JCheckBox rCB = new JCheckBox("Letter replacement rules", false);

			savePanel.add(new JLabel("Tick changes to save:"));

			docCB.setSelected(true);
			savePanel.add(docCB);

			if(confidenceWeights.hasChanged()) {
				cwCB.setSelected(true);
				savePanel.add(cwCB);
			}
			
			if(lud.isWordsChanged()) {
				dCB.setSelected(true);
				savePanel.add(dCB);
			}
			
			if(lud.isVariantsChanged()) {
				vCB.setSelected(true);
				savePanel.add(vCB);
			}
			
			if(lud.isRulesChanged()) {
				rCB.setSelected(true);
				savePanel.add(rCB);
			}

			Object[] options = {"Save changes", "Cancel"};
			int pc = JOptionPane.showOptionDialog(frame, savePanel, "Save changes?", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[0]);

			if(pc == JOptionPane.OK_OPTION) {
				
				new Thread(new Runnable() {
					public void run() {
						if(docCB.isSelected()) {
							save();
						}
						try {
							if(dCB.isSelected()) {
								lud.writeWordsToFile();
							}
							if(vCB.isSelected()) {
								lud.writeVariantsToFile();
							}
							if(rCB.isSelected()) {
								lud.writeRulesToFile();
							}
							if(cwCB.isSelected()) {
								confidenceWeights.save();
							}
						}
						catch(IOException ex) {
							global.exceptionHandler.showException("Error writing file.", ex);
						}
					}
				}).start();
			}
		}
	}
	
	private class ExitAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 6496262943261420464L;

		ExitAction() {
			super();
		}

		public void actionPerformed(ActionEvent e) {
			doExit();
		}
	}

	private class PasteAction extends AbstractAction {

		/**
		 * 
		 */
		private static final long serialVersionUID = -4304408041448008546L;
		Timer timer, timer2;
		String cbText;

		private PasteAction() {
			super();
/*			timer = new Timer(50, new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					progressBar.setValue(docModel.getCurrentPosBeingRead());
					if(docModel.isReadFinished()) {
						timer.stop();
						progressBar.setValue(0);
						progressBar.setMaximum(docModel.getReplacements());
						countReplacementsButton.setEnabled(true);
						copyReplacementsAnalysisButton.setEnabled(true);
						setProgressBarLabelLoading("Finding replacements...");
						timer2.start();
					}
				}
			});
*/

			timer2 = new Timer(50, new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					progressBar.setValue(docModel.getCurrentPosBeingRead());
					if(docModel.isReadFinished()) {
						timer2.stop();
						progressBar.setValue(0);
						resetProgressBarLabel();
					}
				}
			});
		}

		public void actionPerformed(ActionEvent evt) {
			
			//get clipboard contents
			cbText = "";
			Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();

			Transferable cbContents = cb.getContents(null);
			if(cbContents != null && cbContents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
				try {
					cbText = (String) cbContents.getTransferData(DataFlavor.stringFlavor);
				}
				//already checked, so not going to happen
				catch(UnsupportedFlavorException ex) {
					global.exceptionHandler.showException("Error occurred pasting from the clipboard.", ex);
					return;
				}
				catch(IOException ex) {
					global.exceptionHandler.showException("Error occurred pasting from the clipboard.", ex);
					return;
				}
			}

			else
				return;

			//nothing to paste
			if(cbText=="") {
				return;
			}
			
			
			setLoading(true);

			StyleConstants.setBold(currentViewAttributes, boldToggle.isSelected());
			StyleConstants.setItalic(currentViewAttributes, italicToggle.isSelected());
			StyleConstants.setUnderline(currentViewAttributes, underlineToggle.isSelected());

			setProgressBarLabelLoading("Reading text...");
			progressBar.setMaximum(cbText.length());
			Thread thread = new Thread(new Runnable() {
				public void run() {
					try {
						docModel.insertTextAndProcess(cbText, currentViewAttributes);
					}
					catch(BadLocationException ex) {
						global.exceptionHandler.showException("Error occurred updating the the style attributes for the new text.", ex);
						return;
					}
					finally {
						setLoading(false);
					}
				}
			});
			thread.setPriority(6);
			thread.start();
			timer2.start();
		}
	}
	
	private class JoinAction extends AbstractAction {
		/**
		 * 
		 */
		private static final long serialVersionUID = 5061994287539564528L;

		private JoinAction() {
			super();
		}
		
		public void actionPerformed(ActionEvent e) {
			int start = textPane.getSelectionStart();
			int end = textPane.getSelectionEnd();
			if(end-start > 0) {
				try {
					DocumentModel.JoinEdit je = docModel.getJoinEdit(start, end);
					if(je.isValid()) {
						je.execute();
						undoSupport.postEdit(je);
					}
					else
						displayError(je.getWhyInvalid());
				} catch(BadLocationException ex) {
					global.exceptionHandler.showException("Join Failed.", ex);
				}
				catch(InvalidInstanceChangeException ex) {
					global.exceptionHandler.showException("Join Failed.", ex);
				}
			}
		}
	}
	
	private class RuleListManagerAction extends AbstractAction {

		private static final long serialVersionUID = 1L;

		private RuleListManagerAction() {
			super();
		}
		
		public void actionPerformed(ActionEvent e) {
			new RuleManager(frame);
		}
	}
	
	private class UndoAction extends AbstractAction {
			
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private UndoAction() {
			super();
		}
		
		public void actionPerformed(ActionEvent e) {
			undoManager.undo();
		}
	}
	
	private class RedoAction extends AbstractAction {
		
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private RedoAction() {
			super();
		}
		
		public void actionPerformed(ActionEvent e) {
			undoManager.redo();
		}
	}
	
	private class ThreadedProcessEditHolder extends AbstractUndoableEdit {
		
		private static final long serialVersionUID = 1L;

		private ThreadableEdit edit;
				
		private final Timer timer = new Timer(50, new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				progressBar.setValue(edit.getCurrentPos());
				if(edit.isProcessComplete()) {
					timer.stop();
					progressBar.setValue(0);
					resetProgressBarLabel();
				}
			}
		});
		
		private ThreadedProcessEditHolder(ThreadableEdit edit) {
			this.edit = edit;
		}
		
		public void execute() {
			progressBar.setValue(0);
			setProgressBarLabelLoading(edit.getPresentationName());
			progressBar.setMaximum(edit.getExecuteSize());
			Thread thread = new Thread( new Runnable() {
				public void run() {
					try {
						edit.execute();
					}
					catch(doc.CannotExecuteException ex) {
						global.exceptionHandler.showException("Error occurred whilst replacing variants", ex);
					}
					finally {
						setLoading(false);
					}
				}
			});
			thread.setPriority(5);
			thread.start();
			timer.start();
		}
		
		public void undo() throws CannotUndoException {
			progressBar.setValue(0);
			setProgressBarLabelLoading("Undoing: " + edit.getPresentationName());
			progressBar.setMaximum(edit.getUndoSize());
			Thread thread = new Thread( new Runnable() {
				public void run() {
					try {
						edit.undo();
					}
					catch(CannotUndoException ex) {
						global.exceptionHandler.showException("Error occurred whilst undoing replacing variants", ex);
					}
					finally {
						setLoading(false);
					}
				}
			});
			thread.setPriority(5);
			thread.start();
			timer.start();
		}
		
		public void redo() throws CannotRedoException {
			progressBar.setValue(0);
			setProgressBarLabelLoading("Redoing: " + edit.getPresentationName());
			progressBar.setMaximum(edit.getRedoSize());
			Thread thread = new Thread( new Runnable() {
				public void run() {
					try {
						edit.redo();
					}
					catch(CannotRedoException ex) {
						global.exceptionHandler.showException("Error occurred whilst redoing replacing variants", ex);
					}
					finally {
						setLoading(false);
					}
				}
			});
			thread.setPriority(5);
			thread.start();
			timer.start();
		}
		
		public String getPresentationName() {
			return edit.getPresentationName();
		}
		
		public boolean canUndo() {
			return edit.canUndo();
		}
		
		public boolean canRedo() {
			return edit.canRedo();
		}
	}
	
	private class UIUpdatingUndoManager extends UndoManager {
		
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		
		private StackListModel<String> undoList, redoList;

		private UIUpdatingUndoManager() {
			super();
			setLimit(1000);
			undoList = new StackListModel<String>();
			redoList = new StackListModel<String>();
		}
		
		public void redo(int n) {
			for(int i=0;i<n && canRedo(); i++) {
				redo();
			}			
		}

		public void undo(int n) {
			for(int i=0;i<n && canUndo(); i++) {
				undo();
			}
		}

		public void undo() throws CannotUndoException {
			if(canUndo()) {
				super.undo();
				undoList.remove();
				redoList.add(getRedoPresentationName());
				refreshUndoRedoUI();
			}
		}
		public void redo() throws CannotRedoException {
			if(canRedo()) {
				super.redo();
				redoList.remove();
				undoList.add(getUndoPresentationName());
				refreshUndoRedoUI();
			}
		}
		public boolean addEdit(UndoableEdit edit) {
			boolean toReturn = super.addEdit(edit);
			refreshUndoRedoUI();
			undoList.add(getUndoPresentationName());
			redoList.clear();
			return toReturn;
		}
		
		private void refreshUndoRedoUI() {
			Action undoAction = getActionByName("Undo");
			undoAction.setEnabled(canUndo());
			if(canUndo())
				undoAction.putValue(Action.NAME, getUndoPresentationName());
			else
				undoAction.putValue(Action.NAME, "Nothing to undo");
			Action redoAction = getActionByName("Redo");
			redoAction.setEnabled(canRedo());
			if(canRedo())
				redoAction.putValue(Action.NAME, getRedoPresentationName());
			else
				redoAction.putValue(Action.NAME, "Nothing to redo");
				
		}

		/**
		 * @return the redoList
		 */
		public StackListModel<String> getRedoList() {
			return redoList;
		}

		/**
		 * @return the undoList
		 */
		public StackListModel<String> getUndoList() {
			return undoList;
		}
	}
	
	public static void displayError(String message) {
		JOptionPane.showMessageDialog(MainScreen.frame, message, "Error", JOptionPane.ERROR_MESSAGE);
	}
	
	public void showException(String message, Exception ex) {
		JOptionPane.showMessageDialog(MainScreen.frame, message + "\n\n" + ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
	}
	
	private class ImportXML {
		private static final long serialVersionUID = -1900123810704545238L;

		Timer timer2;
		boolean updateConfidenceWeights;
		
		private ImportXML() {
			timer2 = new Timer(50, new ActionListener() {
				public void actionPerformed(ActionEvent evt) {
					if(docModel.isReadFinished()) {
						timer2.stop();
						progressBar.setValue(0);
						resetProgressBarLabel();
						progressBar.setIndeterminate(false);
					}
				}
			});
		}
		
		private void run() {
			Object[] options = {"Yes", "No", "Cancel"};
			int pc = JOptionPane.showOptionDialog(frame, "Would you like to update the confidence weights according to any replacements found within this XML file.\n This is not recommended if the confidence weights were saved in the same session as the xml file was exported.", "Update confidence weights?", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE, null, options, options[0]);
			if(pc == JOptionPane.YES_OPTION)
				updateConfidenceWeights = true;
			else if(pc == JOptionPane.NO_OPTION)
				updateConfidenceWeights = false;
			else
				return;
				
			setLoading(true);
				
			currentFile = null;
			textPane.setStyledDocument(new javax.swing.text.DefaultStyledDocument());
			setupTextPane();
			
			progressBar.setIndeterminate(true);
			frame.setTitle(PROGRAM_TITLE + " - " + fileChooser.getSelectedFile().getName());
			setProgressBarLabelLoading("Reading XML...");
	
			Thread thread = new Thread(new Runnable() {
				public void run() {
					try {
						docModel.readXML(fileChooser.getSelectedFile().toString(), updateConfidenceWeights);
					}
					catch(BadLocationException ex) {
						global.exceptionHandler.showException("Error parsing XML.", ex);
					}
					catch(BadXMLSyntaxException ex) {
						global.exceptionHandler.showException("Incorrect XML Syntax.", ex);
					}
					finally {
						setLoading(false);
					}
				}
			});
			thread.setPriority(6);
			thread.start();
			timer2.start();
		}
	}

	public void finishMessages() {
		resetProgressBarLabel();
		progressBar.setIndeterminate(false);
		setLoading(false);
		
	}

	public void writeMessage(String message) {
		setLoading(true);
		progressBar.setIndeterminate(true);
		setProgressBarLabelLoading(message);
		
	}

	public void rulesChanged(boolean changed) {
		getActionByName("Save Rule List").setEnabled(changed);		
	}

	public void variantsChanged(boolean changed) {
		getActionByName("Save Variant List").setEnabled(changed);		
	}

	public void wordsChanged(boolean changed) {
		getActionByName("Save Dictionary").setEnabled(changed);		
	}

	public void changeUpdate(boolean changed) {
		getActionByName("Save Confidence Weights").setEnabled(changed);
	}
}